<?php
/**
 * @package Legacy
 * @version $Id: ImageEditAction.class.php,v 1.1.2.7 2006/08/18 11:30:00 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/base/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/base/admin/forms/ImageAdminEditForm.class.php";

class Legacy_ImageEditAction extends Legacy_AbstractEditAction
{
	function _getId()
	{
		return isset($_REQUEST['image_id']) ? xoops_getrequest('image_id') : 0;
	}

	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('image', 'base');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm =& new Legacy_ImageAdminEditForm();
		$this->mActionForm->prepare();
	}

	function _doExecute()
	{
		$handler =& xoops_getmodulehandler('imagecategory', 'base');
		$category =& $handler->get($this->mActionForm->get('imgcat_id'));
		
		//
		// [TODO]
		// Should the following procedure be after parent::_doExecute()?
		//
		if ($category->get('imgcat_storetype') == 'file') {
			$this->_storeFile();
		}
		else {
			$this->_storeDB();
		}
	
		return parent::_doExecute();
	}
	
	function _storeFile()
	{
		if ($this->mActionForm->mFormFile != null) {
			if (!$this->mActionForm->mFormFile->saveAs(XOOPS_UPLOAD_PATH)) {
				return false;
			}
		}
		
		//
		// If there is a old file, delete it
		//
		if ($this->mActionForm->mOldFilename != null) {
			@unlink(XOOPS_UPLOAD_PATH . "/" . $this->mActionForm->mOldFilename);
		}
	}
	
	function _storeDB()
	{
		
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("image_edit.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		$render->setAttribute('object', $this->mObject);
		
		$handler =& xoops_getmodulehandler('imagecategory', 'base');
		$categoryArr =& $handler->getObjects();
		$render->setAttribute('categoryArr', $categoryArr);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=ImageList&imgcat_id=" . $this->mActionForm->get('imgcat_id'));
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeRedirect("./index.php?action=ImagecategoryList", 1, _MD_BASE_ERROR_DBUPDATE_FAILED);
	}
	
	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=ImageList&imgcat_id=" . $this->mActionForm->get('imgcat_id'));
	}
}

?>
