<?php
/**
 * @package user
 * @version $Id: UserInfoAction.class.php,v 1.1.2.5 2006/07/27 09:43:26 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * This action shows a information of the target user which is specified by
 * $uid. And display posts of the user with the global search service.
 * 
 * [Warning]
 * Now, the global search service can't work because the design of XCube is
 * changed.
 * 
 * @todo The global search service can't work.
 */
class User_UserInfoAction extends User_Action
{
	var $mObject = null;
	var $mRankObject = null;
	var $mSearchResults = null;

	function isSecure()
	{
		return false;
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{
		$uid = isset($_GET['uid']) ? intval(xoops_getrequest('uid')) : 0;
		
		$handler =& xoops_gethandler('user');
		$this->mObject =& $handler->get($uid);
		
		if (!is_object($this->mObject)) {
			return USER_FRAME_VIEW_ERROR;
		}
		
		$rankHandler =& xoops_getmodulehandler('ranks');
		$this->mRankObject =& $rankHandler->get($this->mObject->get('rank'));
		
		$root =& $controller->mRoot;
		$service =& $root->mServiceManager->getService("LegacySearch");
		if (is_object($service)) {
			$client =& $root->mServiceManager->createClient($service);
			
			$current_uid = is_object($xoopsUser) ? $xoopsUser->get('uid') : 0;

			$this->mSearchResults = $client->call('GetItems', $uid, $current_uid);
		}

		return USER_FRAME_VIEW_SUCCESS;
	}
	
	/**
	 * [Notice]
	 * Because XCube_Service class group are changed now, this member function
	 * can't get the result of user posts.
	 */
	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("user_userinfo.html");
		$render->setAttribute("thisUser", $this->mObject);
		$render->setAttribute("rank", $this->mRankObject);

		$myts =& MyTextSanitizer::getInstance();
		$userSignature = $myts->makeTareaData4Show($this->mObject->get('user_sig'), 0, 1, 1);
		
		$render->setAttribute('user_signature', $userSignature);

		$render->setAttribute("searchResults", $this->mSearchResults);
		
		//
		// set flags.
		//
		$user_ownpage = (is_object($xoopsUser) && $xoopsUser->get('uid') == $this->mObject->get('uid'));
		$render->setAttribute("user_ownpage", $user_ownpage);
	}
	
	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php");
	}
}

?>