<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/class/XCube_ActionForm.class.php";
require_once XOOPS_MODULE_PATH . "/base/class/Legacy_Validator.class.php";

class Legacy_ImageUploadForm extends XCube_ActionForm
{
	var $mOldFileName = null;
	var $_mIsNew = null;
	var $mFormFile = null;

	function getTokenName()
	{
		return "module.base.ImageUploadForm.TOKEN" . $this->get('imgcat_id');
	}

	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['image_name'] =& new XCube_ImageFileProperty('image_name');
		$this->mFormProperties['image_nicename'] =& new XCube_StringProperty('image_nicename');
		$this->mFormProperties['imgcat_id'] =& new XCube_IntProperty('imgcat_id');
	
		//
		// Set field properties
		//
		$this->mFieldProperties['image_name'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['image_name']->setDependsByArray(array('extension'));
		$this->mFieldProperties['image_name']->addMessage('required', _AD_BASE_ERROR_REQUIRED, _AD_BASE_LANG_IMAGE_NAME);
		$this->mFieldProperties['image_name']->addMessage('maxlength', _AD_BASE_ERROR_EXTENSION, _AD_BASE_LANG_IMAGE_NAME);
		$this->mFieldProperties['image_name']->addVar('extension', 'jpg,gif,png');
	
		$this->mFieldProperties['image_nicename'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['image_nicename']->setDependsByArray(array('required'));
		$this->mFieldProperties['image_nicename']->addMessage('required', _AD_BASE_ERROR_REQUIRED, _AD_BASE_LANG_IMAGE_NICENAME);
		
		$this->mFieldProperties['imgcat_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['imgcat_id']->setDependsByArray(array('required','objectExist'));
		$this->mFieldProperties['imgcat_id']->addMessage('required', _AD_BASE_ERROR_REQUIRED, _AD_BASE_LANG_IMGCAT_ID);
		$this->mFieldProperties['imgcat_id']->addMessage('objectExist', _AD_BASE_ERROR_OBJECTEXIST, _AD_BASE_LANG_IMGCAT_ID);
		$this->mFieldProperties['imgcat_id']->addVar('handler', 'imagecategory');
		$this->mFieldProperties['imgcat_id']->addVar('module', 'base');
	}
	
	/**
	 * Check the permission of uploading.
	 */	
	function validateImgcat_id()
	{
		$imgcat_id = $this->getImgcatId();
		if ($imgcat_id != null) {
			$root =& XCube_Root::getSingleton();
			$xoopsUser =& $root->mController->getXoopsUser();
			
			$groups = array();
			if (is_object($xoopsUser)) {
				$groups =& $xoopsUser->getGroups();
			}
			else {
				$groups = array(XOOPS_GROUP_ANONYMOUS);
			}
			
			$handler =& xoops_getmodulehandler('imagecategory', 'base');
			$imgcat =& $handler->get($imgcat_id);
			if (is_object($imgcat) && !$imgcat->hasUploadPerm($groups)) {
				$this->addErrorMessage(_MD_BASE_ERROR_PERMISSION);
			}
		}
	}

	function validateImage_name()
	{
		$formFile = $this->get('image_name');
		
		if ($formFile == null && $this->_mIsNew ) {
			$this->addErrorMessage(_AD_BASE_ERROR_REQUIRED);
		}
	}
	
	function validate()
	{
		parent::validate();
		
		$handler =& xoops_getmodulehandler('imagecategory', 'base');
		$category =& $handler->get($this->getImgcatId());
		
		$formFile = $this->get('image_name');

		if ($formFile != null && is_object($category)) {
			//
			// Imagefile width & height check.
			//
			if ($formFile->getWidth() > $category->get('imgcat_maxwidth') || $formFile->getHeight() > $category->get('imgcat_maxheight')) {
				$this->addErrorMessage(XCube_Utils::formatMessage(_AD_BASE_ERROR_IMG_SIZE, $category->get('imgcat_maxwidth'), $category->get('imgcat_maxheight')));
			}
			
			//
			// Check file size
			//
			if ($formFile->getFilesize() > $category->get('imgcat_maxsize')) {
				$this->addErrorMessage(XCube_Utils::formatMessage(_AD_BASE_ERROR_IMG_FILESIZE, $category->get('imgcat_maxsize')));
			}
		}
	}
	
	function getImgcatId()
	{
		return $this->get('imgcat_id');
	}

	function load(&$obj)
	{
		$this->set('image_nicename', $obj->get('image_nicename'));
		$this->set('imgcat_id', $obj->get('imgcat_id'));
		
		$this->_mIsNew = $obj->isNew();
		$this->mOldFileName = $obj->get('image_name');
	}

	function update(&$obj)
	{
		$obj->set('image_nicename', $this->get('image_nicename'));
		$obj->set('image_display', true);
		$obj->set('imgcat_id', $this->getImgcatId());
		
		$handler =& xoops_getmodulehandler('imagecategory', 'base');
		$category =& $handler->get($this->getImgcatId());

		$this->mFormFile = $this->get('image_name');
		
		if ($this->mFormFile != null) {
			$this->mFormFile->setRandomToBodyName('img');
			
			$filename = $this->mFormFile->getBodyName();
			$this->mFormFile->setBodyName(substr($filename, 0, 24));
	
			$obj->set('image_name', $this->mFormFile->getFileName());
			$obj->set('image_mimetype', $this->mFormFile->getContentType());
			
			//
			// To store db
			//
			if ($category->get('imgcat_storetype') == 'db') {
				$obj->loadImageBody();
				if (!is_object($obj->mImageBody)) {
					$obj->mImageBody =& $obj->createImageBody();
				}
					
				//
				// Access to private member property.
				//
				$obj->mImageBody->set('image_body', file_get_contents($this->mFormFile->_mTmpFileName));
			}
		}
	}
}

?>
