<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/base/class/AbstractFilterForm.class.php";

define('SMILES_SORT_KEY_ID', 1);
define('SMILES_SORT_KEY_CODE', 2);
define('SMILES_SORT_KEY_SMILE_URL', 3);
define('SMILES_SORT_KEY_EMOTION', 4);
define('SMILES_SORT_KEY_DISPLAY', 5);

define('SMILES_SORT_KEY_DEFAULT', -SMILES_SORT_KEY_DISPLAY);
define('SMILES_SORT_KEY_MAXVALUE', 5);

class Legacy_SmilesFilterForm extends Legacy_AbstractFilterForm
{
	var $mSortKeys = array(
		SMILES_SORT_KEY_ID => 'id',
		SMILES_SORT_KEY_CODE => 'code',
		SMILES_SORT_KEY_SMILE_URL => 'smile_url',
		SMILES_SORT_KEY_EMOTION => 'emotion',
		SMILES_SORT_KEY_DISPLAY => 'display'
	);

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval(xoops_getrequest('sort')) : SMILES_SORT_KEY_DEFAULT;
	
		if (!isset($this->mSortKeys[abs($this->mSort)])) {
			$this->mSort = SMILES_SORT_KEY_DEFAULT;
		}
	
		if (isset($_REQUEST['code'])) {
			$this->_mNavi->addExtra('code', xoops_getrequest('code'));
			$this->_mCriteria->add(new Criteria('code', xoops_getrequest('code')));
		}
	
		if (isset($_REQUEST['smile_url'])) {
			$this->_mNavi->addExtra('smile_url', xoops_getrequest('smile_url'));
			$this->_mCriteria->add(new Criteria('smile_url', xoops_getrequest('smile_url')));
		}
	
		if (isset($_REQUEST['emotion'])) {
			$this->_mNavi->addExtra('emotion', xoops_getrequest('emotion'));
			$this->_mCriteria->add(new Criteria('emotion', xoops_getrequest('emotion')));
		}
	
		if (isset($_REQUEST['display'])) {
			$this->_mNavi->addExtra('display', xoops_getrequest('display'));
			$this->_mCriteria->add(new Criteria('display', xoops_getrequest('display')));
		}

		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());
	}
}

?>
