<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_BASE_PATH."/class/Legacy_ModuleAdapter.class.php";
require_once XOOPS_BASE_PATH."/admin/forms/ActionSearchForm.class.php";

class Legacy_ActionSearchArgs
{
	var $mKeywords;
	var $mRecords;

	function Legacy_ActionSearchArgs($words)
	{
		$this->setKeywords($words);
	}
	
	function setKeywords($words)
	{
		foreach (explode(" ", $words) as $word) {
			if( strlen($word) > 0) {
				$this->mKeywords[] = $word;
			}
		}
	}

	function getKeywords()
	{
		return $this->mKeywords;
	}

	function addRecord($moduleName, $url, $title, $desc = null)
	{
		$this->mRecords[] =& new Legacy_ActionSearchRecord($moduleName, $url, $title, $desc);
	}
	
	function &getRecords()
	{
		return $this->mRecords;
	}
	
	/**
	 * @return bool
	 */
	function hasRecord()
	{
		return count($this->mRecords) > 0;
	}
}

/**
 * An item on one search record. This is a class as a structure.
 * 
 * @todo we may change it to Array.
 */
class Legacy_ActionSearchRecord
{
	var $mModuleName;
	var $mActionUrl;
	var $mTitle;
	var $mDescription;

	function Legacy_ActionSearchRecord($moduleName, $url, $title, $desc=null)
	{
		$this->mModuleName = $moduleName;
		$this->mActionUrl = $url;
		$this->mTitle = $title;
		$this->mDescription = $desc;
	}
}

/**
 *  Execute action searching. Now, it returns all of modules' results whether
 * the current user can access to.
 * 
 * @todo We should return the result by the current user's permission.
 */
class Legacy_ActSearchAction extends Legacy_Action
{
	var $mModules = array();
	var $mModuleRecords = null;
	var $mRecords = null;
	var $mActionForm = null;
	
	var $mSearchAction = null;
	
	function Legacy_ActSearchAction($flag)
	{
		parent::Legacy_Action($flag);
		
		$this->mSearchAction =& new XCube_Delegate();
		$this->mSearchAction->register('Legacy_ActSearchAction.SearchAction');
	}

	function prepare(&$controller, &$xoopsUser)
	{
		parent::prepare(&$controller, &$xoopsUser);

		$db=&$controller->getDB();

		//
		// TODO : We don't use handler and write sql directly.
		//
		$sql = "SELECT {mod}.* FROM {mod},{perm} ".
		        "WHERE {mod}.mid={perm}.gperm_itemid AND {perm}.gperm_name='module_admin' AND {perm}.gperm_groupid IN ({groups}) ".
		        "ORDER BY {mod}.weight";

		$replaceMap = array(
			"mod"=>$db->prefix("modules"),
			"perm"=>$db->prefix("group_permission"),
			"groups"=>implode(",",$xoopsUser->getGroups())
		);

		$sql = XCube_Utils::formatMessageByMap($sql,$replaceMap);

		$result = $db->query($sql);
		while ($row = $db->fetchArray($result)) {
			$xoopsModule =& new XoopsModule();
			$xoopsModule->assignVars($row);

			$adapter =& new Legacy_ModuleAdapter($xoopsModule);
			$adapter->prepareAdmin($controller);
			
			$this->mModules[] =& $adapter;

			unset($xoopsModule);
			unset($adapter);
		}
	}

	function hasPerm(&$controller, &$xoopsUser)
	{
		$permHandler =& xoops_gethandler('groupperm');
		return $permHandler->checkRight('module_admin', -1, $xoopsUser->getGroups());
	}
	
	function getDefaultView(&$controller, &$xoopsUser)
	{
		$this->_processActionForm();
		return LEGACY_FRAME_VIEW_INPUT;
	}
	
	function execute(&$controller, &$xoopsUser)
	{
		$this->_processActionForm();

		$this->mActionForm->fetch();
		$this->mActionForm->validate();

		if($this->mActionForm->hasError()) {
			return LEGACY_FRAME_VIEW_INPUT;
		}

		$searchArgs =& new Legacy_ActionSearchArgs($this->mActionForm->get('keywords'));
		$this->mSearchAction->call(new XCube_Ref($searchArgs));

		if ($searchArgs->hasRecord()) {
			$this->mRecords =& $searchArgs->getRecords();
			return LEGACY_FRAME_VIEW_SUCCESS;
		}
		else {
			return LEGACY_FRAME_VIEW_INPUT;
		}
	}
	
	function _processActionForm()
	{
		$this->mActionForm =& new Legacy_ActionSearchForm();
		$this->mActionForm->prepare();
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("legacy_admin_actionsearch_success.html");
		$render->setAttribute("records", $this->mRecords);
		$render->setAttribute("actionForm", $this->mActionForm);
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("legacy_admin_actionsearch_input.html");
		$render->setAttribute("actionForm", $this->mActionForm);
	}
}

?>