#!/bin/sh
# test platform ... debian dash

# GPL_3 license
cat << 'EEE' > /dev/null
/* readlink_p .... portable readlink. bourne-shell script
 * Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

buf=`./rdopt "hf:i:" "$@"`
if [ $? -ne 0 ] ; then echo "$0: optErr. see -h. sleep." >/dev/stderr ;sleep 1000; exit 1; fi
eval "$buf"

if [ "$opt_f" = "" ] || [ "$opt_i" = "" ] ; then
	echo "$0: optErr. see -h" > /dev/stderr
	exit 1
fi


# ./repeat_xa.sh -f unko -i tes.ini > out.xkm

sfile="$opt_f"
inifile="$opt_i"

tmpfile1="$0.buf1"
tmpfile2="$0.buf2"
cp "$sfile" "$tmpfile1"

echo "--- $0:" >/dev/stderr

#適当に処理してファイルの尻尾に追加する。onとoffの羅列
# repeat <LatA> <LFSH> :: 0/1	...0:off 1:on
ron=""
roff=""

ron=`cat "$inifile" | awk '$1 == "repeat" && $NF == "1" {$1="";$NF="";$(NF-1)="";print $0}' | 
while read -r A
do
	echo " $A"
done`

roff=`cat "$inifile" | awk '$1 == "repeat" && $NF == "0" {$1="";$NF="";$(NF-1)="";print $0}' | 
while read -r A
do
	echo " $A"
done`

#通称キーコードから真キーコード探索用
dmylist=`cat "$sfile" | ./getblock_xa.sh  '$1 == "xkb_keycodes"' -s |
	awk '$1=="alias" {$1=""; print $0}' | tr '=;' ' '`

buf=`
for ii in $ron
do
	hit=$(echo "$dmylist" | awk -v tgt="$ii" '
		$1 == tgt {print $2}')
	if [ "$hit" != "" ] ; then
		echo " $hit"
	else
		echo " $ii"
	fi
done`
set -- $buf
ron="$@"

#offも
buf=`
for ii in $roff
do
	hit=$(echo "$dmylist" | awk -v tgt="$ii" '
		$1 == tgt {print $2}')
	if [ "$hit" != "" ] ; then
		echo " $hit"
	else
		echo " $ii"
	fi
done`
set -- $buf
roff="$@"


#ラベルたちからキーコードを取り出す。
nlist=`cat "$sfile" | ./getblock_xa.sh  '$1 == "xkb_keycodes"' -s |
	awk '$1 ~ /[<].*[>]/ {print $0}' | tr '=;' ' '`

buf=`for ii in $ron
do
	echo "$nlist" | grep -F "$ii" | awk '{print $2}'
done`
set -- $buf
ron="$@"	# 31 50 ... の羅列

buf=`for ii in $roff
do
	echo "$nlist" | grep -F "$ii" | awk '{print $2}'
done`
set -- $buf
roff="$@"



#尻尾に追加。出力
if [ "$ron" != "" ] ;then
for ii in $ron
do
	printf '//keyrepeat xset r %s	#repeat_on\n' "$ii" | tee /dev/stderr >> "$tmpfile1"
done
fi

if [ "$roff" != "" ] ;then
for ii in $roff
do
	printf '//keyrepeat xset -r %s	#repeat_off\n' "$ii" | tee /dev/stderr >> "$tmpfile1"
done
fi

cat "$tmpfile1"
echo "--- $0: end" >/dev/stderr
