#!/bin/sh
# test platform ... debian dash

# GPL_3 license
cat << 'EEE' > /dev/null
/* readlink_p .... portable readlink. bourne-shell script
 * Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE






#iniとsfileでalias挿入分を作成。仮称も処理。リピートも処理。
#  ./remap_xa.sh -f unko -i ./redtest.ini
# >>> alias <AC06> = <KP9> ;

#remap <LatH> :: <KP9>
#remap 80 :: 115
# <LatH> :: <KP9>  >> <AC01> = 92;
#左はコードorラベル。右はラベルのみだけど最終はコードに変換。
# <AD01> = 85;
#当面はラベルのみ。
#左のラベル名が存在するか否かをエラー判定とか。


buf=`./rdopt "hf:i:" "$@"`
if [ $? -ne 0 ] ; then echo "$0: optErr. see -h. sleep." >/dev/stderr ;sleep 1000; exit 1; fi
eval "$buf"

if [ "$opt_f" = "" ] || [ "$opt_i" = "" ] ; then
	echo "$0: optErr. see -h" > /dev/stderr
	exit 1
fi

sfile="$opt_f"
inifile="$opt_i"
tmpfile1="$0.buf1"
tmpfile2="$0.buf2"
tmpfile3="$0.buf3"
#---ready


#---main	loop読み込みでremapを全部処理。
#keyrepeat判定用
replist=`./repstate_xa.sh -l`	# -k でもいいけど、ループで重いので一回で済ます。
kclist=` cat "$sfile" | ./getblock_xa.sh '$1 == "xkb_keycodes"' |
	awk '$1 ~ /<.*>/ {print $0}' | tr '=;' ' ' | awk '{print $1 " " $2}'`

cat "$inifile" >/dev/stderr
#ini ... remap <LatA> :: <LatB>

echo "--- $0:" >/dev/stderr

cat "$inifile" | awk '$1 == "remap" {print $0}' | 
while read -r A
do

echo "--- $A" >/dev/stderr
set -- $A
if [ "$1" != "remap" ]; then
	echo "$0: cmd err"
	exit 1
fi

#ラベル正式名探し
slbl="$2"
dlbl="$4"
slbl=`./cklabel_xa.sh -f "$sfile" -l "$slbl" `
if [ "$slbl" = "" ] ; then
	echo "$0: err. invalid label name" > /dev/stderr
	exit 1
fi

if [ "$dlbl" != "null" ] ; then
	dlbl=`./cklabel_xa.sh -f "$sfile" -l "$dlbl" `
fi


#無効化指定と普通の指定
buf=`echo $dlbl | tr '[:upper:]' '[:lower:]' `
if [ "$buf" = "null" ] && [ "$slbl" != "" ] ; then
#key <LFSH> {
#	[ RedirectKey(key=<LatJ>)]
#};
printf 'key %s {\n[ NoSymbol ]\n};\n' "$slbl" | tee /dev/stderr


#dnum=`cat "$sfile" | awk -v ag="$dlbl" '$1 == ag {print $0}' |
#	ssp -fs '*=' 2 | tr -d ';' | awk '{print $1}'`

#ふつーにリマップ。type指定とかしてないけど、自動でoneだろうから。
# >> コピーにした。redだとmods系が働かない。意味不明。

elif [ "$dlbl" != "" ] && [ "$slbl" != "" ] ; then
#key <LFSH> {
#	[ RedirectKey(key=<LatJ>)]
#};
#	printf 'key %s {\n[ RedirectKey( key=%s ) ]\n};\n' "$slbl" "$dlbl" | tee /dev/stderr
	buf=`cat "$sfile" | ./getblock_xa.sh  '$1 == "key" && $2 == "'"$dlbl"'"' `
	printf 'key %s { %s };\n' "$slbl" "$buf" | tee /dev/stderr
else
	echo "$0: err. invalid label name" > /dev/stderr
	exit 1
fi


#最後。
#	.... repeatは個別にやってもらおうと思ったけど、なんか非常に使い勝手が
#微妙っぽくなったのでrepeatの自動判定追加をする。ブロック内に埋め込まれるけどあとで処理
#	"$slbl" "$dlbl"  からキーコードを引っ張って判定。
#	ソースがぐちゃぐちゃなので整理が必要かも。

buf=`echo $dlbl | tr '[:upper:]' '[:lower:]' `
if [ "$buf" = "null" ] ;then
	continue
fi

# echo "$kclist" | grep "$slbl"  >/dev/stderr
# sleep 1
# s_kcは元ファイルのコードブロックからラベルにヒットするキーコード。
# 重複ラベルはないはずだけど、一応最後のヒットを採用
s_kc=`echo "$kclist" | grep "$slbl" | awk '{print $2}' | sed -ne '$p' `
s_flg=`echo "$replist" | awk -v kc="$s_kc" '$1 == kc {print $2}'`

# echo "#### $s_kc @@ $s_flg" >/dev/stderr
# sleep 10

d_kc=`echo "$kclist" | grep "$dlbl" | awk '{print $2}'| sed -ne '$p' `
d_flg=`echo "$replist" | awk -v kc="$d_kc" '$1 == kc {print $2}'`

# echo "#### $d_kc @@ $d_flg" >/dev/stderr
# sleep 10

if [ "$s_flg" = "" ] ||  [ "$d_flg" = "" ] ;then
	echo "$0: keyrepeat status err sleep 10000" > /dev/stderr
	sleep 10000
	exit 1
fi


if [ "$s_flg" != "$d_flg" ] ;then
	buf=`echo "$d_flg" | awk '
		$1 == "1" {print "r"}
		$1 == "0" {print "-r"}'`
	
	printf '//keyrepeat xset %s %s	#%s\n' "$buf" "$s_kc" "$A" | tee /dev/stderr
fi	

done > "$tmpfile1"
# 追加文書。keyblockとかrepeatコメントとか
#while問題。内部処理
#echo "$addlist"
#echo unko > /dev/stderr

#追加keyblock文章は出来たけどrepeatコメントが混じっているので分離削除する
replist=`cat "$tmpfile1" | awk '$1 == "//keyrepeat" {print $0}'`
addblk=`cat "$tmpfile1" | awk '$1 != "//keyrepeat" {print $0}' `
#NoSymbolとかlvl2抜けとかブッキングするので元キーラベル削除。
rmkeys=`cat "$tmpfile1" | awk '$1 == "key" {print $2}'`
#cat "$tmpfile" > /dev/stderr
#echo "$rmkey" > /dev/stderr
#<AB06>とかの羅列.追加予定のブロックからラベルだけ取り出す


#cp "$sfile" "$tmpfile2"
#for ii in $rmkey
#do
#cat "$tmpfile2" | ./getblock_xa.sh  '$1 == "key" && $2 == "'$ii'"' -r -v > "$tmpfile3"
#cp "$tmpfile3" "$tmpfile2"
#done

#	#まとめてみる
#	cmd="cat - "
#	for ii in $rmkey
#	do
#		#<AB06>とかのブロックを消す
#		#	echo "$lbl" | ./delkey_xa.sh -f "$tmpfile1" > "$tmpfile2"
#		# バッファリングのほうが早いのかな。。。整備性はdelkeyのほうがよさそうだけど。
#		# delkeyを強化すれば恩恵あるか。 >> もうやってた。
#		cmd="$cmd | ./getblock_xa.sh  '\$1 == \"key\" && \$2 == \"$ii\"' -r -v"
#	done
#	#echo "$cmd" > /dev/stderr
#	cat "$sfile" | eval "$cmd" > "$tmpfile2"

#echo "@@@ $rmkeys" >/dev/stderr
# 空っぽのときは無視設定にしないと。

# 古ラベルをリストラ
echo "$rmkeys" | ./delkey_xa.sh -f "$sfile" > "$tmpfile1"
#新ラベルを追加してそのまま出力
echo "$addblk" | ./addcode_xa.sh -f "$tmpfile1" -b xkb_symbols
#尻尾にコメントでrepeat情報追加
echo "$replist"
echo "--- $0: end" >/dev/stderr
