#!/bin/sh
# test platform ... debian dash
# GPL_3 license
cat << 'EEE' > /dev/null
/* readlink_p .... portable readlink. bourne-shell script
 * Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE


buf=`./rdopt "hf:t:v:" "$@"`
if [ $? -ne 0 ] ; then echo "$0: optErr. see -h. sleep." >/dev/stderr ;sleep 1000; exit 1; fi
eval "$buf"

if [ "opt_f" = "" ] || [ "opt_t" = "" ] || [ "opt_v" = "" ] ; then
	echo "$0: optErr. see -h"
	exit 1
fi

echo "--- $0" > /dev/stderr
basefile="$opt_f"
ntyp="$opt_t"
pos="$opt_v"

#要求のkeyブロックを作成する。
#cmd ... red {+s+c+m2} <LatA> :: {+s+c} <LatC>
#cmd ... red {} <LatA> :: {+s} <LatC>
#cmd ... red {+s+c+any} <LatA> :: {+any} <LatC>
#time echo 'red {+s+c+m1} <AE01> :: {+s+c} <LatC>' | ./redps2_xa.sh -f unko  -t ALPHABET -v 2


#必要なのは
#defファイル,元ラベル、新typeの3つ？+上書きor追加位置lvの5つ。

#変更したkey<...>ブロックを作成。
#1.	目的キーコードラベルを取得。
#	標準からコマンドを流し込んでもらう。
# red {+s+c+m3} <LatA> :: {+s+c} <LatC>	...redirect ラベルは真のはず
inline=`awk '{print $0}'`
lbl=`echo "$inline" | awk '{print $3}' `

#2. 元のキーラベルブロックを取得。扱いやすい羅列形になってる。最終ヒットのみ。
# ps1でもやったから重複だけど、分けたほうが分かりやすいし。
base=`./keyblkfmt_xa.sh -l "$lbl" -f "$basefile"`	#'<AE13>'
# echo "@@@ $base" >/dev/stderr

# ctype null 
# type KEYPAD_KP8add 
# sGroup@1  KP_Up KP_8 NoSymbol
# aGroup@1  NoAction(),NoAction(),RedirectKey(Key=<UP>,clearmodifiers=Shift+Lock+Control+Mod1+Mod2+Mod3+Mod4+Mod5,modifiers=None)

#sがない場合もある。>> keyblkでsは自動追加にした。


#type  "TWO_LEVEL" 
#sGroup1               Alt_R           Meta_R 
#aGroup@1	Nosymbol()	red(,,) ... 
#// ---gsplit
#以下雑魚
#こんな感じ
#Groupが省略されてても追加してgroup@1とかで埋めたのが出てくる。

#echo "@@@ $base" > /dev/stderr; sleep 100

#3.	typeとgroup1を取得して追加差し替え。group1か@1のみ。複数グループ2,3,4は無視。
#	余分なメモtypeとかは削除して必要なもののみ残す。
#	ヘボいけど、対象の行番号を取得
#	sグループが存在しない場合もある。その時はagroupから項目数をとりだして
#	NoSymbolで捏造する。

# >> keyblockで共通処理にした
# buf=`echo "$base" | tr '[:upper:]' '[:lower:]' | grep sgroup `
# if [ "$buf" = "" ] ; then
# 	#sグループなし>aから捏造。aもなかったらstop
# 	buf=`echo "$base" | tr '[:upper:]' '[:lower:]' | tr -d '@' | 
# 		awk ' $1 == "agroup1" { 
# 			printf "sGroup1 "
# 			for(i=1; i<NF; i++){
# 				printf "NoSymbol "
# 			}
# 		}' `
# 	base=`printf '%s\n%s\n' "$base" "$buf" `
# 	if [ "$buf" = "" ] ; then
# 		echo "$0: err. invalid format. sleep  $base" > /dev/stderr ; sleep 1000
# 	fi
# fi
# echo "@@ $base" > /dev/stderr ; sleep 1000

tgn=`echo "$base" | awk '
	$1 == "sGroup1" || $1 == "sGroup@1" {print NR }' | 
	awk '$1 != "" {print $0}' | sed -ne '$p' `
buf=`echo "$base" | sed -ne "$tgn"p `
#ターゲットのgroup行。最新の1だけ。

#symbolグループにNosymbol追加。redはアクションなので、シンボルグループに明示しておく。
repg=`echo "$buf" | awk -v i="$pos" '{
	i=i+1	#頭のgroup分
	$i="NoSymbol"
	print $0
}'`


#4. redirect用にアクショングループを処理。
#	だけど、RedirectKey( Key=<AC07>, clearmodifiers=Shift )
#	みたいに条件も一緒に必要なので準備する。
#	dmodで+-を使って入力時のモディファイヤに対して加えたり
#	>>	追加。red先がnullのときはnosym,noactionで。最後の方で上書き。

dlbl=`echo "$inline" | awk '{print $6}' `

# sedの改行追加がコマンド展開で削除される。先に変数に仕込んでバリアしとく。修正。
# cmd=""
# while read -r a
# do
# 	cmd="$cmd
# $a"
# done << 'EEE'
# sed -e 's/[-+]/\
# &/g' | grep -v '^$'
# EEE
cmd='s/[-+]/\
&/g'

dmod=`echo "$inline" | awk '{print $5}' | ./reqmod_xa.sh | sed -e "$cmd" | grep -v '^$' `	#ps1でもつかった。Shift+...が出る。
cmod=`echo "$inline" | awk '{print $2}' | ./reqmod_xa.sh | sed -e "$cmd" | grep -v '^$'`
fmod=`echo "{+s+l+c+m1+m2+m3+m4+m5}" |./reqmod_xa.sh | sed -e "$cmd" | grep -v '^$'`

#fmodはfullリスト。比較用に色々使う。cはclear, 削除される予定のmod.入力時のmodが滲みてくるので。
# clearするのにはじめのmodも必要。-+つき。後で分類するので改行スプリット。...横grepとか。いらんか。
# echo "@@@_$dmod" >/dev/stderr
# sleep 1000

#条件分け。dmodにanyがあったりなかったり。
#dmodにanyがあるってことは、cmodに、元のキーmodにanyがあるってこと。必ず。
# 逆にソースにanyがあってもdにあるとは限らない。
buf=`echo "$dmod" | grep any`

if [ "$buf" = "" ] ; then	#anyがない。ふつーの場合。-+のみで制御。
	cmod="Shift+Lock+Control+Mod1+Mod2+Mod3+Mod4+Mod5"
	dmod=`echo "$dmod" | grep -v '^-' | tr -d '\n' | sed -e 's/^[+]//g' ` # Shift+any みたいな出力
else
	#anyが存在。。。削除対象を解析処理。全削除ではない。
	#anyって具体的にはどのmodかを解析する。入力modによって変化するため。
	buf=`echo "$cmod" | grep -v 'any' `	#anyに含まれないmodたち。削除予定. 左辺値の{+s}とか。
	cmod=`echo "$dmod" | grep -v 'any' |
		grep '^-' | tr '-' '+' `"
$buf"	#削除要求合体。後で-が欲しくなるかも。anyがcmodなので、any以外の表記modを全部。
# 重複要求を削除してから整える。。デバッグ。

	cmod=` echo "$cmod" | sort | uniq | tr -d '\n' | sed -e 's/^[+]//g'  `	#整える。
	
	#付加要求
	dmod=`echo "$dmod" | grep -v 'any' | grep -v '^-' | tr -d '\n' | sed -e 's/^[+]//g' `
fi
#{}などのmodなし指定の場合はnoneで対処できる。
#noneはモディファイヤが全く存在しないってわけじゃなく、特に追加フラグがないってこと。
if [ "$dmod" = "" ]; then
	dmod="None"
fi
if [ "$cmod" = "" ]; then
	cmod="None"
fi

# echo "clear@@@ $cmod"
# echo "@@_ $dmod"
# exit
	
#モディファイヤを消してから、再度追加。cとaddの行の順番で変わる。
#awkで処理するので空白がないように詰めて書く。
rtxt="RedirectKey(Key=${dlbl},clearmodifiers=${cmod},modifiers=${dmod})"
#対応するredstringはできたので、既存のredに追加する。
#まだ[]は付けない。空白区切り。
# aGroup1 ..の最終だけ取り出す。複数あるかもしれんから。

repa=`echo "$base" | awk '
	{str=tolower($0) }
str ~ /^agroup1/ || str ~ /^agroup@1/ {print $0}' | sed -ne '$p' `
#echo "$repa" >/dev/stderr ; sleep 1

#exit

#posはagroupで+1。repaの存在有無で分ける

#アクション系が存在しない。多分新規。symbol系をパクって体裁を整える。
# repgは sGroup1 nosum nosymみたいな。
if [ "$repa" = "" ] ;then

	repa=`echo "$repg" | awk -v tx="$rtxt" -v pos="$pos" '{
	pos=pos+1
	gsub(/sGroup/, "aGroup", $1)
	for(i=2; i<=NF; i++){	#とりあえず全部noactionで埋める
		$i="NoAction()"
	}
	$pos=tx		#posの部分を要求アクションで上書き。塗りつぶす
	print $0
}'`

else

# echo "@@@_$pos" >/dev/stderr
#二回目以降。先客がいるので拝借して塗りつぶしたり尻尾を付けたり
#基本的にないけど、ポジションがとんでるかもしれないので埋める。
#actionはカンマ区切りで一塊になってるので、そのへん。

#まずカンマを改行化して分ける。groupとそれ以外でくっついているので
# 頭のgroupが邪魔なので消す。$1 バイバイ
# repa はこんなの	aGroup@1  RedirectKey(key=<LFSH>)
# funcをばらしてリスト行列を吐く。
# NoSymbol()
# Red()
# ...

func_l=`echo "$repa" | awk '{print $2}' | ./keyblkch_xa.sh `
#echo "aaa" > /dev/stderr
#echo "$repa" | awk '{print $2}' >/dev/stderr
#echo "$buf" >/dev/stderr

num=`echo "$func_l" | wc -l`	#現在のアクション数。
#echo "___ $pos $num" >/dev/stderr
num=`expr $pos - $num`

# posが小さいときはマイナスでスキップされる。
addbuf=""
for ii in `seq 1 $num `
do
	addbuf="$addbuf "`echo "NoAction()"`
done
#echo "$0: ___ $addbuf ::: $num $pos" > /dev/stderr ; sleep 100

#ダミーをくっつける。NoAction() 達
addbuf=`echo "$addbuf" | tr ' ' '\n' | awk '$1 !="" {print $0}' `
func_l=`printf '%s\n%s\n' "$func_l" "$addbuf" | awk '$1 != "" {print $0}' `
#指定ポジションに上書きする。したら一行に戻す
buf=`echo "$func_l" | awk -v pos="$pos" -v tx="$rtxt" '
	NR == pos {$0=tx}
	{print $0}' | tr '\n' ',' | sed -e 's/,$//g'`

#echo "@@@__$buf" >/dev/stderr

#頭がないので追加する。aGroup
head=`echo "$repa" | awk '{print $1}'`
repa=`printf '%s %s\n' "$head" "$buf" `
#echo "@@@ $repa" > /dev/stderr
fi
#symbol側もsを追加 >fmt側で対処した
# repg=`echo "$repg" | awk '{
# 	$1="s" $1
# 	print $0
# }'`


# red先がnullの場合はNoAction()で上書き。
if [ "$dlbl" = "" ] ; then
repa=`echo "$repa" | awk -v pos="$pos" '{
	pos=pos+1
	$pos="NoAction()"
	print $0
	}' `
fi


#4.3	group系以外の雑魚を回収
rest=`echo "$base" | awk '
	BEGIN{flg=0}
	$1=="//" {flg=1;next}
	flg==1 {print $0}' | awk '$1 != "" {print $0}' `

#5.	材料が揃ったので組み立てる。type-sgroup-agroupの順番。 
#対応した新しいtypeをgroupに紐付け。groupの直前と合体。	こいつを使って入れ替える
buf=`printf '%s %s\n' "type " "$ntyp"`
nbase=`printf '%s\n%s\n%s\n%s\n' "$buf" "$repg" "$repa" "$rest" `
#new_base

# type	ONE
# sGroup1	Nosymbol ...
# aGroup ...


# #repgが新しいgroup記述になる。defaultのやつに割り込み上書き修正。行番号で指定。
# nbase=`echo "$base" | awk -v rp="$itr" -v tgn="$tgn" '
# 	NR == tgn {print rp}
# 	NR != tgn {print $0}'` 
# 
# #typeが重複してたりするので掃除。連続type行は最後を残して削除。最終行がtypeの場合は削除される。
# #これで必要事項は完了。{}の付いてない羅列状態。
# nbase=`echo "$nbase" | awk '
# 	BEGIN {bb=""}
# 	$1 ~ /type/ {bb=$0; next}
# 	$1 !~/type/ && bb != "" {print bb; bb=""}
# 	#typeが連続ではない。
# 	{print $0}'`

#羅列からxkb対応のテキストを起こす。
#key <$lbl>みたいな。
#group系はカッコとか付加されて、それ以外は生出力+','
# で最後に{}パッキングされる。

#echo "@@@@@@@   $nbase"  >/dev/stderr

buf=`echo "$nbase" | ./keyblkfmtr_xa.sh "$lbl"`
echo "$buf"
echo "$buf" > /dev/stderr
