#!/bin/sh
# test platform ... debian dash

# GPL_3 license
cat << 'EEE' > /dev/null
/* readlink_p .... portable readlink. bourne-shell script
 * Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE


buf=`./rdopt "hf:m:" "$@"`
if [ $? -ne 0 ] ; then echo "$0: optErr. see -h. sleep." >/dev/stderr ;sleep 1000; exit 1; fi
eval "$buf"

if [ "$opt_f" = "" ] || [ "$opt_m" = "" ] ; then
	echo "$0: optErr. see -h"
	exit 1
fi

basefile="$opt_f"
rvmod="$opt_m"

#やること多い。初期のラベル指定モディをシンボルに書き換え。ラベル系modは削除
#cmdから元typeを探し出して、付加されたモディファイヤから適切なtypeを再生成する。
# newtypeのlvlは追加型。そのうち溢れそう。

# Shift  
# Control  
# Lock  
# Mod1 Alt Meta 
# Mod2 NumLock 
# Mod4 Hyper Super 
# Mod5 LevelThree  AltGr 
# ...m


#  buf=`cat << 'EEE'
#  Shift  
#  Control  
#  Lock  
#  Mod1 Alt Meta 
#  Mod2 NumLock 
#  Mod4 Hyper Super 
#  Mod5 LevelThree  AltGr 
#  EEE
#  `






# echo 'red {+s+c+m1} <AE01> :: {+s+c} <LatC>' | ./redps1_xa.sh -f unko -m "$buf"
#行は標準入力から。
# 返却はtype名。type "KEYPAD_KP0add"
# だけだけど、内部では色々書き換え追加。



#簡易検査 >> 外部委託。
#inline=`awk '$1 == "red" {print $0}' `
#if [ "$inline" = "" ] ; then
#	echo "input 'red' err"
#	exit
#fi

#cmd一行入力を保存
echo "--- $0" >/dev/stderr
read -r inline

#1.{}をパース、newtypeのために正式名にする。baseは{}で。nullとかbaseじゃないよ。
buf=`echo "$inline" | awk '{print $2}' `	#{+s+c} etc
reqmod=`echo "$buf" | ./reqmod_xa.sh |  sed -e 's/^[+]//g'`	#req mod... Shift+Control-Mod1+any   etc

buf=`echo "$reqmod" | grep '-'`
if [ "$buf" != "" ] ; then
	echo "$0: cmderr. '-' detect" >/dev/stderr 
	exit 1
fi

#anyのみの場合は全てoneレベルハードコードで問題ない。かも。 >> 元ブロックに[]の複数シンボルが残るけど。
# 同じ名前が残るので、mmm.戻ったときに重複タイプは削除しないと、後工程で引っかかる。
if [ "$reqmod" = "any" ] ; then
cat << 'EEE' | tee /dev/stderr
type "ONE_LEVEL" {
	modifiers= none;
	level_name[Level1]= "Any";
map[None]= Level1;
// override_nlv 1
};
EEE
exit 0
fi



#2. 入力<LatA>を解析して対象typeを特定。typeの書式と使っているモディファイヤを取り出す。
#	<LatA>がエイリアスで<AD01>が内部で使われていることがあるので
#	判定と変換スクリプトが必要。ラベル。 <LatA>とかのこと
lbl=`echo "$inline" | awk '{print $3}' `

# lbl=`./cklabel_xa.sh -f "$basefile" -l "$lbl"`	##<LatA>とalias<AE01>の判定。使える方を出力
#>> 外部に出したい。いや、個別がいいか。最初のreplaceで<>系をまとめて
# 書き換えれば少し早い？ >> とりあえず、どっかで変換しといた。>>一つ上の親で纏めて変換した。
# echo yyy$lbl >/dev/stderr
#sleep 1000

#lblのつかっているtypeを出力
#重複ブロックは事前に分ける。//でスプリットされて出てくるので判断
#オプション？

# keyblk系でtype判定なんだけど、ここでsymbol[]がない場合のエラー？

# ラベルから整形されたブロックが出てきて、それからtype判別。帰りは aGropu1 ONE_LEVELとか。
buf=`./keyblkfmt_xa.sh -l "$lbl" -f "$basefile" | ./keyblktype_xa.sh`
#num=`echo "$blks" | grep // | wc -l`
#buf=`echo "$blks" | 
#		awk -v n=$num '
#		$1 == "//" {hit=hit+1}
#		hit == n {print $0}' | grep -F -v '//' | ./keyblktype_xa.sh`

# echo "$0:;;;;; $buf" >/dev/stderr ; sleep 2

#exit

#	....	Group1 TWO_LEVEL
#			Group2 ONE_LEVEL  ,,,typeからキーラベルを作り出して？type再生？
#	
#	グループが2つ以上ある場合はgroup1のみ対象にすすめる。 >>keyblkで1つに指定済み。
#	TWO_LEVELとかを取り出してtypeに攻勢をかける。
bt_name=`echo "$buf" | sort | head -n 1 | awk '{print $2}'`
	
	
#base_type_name, 改造元のtypeの名前。あとで使う。
#	前にtype改変してて、再びならどうする。。。？
#	書き出しリストを準備して、そっちを毎回チェックする。ヒットしたら書き出し側、
#	ヒットしなかったらbaseを対象に操作するとか。
#	書き出ししていって、怪しい名前があったらヒットで再書き出しか。
#	ブロック削除スクリプトが必要かな。
#	自動的に無視されるけど、掃除しておくとか。
#	後で考えよ。

#	typeの重複登録を防ぐためにチェックする。
#	bt_nameの尻尾がaddならそのまま使う。
#	>> やめ。跡は残すことにする。

#buf=`echo "$bt_name" | sed -nre /_add$/p`
#if [ "$buf" != "" ] ; then
#	nt_name="$bt_name"
#else
#	buf=`echo "$lbl" | tr -d '><'`
#	nt_name="$bt_name""_$buf""_add"
#fi
#		...TWO_LEVEL_KPMU_add
buf=`echo "$lbl" | tr -d '><'`
nt_name="$bt_name""_$buf""add"

#echo unkokko$nt_name >/dev/stderr
#exit

#3. 中身を直接いじる前に方言を修正して標準語にする。
#smchはtypeの中身生。方言仮想modも単純置換だけど修正済み。smchに方言は存在しないはず。AltとかはMod1になってるはず。
smch=`./rebuildtype_xa.sh -f "$basefile" -t "$bt_name" -m "$rvmod"`
##    type "SHIFT+ALT" {
#        modifiers= Shift+Alt;
#        map[Shift+Alt]= Level2;
#        level_name[Level1]= "Base";
#        level_name[Level2]= "Shift+Alt";
##    };

rest=`echo "$smch" | awk '$1 !~ /modifiers/ {print $0}'`	#modefierを抜いたもの。あとで使う
# echo "$0: [[[[ $smch" >/dev/stderr

#4. typeからmaxlevelを判定する。typeのmodiは複数宣言エラー？ >> みたい。差し替えが必要ね。
#	とりあえず先に最新lvl判定。
buf=`echo "$rest" | tr ';' '\n' | grep map | ./ssp -fs '*=' 2 |
	sed -e 's/Level//g' | sort -rn | head -n 1`

#mapがない場合もある >>onelevel
if [ "$buf" = "" ] ; then
	buf=1
fi

#			...-rnででかい順に並ぶので最大レベルがわかる。
nlv=`expr $buf + 1`	#次以降に使うレベル番号
lvcomm="// override_nlv $nlv"
#echo "[[[[; $lvcomm" >/dev/stderr	#;sleep 1000

#6. 重複する場合はmap[]を消したりlvを合わせたりせず、lvとmapを無神経に追加していく。
# あとから追加で勝手に上書きされるので、そっちのほうが具合がいい。 >> 嘘。map[]は消す必要がある。
# あとでチェックして消す




#7.	modi書き換え用に重複しない使用modifierズを取得。
#	元のやつと、要求{}のモディを合体整理.
buf=`echo "$smch" | awk '$1~"modifier" {print $0}' | ./ssp -fs '*=' 2 `
newmod="$buf"" $reqmod"
newmod=`echo "$newmod" | tr '+;' ' ' | tr ' ' '\n' | grep -v '^$' | sort | uniq`
#		...	Control LevelFive Lock Mod1 Mod5 Shift ...
newmod=`echo -n "$newmod" | sed -e 's/any//g' | tr '\n' '+'  	`


#8. ここでany入りとそれ以外で処理
#	map[]を作成するが、anyの場合は別途処理が必要なので。
#	ここだけ分けて処理すれば、後ろは特に気にしなくていい。

# 部品のとりあえず完成
newmod="modifiers= ""$newmod"';'
newlv='map['"$reqmod"']= Level'$nlv';'

# echo "www $newlv" >/dev/stderr
#baseはmapを追加しない。nullでもいいんだけど。ややっこしいから。map[None] = Level4;
#が使えるので、やっぱ使う。 https://www.charvolant.org/doug/xkb/html/node5.html

# {} <LatA> :: {+s} <> みたいにmodがない。。。ベースキーを入れ替えるとき。
if [ "$reqmod" = "" ] ; then
	nlv=1
	newlv='map[None]= Level1;'
	lvcomm="// override_nlv 1"
fi
# echo "www $lvcomm" >/dev/stderr

#anyの場合はmap...lvl要求の再構築。
buf=`echo "$reqmod" | grep any`
if [ "$buf" != "" ] ; then
	#anyは全てのモディファイヤ処理が必要。
	newmod="modifiers= Shift+Lock+Control+Mod1+Mod2+Mod3+Mod4+Mod5;"
	#固定ファイル types_xa.list。255こ並んでる Shift Lock ...のスペース区切り。連続フィルタコマンド作成
	#要求modたちを含む組み合わせを取り出す。
	#mapだらけになるけど。
	
	buf=`echo "$reqmod" | sed -e 's/any//g' | tr '+' ' ' `
	set -- $buf
	ftr=""
	for ii
	do
		ftr="$ftr | grep $ii"
	done
	ftr=`echo "$ftr" | awk '{$1=""; print $0}'`	#頭の|を削除
	
	# #anyのみの場合は変になるのでさらに別処理 >> onelevelでいいみたいなので、一番最初に決め打ち。
	# ほんとはここでまとめて処理したいところ。
	# if [ "$ftr" = "" ] ; then
	# 	nlv=1
	# 	ftr=' | cat - '
	# 	lvcomm="// override_nlv 1"
	# fi
	
	newlv=`cat "types_xa.list" | eval "$ftr" | tr ' ' '+' | awk -v nlv="$nlv" '{
		out="map[" $0 "]= Level" nlv ";"
		print out
	}'`
fi

# echo "rrr_$newlv" >/dev/stderr
#echo "___ $newmod"
#exit



#	これで材料は揃ったので、newtypeブロックを生成.restがソース大部分になる。
hd="type \"$nt_name\" {"	#ヘッダ
ntblk=`printf '%s\n%s\n%s\n%s\n%s\n%s\n' "$hd" "$newmod" "$rest" "$newlv" "$lvcomm" "};" `
# echo "oooo $ntblk" >/dev/stderr

# こんなんが出てくる。
# type "TWO_LEVEL_AE01add" {
# modifiers= Control+Mod1+Shift;
#         map[Shift]= Level2;
#         level_name[Level1]= "Base";
#         level_name[Level2]= "Shift";
# map[Shift+Control+Mod1]= Level3;
# // override_nlv  3
# };

#上から再度形を整えて、mapの重複を調査,削除する
#1行1コマンド, 整形
rbase=`echo "$ntblk" | sed -e 's/[;]/;\
/g' | awk '$1 != "" {print $0}'`
#re_base?

#get map line with line num
mp=`echo "$rbase" | cat -n - | tr '[:upper:]' '[:lower:]' | 
	awk '$2 ~ /^map/ {print $0}' | tr -d ' ' | tr '][' ' ' | awk '{print $1 " " $3}'`
#mp=`echo "$rbase" | cat -n - | tr '[:upper:]' '[:lower:]' | 
#	awk '$2 ~ /^map/ {print $0}' | sed -re 's#([0123456789]+)(.*[[])(.*)([]].*$)#\1 \3#g'`
# 3行目 map[Shift]= Level2; ... みたいな。
# echo "ppp___$mp" >/dev/stderr
# 3 shift+control ...みたいに取り出した。


mp=`echo "$mp" | tr '+' ' ' `
#sort each lines. 並びを統一して比較しやすくする
mp_s=$( echo "$mp" | while read -r A
do
	buf=`echo "$A" | tr ' ' '\n' | awk '$1 != "" {print $0}' | sort | tr '\n' ' '`
	echo "$buf"
done | awk '{$(NF+1)=$1; $1=""; print $0 }' | sort -n )
# numlock control 4
# shift 3
# shift 7

# echo "tttt $mp_s" >/dev/stderr


#重複map行番号、最新以外。 基本的に一つの要求なのでブッキングはゼロか1で、2以上とか複数はないはず
#>>onelevelですり抜け発生, anyで大量にある場合の問題
nums=`echo "$mp_s" | awk '
	{ bufn=$NF }
	{ $NF=""; buf = $0 }
buf == bbuf { 
	if(bufn < bbufn){
		print bufn
	}else{
		print bbufn
	}
}
	{bbuf=buf; bbufn=bufn} ' `
set -- $nums	# 34 44 etc
# echo "@@@ $nums" >/dev/stderr
# echo "@@@ $mp_s" >/dev/stderr
# echo "@@@ $rbase" >/dev/stderr

nbase=`echo "$rbase" `
if [ $# -ne 0 ] ; then
#rbaseが元で、numsが削除すべき行番号。

#tgtln=`echo "$rbase" | sed -nre "${1}p" `
##	map[Shift]= Level2;	こんなのがとれるので、lvlを保存しとく。>>ここが問題。再スキャンして
## 抜けを確認した方が安全。抜け番号があったらそっちに変更。
#echo "kkkk_$tgtln" >/dev/stderr
#echo "uuuu_$nbase" >/dev/stderr
#newlvl=`echo "$tgtln" | tr '=;' ' ' | awk '{print $NF}' | tr -d -c '0123456789'`
#重複行の削除。
nbase=`echo "$rbase" | ./n_abone_xa.sh "$@" `

#削除したら再スキャンしてlvに飛びがないか確認する。 lost a tooth
# map[Control+Mod2]= Level3;	こんなのから。
ck_lt=`echo "$nbase" | tr '][=;' ' ' | awk '$1 == "map" {print $NF}' | 
( echo "1 " ; tr -d -c '01234567890\n' ) | sort -n | uniq`
# echo "uuuuu$nbase" >/dev/stderr
# echo "kkkk $ck_lt" >/dev/stderr
cklv=`echo "$ck_lt" | awk '
{
	buf=NR-$0
	if (buf!=0){
		print NR
		exit
	}
}
END{
	if(buf==0){
		print $0
	}
}
'`
# 抜けがあったら抜け番号、なかったら最大の数字
# echo "@@@@$nlv "  "$cklv" >/dev/stderr

# aboneしたけど, // over とmapのlvを修正。変わってない場合はスキップ
if [ "$nlv" != "$cklv" ] ; then
	nbase=`echo "$nbase" | awk -v nlv="$nlv" -v cklv="$cklv" '
	$1 ~ /^map/ && $0 ~ '"/evel$nlv"'/ {
		gsub(/=.*/, "= Level" cklv ";", $0)
	}
	$0 ~ /override_nlv/ {
		$0 = "// override_nlv " cklv
	}
	{print $0}' `
fi

# echo "ppppp $nbase" >/dev/stderr
# sleep 1
#exit
fi


echo "$nbase" | tee /dev/stderr
# sleep 10

# こんなんが出てくる。
# type "TWO_LEVEL_AE01add" {
# modifiers= Control+Mod1+Shift;
#         map[Shift]= Level2;
#         level_name[Level1]= "Base";
#         level_name[Level2]= "Shift";
# map[Shift+Control+Mod1]= Level3;
# // override_nlv  3
# };


#依存はこのへん。
#alias <>
#key <>
#type block
#...重複と空の場合は処理しなきゃ。
#重複処理は後続にも影響があるのでreturn先で処理してほしい。
