#!/bin/sh
# test platform ... debian dash

# GPL_3 license
cat << 'EEE' > /dev/null
/* readlink_p .... portable readlink. bourne-shell script
 * Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE


buf=`./rdopt "hf:i:" "$@"`
if [ $? -ne 0 ] ; then echo "$0: optErr. see -h. sleep." >/dev/stderr ;sleep 1000; exit 1; fi
eval "$buf"

if [ "$opt_f" = "" ] || [ "$opt_i" = "" ] ; then
	echo "$0: optErr. see -h" > /dev/stderr
	exit 1
fi


# ./modset_xa.sh -f unko -i redtest.ini

sfile="$opt_f"
inifile="$opt_i"

tmpfile1="$0.buf1"
tmpfile2="$0.buf2"
cp "$sfile" "$tmpfile1"


#vmodsを追加。keyブロック内に置けるのでそうする。
# Alt_L Alt
# Alt_R Alt
# Meta_L Meta
# Meta_R Meta	リスト

sym_vmod=`cat "$sfile" | awk ' $1 == "interpret" || $0 ~ /virtualModifier/ {print $0}' |
 ./ljt -1 '/interpret/' -2 '/virtualMod/' -s "@@@" | grep '@@@' |
  tr '+=;' ' ' | awk '{print $2 " " $NF}' `

# ... modset <LatA> <LatB> :: Shift/set (Shift_L)
cat "$inifile" | awk '$1 == "modset" {print $0}' |
while read -r A
do
	echo "--- $A" >/dev/stderr

	buf=`echo "$A" | awk '{print $(NF-1)}' | tr '/' ' ' | tr "[:upper:]" "[:lower:]" `
	set -- $buf	#+s+c ...

	#modiを判別整形。特定文字以外はエラー
#	buf=`echo "$1" | sed -re 's#[+]s|[+]l|[+]c|[+]m1|[+]m2|[+]m3|[+]m4|[+]m5##g' | tr -d '}{'`
#
#	if [ "$buf" != "" ] ; then
#		echo "$0: invalid modname (allow {+s} etc), sleep 1000" > /dev/stderr
#		sleep 1000
#		exit 1
#	fi
# >> reqmodに任せる

	modt=`echo "$1" | ./reqmod_xa.sh `	#req mod... Shift+Control-Mod1   etc
	# +s+c からShift+Controlへ

	#stateを判別整形
	if [ "$2" != "set" ] &&
		[ "$2" != "lock" ] &&
		[ "$2" != "latch" ] ; then
		echo "$0: invalid modstatename" > /dev/stderr
	fi
	b1=`echo "$2" | cut -c 1 | tr "[:lower:]" "[:upper:]" `
	b2=`echo "$2" | cut -c 2- `
	mods="$b1$b2""Mods" #lock からLockModsへ

	# add clear
	if [ "$2" != "lock" ] ; then
		modt="$modt,clearLocks"
	fi

	#対象ラベル達を取り出し。リアルラベル調査変更
	modl=`echo "$A" | ./ssp -bl -- '::*' 1 | awk '{$1=""; print $0}'`
	set -- $modl
#	echo "$modl" > /dev/stderr

	modl=""
	for ii
	do
		buf=`./cklabel_xa.sh -f "$sfile" -l "$ii"`
		modl="$modl ""$buf"
	done
	set -- $modl
#	echo "$modl" > /dev/stderr

	modl="$@"	#タブ空白フォーマット 基本的に単独ラベル<AB01>とか。modsetは複数<>許可なので。

	#整形完了。シンボルはどうしようか。自動検索か指定させるか。
	#右か左かわかんないし、指定させよう。
	sym=`echo "$A" | awk '{print $NF}' | tr -d ')(' `


	# 追加。仮想modを入れる。対象modから対応する仮想modを引っ張り出す
	# 仮想modは基本的にキーラベルに結びついているので、シンボルを見る
	# NuSymbolの場合は仮想はタッチしない。
	# set側と両対応させようと思ったけど無理。

#	modbuf=`echo "$modt" | tr '+' ' ' | sed -re 's/,.*$//g'`
#	for ii in $modbuf
#	do
	vmodstr=`echo "$sym_vmod" | awk '$1 == "'"$sym"'" {print $2 "+"}' |
	 tr -d '\n' | sed -e 's/[+]$//g'`
	echo "$sym_vmod" >/dev/stderr
	if [ "$vmodstr" != "" ] ; then
		vmodstr=",virtualMods= $vmodstr"
	else
		vmodstr="//---no virtualMods"
	fi
#	done


	#以上で材料は揃った。ブロックを作成する。
	#echo "$modt" " $mods" " $modl" " $sym"
	blk=""
	for ii in $modl
	do
	blk="$blk""
key $ii {
	"'type= "ONE_LEVEL",'"
	symbols[Group1]= [ $sym ],
	actions[Group1]= [ $mods(mods=$modt) ]
	$vmodstr
};"
	done
	blk=`echo "$blk" | awk '$1 != "" {print $0}' `
	echo "$blk" > /dev/stderr
	#キーを追加する...んだけど、元のキーラベル削除する？しよう。modlが <>の羅列。
	echo "$modl" | ./delkey_xa.sh -f "$tmpfile1" > "$tmpfile2"
	echo "$blk" | ./addcode_xa.sh -f "$tmpfile2" -b xkb_symbols > "$tmpfile1"
	#cp "$tmpfile2" "$tmpfile1"
done
cat "$tmpfile1"
echo "--- $0: end" >/dev/stderr

#./modset_xa.sh -f unko -i redtest.ini
# ./modset_xa.sh -f unko -i redtest.ini >/dev/null

#key <AC01> {
#	type= "ONE_LEVEL",
#	symbols[Group1]= [ NoSymbol ],
#	actions[Group1]= [ SetMods(mods=Shift,clearlocks) ]
#	,virtualMods= Alt
#};
#
#ラベルだけだと仮想modの紐付けができなそう。mofifier_mapの作成も必要かも。
# 試したらactionだけでも勝手に紐付けされた気がする。
