#!/bin/sh
# test platform ... debian dash

# GPL_3 license
cat << 'EEE' > /dev/null
/* readlink_p .... portable readlink. bourne-shell script
 * Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE


buf=`./rdopt "hf:i:" "$@"`
if [ $? -ne 0 ] ; then echo "$0: optErr. see -h. sleep." >/dev/stderr ;sleep 1000; exit 1; fi
eval "$buf"

if [ "$opt_f" = "" ] || [ "$opt_i" = "" ] ; then
	echo "$0: optErr. see -h" > /dev/stderr
	exit 1
fi
# ./red_xa.sh -f unko -i tes.ini


sfile="$opt_f"
inifile="$opt_i"

tmpfile1="$0.buf1"
tmpfile2="$0.buf2"
cp "$sfile" "$tmpfile1"


#-----------
echo "--- $0:" >/dev/stderr

#numとインジケータ番号の突き合わせ, exchange list
# 元ネームが必要なので、対象のled番号 - ネームをリストしておく。
# exlist=`cat "$tmpfile1" | ./getblock_xa.sh '$1 == "xkb_keycodes"' |
# 	awk '$1 == "indicator" {print $0}' | tr '[:upper:]' '[:lower:]' |
# 	awk '{print $0 " " $2}' | tr -d ';' | ssp -fs '*"' 2 | sed -re 's#^#"#g' `
# echo "$exlist" >/dev/stderr ; sleep 1000

cat "$inifile" | awk '$1 == "led" || $1 == "aled" {print $0}' | while read -r a
do
	echo "--- $a" >/dev/stderr

	#led番号
#	buf=`echo "$a" | awk '{print $2}' ` 
#	tgt_n=`echo "$exlist" | awk -v buf=$buf '$2 == buf {print $1}' | ssp -fl '*"' 1 | tr -d '"'`
	tgt_n=`echo "$a" | awk '{print $2}' ` 
	tgt_name="\"led$tgt_n\""
	
	#対応mod, Shift+Lockとかok {+s+c}
	buf=`echo "$a" | tr ':/' ' ' | awk '{print $3}' ` 
	tgt_mod=`echo "$buf" | ./reqmod_xa.sh `
	#反応する状態. 大文字小文字は向こうでやってくれると思う。
	tgt_state=`echo "$a" | tr ':/' ' ' | awk '{print $4}' | tr '[:upper:]' '[:lower:]' |
	awk '
	$0 ~ /base/ {print "base"}
	$0 ~ /latch/ {print "latched"}
	$0 ~ /lock/ {print "locked"}
	$0 ~ /ef/ || $0 ~ /set/ {print "effective"} 
	$0 == "set" {
		buf="echo \"...led state allows base/lock/latch/effective. translate -effective-\" > /dev/stderr"
		system(buf)} 
	'` 
#	echo $tgt_mod >/dev/stderr
#	echo $buf >/dev/stderr
#	sleep 100
	
	#外部操作許可
	tgt_allow=`echo "$a" | 
	awk '$1 == "led" {print "!allowExplicit"}
		 $1 == "aled" {print "allowExplicit"}' ` 
	
	#組み立て。ブロック分と定義分。
	kbstr="indicator $tgt_n = $tgt_name;"
	defstr="indicator $tgt_name {
		$tgt_allow ;
		whichModState= $tgt_state ;
		modifiers= $tgt_mod ;
	}; "
	
	echo "$kbstr" > /dev/stderr
	echo "$defstr" > /dev/stderr
	
	#追加する前にブッキングを消す。
	#コード内の行番号とターゲット名。
	buf=`cat "$tmpfile1" | awk '{print $0 " " NR}' |
	 ./getblock_xa.sh '$1 == "xkb_keycodes"' |
	awk -v num=$tgt_n '$1 == "indicator" && $2 == num {print $0}' |
	./ssp -fs '*=' 2 | tr -d ';' `
#	echo "$buf" > /dev/stderr
	
	del_n=`echo "$buf" | awk '{print $NF}'`
	bufname=`echo "$buf" | awk '{$NF=""; print $0}' | sed -e 's# \{1,\}$##g'`
	cmd=" ./getblock_xa.sh -r -v '\$1 == \"indicator\" && \$0 ~ /$bufname/' "
	
	#echo "$cmd" > /dev/stderr
	# echo "$del_n" > /dev/stderr

	#cat "$tmpfile1"  | eval "$cmd"
	#exit
	
	#とりあえずキーコード宣言部分は殺せる。
	cat "$tmpfile1" | ./n_abone_xa.sh "$del_n" > "$tmpfile2"
	cp "$tmpfile2" "$tmpfile1"

	#exit
	#コンパチブロック内のみ消したい。ポジションも引っかかるのでなんとか。
	#-sオプションでもいいんだけど。レンジを計測して削除か。

	range=`cat "$tmpfile1" | ./getblock_xa.sh -n '$1 == "xkb_compatibility"' | 
		sed -ne '1p;$p' | awk '{print $1}'`
	set -- $range
	range1="1-"`expr $1 - 1`
	range2="$1-$2"
	range3=`expr $2 + 1`"-"

#	echo "$tmpfile1 $range1 $range2 $range3" 
#	sleep 10

	
#	exit
	cat "$tmpfile1" | ./getblock_xa.sh -N | awk '{$1=""; print $0}' | ./lcat $range1 > "$tmpfile2"
#	cp "$tmpfile2" "$tmpfile1"
	cat "$tmpfile1" | ./getblock_xa.sh -N | 
		awk '{$1=""; print $0}' | ./lcat $range2 | eval "$cmd" >> "$tmpfile2"
#	cp "$tmpfile2" "$tmpfile1"
	cat "$tmpfile1" | ./getblock_xa.sh -N | awk '{$1=""; print $0}' | ./lcat $range3 >> "$tmpfile2"
	cp "$tmpfile2" "$tmpfile1"
	
	#放逐完了。追加する。
	echo "$kbstr" | ./addcode_xa.sh -f "$tmpfile1" -b xkb_keycodes > "$tmpfile2"
	cp "$tmpfile2" "$tmpfile1"
	echo "$defstr" | ./addcode_xa.sh -f "$tmpfile1" -b xkb_compatibility > "$tmpfile2"
	cp "$tmpfile2" "$tmpfile1"
done

cat "$tmpfile1"
echo "--- $0: end" >/dev/stderr

# indicator "Caps Lock" {
#     !allowExplicit;
#     whichModState= locked;
#     modifiers= Lock;
# };

