#!/bin/sh
# test platform ... debian dash

# GPL_3 license
cat << 'EEE' > /dev/null
/* readlink_p .... portable readlink. bourne-shell script
 * Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE


# cat ...xkb | ./keyblkfmt_xa.sh '<AE01>' | ./keyblktype_xa.sh
#整形した並びから各グループのモディファイヤタイプを決定する。
# シンボルは暗黙とかあるけど、@は全削除して比較。
# グループは1しか見ない。

#見てるのはgroupとtypeのみ。それ以外の行は空気。

#ctype  null 
#Group@1 1           exclam 
# // ---gsplit
#
# >>> Group@1 TWO_LEVEL
echo "--- $0:" >/dev/stderr 

key_typeck(){
awk '
#入力はGroup1とかtypeの羅列。整理済みデフォルト判定はTWO_LEVEL

{buf=tolower($1); gsub(/@/, "", buf)	}	#case-insensitive
buf ~ /^ctype/{ deftype=$2}
buf ~ /^type/{ deftype=$2}

#group記述。。。つまりtype系が途切れた。判定の時間

buf ~ /^sgroup1/ || buf ~ /^agroup1/ {
	if(NF-1 == 1){
		auto="ONE_LEVEL"	#まずレベルをスプリットしてone判定
	}else if( $2 != $3 && toupper($2) == $3 ){
		auto="ALPHABETIC"			#lowerとかupperなら２
	}else{
		buf=1				#KP_が全てに入っていたらkeypad
		for(i=2; i<=NF; i++){
			buf=buf*match($i, /KP_/)
		}
		if(buf != 0){
			auto="KEYPAD"
		}else{
			auto="TWO_LEVEL"
		}
	}
	# auto判定完了
	
	#print は$1でいい。 ... こんな。	sGroup1 ALPHABETIC
	
	if(deftype != "null"){		#keyブロック内で指定typeがあったらそいつ。それ以外は自動。
		print NF " " $1 " " deftype " "
	}else{
		print NF " " $1 " " auto " "
	}
	#判定は住んだけど、asで2つのブロックが異なるシンボル数を持つことがある。多い方。
	
}' | sort -n | head -n 1 | awk '{$1=""; print $0}'
}

#main---
key_typeck | tee /dev/stderr
echo "--- $0: end" >/dev/stderr 

