#!/bin/sh
# test platform ... debian dash

# GPL_3 license
cat << 'EEE' > /dev/null
/* readlink_p .... portable readlink. bourne-shell script
 * Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE


buf=`./rdopt "hf:l:" "$@"`
if [ $? -ne 0 ] ; then echo "$0: optErr. see -h. sleep." >/dev/stderr ;sleep 1000; exit 1; fi
eval "$buf"

#key= $1

if [ "$opt_f" = "" ] || [ "$opt_l" = "" ] ; then
	echo "$0: optErr. see -h. sleep" > /dev/stderr
	sleep 1000
	exit 1
fi

sfile="$opt_f"
label="$opt_l"
tmpfile1="$0.buf1"
tmpfile2="$0.buf2"
# ラベルとファイルを突っ込むと整形したkeyブロックを吐く。
# こんな感じ
#ctype null 
#sGroup1 NoSymbol
#aGroup@1  RedirectKey(key=<LFSH>)
#//

# 暗黙の.typeのシンボル有無とブロックに追記して、対応ブロックの中身を出力。最終ヒットのみ。
# 整形は後工程に回す。
# cat "foo.xkb" | f_basicsv		...できたらxkbはxkbcomp $DISPLAY -> foo で新鮮なのを。
# ctype、check_typeが追加。全体でデフォ設定がされている場合の下ごしらえ。
# デフォtypeを子ブロックに無差別追加。

f_xkbsymbols_base(){
./getblock_xa.sh  '$1 == "xkb_symbols"' | awk '
 BEGIN { basictype="ctype= \"null\"" }
 $1 == "key.type" {
	rtn=split($0, a, "=;")
	basictype="ctype= " a[1]
 }
 $1 == "{" {
	gsub("{","{\n" basictype "," , $0)
	}
 { print $0 }'
}


#<LFSH>とかのラベル
#lb="$1"
#svt
#echo $1
#svt_2 '$1 == "key" && $2 == "'"$lb"'"'

##./servey_type.sh -f unko '<LFSH>'
##keyブロックのtypeとかsymbolとかを整形する。
#key_styleformat(){
#sed -re 's/symbols//g' | sed -re 's/[]][^[]*[,]/]\n/g' | 
#awk ' $1 != "" {print $0}' | tr  '[]=,' ' ' | sed -re 's/^[ \t]*//g' |
#awk '
# BEGIN{num=1}
# $1 !~ /Group/ && $1 !~ /type/ {
# $0 = "Group@" num " " $0
# num=num+1}
# {print $0}' | tr -d '"'
#}

#main----
#複数ブロックの場合に困るので考慮
#ストリーム処理が良かったけど、一時ファイルで事前調査しかないか。
#最終ブロックのみ出力に変更

cat "$sfile" | f_xkbsymbols_base > "$tmpfile1" 	#デフォtypeを追加したkeyblock郡。いっぱい。
# 切り出し。中身だけじゃなくてブロック全体がほしいから。

hit=`cat "$tmpfile1" | awk '$1 == "key" && $2 =="'"$label"'" {print NR}'`
# echo @@@$hit$label > /dev/stderr
buf=`echo "$hit" | awk '
	BEGIN{bf=0}
	{
		print bf " -" $0-1
		bf=$0}
	END{print bf " -"}' | awk '$1 != 0 {print $0}' | tr -d ' ' | sed -ne '$p' `
#bufファイルで、切り出し行位置を下準備。カンマだったり};だったりで糞なので。
# hitでラベルの頭行を取り出して、ラベル名（複数可能性）のブロック行を10-14形式で。
# あとでsedを追加して最終のみ対象にした。

#echo pppppp$buf >/dev/stderr
#暗黙typeが追加されたkeyブロックを整形表示。
for i in $buf	# 10-14 23-34 ... sedで最終のみに変更してる
do
#echo "//"

cat "$tmpfile1" | ./lcat $i | 
	./getblock_xa.sh '$1 == "key" && $2 =="'"$label"'"' |
	awk '$1 !~ /^\/\// {print $0}' | 	#後工程で引っかかったので追加。コメ行削除。awkは[]がびみょい。
	./keyformat_xa.sh #| key_typeck ... keytypeblkに分離。単体のkey解析はよく使うのでここで止める。
done

# こんな感じ
#ctype null 
#sGroup1 NoSymbol
#aGroup@1  RedirectKey(key=<LFSH>)
#// ---gsplit
#nanika=00;



#test
#echo 'key <AE13> {
#		  ctype= null
#	[       back,        ],	[       back,    BACK    ],
#        symbols[Group1]= [       backslash,             bar ],
#        symbols[Group2]= [             yen,             bar ],
#         type= PC_ALT_LEVEL2 ,
#        [       KP_1 , two       ]
#    };' | ./getblock.sh '$1 == "key"' | ./keyblkfmt_xa.sh
    
    
# sed -re 's/[]][^[]*[,]/]\n/g' | awk ' $1 != "" {print $0}' |
# tr  '[]=,' ' ' | sed -re 's/^[ \t]*//g' | awk '
# BEGIN{num=1}
# $1 !~ /Group/ && $1 !~ /type/ {
# $0 = "Group@" num " " $0
# num=num+1}
# {print $0}' | awk '		#Group1とかtypeの羅列。
#$1 ~ /^ctype/{ deftype=$2}
#$1 ~ /^type/{ deftype=$2}
#$1 !~ /type/{
#	#デフォルト判定はTWO_LEVEL
#	auto="TWO_LEVEL"
#
#	#まずレベルをスプリットでone判定
#	if(NF-1 == 1){
#		auto="ONE_LEVEL"
#	}else if( $2 != $3 && toupper($2) == $3 ){
#		#lowerとかupperなら２
#		auto="ALPHABETIC"
#	}else{
#		#KP_が全てに入っていたらkeypad
#		buf=1
#		for(i=2; i<=NF; i++){
#			buf=buf*match($i, /KP_/)
#		}
#		if(buf != 0){
#			auto="KEYPAD"
#		}
#	}
#	
#	if(deftype != "null"){
#		print $1 " " deftype
#	}else{
#		print $1 " " auto
#	}
#}'
 
 
 #| awk '
 
#$1 ~ /type/{print $0}
#$1 !~ /type/{
#	#まずレベルをスプリットでone判定
#	if(NR-1 == 1){
#		print "auto= ONE_LEVEL"
#	}else if( $2 != $3 && toupper($2) == $3 ){
#		#lowerとかupperなら２
#		print "auto= TWO_LEVEL"
#	}else{
#		#KP_が全てに入っていたらkeypad
#	buf=1
#	for(i=2; i<=NR; i++){
#		buf=buf*match($i, /KP_/)
#	}
#	if(buf != 0){
#		print "auto KEYPAD"
#	}else{
#		#残りはtwo
#		print "auto TWO_LEVEL"
#	}
#	}
#}' 
