#include <emsg: see ... '~$ sh aaa.sh.c -h'   (other opt:no/-m/-w/)>	/*
C='^[#]SH_'     ;O=${0##*[/]};R=`dirname $0`;R=${R%/}/;R0=$R$O;R=$R${O%%.*}
O=${0##*.};Rs=$R.$O;Rm=$R.tmp.$O;Rh=$R.h;R=$Rs$Rh$Rm;Rp='printf %s\n ';Rc=:;O="
";[ "${R##*$R0*}" = '' ]&&$Rp"$0:NGsuffix"&&exit 1;R='sed -ne ';Cm=$R'"/[E]ND/!d
:l;n;p;bl"<$R0>$Rm;$Rp"$Rm"';RB=$($R"s/${C}OP//p"<$R0|(F=mw;while read -r a b;do
B=${a%:};F=`$Rp"$F"|$R"s#$B:*##1;p"`${a%_};$Rp"C$B=\$(cat<<'E'$O$b${O}E$O)";done
$Rp"R1=$F"));Rw=$R'"/$C$R/!d;:l;n;/${C}ED/q;p;bl"<$R0';Cw="(R=LS;$Rw;$Rw>&3;R=HD
$Rw;R=SC;$Rw>&3)"'>$Rh 3>$Rs;$Rp"$Rh $Rs"';Re=eval\ ;$Re"$RB";while getopts $R1\
 R;do case $R in \?)exit 1;;*)$Re"O$R=\$OPTARG";Rc=$Rc$O`$Re'$Rp"$C'$R\"`;;esac
done;[ "$Rc" = : ]&&Rc=$Cm;shift $((OPTIND-1));$Re"$C_$O$Rc";exit   #END GPL3+*/

#SH_LS
#!/bin/sh
# GPL_3+
cat << 'EEE' > /dev/null
/* Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE
cat << 'EEE' > /dev/null
#SH_doc
title=*SH_bn* section=1 repnl=\040
@name *SH_bn*
@_brief X11 keyconfig, xkbcomp setting helper
@_syno
	*SH_bn* [-hHVls] [-f basefile] [-i inifile] [-a outfile]

@tl;dr
		@(code)@
	~$ xkbcomp $DISPLAY ./keymap.dfl
	~$ xkmp -f keymap.dfl -i setting.ini	#output xkmp.out
	~$ xkmp -a xkmp.out		#apply
	( ~$ xkbcomp keymap.dfl $DISPLAY		#rollback)
		@()
@_opt
	@(list_o)
	-hHV: usage, version
	-l: list for ini setting symbols/keycode etc
	-s: output sample inifile
	-f basefile: basefile made by ~$ 'xkbcomp $DISPLAY -'
	-i inifile: keymap setting file. see '-s' and edit
	@()
@_desc
	'*SH_bn*' makes keymap config file for X11. 
	X11 has standard keyboard setting system `xkbcomp`, but this is
	very complex so noone can handle it. --
	'*SH_bn*' helps to make `xkbcomp` setting with more general	syntax/files. 
	keymap.ini accepts the below commands: --
	'  'define, modclear, keymv, keycp, keydef, modset, red, led, repeat --
	--
	see 'xkmp -s' about keymap.ini detail setting.
@_eg
	@(code)@
	~$ cat << 'EEE' > mykey.ini
	keymv <CAPS> :: <LCTL>	#swap caps<->ctrl
	keymv <LCTL> :: <CAPS>
	keymv <INS>  :: null	#kill ins
	EEE
	
	~$ xkbcomp $DISPLAY - > keymap.dfl
	~$ xkmp -f keymap.dfl -i mykey.ini	#>> output xkmp.out
	~$ xkmp -a xkmp.out		#>> apply keymap
	~$ xev	#>> test keysetting. push ins etc
	~$ xkbcomp keymap.dfl $DISPLAY	#>> rollback to default
	@()@
@exit_status
	suc/fail == 0/not 0

@notes
	I used AutoHotKey(AHK) for keymappting. this app is the result of 
	anger spill over for X11/xkbcomp.
@conforming_to	posix-shell
@copyright	Copyright (C) 2018 Momi-g
@_ver 2021-09-07 v2.0.0
@_see 'xkbcomp(1), xmodmap(1), xev(1), xbindkeys(1), xdotool(1)' --
	'wmctrl(1), bind(bash), zenity(1), dialog(1)' --
	@(code)@
	
	---recommend info
	https://www.charvolant.org/doug/xkb/html/node5.html
	http://pascal.tsu.ru/en/xkb/
	https://wiki.archlinux.jp/index.php/X_KeyBoard_extension
	https://qiita.com/ZeptByteS/items/db1de2cbd940c65b8d1f
	https://github.com/mooz/xkeysnail
	---official, but not recommend
	https://www.x.org/releases/current/doc/libX11/XKB/xkblib.html
	@()@
#SH_docE
EEE
#SH_ED

#SH_HD
#SH_ED

#SH_SC
f_usage(){
cat << 'EEE'
HowTo (xkmp, xkbcomp setting helper)
opt: -f(basefile), -i(nifile), -a(pply), -s(ample ini), -l(lbl/sym list) -hHV
------
you *SHOULD* save your dfl key setting for recovery. keymap is very sensitive.
	xkbcomp $DISPLAY ./keymap.dfl	#... save
	xkbcomp ./keymap.dfl $DISPLAY	#... rollback
--
1. make basic file
	~$ xkbcomp $DISPLAY base.file
	
	# mymap.ini
	red {+s} <LatJ> :: {} <UP>	# shift+J -> up

2. run xkmp generate keymap file for 'xkbcomp'
	~$ xkmp -f base.file -i mymap.ini	# -f: xkmp needs pure basefile.

3. apply 'xkmp.out' to 'xkmp -a' or 'xkbcomp'
	~$ xkmp -a xkmp.out	..or..	~$ xkbcomp xkmp.out $DISPLAY

4. check working or recover
	~$ xev	 ..or.. ~$ xkbcomp base.file $DISPLAY (rollback)
...see 'xkmp -s/H'
EEE
	exit 0
}

f_usage_H(){
 cat << 'E E'|sed -e'1d;$d'
	#SH_rf* *SH_bn*.1.txt	*
E E
exit 0
}
f_version_info(){
cat << 'EEE'
*SH_bn* *SH_ver*
Copyright (C) 2018 Momi-g
License GPLv3+: GNU GPL version 3 or later <https://gnu.org/licenses/gpl.html>
EEE
exit 0
}

#	X11 keymapping helper
# ... xkbcomp $DISPLAY base.file
# ...  ./xkmp.dash -f base.file -i mykey.ini
# ... xkbcomp xkmp.dash.out $DISPLAY
# ... xkbcomp base.file $DISPLAY	...reload

f_err(){ echo "`basename $0`: $*" >/dev/stderr; exit 1;}
f_fileck(){ [ -f "$1" ]||f_err "ERR: ${2-""} file $1 not found" ;}
f_abs()( buf="$1"; [ "${1#/}" = "$1" ] && buf="$PWD/$buf"; printf '%s' "$buf")

*SH_bn*_main()(
 tdir="/tmp"
 cdir="$PWD"
 # cd "$bdir"	#<< argでfile指定があるからここでcdするとnot foundになる 終わってから。
 b="$0"
 while :;do
   [ "${b##/*}" = "" ]||b="$PWD/$b"
   cd "${b%/*}"
   [ -L "$b" ]||break
   pre="$b: symbolic link to @"
   LC_ALL=C b=`file -h "$b"|cut -b ${#pre}-; printf @`
   b=${b%??}
 done
 cd "$cdir"
 bdir=`dirname "$b"`
 bname=`basename "$b"`
 PATH="$bdir:$PATH"
 
 cmd=$(cat <<- 'END'   # 'END'.. not expand $foo etc. 
    # opt dfl  type	( +add command you want to test input opt)	
      -h   0	bool	f_usage
      -H   0	bool	f_usage_H
      -V   0	bool	f_version_info
      -l   0	bool	'f_list_info "$bdir"'
      -s   0	bool	'f_sample "$bdir"'
      -i   nofile	str
      -f   nofile	str
      -a   0	str		'f_apply "$opt_a"'
	END
 )
 buf=`$bdir/ckopt "$cmd"`  #..or.. "$cmd"  (colon, quiet err mode as getopts )
 eval "$buf"
 
 f_fileck "$opt_i" "inifile"
 f_fileck "$opt_f" "baseini"
 sfile=`f_abs "$opt_f"`
 inifile=`f_abs "$opt_i"`

 cd "$bdir"
 tmpf_1="$tdir/$bname.buf1"
 tmpf_2="$tdir/$bname.buf2"
 tmpf_3="$tdir/$bname.buf3"
 tmpf_4="$tdir/$bname.buf4"
 tmpf_out="$tdir/$bname.out"
 tmpf_base="$tdir/$bname.base"

 echo "bin dir: $bdir" >/dev/stderr
 pwd>/dev/stderr

 #--main start
 cp "$sfile" "$tmpf_base"

 #0. 途中経過表示
 echo "$0: show status to stderr ..." > /dev/stderr

 #1. iniのコメント削除とラベルreplace		lnick @a :: <LatA>
 ./replace_xa.sh -i "$inifile" > "$tmpf_4"
 inifile="$tmpf_4"
 # 色々使う仮想modの情報取得. 下準備. default状態の奴を準備 両方必要なので纏めない
 # symbol2real list, read-vmk list
 s2rmods=`./improvemodifier_xa.sh "$tmpf_base" ` # modifier_map Control { Shift_L };
 rvmods=`./vmod2rmod_xa.sh "$tmpf_base" "$s2rmods"`	# alt alt_l alt_r ...etc real-vmk list

 #2. デフォから指定mod削除	modclear {+s+c+m1}
 cat "$inifile" | awk '$1 == "modclear" {print $0}' > "$tmpf_1"
 ./modclear_xa.sh  -f "$tmpf_base" -i "$tmpf_1" -s "$s2rmods" -m "$rvmods" > "$tmpf_3"
 cp "$tmpf_3" "$tmpf_base"

 #3. keyset系再配置 keymv,keycp 
 ./keyset_xa.sh -f "$tmpf_base" -i "$inifile" > "$tmpf_3"
 cp "$tmpf_3" "$tmpf_base"

 #4. defkeyキーコード作成。ブロック系なのでini直接読み込み。
 ./deflbl_xa.sh -f "$tmpf_base" -i "$inifile" > "$tmpf_3"
 cp "$tmpf_3" "$tmpf_base"

 #5. モディファイヤの指定。	 modset <LatA> <LatB> :: @shift/set (Shift_L)	とか。
 cat "$inifile" | awk '$1 == "modset" {print $0}' > "$tmpf_1"
 ./modset_xa.sh  -f "$tmpf_base" -i "$tmpf_1" > "$tmpf_3"
 cp "$tmpf_3" "$tmpf_base"

#define <mKey> :: {
#	kc=255
#	mod=[base, +s, +s+c]
#	sym=[g, Shift_L, A]
#	repeat=off
#}

 #5. remap実行	remap <LatA> :: <LatB>  / or null	>> omitした。remap自体はkeycpで内部で使用してる。
 cat "$inifile" | awk '$1 == "remap" {print $0}' > "$tmpf_1"
 ./remap_xa.sh -f "$tmpf_base" -i "$tmpf_1" > "$tmpf_3"
 cp "$tmpf_3" "$tmpf_base"

 #6. red指定	red {+s+c} <LatT> :: {+s} <LatU>
 cat "$inifile" | awk '$1 == "red" {print $0}' > "$tmpf_1"
 ./red_xa.sh -f "$tmpf_base" -i "$tmpf_1" -m "$rvmods" > "$tmpf_3"
 cp "$tmpf_3" "$tmpf_base"

 #7. led追加
 cat "$inifile" | awk '$1 ~ /led/ {print $0}' > "$tmpf_1"
 ./led_xa.sh -f "$tmpf_base" -i "$tmpf_1" > "$tmpf_3"
 cp "$tmpf_3" "$tmpf_base"

 #8.	最後にxset向けにrepeatキーコードをコメント	repeat <LatA> <LFSH> :: off >> 並列は面倒くさいので止め。
 cat "$inifile" | awk '$1 == "repeat" {print $0}' > "$tmpf_1"
 ./repeat_xa.sh -f "$tmpf_base" -i "$tmpf_1" > "$tmpf_3"
 cp "$tmpf_3" "$tmpf_base"

 cp "$tmpf_base" "$tmpf_out"
 cp -f "$tmpf_out" "$cdir"

 outname=${tmpf_out##*/}
 echo
 echo "--- complete. run '$bname -a $outname'
 ...or 'xkbcomp $tmpf_out \$DISPLAY' + 'xset r ...' "
)


# apply outputfile
f_apply(){
	f_fileck "$1" "apply"
	fl="$1"
	replist=`cat "$fl"|awk '$1 != "" {print $0}'| awk '{print NR " " $0 }' |
		sort -nr | awk '
		$2 == "//keyrepeat" {print $0}
		$2 != "//keyrepeat" {exit 0}' | sort -n | awk '{$1="";$2="";print $0}' `
	#list of  xset r 66 # define <CAPS> , ...

	cmd="xkbcomp \"$fl\" \$DISPLAY"
	echo "run command:  $cmd"
	eval "$cmd"		# xkbcomp outfile $diSPLAY
	[ $? = 0 ] || f_err "xkbcomp failed..."

	echo "xkbcomp suc. run xset:"
	echo "$replist"
	eval "$replist"
	[ $? = 0 ]||f_err "xset failed. recommend to reset 'xkbcomp keymap.bak \$DISPLAY'"
	exit 0
}

f_list_info(){
# search lbl(+alias) from xkmcomp
 cd "$1"
 kc_lbl=`xkbcomp $DISPLAY - |
 ./getblock_xa.sh '$1 == "xkb_keycodes"' | tr '=;' ' ' | awk '
	$1 ~/^</ {print $2 " " $1}
	$1 == "alias" {print $2 " " $3}
	' | ./ljoin -k 2 | awk '{print $0 "\t"}'`

#echo "$0: $lbl_kc" >/dev/stderr ; sleep 1000
 kc_sym=`xmodmap -pke | tr '=' ' ' | awk '{$1=""; print $0}'  `

 buf=`printf '%s\n%s\n' "$kc_lbl" "$kc_sym"`
 echo "$buf" | ./ljoin -k 1
 echo "keycode -- label(+alias label) -- keysymbols"
 echo "make from 'xkbcomp \$DISPLAY -' and 'xmodmap -pke'. check 'xev' too"

 cat << 'EEE'
keylabels. see 'xev', 'cat /usr/include/X11/keysymdef.h'

<FK01> - <FK12>
<ESC>,<HZTG>,<TAB>,<CAPS>,<LFSH>,<LCTL>
<LWIN>,<LALT>,<MUHE>,<SPCE>,<HENK>,<HKTG>,<RALT>,<MENU>,<RCTL>
<RTSH>,<RTRN>,<BKSP>

<PRSC>,<SCLK>,<PAUS>
<INS>,<DELE>,<HOME>,<END>,<PGUP>,<PGDN>
<UP>,<DOWN>,<LEFT>,<RGHT>

<KP0> - <KP9>
<NMLK>, <KPDV>, <KPMU>, <KPSU>, <KPAD>, <KPEN>, <KPDL>

1-0 <AE01>-<AE10>
a-z <LatA> - <LatZ>

-^\ ...AE11-13
@[ ... AD11-12
;:] ... AC10-12
,./\ ... AB08-11
EEE
 exit 0
}

f_sample(){ cat $1/dropsample.ini; exit 0; }

# set -e is broken option. buggy rule is imported from ksh 
# https://unix.stackexchange.com/questions/65532/why-does-set-e-not-work-inside-subshells-with-parenthesis-followed-by-an-or
# https://www.austingroupbugs.net/view.php?id=52
*SH_bn*_main "$@" || exit 	#SH_MAIN

#SH_TSS
test_1(){
	(./xkmp);				_fail msg1
	(./xkmp a);				_fail msg2
	(./xkmp -f abc);		_fail msg3
	(./xkmp -f abc -i xyz);	_fail
	(./xkmp -h);	_suc
	(./xkmp -H);	_suc
	(./xkmp -V);	_suc
	(./xkmp -l);	_suc
	xkbcomp $DISPLAY ./test.dfl
	#(./xkmp -f map.dfl -i mymap.ini);	_suc
	echo "test parser is working. wait for 30 sec ..." >/dev/stderr
	(./xkmp -f test.dfl -i test.ini) 2>/dev/null;	_suc
} >/dev/null
#SH_TSE

#SH_TSS
#suite=$(sed -ne '/^test_[0-9]*[(]/{s/[(].*//p}'<*SH_bn*.ts.sh)   #grep test_**
#for fc in $suite;do $fc ;done
#SH_TSE

cat<<'EEE'>/dev/null
 change log
 --
2021-09-07  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*(all): change ini syntax define, lnick, etc
	
	* *SH_bn*(all): new pkg. v2.0.0

2018-09-19  Momi-g	<dmy@dmy.dmy>

	* xkmp.dash(all): publish v1.0.0

EEE
#SH_ED

#SH_OP _ set -e;a=`sed -ne "/${C}DF/!d;:l;n;/${C}DE/q;p;bl"<$R0`;eval "$a";set +e #*/
#SH_OP h $p"-tsbS:test/eg/.o/.so -LMP:leak,mem,prof -f:funcs -o:bldout		GPLv3+"	 #*/
#SH_OP f sed -ne "/${C}DF/q;/;/d;/^[a-z].*)/p"<$R0 #*/
#SH_OP t $e"$CW";ftt "$@">$Rm;mv $Rm $tf;bash --posix $tf "$@"

#SH_OP b $e"$CW"
#SH_OP W $e"$Cm$O$Cw">/dev/null;$i0;$i1;mv $Rs $bn;rm $Rh;chmod 755 $bn;$p"$bn $tf"	#*/
#SH_OP o $p'fman $R0 1'|fv		#*/

#SH_DF
#-- noob
fman()( $p"fgr0 '${C}doc' '${C}docE'<$1|fbn|amn >$bn.$2
 mandoc -Thtml <$bn.$2 >$bn.$2.html
 ## mandoc -Tps <$bn.$2 >${bn}_$2.ps
 ## mandoc -Tpdf <$bn.$2 >${bn}__$2.pdf
 (echo '.mso ja.tmac';cat $bn.$2)|man -Tutf8 -l -|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt"|fv
 # man -Tutf8 /dev/stdin<$Rm|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt"|fv
 # cat ${bn}_$2.txt|enscript -f Ricty11 -p $bn$2.ps
 # ps2pdf ${bn}_$2.ps ${bn}_$2.pdf
 # ps2pdf ${bn}$2.ps ${bn}$2.pdf"|fv
)
#mandoc -Tascii <$bn.$2 |sed -e 's/."`printf '\010'`"//g'>${bn}_$2.txt

#-- local

#-- vars
bn=`basename ${Rs%.*}`; tf=${Rs%/*}/${bn}.ts.${Rs##*.}; e="eval "; p="$Rp"
#-- mod
fv()(while read -r a;do $e"cat<<E$O# $a${O}E"|sed -e 's@-L.*-L[^ ]*@-L(omit)@g'>/dev/stderr;$e"$a";done)

fbn()(sed -e "s@\*${C##*]}bn\*@$bn@g"|frf|frv)
fsn()(tr -s ' \t' '\n')
fsl()(tr -s '\n' ' ')
fu()(fsn|sort -u)
fU()(fu|fsl;$p)

fgr()(sed -e "/$1/!d;:l;/$2/{p;d};n;bl")	#切出
fgr0()(sed -ne "/$1/!d;:l;n;/$2/d;p;bl")	#抜き切出
fgR()(sed -ne "/$1/bl;p;d;:l;n;/$2/d;bl")	#切すて
fg()(sed -ne "s/.*${C##*]}co\*\([^*]*\).*$/\1/p" "$@"|fsn|awk '!a[$0]{a[$0]=1;print}'|fsl)

#-- longcmd
frf()(
 awk -v r="${C##*]}rf" 'match($0,r){
 s=substr($0, RSTART+RLENGTH+1)	# /*SH_rf*, #SH_rf* abc.txt 123.txt *  ..etc 
 gsub(/.[^*]*$/, "", s);split(s, a)
 m="[ -f %s ]&&echo \"/*--copyfrom %s*\"/&&cat %s&&echo \"/*--copyend %s*\"/"
 for(i=1;v=a[i];i++){ system( sprintf(m, v,v,v,v)) }
 next
 }
 {print}'
)
frv()(buf=`awk '$1=="@_ver" {print $3;exit}'<$R0`;sed -e "s@\*${C##*]}ver\*@$buf@g")

ftt()(
 suite=$(cat $tf|awk '$1~/^test_[^(]*\(\)/{print $1}'|sed -e 's/[(].*//g')
 [ $# = 0 ] || suite="$suite $@"
 [ $# != 0 ]  || suite="$suite $suite"
 suite=`$p'%s\n' "$suite"|tr '[ \t]' '\n'|sort|uniq -d`
 (shunit_m;cat $bn $tf|grep -vF "${C##*]}MAIN"
 $p' [ $# = 0 ] && set -- '"$suite"';for fc;do $fc ;done;_res')
)

i0=$e'fgr0 "${C}TSS" "${C}TSE"<$Rm|fbn>$tf'
i1=$e'fgR "${C}TSS" "${C}TSE"<$Rs|fbn>$Rm;mv $Rm $Rs'
#SH_DE

