#!/bin/sh
cat << 'EEE' > /dev/null
/* repstate_xa.sh, show key repeat setting
 * Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

buf=`./rdopt ":hlk:" "$@"`
if [ $? -ne 0 ] ; then echo "$0: optErr. see -h. sleep." >/dev/stderr ;sleep 1000; exit 1; fi
eval "$buf"

#exclusive -l -k
buf=`(echo "$opt_l" ; echo "$opt_k") | grep -v '^$' | wc -l`
if [ "$buf" != "1" ] ; then	err=1 ;fi
if [ "$#" -ne 0 ] ; then err=1 ;fi

if [ "$opt_h" = '1' ] ; then
cat << 'EEE'
HowTo (repstate_xa.sh, show keycode-keyrepeat setting)
option: -h (this), -l(ist), -k(eycode)
------
ex.) ~$ repstate_xa.sh -l
>>>
0 0
1 0
...
255 1

...show keycode and keyrepeat setting
parsed 'xset -q' data

ex.) ~$ repstate_xa.sh -k 25
>>>
1	...keycode 25 keyrepeat is on (1:on 0:off)
EEE
exit 0
fi

if [ "$err" = "1" ] ; then		# not stdin
	echo "$0: optErr. see -h" > /dev/stderr
	exit 1
fi

if [ "$opt_l" = "1" ] ; then
	l_or_k="l"
else
	l_or_k="$opt_k"
fi


#app ck
xset -version >/dev/null 2>&1
if [ "$?" != "0" ] ; then
	echo "$0: not found 'xset'" >/dev/stderr
	exit 1
fi
#---ready



#---main
echo "--- $0:" >/dev/stderr

# algorism... show xset -q
#                       kc1
#	auto repeating keys:  00ffffffdffffbbf
#	                      fadfffefffedffff
#	                      9fffffffffffffff
#	                      fff7ffffffffffff	kc255
#
#	>>>
#
#	kc1
#	00 ff ff ff df ff fb bf
#	fa df ff ef ff ed ff ff
#	9f ff ff ff ff ff ff ff
#	ff f7 ff ff ff ff ff ff	kc255
#
#	>>>
#
#	kc255
#	ff ff ff ff f7 ff fb bf
#	fa df ff ef ff ed ff ff
#	9f ff ff ff ff ff ff ff
#	ff f7 ff ff df ff ff 00	kc1		... reverse
#
#	>>>
#
#	kc255
#	11111111 11111111 ...
#	...
#	...
#	... 11111111 00000000	kc1		... hex to bin
#
#	>>>
#
#	255 254 ...   3 2 1	keycode
#	1 1 1 1 ... 0 0 0 0	repeat flg


# ...what is repeat flg?	see source.
#	X11R6.9.0-src/xc/doc/specs/Xi/library.ms
#
#	typedef struct {
#		XID class;
#		int length;
#		XID id;
#		int click;
#		int percent;
#		int pitch;
#		int duration;
#		int led_mask;
#		int global_auto_repeat;
#		char auto_repeats[32];
#	} XKbdFeedbackState;
#
#	...
#	The global_auto_repeat member has a value of
#	.PN AutoRepeatModeOn
#	or
#	.PN AutoRepeatModeOff .
#	.IP \(bu 5
#	The auto_repeats member is a bit vector.  Each bit set to 1 indicates
#	that auto-repeat is enabled for the corresponding key.  The vector is
#	represented as 32 bytes.  Byte N (from 0) contains the bits for keys
#	8N to 8N + 7, with the least significant bit in the byte representing
#	key 8N.
#	.sp




# get repeat flg list
buf=`xset -q`
snum=`echo "$buf" | grep -n 'auto repeating keys' | sed -e 's#:.*$##g'`
enum=`expr $snum + 3`

# base ... ff 11 ... hex list
base=`echo "$buf" | ./lcat $snum-$enum |
	tr ':' '\n' | tail -n 4 | awk '{print $1}' |
	sed -e 's/../&@/g' | tr '@' '\n' | awk '$1 != "" {print $1}' `

# echo "unko$base" >/dev/stderr


# invert list
rvs=`echo "$base" | grep -n '' | sort -nr | sed -e 's/^.*://1' `
# echo "inv_$rvs" >/dev/stderr


# hex to bin
cmd="sed -e '
s/0/0000/g
s/1/0001/g
s/2/0010/g
s/3/0011/g
s/4/0100/g
s/5/0101/g
s/6/0110/g
s/7/0111/g
s/8/1000/g
s/9/1001/g
s/9/1001/g
s/a/1010/g
s/b/1011/g
s/c/1100/g
s/d/1101/g
s/e/1110/g
s/f/1111/g
'"
#	...	echo "f1 01" | cmd	... 11110001 00000001
list=`
echo "$rvs" | eval "$cmd" |
# re-invert for sort 255-1 to 1-255
	sed -e 's/./&@/g' | tr '@' '\n' | awk '$1 != "" {print $0}' |
	awk '{print 256-NR " " $0}' | sort -n
`
# echo "$list" >/dev/stderr
# print
if [ "$l_or_k" = "l" ] ;then
	echo "$list"
else
	echo "$list" | awk -v kc="$l_or_k" '$1 == kc {print $2}'
fi
echo "--- $0: end" >/dev/stderr
# ...xmodmap -pke	see keycode
#	http://wiki.onakasuita.org/pukiwiki/?Linux%2F%E3%82%AD%E3%83%BC%E3%82%B3%E3%83%BC%E3%83%89
