#!/bin/sh
# test platform ... debian dash

# GPL_3 license
cat << 'EEE' > /dev/null
/* readlink_p .... portable readlink. bourne-shell script
 * Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

#邪魔な基本modをポアする
# interpretのハードコーディングを解釈して全て参照型に修正
# キー指定のモディファイヤをラベルや別名からシンボル名に統一
# symbol,mod を追加。mod系のstrとv-s
#単純なinterpretじゃないとエラーを吐く

buf=`./rdopt "hf:i:s:m:" "$@"`
if [ $? -ne 0 ] ; then echo "$0: optErr. see -h. sleep." >/dev/stderr ;sleep 1000; exit 1; fi
eval "$buf"

if [ "$opt_f" = "" ] || [ "$opt_i" = "" ] ; then
	echo "$0: optErr. see -h" > /dev/stderr
	exit 1
fi
# ./modclear_xa.sh -f unko -s "aaa! -m "mmm" -i tes.ini

sfile="$opt_f"
inifile="$opt_i"
s2rmods="$opt_s"	# modifier_map Control { Shift_L };
rlist="$opt_m" #Mod1 Alt Alt Meta Meta	#別名リスト

tmpfile1="$0.buf1"
tmpfile2="$0.buf2"
cp "$sfile" "$tmpfile1"

echo "--- $0: remove initial mod and parse interpret block" >/dev/stderr

#コマンド処理 modclear {+s+m1} ...
reqmod=`cat "$inifile" | awk '$1 == "modclear" {print $2}' | ./reqmod_xa.sh | tr '+-' ' '`
#echo "$reqmod" >/dev/stderr
#sleep 3

echo "--- $0: re-define modkeys" >/dev/stderr
echo "--- $reqmod ...del mods" >/dev/stderr

cat "$tmpfile1" | ./getblock_xa.sh  '$1 == "modifier_map"' -r -v > "$tmpfile2"
cp "$tmpfile2" "$tmpfile1"
# 追加は重複がありそうなので、最後に纏めて追加
# echo "$s2rmods" | ./addcode_xa.sh -f "$tmpfile1" -b xkb_symbols > "$tmpfile2"
# cp "$tmpfile2" "$tmpfile1"

# interpretブロックの解釈、追加
# modifier_map調査でvirtual modのリスト取得
# 先にリアルmodと仮想modで結びついたものを出さないと>>rlistで真名 仮名 仮名...を用意した
# 完全仮想っぽいやつも紛れているので。

base=`cat "$tmpfile1" | ./getblock_xa.sh '$1 == "xkb_compatibility"' -N `

cmd=`echo "$rlist" | awk ' {
	for(i=1; i<=NF; i++){
		printf("/%s/p\n",$i)
	}
}' `
# リアルmodと仮想modで並んでるsedコマンド。ハードコードを検知するためのsed準備。
# これでmod臭い行を抽出する 再度逆解釈して参照名に置き換える準備
cmd="sed -ne '$cmd'"
# echo "$cmd" >/dev/stderr
# sleep 100
# out	sed -nre '/Shift/p
# 		/Control/p
# 		/Lock/p


# echo "$base" | tr -d ' \t' >/dev/stderr

#仮想mod名をリアルに戻す。getblockで整形されてる。
repl=`echo "$base" | sed -ne '/.*action.*=.*Mods[(]/p' | 
	grep -v modMapMods | sed -e 's#,.*$##g' |
	awk '{
		printf("%s", $1)
		gsub(/^.*[(]/, "", $0)
		gsub(/[ \t]/, "", $0)
		print " " $0
		}' | tr -d ');' | eval "$cmd" `	#>>	723 modifiers=Shift

#echo "$modl" >/dev/stderr
# sleep 3
#sed
# ハードコードを全て参照に書き換え '123s#modifiers=Shift#modifiers=modmapmods#g'
modchsed=`echo "$repl" | awk 'NF{printf(" | sed -e \047%ss#%s#modifiers=modMapMods#g\047", $1, $2) }' `
modchsed="cat - $modchsed"

# interpret re-write
cat "$tmpfile1" | eval "$modchsed" > "$tmpfile2"
cp "$tmpfile2" "$tmpfile1"

# sleep 1

# 同じくinterpの仮想名を編集
#interpretは何かキーをおしたときにフックしてmodstateをいじったりledを付けたりするもの
#---add modidier_map, sym-modname
buf=`echo "$repl" | grep '+' `	#Alt_L NumLock+Lock
if [ "$buf" != "" ] ; then
	echo "$0: err. input file is already edit. sleep 1000.  $buf" > /dev/stderr ; sleep 1000
	exit 1
fi

#キーをトリガーとしたアクション。仮想名がありえるので正式名に書き換える
#AltをMod1とかMetaをMod1とか。シンボル名はいじらない。あくまでxkb内部のラベル
modl=`echo "$repl" | sed -e 's# .*=# #g' `	#743 AltGrとか。
syml=`echo "$base" | grep 'interpret ' |
	sed -e 's#[+].*$##g' | awk '{print $1 " " $2 " " $NF}'  `	# 1002 interpret KP_Decimal

# echo "@ $syml" >/dev/stderr
# sleep 10

sym_mod=`printf '%s\n%s\n' "$syml" "$modl" | sort -n | awk '
$2 == "interpret" { printf("\n%s ",$0) }
$2 != "interpret" { printf("%s ",$2) }' | awk '$4 != "" {print $3 " " $NF}' | sort -u `

# echo "$sym_mod" >/dev/stderr
# echo "$rlist" >/dev/stderr
# sleep 3

# change virtual mod to real mod
cmd=`echo "$rlist" | awk '$2 != "" {
	for(i=2; i<=NF; i++){
		printf(" | sed -e \047s# %s# %s#g\047 ", $i, $1)
	}
}' `
cmd="cat - $cmd"
# echo "___$cmd" >/dev/stderr
# sleep 10
# 	cat -  | sed -re 's# Alt# Mod1#g'  ...


# add kick 'Any' symbol		>> xmodmap -pke...?
# sym-mod, Alt_L Mod1 ,1:1 list + line
sym_rmod=`echo "$sym_mod" | eval "$cmd" | sort -u | awk '$1 != "Any" {print $0}' `

# mod正式名再定義の準備
#echo "____ $sym_rmod" >/dev/stderr
v2rstr=`echo "$sym_rmod" | awk 'NF{ printf("modifier_map %s { %s };\n", $2, $1)	}' | sort`

# combine & uniq	modmap {Shift_L} ...
addlist=`printf '%s\n%s\n' "$s2rmods" "$v2rstr" | sed -e 's/[}{]/ & /g' |
	sed -e 's/[ ]\{1,\}/ /g' | sort | uniq | sed -e 's#[}] [;]#};#g'`
# modifier_map Shift { Shift_L };
# modifier_map Shift { Shift_R }; ...

# echo "$addlist" >/dev/stderr
# sleep 100
# printf '%s\n%s\n' "$s2rmods" "$v2rstr">/dev/stderr
# sleep 1000

#addlistがsymbol名で定義された、仮想名も全て考慮した再定義。
echo "$addlist" > /dev/stderr
echo "$addlist" | ./addcode_xa.sh -f "$tmpfile1" -b xkb_symbols > "$tmpfile2"
cp "$tmpfile2" "$tmpfile1"
# ここまでがbaseからvmodを取り除いて再baseにしたところ

# 正規化されたbaseから指定modキー関係をaboneする
#---delete modifier_map line	modclear {+s+m1} ... >> Shift Lock ...
# ラベル達は参照名で置換してるのでmoddefをするかしないかでonoff出来る
set -- $reqmod
symlist=""
for ii in $@
do
	buf='$1 == "modifier_map" && $2 == "'"$ii"'"'
#	sym=`echo "$addlist" | ./getblock_xa.sh '$1 == "modifier_map" && $2 =="'"$ii"'"'`
	sym=`echo "$addlist" | ./getblock_xa.sh "$buf" `
	symlist="$symlist $sym"
	# sym_rmodはダメ。元のシンボルが抜けてる。
	#echo "$sym_rmod" | awk '$2 == "'"$ii"'" {print $1}' >/dev/stderr

	cat "$tmpfile1" |
	./getblock_xa.sh  '$1 == "modifier_map" && $2 =="'"$ii\"" -r -v > "$tmpfile2"
	cp "$tmpfile2" "$tmpfile1"
done

#---delete fix interpret

set -- $symlist	#clearするターゲットmodのsymbol対象
# echo ppppp$@ >/dev/stderr
# sleep 2
symlist="$@"

# interpのaction系？をskipさせる書き換え？
# interpにmod仮名の動作予約が残ってる場合があるので本家Mod1を残してalt, altGr削除
if [ "$#" != "0" ] ; then
./delinter_xa.sh -f "$tmpfile1" -s "$symlist" > "$tmpfile2"
cp "$tmpfile2" "$tmpfile1"
fi

cat "$tmpfile1"
echo "--- $0: end" >/dev/stderr
