#!/bin/sh
# test platform ... debian dash

# GPL_3 license
cat << 'EEE' > /dev/null
/* readlink_p .... portable readlink. bourne-shell script
 * Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

buf=`./rdopt "hf:s:" "$@"`
if [ $? -ne 0 ] ; then echo "$0: optErr. see -h. sleep." >/dev/stderr ;sleep 1000; exit 1; fi
eval "$buf"

if [ "$opt_f" = "" ] || [ "$opt_s" = "" ] ; then
	echo "$0: optErr. see -h. sleep 1000" > /dev/stderr
	sleep 1000
	exit 1
fi


#	キーラベルを自分で大まかに使いやすく再設定する。interpret系に分散を削除修正。
# ./delinter_xa.sh -f unko -s "Shif_L Alt NumLock" ...
# sはShift_Lとかのclear対象シンボル。そっからModsの行を割り出す

sfile="$opt_f"
tmpfile1="$0.buf1"
tmpfile2="$0.buf2"
syms="$opt_s"
cp "$sfile" "$tmpfile1"


echo "--- $0:" >/dev/stderr

lines=`cat "$tmpfile1" | grep -n action | grep Mods | grep -v ')' | grep -v ';' `
lines=`echo "$lines" | awk '{print $1}' | tr -d ';' | tr '\n' ' ' `" "

ck=`echo "$lines" | sed -e 's# #==NR || #g' | sed -e 's#[|][|] $##g' `

# actions整形. mod設定系の行を整形。
cat "$tmpfile1" | awk '
$0 ~ /action/ && $0 ~ /Mods/ && $0 !~ /[)]/ && $0 !~ /[;]/ {
	flg=0
	buf=$0
	while (flg == 0){
		getline
		buf=buf $0
		flg=match(buf, /[)].*;/)
	}
	$0=buf
	}
{print $0}' > "$tmpfile2"
cp "$tmpfile2" "$tmpfile1"

# interpret行番号の取得
# echo "$syms" >/dev/stderr

lines=""
for ii in $syms
do
	buf=`cat "$tmpfile1" | tr '+' ' ' | 
	./getblock_xa.sh '$1 == "interpret" && $2 == "'"$ii"'"' -n | 
	grep action | grep Mods | awk '{print $1}' `
	lines="$lines $buf"
done
set -- $lines
# echo $@ >/dev/stderr

#番号をsed削除コマンドに加工 22 -> 22c\ //---abone
cmd=`printf '%sc\134\n//---abone\n' "$@" `
cmd="sed -e '$cmd'"

#	sed -e '785c\
#	//---abone
#	1182c\
#	//---abone	...

 echo "$cmd" > /dev/stderr
# sleep 10

#出力
cat "$tmpfile1" | ./getblock_xa.sh -N | 
	awk '{$1="";print $0}' | sed -re s'#^ ##g' | eval "$cmd"  > "$tmpfile2"
cp "$tmpfile2" "$tmpfile1"

#echo $syms >/dev/stderr
#sleep 10

# interpretが消去の結果空っぽだとエラーになる。削除しないとダメ.
for ii in $syms
do
	# 相変わらず適当パーサーだけど、それなりに働く。getblockで形は整ってるはずだし。
	cat "$tmpfile1" | sed -ne "
	/interpret.*$ii[+]/ {h;n;b label1}#"'
	p;d
	:label1
	/{/ {H;n;b label1}
	/abone/ {H;n;b label1}
	/}.*;/ { c\
//---abone
		d}
	H;g;p'	> "$tmpfile2"
	ck=`diff "$tmpfile2" "$tmpfile1" | head -n 1`
	if [ "$ck" != "" ] ; then
		echo "$ii: empty interpret block detect. del." >/dev/stderr
	fi
	cp "$tmpfile2" "$tmpfile1"

	
#	echo $ii >/dev/stderr
#	echo $buf >/dev/stderr
#	sleep 1
#	
#		cat "$tmpfile1" | 
#		./getblock_xa.sh '$1 == "interpret" && $2 ~ /^'"$ii"'[+]/' -r -v > "$tmpfile2"
#		cp "$tmpfile2" "$tmpfile1"
#	fi
done

cat "$tmpfile1" 
echo "--- $0: end" >/dev/stderr
