<?php

require_once 'root.class.php';

//******************************************************************************

class CM_Confirm extends CM_Root
{
	
	//--------------------------------------------------------------------------
	
	function CM_Confirm()
	{
		// $key, $data_type, $default, $required, $size
		$this->initVar('c_commu_confirm_id', XOBJ_DTYPE_INT);
		$this->initVar('c_commu_id', XOBJ_DTYPE_INT);
		$this->initVar('uid_from', XOBJ_DTYPE_INT);
		$this->initVar('uid_to', XOBJ_DTYPE_INT);
		$this->initVar('mode', XOBJ_DTYPE_INT);
		$this->initVar('r_datetime', XOBJ_DTYPE_TXTBOX);
		$this->initVar('message', XOBJ_DTYPE_TXTAREA);
		
		$this->doXcode = false;
	}
	
	//--------------------------------------------------------------------------
	
}

//******************************************************************************

class CM_ConfirmHandler extends CM_RootHandler
{
	
	//--------------------------------------------------------------------------
	
	function CM_ConfirmHandler()
	{
		$this->CM_RootHandler();
		$this->obj_class = "CM_Confirm";
		$this->table_name = "c_commu_confirm";
		$this->primary_key = "c_commu_confirm_id";
	}
	
	//--------------------------------------------------------------------------
	
	function &getInstance()
	{
		static $instance = NULL;
		if(is_null($instance)){
			$instance = new CM_ConfirmHandler();
		}
		return $instance;
	}
	
	//--------------------------------------------------------------------------
	
	function &get($cid, $uid_from, $uid_to, $mode)
	{
		$ret = false;
		$criteria = new CriteriaCompo(new Criteria('c_commu_id', $cid));
		$criteria->add(new Criteria('uid_from', $uid_from));
		$criteria->add(new Criteria('uid_to', $uid_to));
		$criteria->add(new Criteria('mode', $mode));
		
		$confirm =& $this->getObjects($criteria);
		if(is_array($confirm) && count($confirm)==1 && is_object($confirm[0])){
			$ret =& $confirm[0];
		}
		return $ret;
	}
	
	//--------------------------------------------------------------------------
	
}

//******************************************************************************

?>
