<?php

class commonAction extends Action
{

//------------------------------------------------------------------------------

function getIntRequest($key, $req_type=APP_REQUEST_POST)
{
	$value = $this->getRequest($key, $req_type);
	if(!isset($value)){
		return NULL;
	}
	return intval($value);
}
//------------------------------------------------------------------------------

function getTextRequest($key, $req_type=APP_REQUEST_POST, $sanitize_mode=NULL)
{
	$value = $this->getRequest($key, $req_type);
	if(!isset($value)){
		return NULL;
	}
	
	// eLXgtH[ɏo͂ۂɍsTj^CY@w
	switch($sanitize_mode){
		case XOBJ_DTYPE_STRING:
		case XOBJ_DTYPE_TXTBOX:
			$ts =& CM_TextSanitizer::getInstance();
			$value = $ts->makeTboxData4PreviewInForm($value);
			break;
		
		case XOBJ_DTYPE_TEXT:
		case XOBJ_DTYPE_TXTAREA:
			$ts =& CM_TextSanitizer::getInstance();
			$value = $ts->makeTareaData4PreviewInForm($value);
			break;
		
		default:
			break;
	}
	
	return $value;
}
//------------------------------------------------------------------------------

function getRequest($key, $req_type=APP_REQUEST_POST)
{
	if($req_type==APP_REQUEST_POST){
		$value = isset($_POST[$key]) ? $_POST[$key] : NULL;
	}
	elseif($req_type==APP_REQUEST_GET){
		$value = isset($_GET[$key]) ? $_GET[$key] : NULL;
	}
	elseif($req_type==APP_REQUEST_SESSION){
		$value = isset($_SESSION[$key]) ? $_SESSION[$key] : NULL;
	}
	else{
		return NULL;
	}
	return $value;
}
//------------------------------------------------------------------------------

function isXoopsUser()
{
	global $xoopsUser;
	if(is_object($xoopsUser) && strtolower(get_class($xoopsUser)) == 'xoopsuser'){
		return true;
	}
	return false;
}
//------------------------------------------------------------------------------

function isGuest()
{
	if($this->isXoopsUser()){
		global $xoopsUser;
		return in_array(XOOPS_GROUP_ANONYMOUS, $xoopsUser->getGroups());
	}
	return true;
}
//------------------------------------------------------------------------------

function getFormHeader($method='post', $target='', $action='', $upload=false, $hidden_vars=NULL, $token_name=NULL)
{
	$page_html = (empty($target))? 
		"" : "<input type=\"hidden\" name=\"".APP_PAGE_ARG."\" value=\"".$target."\">\n";
	$action_html = (empty($action))? 
		"" : "<input type=\"hidden\" name=\"".APP_ACTION_ARG."\" value=\"".$action."\">\n";
	$upload_html = ($upload)? " enctype=\"multipart/form-data\"" : "";
	
	$form = "<form action=\"index.php\" method=\"".$method."\"".$upload_html.">\n".
			$page_html. $action_html;
	
	if(is_array($hidden_vars)){
		foreach($hidden_vars as $key => $value){
			$form .= "<input type=\"hidden\" name=\"".$key."\" value=\"".$value."\">\n";
		}
	}
	if(!is_null($token_name)){
		$token_handler =& new XoopsMultiTokenHandler();
		$token =& $token_handler->create($token_name);
		$form .= $token->getHtml();
	}
	
	return $form;
}
//------------------------------------------------------------------------------

function getPageSelector($base_url, $start, $limit, $data_count, $total, $color=NULL)
{
	if($data_count < 1){
		return NULL;
	}
	
	$page_id = intval($start/$limit);
	$page_count = 1 + intval(($total-1)/$limit);
	if($page_id > $page_count-1){
		return NULL;
	}
	
	if($page_count > 10){
		$page_start = $page_id - 4;
		$page_end =   $page_id + 6;
		if($page_start < 0){
			$page_start = 0;
			$page_end = 10;
		}
		if($page_end > $page_count){
			$page_end = $page_count;
			$page_start = $page_end - 10;
		}
	}
	else{
		$page_start = 0;
		$page_end = $page_count;
	}
	
	$style = is_null($color) ? " class=\"selectedPage\"" : " style=\"background-color:".$color."\";";
	$html = "|";
	for($i=$page_start; $i<$page_end; $i++){
		if($page_id == $i){
			$html.= "<span ".$style."> ".($i+1)." </span>|";
		}
		else{
			$url = $base_url."&s=".($i*$limit);
			$html.= "<a href=\"".str_replace("?&", "?", $url)."\"> ".($i+1)." </a>|";
		}
	}
	$description = sprintf(_CM_PAGE_SELECT_DESC, $total, 1+$start, $start+$data_count);
	
	return array('selector' => $html, 'description' => $description);
}
//------------------------------------------------------------------------------

function validateToken($name, $clearIfValid=true)
{
	$token_handler = new XoopsMultiTokenHandler();
	return $token_handler->autoValidate($name, $clearIfValid);
}
//------------------------------------------------------------------------------

function debug($arr)
{
	echo "<pre>".print_r($arr, true)."</pre>";
}
//------------------------------------------------------------------------------

}

?>
