<?php
// $Id: edituser.php,v 1.5 2006/05/01 02:37:26 onokazu Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //


class profile_edit_execAction extends mypageAction
{

function dispatch(&$context)
{
	require APP_FRAMEWORK_DIR.'/global.php';
	require_once XOOPS_ROOT_PATH.'/language/'.$xoopsConfig['language'].'/user.php';
	$ts =& CM_TextSanitizer::getInstance();
	
	if($this->isGuest() || !$this->validateToken('edituser')){
		redirect_header(_CM_URL_MYPAGE, 2, _US_NOEDITRIGHT);
	}
	$config_handler =& xoops_gethandler('config');
	$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
	if(!isset($xoopsConfigUser['avatar_allow_upload'])){
		$xoopsConfigUser =& $config_handler->getConfigsByDirname('user');	// for XOOPS Cube 2.1
	}
	if(!is_array($xoopsConfigUser)){
		redirect_header(_CM_URL_MYPAGE, 2, _US_NOEDITRIGHT);
	}
	
	$uid = 0;
	if (!empty($_POST['uid'])) {
		$uid = intval($_POST['uid']);
	}
	if (empty($uid) || $xoopsUser->getVar('uid') != $uid) {
		redirect_header(_CM_URL_MYPAGE, 3, _US_NOEDITRIGHT);
	}
	$errors = array();
	if ($xoopsConfigUser['allow_chgmail'] == 1) {
		$email = '';
		if (!empty($_POST['email'])) {
			$email = $ts->stripSlashesGPC(trim($_POST['email']));
		}
		if ($email == '' || !checkEmail($email)) {
			$errors[] = _US_INVALIDMAIL;
		}
	}
	$password = '';
	if (!empty($_POST['password'])) {
		$password = $ts->stripSlashesGPC(trim($_POST['password']));
	}
	if ($password != '') {
		if (strlen($password) < $xoopsConfigUser['minpass']) {
			$errors[] = sprintf(_US_PWDTOOSHORT,$xoopsConfigUser['minpass']);
		}
		$vpass = '';
		if (!empty($_POST['vpass'])) {
			$vpass = $ts->stripSlashesGPC(trim($_POST['vpass']));
		}
		if ($password != $vpass) {
			$errors[] = _US_PASSNOTSAME;
		}
	}
	if (count($errors) > 0) {
		redirect_header(_CM_URL_MYPAGE, 3, _US_NOEDITRIGHT);
	}
	else {
		$member_handler =& xoops_gethandler('member');
		$edituser =& $member_handler->getUser($uid);
		if(!is_object($edituser)){
			redirect_header(_CM_URL_MYPAGE, 3, _US_NOEDITRIGHT);
		}
		
		$edituser->setVar('name', $_POST['name']);
		if ($xoopsConfigUser['allow_chgmail'] == 1) {
			$edituser->setVar('email', $email, true);
		}
		$edituser->setVar('url', formatURL($_POST['url']));
		$edituser->setVar('user_icq', $_POST['user_icq']);
		$edituser->setVar('user_from', $_POST['user_from']);
		$user_viewemail = (!empty($_POST['user_viewemail'])) ? 1 : 0;
		$edituser->setVar('user_viewemail', $user_viewemail);
		$edituser->setVar('user_aim', $_POST['user_aim']);
		$edituser->setVar('user_yim', $_POST['user_yim']);
		$edituser->setVar('user_msnm', $_POST['user_msnm']);
		if ($password != '') {
			$edituser->setVar('pass', md5($password), true);
		}
		$attachsig = !empty($_POST['attachsig']) ? 1 : 0;
		$edituser->setVar('user_intrest', $_POST['user_intrest']);
		$edituser->setVar('attachsig', $attachsig);
		$edituser->setVar('timezone_offset', $_POST['timezone_offset']);
		$edituser->setVar('user_occ', $_POST['user_occ']);
		
		if(!defined('_CM_DEMO_VERSION')){
			$edituser->setVar('user_sig', xoops_substr($_POST['user_sig'], 0, 255));
			$edituser->setVar('uorder', $_POST['uorder']);
			$edituser->setVar('umode', $_POST['umode']);
			$edituser->setVar('notify_method', $_POST['notify_method']);
			$edituser->setVar('notify_mode', $_POST['notify_mode']);
			$edituser->setVar('bio', xoops_substr($_POST['bio'], 0, 255));
			$edituser->setVar('user_mailok', $_POST['user_mailok']);
			
			if(!empty($xoopsConfig['usercookie'])){
				if (!empty($_POST['usecookie'])) {
					setcookie($xoopsConfig['usercookie'], $xoopsUser->getVar('uname'), time()+ 31536000);
				}
				else {
					setcookie($xoopsConfig['usercookie']);
				}
			}
		}
		
		if (!$member_handler->insertUser($edituser)) {
			redirect_header(_CM_URL_MYPAGE, 3, _US_NOEDITRIGHT);
		}
		else {
			redirect_header(_CM_URL_MYPAGE, 2, _US_PROFUPDATED);
		}
	}
}

}

?>