<?php
class fileAction extends commonAction
{

//------------------------------------------------------------------------------

function checkAuthority($image_id, $file_id)
{
	global $xoopsUser, $xoopsUserIsAdmin;
	
	if($xoopsUserIsAdmin){
		return true;
	}
	
	if($this->isGuest()){
		return false;
	}
	$own_uid = $xoopsUser->getVar('uid');
	
	if($image_id > 0 && $file_id > 0){
		return false;
	}
	elseif($image_id > 0){
		$image_handler =& CM_ImageHandler::getInstance();
		$data =& $image_handler->get($image_id);
	}
	elseif($file_id > 0){
		$file_handler =& CM_FileHandler::getInstance();
		$data =& $file_handler->get($file_id);
	}
	else{
		return false;
	}
	
	$target = $data->getVar('target');
	$target_id = $data->getVar('target_id');
	
	$commu_handler =& CM_CommunityHandler::getInstance();
	$comment_handler =& CM_TopicCommentHandler::getInstance();
	
	if($target == 1){
		// for community
		$community =& $commu_handler->get($target_id);
		if(!is_object($community)){
			return false;
		}
		
		if($own_uid != $community->getVar('uid_admin')){
			return false;
		}
	}
	elseif($target == 2){
		// for topic comment
		$comment =& $comment_handler->get($target_id);
		if(!is_object($comment)){
			return false;
		}
		
		$comment_uid = $comment->getVar('uid');
		$cid = $comment->getVar('c_commu_id');
		
		$community =& $commu_handler->get($cid);
		if(!is_object($community)){
			return false;
		}
		
		if($own_uid != $comment_uid && $own_uid != $community->getVar('uid_admin')){
			return false;
		}
	}
	else{
		return false;
	}
	return true;
}

//------------------------------------------------------------------------------

}
?>
