<?php

class commonView extends View
{

//------------------------------------------------------------------------------

function assignStyleSheet($filename=NULL)
{
	$html = '<link rel="stylesheet" type="text/css" media="screen" href="'.APP_CSS_URL.'/common.css" />';
	if(!is_null($filename)){
		$html.= '<link rel="stylesheet" type="text/css" media="screen" href="'.APP_CSS_URL.'/'.$filename.'" />';
	}
	$this->tpl->assign('xoops_module_header', $html);
}
//------------------------------------------------------------------------------

function assignHeader($css_file=NULL, $js_file=NULL)
{
	$html = '<script type="text/javascript" src="'.XOOPS_URL.'/include/xoops.js"></script>';
	$html .= '<link rel="stylesheet" type="text/css" media="screen" href="'.APP_CSS_URL.'/common.css" />';
	if(!is_null($css_file)){
		if(is_array($css_file)){
			foreach($css_file as $css){
				$html.= '<link rel="stylesheet" type="text/css" media="screen" href="'.APP_CSS_URL.'/'.$css.'" />';
			}
		}
		else{
			$html.= '<link rel="stylesheet" type="text/css" media="screen" href="'.APP_CSS_URL.'/'.$css_file.'" />';
		}
	}
	
	if(!is_null($js_file)){
		if(is_array($js_file)){
			foreach($js_file as $js){
				$html.= '<script type="text/javascript" src="'.APP_JS_URL.'/'.$js.'"></script>';
			}
		}
		else{
			$html.= '<script type="text/javascript" src="'.APP_JS_URL.'/'.$js_file.'"></script>';
		}
	}
	$this->tpl->assign('xoops_module_header', $html);
}
//------------------------------------------------------------------------------

function assignXoopsCodeTarea($content, $textarea_id, $cols=60, $rows=15, $suffix=null, $use_smilies=true)
{
	require_once APP_TRUST_PATH.'/include/xoopscodes.php';
	
	$GLOBALS[$textarea_id] = $content;
	
	ob_start();
	xoopsCodeTarea($textarea_id, $cols, $rows, $suffix);
	$this->tpl->assign('xoops_codes', ob_get_contents());
	ob_end_clean();
	
	unset($GLOBALS[$textarea_id]);
	
	if($use_smilies){
		ob_start();
		xoopsSmilies($textarea_id);
		$this->tpl->assign('xoops_smilies', ob_get_contents());
		ob_end_clean();
	}
}
//------------------------------------------------------------------------------

function assignCommunityTopLink($key, $cid, $cname)
{
	$commu_top = array(
		'title' => '['.$cname.'] '._CM_LINK_COMMU_TOP,
		'url' => _CM_URL_COMMU.'/?cid='.$cid,
	);
	$this->tpl->assign($key, $commu_top);
}
//------------------------------------------------------------------------------

function assignBreadcrumbsList($key, $commu=NULL, $topic=NULL, $act_msg=NULL)
{
	require_once XOOPS_ROOT_PATH.'/class/smarty/plugins/modifier.mb_truncate.php';
	
	$list = "<a href=\"".APP_BASE_URL."/\">". _CM_TITLE_INDEX. "</a>";
	$level1 = $level2 = $level3 = "";
	
	if(!is_null($commu) && $commu['id'] > 0){
		$commu_name = smarty_modifier_mb_truncate($commu['name'], 15);
		$level1 = " &gt; ". $commu_name;
		
		if((!is_null($topic) && $topic['id'] > 0)){
			$topic_name = smarty_modifier_mb_truncate($topic['name'], 15);
			$level1 = "<nobr> &gt; <a href=\"./?cid=".$commu['id']."\">". $commu_name. "</a></nobr>";
			$level2 = "<nobr> &gt; ". $topic_name. "</nobr>";
			if(!is_null($act_msg)){
				$level2 = "<nobr> &gt; <a href=\""._CM_URL_TOPIC."&tid=".$topic['id']."\">". $topic_name. "</a></nobr>";
				$level3 = "<nobr> &gt; ". $act_msg. "</nobr>";
			}
		}
		elseif(!is_null($act_msg)){
			$level1 = "<nobr> &gt; <a href=\"./?cid=".$commu['id']."\">". $commu_name. "</a></nobr>";
			$level2 = "<nobr> &gt; ". $act_msg. "</nobr>";
		}
	}
	elseif(!is_null($act_msg)){
		$level1 = "<nobr> > ". $act_msg. "</nobr>";
	}
	
	$this->tpl->assign($key, $list.$level1.$level2.$level3);
}
//------------------------------------------------------------------------------

function assignFormHeader($form_name, $method='post', $target='', $action='', $upload=false, $hidden_vars=NULL, $token_name=NULL)
{
	$page_html = (empty($target))? 
		"" : "<input type=\"hidden\" name=\"".APP_PAGE_ARG."\" value=\"".$target."\">\n";
	$action_html = (empty($action))? 
		"" : "<input type=\"hidden\" name=\"".APP_ACTION_ARG."\" value=\"".$action."\">\n";
	$upload_html = ($upload)? " enctype=\"multipart/form-data\"" : "";
	
	$form = "<form action=\"\" method=\"".$method."\"".$upload_html.">\n".
			$page_html. $action_html;
	
	if(is_array($hidden_vars)){
		foreach($hidden_vars as $key => $value){
			$form .= "<input type=\"hidden\" name=\"".$key."\" value=\"".$value."\">\n";
		}
	}
	if(!is_null($token_name)){
		$token_handler =& new XoopsMultiTokenHandler();
		$token =& $token_handler->create($token_name);
		$form .= $token->getHtml();
	}
	
	$this->tpl->assign($form_name, $form);
}
//------------------------------------------------------------------------------

}
?>
