<?php
class res_confirmAction extends topicAction
{
function dispatch(&$context)
{
	if($this->isGuest()){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	$tid = $this->getIntRequest('tid');
	if(!isset($tid)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	$commu_handler =& CM_CommunityHandler::getInstance();
	$topic_handler =& CM_TopicHandler::getInstance();
	
	// ȥԥåμ
	$topic =& $topic_handler->get($tid);
	if(!is_object($topic) || $topic->getCommentCount() >= 1001){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	// ߥ˥ƥμ
	$cid = $topic->getVar('c_commu_id');
	$community =& $commu_handler->get($cid);
	if(!is_object($community)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	$commu_auth = $community->getAuthority();
	if($commu_auth < _CM_AUTH_NON_MEMBER
	   || ($commu_auth < _CM_AUTH_MEMBER && $community->getVar('public_flag')==3) ){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	$errors = array();
	
	$body = $this->getTextRequest('body');
	if(empty($body)){
		$errors[] = _CM_TOPIC_RES_BODY_NG;
	}
	
	$comment_handler =& CM_TopicCommentHandler::getInstance();
	$new_comment =& $comment_handler->create();
	$new_comment->setVar('body', $body);
	
	$commu_data = array('id' => $cid, 'name' => $community->getVar('name'));
	$context->setAttributes('community', $commu_data);
	
	$_SESSION['comment_body'] = $body;
	
	if(count($errors) > 0){
		$topic_data = array(
			'id' => $tid,
			'name' => $topic->getVar('name'),
		);
		$default = array(
			'body' => $new_comment->getVar('body', 'f'),
		);
		$context->setAttributes('topic', $topic_data);
		$context->setAttributes('errors', $errors);
		$context->setAttributes('default', $default);
		$context->setAttributes('is_topic_comment', true);
		return "add";
	}
	
	$image_handler =& CM_ImageHandler::getInstance();
	$file_handler =& CM_FileHandler::getInstance();
	
	$topic_data = array(
		'id' => $tid,
		'name' => $topic->getVar('name'),
		'body' => preg_replace('/\[res\]([1-9]\\d*)\[\/res\]/', '>>\1', $new_comment->getVar('body', 'p')),
		'images' => $image_handler->uploadImageTemp('images'),
		'files' => $file_handler->uploadFileTemp('files'),
	);
	
	$context->setAttributes('topic', $topic_data);
}

}
?>
