<?php
class defaultAction extends topicAction
{

var $vars = array();

function dispatch(&$context)
{
	global $xoopsUser;
	$own_uid = ($xoopsUser)? $xoopsUser->getVar('uid') : 0;
	
	$limit = 20;
	$tid = $this->getIntRequest('tid', APP_REQUEST_GET);
	if(!isset($tid)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	$start = $this->getIntRequest('s', APP_REQUEST_GET);
	
	$commu_handler =& CM_CommunityHandler::getInstance();
	$topic_handler =& CM_TopicHandler::getInstance();
	
	// ȥԥåμ
	$topic =& $topic_handler->get($tid);
	if(!is_object($topic)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	// ߥ˥ƥμ
	$cid = $topic->getVar('c_commu_id');
	$commu_handler =& CM_CommunityHandler::getInstance();
	$community =& $commu_handler->get($cid);
	if(!is_object($community) || ($community->getVar('public_flag')==3 && !$community->checkAuthority())){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	$comment_count_all = $topic->getCommentCount() - 1;
	if($comment_count_all > 1000){
		$comment_count_all = 1000;
	}
	
	if(!isset($start) || $start < 0 || $start > 1000){
		$start = $limit * intval($comment_count_all/$limit);
	}
	if($start==1000){
		$start = $start - $limit;
	}
	
	$comment_list_temp =& $topic->getCommentListForPreview($limit, $start);
	
	$default_body = $this->getTextRequest('comment_body', APP_REQUEST_SESSION, XOBJ_DTYPE_TXTAREA);
	unset($_SESSION['comment_body']);
	
	// ѥ쥹Υݥåץåץɥ ----------------
	$res_ids_temp = array();
	$this->vars = array(
		'comment_list' => array(),
		'comment_checked' => array(),
		'res_depth' => 0,
	);
	$this->vars['comment_list'] =& $comment_list_temp;
	
	foreach($comment_list_temp as $comment){
		$this->vars['res_depth'] = 0;
		$res_ids_temp = $this->getResIds($tid, $comment['number'], $comment['body']);
	}
	
	if(is_array($this->vars['comment_checked'])){
		$res_ids = array_keys($this->vars['comment_checked']);
		$res_list =& $this->getResList($tid, $res_ids);
		$res_list_html = $this->getResListHtml($res_ids, $res_list);
	}
	else{
		$res_list = "";
	}
	//------------------------------------------------------
	
	$image_handler =& CM_ImageHandler::getInstance();
	$file_handler =& CM_FileHandler::getInstance();
	$user_handler =& CM_UserHandler::getInstance();
	$comment_list = array();
	$commu_auth = $community->getAuthority();
	
	foreach($comment_list_temp as $comment){
		$comment_ids[] = $comment['c_commu_topic_comment_id'];
	}
	$image_list =& $image_handler->getListByIds(2, $comment_ids);
	$file_list =& $file_handler->getListByIds(2, $comment_ids);
	$authors = array();
	
	foreach($comment_list_temp as $comment){
		$c_uid = intval($comment['uid']);
		if($c_uid > 0){
			if(!isset($authors[$c_uid])){
				$authors[$c_uid] =& $user_handler->get($c_uid);
			}
			
			if(is_object($authors[$c_uid])){
				$author_info =& $authors[$c_uid]->getInfo();
			}
			else{
				$author_info = array(
					'name' => '',
					'page_url' => '',
				);
			}
			
			$id = intval($comment['c_commu_topic_comment_id']);
			$images = isset($image_list[$id]) ? $image_list[$id] : array();
			$files = isset($file_list[$id]) ? $file_list[$id] : array();
			
			$comment_list[] = array(
				'uid' => $c_uid,
				'body' => $this->getResQuotedCommentBody($tid, $comment['number'], $res_list),
				'author' => $author_info['name'],
				'url_author' => $author_info['page_url'],
				'r_datetime' => $comment['r_datetime'],
				'number' => $comment['number'],
				'images' => $images,
				'files' => $files,
				'show_edit' => ($commu_auth>=_CM_AUTH_SUB_ADMIN || $c_uid==$own_uid),
				'show_res_add' => ($commu_auth>=_CM_AUTH_MEMBER),
				'url_edit' => _CM_URL_TOPIC.'&'.APP_ACTION_ARG.'=edit&tid='.$tid.'&n='.$comment['number'],
				'url_del' => _CM_URL_TOPIC.'&'.APP_ACTION_ARG.'=del&tid='.$tid.'&n='.$comment['number'],
			);
		}
		else{
			// deleted topic/comment
			$comment_list[] = array(
				'uid' => 0,
				'body' => '',
				'r_datetime' => $comment['r_datetime'],
				'number' => $comment['number'],
			);
		}
	}
	
	$comment_count = count($comment_list) - 1;
	
	$pager = $this->getPageSelector(_CM_URL_TOPIC.'&tid='.$tid, 
						$start, $limit, $comment_count, $comment_count_all);
	
	$image_handler =& CM_ImageHandler::getInstance();
	$image_handler->DeleteImageTemp();
	
	$file_handler =& CM_FileHandler::getInstance();
	$file_handler->DeleteFileTemp();
	
	$commu_info = array(
		'id' => $community->getVar('c_commu_id'),
		'name' => $community->getVar('name'),
		'auth_level' => $commu_auth,
	);
	
	$topic_info = array(
		'id' => $tid,
		'name' => $topic->getVar('name'),
	);
	
	$context->setAttributes('community', $commu_info);
	$context->setAttributes('topic', $topic_info);
	$context->setAttributes('comment_list', $comment_list);
	$context->setAttributes('comment_count', $comment_count);
	$context->setAttributes('comment_count_all', $comment_count_all);
	$context->setAttributes('pager', $pager);
	$context->setAttributes('res_list_html', $res_list_html);
	$context->setAttributes('default', array('body' => $default_body));
}
//------------------------------------------------------------------------------

function getResIds($tid, $comment_id, $comment_body)
{
	$comment_handler =& CM_TopicCommentHandler::getInstance();
	
	if(!preg_match_all("/\[res\]([1-9]\\d*)\[\/res\]/", $comment_body, $matches)){
		return false;
	}
	if(++$this->vars['res_depth'] > 10){
		$this->vars['res_depth'] = 0;
		return false;
	}
	
	$res_ids = array();
	
	foreach($matches[1] as $id){
		if(isset($this->vars['comment_checked'][$id])){
			continue;
		}
		
		if(isset($this->vars['comment_list'][$id])){
			// ѥɤƵ
			if($id < $comment_id && !empty($this->vars['comment_list'][$id]['body'])){
				$this->vars['comment_checked'][$id] = true;
				$res_ids[] = $this->getResIds($tid, $id, $this->vars['comment_list'][$id]['body']);
			}
		}
		else{
			// ڡϰϳΥȤơѥɤƵ
			$res =& $comment_handler->getByNumber($tid, $id);
			if(is_object($res)){
				$this->vars['comment_checked'][$id] = true;
				$res_ids[] = $this->getResIds($tid, $id, $res->getVar('body'));
			}
		}
	}
	return $res_ids;
}
//------------------------------------------------------------------------------

function getResListHtml($res_ids, $res_list)
{
	$user_handler =& CM_UserHandler::getInstance();
	$res_list_html = "";
	
	foreach($res_ids as $id){
		if(!isset($res_list[$id]) || $res_list[$id]['uid'] < 1){
			continue;
		}
		$body = $res_list[$id]['body'];
		$r_datetime = $res_list[$id]['r_datetime'];
		
		$author_obj =& $user_handler->get($res_list[$id]['uid']);
		if(!is_object($author_obj)){
			continue;
		}
		$author_info =& $author_obj->getInfo();
		
		if(preg_match_all("/\[res\]([1-9]\\d*)\[\/res\]/", $body, $matches)){
			foreach($matches[1] as $m){
				if(isset($res_list[$m]) && $res_list[$m]['uid'] > 0){
					$s = floor(($m-1)/20) * 20;
					$body = str_replace("[res]{$m}[/res]", "<a href=\""._CM_URL_TOPIC."&amp;tid={$res_list[$m]['c_commu_topic_id']}&amp;s={$s}#{$m}\" onmouseover=\"showResPopUp('res{$m}',event)\" onmouseout=\"hideResPopUp('res{$m}')\">&gt;&gt;{$m}</a>", $body);
				}
				else{
					$body = str_replace("[res]{$m}[/res]", "&gt;&gt;{$m}", $body);
				}
			}
		}
		$res_list_html .= "<span id='res$id' class='respopup' onmouseover=\"showResPopUp('res{$id}',event,true)\"><nobr><b>". $id. ": ".$author_info['name']."</b> [".$r_datetime."]</nobr><br>". $body. "</span>\n";
		
		unset($author_obj);
	}
	return $res_list_html;
}
//------------------------------------------------------------------------------

function &getResList($tid, $res_ids)
{
	$comment_handler =& CM_TopicCommentHandler::getInstance();
	return $comment_handler->getListByNumbers($tid, $res_ids);
}
//------------------------------------------------------------------------------

function getResQuotedCommentBody($tid, $num, $res_list)
{
	$body = $this->vars['comment_list'][$num]['body'];
	if(!preg_match_all("/\[res\]([1-9]\\d*)\[\/res\]/", $body, $matches)){
		return $body;
	}
	
	foreach($matches[1] as $id){
		if($id < $num && isset($res_list[$id])){
			$s = floor(($id-1)/20)*20;
			$body = str_replace("[res]{$id}[/res]", "<a href=\""._CM_URL_TOPIC."&amp;tid={$tid}&amp;s={$s}#{$id}\" onmouseover=\"showResPopUp('res{$id}',event)\" onmouseout=\"hideResPopUp('res{$id}')\">&gt;&gt;{$id}</a>", $body);
		}
		else{
			$body = str_replace("[res]{$id}[/res]", "&gt;&gt;{$id}", $body);
		}
	}
	return $body;
}
//------------------------------------------------------------------------------

}
?>
