/*
 * Decompiled with CFR 0.152.
 */
package lll.wrj4P5;

import lll.Loc.Loc;
import lll.wrj4P5.BoardPressedThread;
import lll.wrj4P5.BoardReleasedThread;
import lll.wrj4P5.Wrj4P5;
import wiiremotej.BalanceBoard;
import wiiremotej.event.BBButtonEvent;
import wiiremotej.event.BBMassEvent;
import wiiremotej.event.BBStatusEvent;
import wiiremotej.event.BalanceBoardAdapter;

public class WiiBoard
extends BalanceBoardAdapter {
    public long tNow = 0L;
    public float[][] sensed = new float[2][2];
    public float[][] psensed;
    public float weight;
    public float pweight;
    public float topRight;
    public float bottomLeft;
    public float topLeft;
    public float bottomRight;
    public boolean isIlluminated;
    private Wrj4P5 parent;
    private BalanceBoard talker;
    private int myId;
    private float batteryLevel;

    public WiiBoard(Wrj4P5 wii) {
        this.parent = wii;
    }

    public BalanceBoard addTalker(BalanceBoard talker, int id) {
        this.myId = id;
        this.talker = talker;
        return talker;
    }

    public void disconnected() {
        System.out.println("Board disconnected... Please Wii again.");
        this.parent.disconnected(this.myId);
    }

    public void statusReported(BBStatusEvent evt) {
        this.batteryLevel = (float)evt.getBatteryLevel() / 200.0f;
        this.isIlluminated = evt.isLEDIlluminated();
    }

    public void buttonInputReceived(BBButtonEvent evt) {
        Thread t;
        if (this.parent.boardPressed != null && evt.wasPressed()) {
            t = new BoardPressedThread(evt, this.parent, this.myId);
            ((BoardPressedThread)t).run();
        }
        if (this.parent.boardReleased != null && evt.wasReleased()) {
            t = new BoardReleasedThread(evt, this.parent, this.myId);
            ((BoardReleasedThread)t).run();
        }
    }

    public void massInputReceived(BBMassEvent evt) {
        try {
            this.psensed = (float[][])this.sensed.clone();
            this.pweight = this.weight;
            this.weight = (float)evt.getTotalMass();
            this.sensed[0][0] = this.topLeft = (float)evt.getMass(0, 1);
            this.sensed[1][1] = this.bottomRight = (float)evt.getMass(1, 0);
            this.sensed[0][1] = this.topRight = (float)evt.getMass(0, 0);
            this.sensed[1][0] = this.bottomLeft = (float)evt.getMass(1, 1);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        ++this.tNow;
    }

    public void disconnect() {
        if (this.talker != null) {
            this.talker.disconnect();
            this.talker = null;
        }
        this.parent.disconnected(this.myId);
    }

    public boolean isConnected() {
        return this.talker.isConnected();
    }

    public void requestStatus() {
        try {
            if (!this.talker.isReadingData()) {
                this.talker.requestStatus();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public boolean isReadingData() {
        return this.talker.isReadingData();
    }

    public float getBatteryLevel() {
        return this.batteryLevel;
    }

    public boolean isLED() {
        this.isIlluminated = this.talker.isLEDIlluminated();
        return this.isIlluminated;
    }

    public void setLED(boolean illumination) {
        try {
            this.isIlluminated = illumination;
            this.talker.setLEDIlluminated(this.isIlluminated);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Loc guessCoG() {
        float ttl = this.sqr(this.topRight) + this.sqr(this.bottomRight) + this.sqr(this.topLeft) + this.sqr(this.bottomLeft);
        float xrate = (this.sqr(this.topRight) + this.sqr(this.bottomRight)) / ttl;
        float yrate = (this.sqr(this.bottomLeft) + this.sqr(this.bottomRight)) / ttl;
        return new Loc(xrate, yrate, 0.0f);
    }

    public boolean isLeftZone() {
        return this.topRight + this.bottomRight < this.topLeft + this.bottomLeft;
    }

    public boolean isTopZone() {
        return this.bottomLeft + this.bottomRight < this.topLeft + this.topRight;
    }

    public boolean isCentralZone(float tol) {
        float mn;
        float[][] b = this.sensed;
        float mx = Math.max(Math.max(b[0][0], b[0][1]), Math.max(b[1][0], b[1][1]));
        return mx - (mn = Math.min(Math.min(b[0][0], b[0][1]), Math.min(b[1][0], b[1][1]))) < this.weight / 4.0f * tol;
    }

    public boolean isCentralZone() {
        return this.isCentralZone(0.4f);
    }

    private float sqr(float x) {
        return x * x;
    }
}

