/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperProcess;
import org.tanukisoftware.wrapper.test.Main;

public class ChildWrapper {
    private static String c_encoding = System.getProperty("sun.jnu.encoding");

    private static Thread outputThread(String context, Object process, InputStream is, final String name) throws IOException {
        final BufferedReader br = new BufferedReader(new InputStreamReader(is, c_encoding));
        Thread thread = new Thread(context + "-" + name){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        try {
                            String line;
                            while ((line = br.readLine()) != null) {
                                System.out.println(name + ": " + line);
                            }
                        }
                        finally {
                            br.close();
                        }
                    }
                    catch (IOException e) {
                        System.out.println(name + ": Error");
                        e.printStackTrace();
                    }
                }
                finally {
                    System.out.println(name + ": End");
                }
            }
        };
        thread.start();
        return thread;
    }

    private static void joinThread(Thread thread) {
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleJavaProcess(String command) throws IOException, InterruptedException {
        Thread stderrThread;
        Thread stdoutThread;
        System.out.println("Test Begin: " + command);
        Process process = Runtime.getRuntime().exec(command);
        try {
            stdoutThread = ChildWrapper.outputThread("handleJavaProcess", process, process.getInputStream(), "stdout");
            stderrThread = ChildWrapper.outputThread("handleJavaProcess", process, process.getErrorStream(), "stderr");
        }
        finally {
            int exitCode = process.waitFor();
            System.out.println("exitCode: " + exitCode);
        }
        ChildWrapper.joinThread(stdoutThread);
        ChildWrapper.joinThread(stderrThread);
        System.out.println("Test End");
        System.out.println();
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleWrapperProcess(String command) throws IOException, InterruptedException {
        Thread stderrThread;
        Thread stdoutThread;
        System.out.println("Test Begin: " + command);
        WrapperProcess process = WrapperManager.exec((String)command);
        try {
            stdoutThread = ChildWrapper.outputThread("handleJavaProcess", process, process.getInputStream(), "stdout");
            stderrThread = ChildWrapper.outputThread("handleJavaProcess", process, process.getErrorStream(), "stderr");
        }
        finally {
            int exitCode = process.waitFor();
            System.out.println("exitCode: " + exitCode);
        }
        ChildWrapper.joinThread(stdoutThread);
        ChildWrapper.joinThread(stderrThread);
        System.out.println("Test End");
        System.out.println();
        System.out.println();
    }

    public static void main(String[] args) {
        System.out.println("Communicate with child processes using encoding: " + c_encoding);
        try {
            String wrapperCmdTestWrapper;
            String wrapperCmdVersion;
            if (WrapperManager.isWindows()) {
                wrapperCmdVersion = "..\\bin\\wrapper.exe -v";
                wrapperCmdTestWrapper = "..\\bin\\wrapper.exe -c ..\\conf\\wrapper.conf -- exit0";
            } else {
                wrapperCmdVersion = "../bin/wrapper -v";
                wrapperCmdTestWrapper = "../bin/wrapper -c ../conf/wrapper.conf -- exit0";
            }
            String batCmd = "cmd /c ..\\bin\\TestWrapper.bat exit0";
            String batDirect = "..\\bin\\TestWrapper.bat exit0";
            System.out.println(Main.getRes().getString("Runtime.exec test (Version)."));
            ChildWrapper.handleJavaProcess(wrapperCmdVersion);
            System.out.println(Main.getRes().getString("Runtime.exec test (TestWrapper)."));
            ChildWrapper.handleJavaProcess(wrapperCmdTestWrapper);
            System.out.println(Main.getRes().getString("Runtime.exec test (SimpleWaiter)."));
            ChildWrapper.handleJavaProcess("../test/simplewaiter 99 3");
            System.out.println(Main.getRes().getString("Runtime.exec test (SimpleWaiter Crash)."));
            ChildWrapper.handleJavaProcess("../test/simplewaiter -crash 99 3");
            if (WrapperManager.isStandardEdition()) {
                System.out.println(Main.getRes().getString("WrapperManager.exec test (Version)."));
                ChildWrapper.handleWrapperProcess(wrapperCmdVersion);
                System.out.println(Main.getRes().getString("WrapperManager.exec test (TestWrapper)."));
                ChildWrapper.handleWrapperProcess(wrapperCmdTestWrapper);
                System.out.println(Main.getRes().getString("WrapperManager.exec test (SimpleWaiter)."));
                ChildWrapper.handleWrapperProcess("../test/simplewaiter 99 3");
                System.out.println(Main.getRes().getString("WrapperManager.exec test (SimpleWaiter Crash)."));
                ChildWrapper.handleWrapperProcess("../test/simplewaiter -crash 99 3");
            }
            if (WrapperManager.isWindows()) {
                System.out.println(Main.getRes().getString("Runtime.exec test (Bat with cmd)."));
                ChildWrapper.handleJavaProcess(batCmd);
                System.out.println(Main.getRes().getString("Runtime.exec test (Bat direct)."));
                ChildWrapper.handleJavaProcess(batDirect);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        if (c_encoding == null && (c_encoding = System.getProperty("file.encoding")) == null) {
            c_encoding = "Cp1252";
        }
    }
}

