/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.IOException;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperPropertyUtil;
import org.tanukisoftware.wrapper.test.Main;
import org.tanukisoftware.wrapper.test.TestUtils;

public class DelayedIORestarter {
    public static void main(String[] args) {
        boolean restart;
        int pauseDelay;
        TestUtils.sleep(2000L);
        switch (WrapperManager.getJVMId()) {
            case 1: {
                pauseDelay = 1;
                restart = true;
                break;
            }
            case 2: {
                pauseDelay = 5;
                restart = true;
                break;
            }
            case 3: {
                pauseDelay = 10;
                restart = true;
                break;
            }
            default: {
                pauseDelay = 10;
                restart = false;
            }
        }
        System.out.println(Main.getRes().getString("Asking Wrapper to pause logger for {0} seconds.", (Object)new Integer(pauseDelay)));
        try {
            TestUtils.writeWrapperTestCommand("PAUSE_LOGGER " + pauseDelay);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int pollInterval = WrapperPropertyUtil.getIntProperty((String)"wrapper.commandfile.poll_interval", (int)5) + 1;
        if (restart) {
            System.out.println(Main.getRes().getString("Restart JVM after {0} second delay...", (Object)new Integer(pollInterval)));
        } else {
            System.out.println(Main.getRes().getString("Stop JVM after {0} second delay...", (Object)new Integer(pollInterval)));
        }
        TestUtils.sleep(pollInterval * 1000);
        if (restart) {
            WrapperManager.restart();
        } else {
            WrapperManager.stop((int)0);
        }
    }
}

