/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.tanukisoftware.wrapper.test.Main;

public class ShutdownHook {
    public static void main(String[] args) {
        Method addShutdownHookMethod;
        try {
            addShutdownHookMethod = Runtime.class.getMethod("addShutdownHook", Thread.class);
        }
        catch (NoSuchMethodException e) {
            System.out.println(Main.getRes().getString("Shutdown hooks not supported by current JVM."));
            return;
        }
        System.out.println(Main.getRes().getString("This application registers a shutdown hook which"));
        System.out.println(Main.getRes().getString("should be executed after the JVM has told the Wrapper"));
        System.out.println(Main.getRes().getString("it is exiting."));
        System.out.println(Main.getRes().getString("This is to test the wrapper.jvm_exit.timeout property"));
        Runtime runtime = Runtime.getRuntime();
        Thread hook = new Thread(){

            public void run() {
                System.out.println(Main.getRes().getString("Starting shutdown hook. Loop for 25 seconds."));
                System.out.println(Main.getRes().getString("Should timeout unless this property is set: wrapper.jvm_exit.timeout=30"));
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() - start < 25000L) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                System.out.println(Main.getRes().getString("Shutdown hook complete. Should exit now."));
            }
        };
        try {
            addShutdownHookMethod.invoke((Object)runtime, hook);
        }
        catch (IllegalAccessException e) {
            System.out.println(Main.getRes().getString("Unable to register shutdown hook: {0}", (Object)e.getMessage()));
        }
        catch (InvocationTargetException e) {
            System.out.println(Main.getRes().getString("Unable to register shutdown hook: {0}", (Object)e.getMessage()));
        }
        System.out.println(Main.getRes().getString("Application complete.  Wrapper should stop, invoking the shutdown hooks."));
        System.out.println();
    }
}

