<?php
/* ==================================================
 *   Ktai Login Page
   ================================================== */

global $wpload_error, $Ktai_Style;
$wpload_error = 'Could not open the login page because custom WP_PLUGIN_DIR is set.';
require dirname(__FILE__) . '/wp-load.php';
nocache_headers();

if (! isset($Ktai_Style) || ! $Ktai_Style->is_ktai() || @$_COOKIE[KS_COOKIE_PCVIEW] || ! class_exists('Ktai_Style_Admin')) {
	wp_redirect(get_bloginfo('wpurl') . '/wp-login.php');
	exit();
}

define ('KS_ADMIN_MODE', true);
$KS_Login = new Ktai_Style_Login($Ktai_Style);
exit();

/* ==================================================
 *   Ktai_Style_Login class
   ================================================== */

class Ktai_Style_Login {
	private $base;
	private $admin;
	private $mime_type;
	private $charset;
	private $iana_charset;
	private $warp_end;

// ==================================================
public function __construct($base) {
	$this->base = $base;
	$this->admin = new Ktai_Style_Admin;
	switch ($_REQUEST['action']) {
	case 'logout':
		$this->logout();
		break;
	default:
		$this->login();
		break;
	}
}

// ==================================================
private function logout() {
	$sid = $this->admin->get_sid();
	$this->admin->unset_session($sid);
	$this->admin->unset_prev_session($sid);
	do_action('wp_logout');
	$redirect_to = 'login.php?loggedout=true';
	if (isset($_POST['redirect_to']) || isset($_GET['redirect_to'])) {
		$redirect_to = isset($_POST['redirect_to']) ? $_POST['redirect_to'] : $_GET['redirect_to'];
		$redirect_to = $this->admin->shrink_redirect_to($redirect_to);
	}
	$this->admin->safe_redirect($redirect_to);
}

// ==================================================
private function login_header($title = 'Log in', $message = '', $wp_error = '') {
	if ($this->base->check_wp_version(2.7)) {
		$body_color = 'bgcolor="#fbfbfb" text="#333333" link="#777777" vlink="#777777"';
	} else {
		$body_color = 'bgcolor="#ccffff" text="#333333" link="#777777" vlink="#777777"';
	}
	$error_color = 'color="red"';
	$message_color = 'color="#ff5566"';
	$logo_file = 'wplogo25-login';
	if (preg_match('!^' . KS_ADMIN_DIR . '/$!', $redirect_to)) {
		$redirect_to = '';
	}
	$this->mime_type    = 'text/html';
	$this->charset      = $this->base->get('charset');
	$this->iana_charset = $this->base->get('iana_charset');
	$this->base->ktai->set('mime_type', $mime_type); // don't use 'application/xhtml+xml'
	switch ($this->base->is_ktai()) {
	case 'DoCoMo':
		$logo_ext = '.gif';
		$wrap_start = '';
		$this->wrap_end = '';
		$style_input = '';
		break;
	case 'Unknown':
		$logo_ext = '.png';
		$style_body = ' style="text-align:center;"';
		$wrap_start = '<div style="width:19em;margin:0 auto;text-align:left;">';
		$this->wrap_end = '</div>';
		$style_input = 'style="width:100%" ';
		break;
	default:
		$logo_ext = '.png';
		$wrap_start = '';
		$this->wrap_end = '';
		$style_input = '';
		break;
	}
	ob_start();
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML Basic 1.0//EN" "http://www.w3.org/TR/xhtml-basic/xhtml-basic10.dtd">
<html><head>
<meta http-equiv="Content-Type" content="<?php echo attribute_escape($this->mime_type); ?>; charset=<?php echo attribute_escape($this->iana_charset); ?>" />
<meta name="robots" content="noindex,nofollow" />
<title><?php bloginfo('name'); ?> &rsaquo; <?php echo $title; ?></title>
</head><body <?php echo $body_color . $style_body; ?>>
<?php
	echo $wrap_start;
	echo apply_filters('ks_login_logo/ktai_style.php', '<center><h1><img src="' . KS_ADMIN_DIR . '/' . $logo_file . $logo_ext . '" alt="WordPress"/></h1></center>', KS_ADMIN_DIR . '/' . $logo_file, $logo_ext);
?><br />
	<?php if ($wp_error && $wp_error->get_error_code()) {
		$errors = '';
		$messages = '';
		foreach ($wp_error->get_error_codes() as $code) {
			$severity = $wp_error->get_error_data($code);
			foreach ($wp_error->get_error_messages($code) as $error) {
				if ( 'message' == $severity ) {
					$messages .= '	' . $error . "<br />\n";
				} else {
					$errors .= '	' . $error . "<br />\n";
				}
			}
		}
		if (! empty($errors)) {
			echo "<p><font $error_color>" . apply_filters('login_errors', $errors) . '</font></p>';
		}
		if (! empty($messages)) {
			echo "<p><font $message_color>" . apply_filters('login_messages', $messages) . '</font></p>';
		}
	}
}

// ==================================================
private function login_footer() {
?>
<p><?php echo $this->wrap_end; ?></body></html>
<?php
	$buffer = ob_get_contents();
	ob_end_clean();
	if (function_exists('mb_convert_encoding')) {
		$buffer = mb_convert_encoding($buffer, $this->charset, get_bloginfo('charset'));
	}
	$buffer = $this->base->ktai->convert_pict($buffer);
	$buffer = $this->base->ktai->shrink_pre_split($buffer);
	$buffer = $this->base->ktai->shrink_post_split($buffer);
	header ("Content-Type: {$this->mime_type}; charset={$this->iana_charset}");
	echo $buffer;
}

// ==================================================
private function login() {
	if ((! isset($_POST['redirect_to']) || empty($_POST['redirect_to'])) && ! isset($_GET['redirect_to'])) {
		$redirect_to = KS_ADMIN_DIR . '/';
	} else {
		$redirect_to = isset($_POST['redirect_to']) ? $_POST['redirect_to'] : $_GET['redirect_to'];
		$redirect_to = $this->admin->shrink_redirect_to($redirect_to);
	}
	if ($_POST) {
		$user_login = sanitize_user($_POST['log']);
		$user_pass  = $_POST['pwd'];
	} else {
		$user_login = '';
		$user_pass  = '';
	}
	do_action_ref_array('wp_authenticate', array(&$user_login, &$user_pass));
	if ($user_login || $user_pass) {
		$user = wp_authenticate($user_login, $user_pass);
		$redirect_to = apply_filters('login_redirect', $redirect_to, isset( $_REQUEST['redirect_to'] ) ? $_REQUEST['redirect_to'] : '', $user);
	
		if (! is_wp_error($user)) {
			if (! $user->has_cap('edit_posts') && (empty($redirect_to) || $redirect_to == KS_ADMIN_DIR . '/')) {
				$redirect_to = KS_ADMIN_DIR . '/profile.php';
			}
			if ($this->admin->set_session($user_login)) {
				do_action('wp_login', $user_login);
				$this->admin->safe_redirect($redirect_to);
				exit();
			} else {
				$errors = new WP_Error('session', __('<strong>ERROR</strong>: Cannot create a login session.', 'ktai_style'));
			}
		} else {
			$errors = $user;
			if (isset($_GET['loggedout']) && true == $_GET['loggedout']) {
				$errors = new WP_Error('loggedout', __('You are now logged out.', 'ktai_style'), 'message');
			}
		}
	} else {
		$errors = new WP_Error();
	}
	$this->login_header(__('Log in'), '', $errors);
?>
<form method="post" action="login.php"><div>
<?php _e('Username') ?><br /><input type="text" name="log" size="20" istyle="3" mode="alphabet" value="<?php echo attribute_escape(stripslashes($user_login)); ?>" <?php echo $style_input; ?>/><br />
<?php _e('Password') ?><br /><input type="password" name="pwd" size="20" istyle="3" mode="alphabet" value="" <?php echo $style_input; ?>/></div>
<br />
<?php // do_action('login_form'); ?>
<div><input type="submit" name="wp-submit" value="<?php _e('Log in'); ?>" /><input type="hidden" name="redirect_to" value="<?php echo htmlspecialchars($redirect_to, ENT_QUOTES); ?>" />
</div></form>
<p><img localsrc="64" alt="<?php _e('&lt;-', 'ktai_style'); ?>" /><a href="<?php bloginfo('url'); ?>/"><?php printf(__('Back to %s', 'ktai_style'), get_bloginfo('title', 'display')); ?></a>
<?php 
	if ($this->base->get('pcview_enabled')) { 
		echo '<br /><img localsrc="64" alt="' . __('&lt;-', 'ktai_style') . '" /><a href="' . get_bloginfo('wpurl') . '/wp-login.php?pcview=true">' . __('Go to PC login form.', 'ktai_style') . '</a>';
	}
	$this->login_footer();
}

// ===== End of class ====================
}
?>