<?php
/*
Plugin Name: Syntax Highlighter for WordPress
Plugin URI: http://wppluginsj.sourceforge.jp/syntax-highlighter/
Description: 100% JavaScript syntax highlighter This plugin makes using the <a href="http://code.google.com/p/syntaxhighlighter">Syntax highlighter</a> to highlight code snippets within WordPress simple. Supports C++, C#, CSS, Delphi, Java, JavaScript, PHP, Python, Ruby, SQL, VB, XML, and (X)HTML.
Version: 1.5.1
Author: wokamoto
Author URI: http://dogmap.jp/

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

  Copyright 2008 wokamoto (email : wokamoto1973@gmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

if (!class_exists('wokCommonController') || !class_exists('wokScriptManager'))
  require(dirname(__FILE__).'/includes/common-controller.php');

$sh_target = array(
   'c'
  ,'cpp'
  ,'csharp'
  ,'java'
  ,'javascript'
  ,'delphi'
  ,'pascal'
  ,'php'
  ,'python'
  ,'ruby'
  ,'vb'
  ,'vbnet'
  ,'sql'
  ,'css'
  ,'xml'
  ,'html'
  ,'xhtml'
  ,'xslt'
);

class SyntaxHighlighter extends wokCommonController {	/* Start Class */
  var $target;

  function SyntaxHighlighter() {
    $this->init(__FILE__);

    $this->target = array(
       "c" => array(false, 'C')
      ,"cpp" => array(false, 'C++')
      ,"c-sharp" => array(false, 'C#')
      ,"jscript" => array(false, 'Java Script')
      ,"java" => array(false, 'Java')
      ,"delphi" => array(false, 'Delphi')
      ,"pascal" => array(false, 'Pascal')
      ,"php" => array(false, 'PHP')
      ,"python" => array(false, 'Python')
      ,"ruby" => array(false, 'Ruby')
      ,"vb" => array(false, 'VB')
      ,"vb.net" => array(false, 'VB.Net')
      ,"sql" => array(false, 'SQL')
      ,"css" => array(false, 'CSS')
      ,"xml" => array(false, 'XML')
      ,"html" => array(false, 'HTML')
      ,"xhtml" => array(false, 'XHTML')
      ,"xslt" => array(false, 'XSLT')
    );
  }

  function add_head() {
    echo "<link href=\"{$this->plugin_url}css/SyntaxHighlighter.css\" type=\"text/css\" rel=\"stylesheet\" />\n";
  }

  function add_footer(){
    $enabled = false;
    foreach ($this->target as $key => $val) {if ($val[0]) {$enabled = true; break;}}
    if (!$enabled) return;

    $scripts  = "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shCore.js\"></script>\n";
    if (isset($this->target["c"]) && $this->target["c"][0]) $scripts .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shBrushCpp.js\"></script>\n";
    if (isset($this->target["cpp"]) && $this->target["cpp"][0]) $scripts .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shBrushCpp.js\"></script>\n";
    if (isset($this->target["c-sharp"]) && $this->target["c-sharp"][0]) $scripts .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shBrushCSharp.js\"></script>\n";
    if (isset($this->target["java"]) && $this->target["java"][0]) $scripts .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shBrushJava.js\"></script>\n";
    if (isset($this->target["jscript"]) && $this->target["jscript"][0]) $scripts .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shBrushJScript.js\"></script>\n";
    if (isset($this->target["delphi"]) && $this->target["delphi"][0]) $scripts .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shBrushDelphi.js\"></script>\n";
    if (isset($this->target["pascal"]) && $this->target["pascal"][0]) $scripts .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shBrushDelphi.js\"></script>\n";
    if (isset($this->target["php"]) && $this->target["php"][0]) $scripts .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shBrushPhp.js\"></script>\n";
    if (isset($this->target["python"]) && $this->target["python"][0]) $scripts .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shBrushPython.js\"></script>\n";
    if (isset($this->target["ruby"]) && $this->target["ruby"][0]) $scripts .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shBrushRuby.js\"></script>\n";
    if (isset($this->target["vb"]) && $this->target["vb"][0]) $scripts .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shBrushVb.js\"></script>\n";
    if (isset($this->target["vb.net"]) && $this->target["vb.net"][0]) $scripts .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shBrushVb.js\"></script>\n";
    if (isset($this->target["sql"]) && $this->target["sql"][0]) $scripts .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shBrushSql.js\"></script>\n";
    if (isset($this->target["css"]) && $this->target["css"][0]) $scripts .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shBrushCss.js\"></script>\n";
    if (isset($this->target["xml"]) && $this->target["xml"][0]) $scripts .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shBrushXml.js\"></script>\n";
    if (isset($this->target["html"]) && $this->target["html"][0]) $scripts .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shBrushXml.js\"></script>\n";
    if (isset($this->target["xhtml"]) && $this->target["xhtml"][0]) $scripts .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shBrushXml.js\"></script>\n";
    if (isset($this->target["xslt"]) && $this->target["xslt"][0]) $scripts .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}js/shBrushXml.js\"></script>\n";
    echo $scripts;

    $js_out  = "dp.SyntaxHighlighter.Toolbar.Commands.About.label='" . __('?', $this->textdomain_name) . "';";
    $js_out .= "dp.SyntaxHighlighter.Toolbar.Commands.CopyToClipboard.label='" . __('copy to clipboard', $this->textdomain_name) . "';";
    $js_out .= "dp.SyntaxHighlighter.Toolbar.Commands.CopyToClipboard.func=function(B,A){var D=A.originalCode;var w=window,d=document;if(w.clipboardData){w.clipboardData.setData('text',D)}else{if(dp.sh.ClipboardSwf!=null){var C=A.flashCopier;if(C==null){C=d.createElement('div');A.flashCopier=C;A.div.appendChild(C)}C.innerHTML='<embed src=\"'+dp.sh.ClipboardSwf+'\" FlashVars=\"clipboard='+encodeURIComponent(D)+'\" width=\"0\" height=\"0\" type=\"application/x-shockwave-flash\"></embed>'}}alert(\"" . __('The code is in your clipboard now', $this->textdomain_name) . "\")};";
    $js_out .= "dp.SyntaxHighlighter.Toolbar.Commands.ExpandSource.label='" . __('+ expand source', $this->textdomain_name) . "';";
    $js_out .= "dp.SyntaxHighlighter.Toolbar.Commands.PrintSource.label='" . __('print', $this->textdomain_name) . "';";
    $js_out .= "dp.SyntaxHighlighter.Toolbar.Commands.ViewSource.label='" . __('view plain', $this->textdomain_name) . "';";
    $js_out .= "dp.SyntaxHighlighter.ClipboardSwf = '{$this->plugin_url}js/clipboard.swf';\n";
    $js_out .= "dp.SyntaxHighlighter.HighlightAll('code');\n";
    $this->writeScript($js_out, 'footer');;
  }

  function SH_Shortcode_Handler($atts, $content = null, $startTag) {
    extract(shortcode_atts(array('num' => 1), $atts));
    $pVal = (int) $num;				// get the starting line number
    $inTxt = htmlentities($content, ENT_QUOTES, get_settings('blog_charset'), true);
    if (isset($this->target[$startTag])) $this->target[$startTag][0] = true;

    $outTxt = "\n\n"
            . '<div style="position:relative;top:18px;margin-top:-18px;">'
            . "<small><strong>{$this->target[$startTag][1]}</strong></small>\n"
            . '</div>'
            . '<pre name="code"'
            . ' class="'.$startTag.($pVal > 1 ? ":firstLine[{$pVal}]" : '').'"'
            . ' style="margin:18px 0;">'
            . $inTxt
            . '</pre>'
            . "\n\n";

    return $outTxt;
  }

  function SH_Shortcode_c($atts, $content = null) {return $this->SH_Shortcode_Handler($atts, $content, 'c');}
  function SH_Shortcode_cpp($atts, $content = null) {return $this->SH_Shortcode_Handler($atts, $content, 'cpp');}
  function SH_Shortcode_csharp($atts, $content = null) {return $this->SH_Shortcode_Handler($atts, $content, 'c-sharp');}
  function SH_Shortcode_java($atts, $content = null) {return $this->SH_Shortcode_Handler($atts, $content, 'java');}
  function SH_Shortcode_javascript($atts, $content = null) {return $this->SH_Shortcode_Handler($atts, $content, 'jscript');}
  function SH_Shortcode_delphi($atts, $content = null) {return $this->SH_Shortcode_Handler($atts, $content, 'delphi');}
  function SH_Shortcode_pascal($atts, $content = null) {return $this->SH_Shortcode_Handler($atts, $content, 'pascal');}
  function SH_Shortcode_php($atts, $content = null) {return $this->SH_Shortcode_Handler($atts, $content, 'php');}
  function SH_Shortcode_python($atts, $content = null) {return $this->SH_Shortcode_Handler($atts, $content, 'python');}
  function SH_Shortcode_ruby($atts, $content = null) {return $this->SH_Shortcode_Handler($atts, $content, 'ruby');}
  function SH_Shortcode_vb($atts, $content = null) {return $this->SH_Shortcode_Handler($atts, $content, 'vb');}
  function SH_Shortcode_vbnet($atts, $content = null) {return $this->SH_Shortcode_Handler($atts, $content, 'vb.net');}
  function SH_Shortcode_sql($atts, $content = null) {return $this->SH_Shortcode_Handler($atts, $content, 'sql');}
  function SH_Shortcode_css($atts, $content = null) {return $this->SH_Shortcode_Handler($atts, $content, 'css');}
  function SH_Shortcode_xml($atts, $content = null) {return $this->SH_Shortcode_Handler($atts, $content, 'xml');}
  function SH_Shortcode_html($atts, $content = null) {return $this->SH_Shortcode_Handler($atts, $content, 'html');}
  function SH_Shortcode_xhtml($atts, $content = null) {return $this->SH_Shortcode_Handler($atts, $content, 'xhtml');}
  function SH_Shortcode_xslt($atts, $content = null) {return $this->SH_Shortcode_Handler($atts, $content, 'xslt');}
}

$sh = new SyntaxHighlighter();

remove_filter('the_content', 'do_shortcode');
add_filter('the_content', 'do_shortcode', 0);
foreach ($sh_target as $val) {add_shortcode($val, array(&$sh, 'SH_Shortcode_'.$val));}

add_action('wp_head',   array(&$sh, 'add_head'));
add_action('wp_footer', array(&$sh, 'add_footer'));

unset($sh_target);
unset($sh);
?>