<?php
/*
Plugin Name: Google Maps Anywhere
Version: 0.3.0
Plugin URI: http://wppluginsj.sourceforge.jp/googlemaps-anywhere/
Description: Add Google Maps to your posts and pages.(Only for WordPress 2.5+)
Author: wokamoto
Author URI: http://dogmap.jp/

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html
*/

//define('GM_ANYWHERE_API_KEY', 'XXXXX');
define('GM_ANYWHERE_STATICMAP_URL',  'http://maps.google.com/staticmap');

define('GM_ANYWHERE_SHORTCODE',      'googlemap');
define('GM_ANYWHERE_ELEMENT',        'div.googlemaps');
define('GM_ANYWHERE_META_FIELD_NAME','Lat_Long');
define('GM_ANYWHERE_DEBUG_MODE',     true);

// User Level Permission -- Subscriber = 0,Contributor = 1,Author = 2,Editor= 7,Administrator = 9
define('GM_ANYWHERE_OPTION_ACCESS_LEVEL', 9);

// default Value
define('GM_ANYWHERE_DEFAULT_LAT',     35.5000);
define('GM_ANYWHERE_DEFAULT_LNG',    139.0000);
define('GM_ANYWHERE_DEFAULT_WIDTH',  '300px');
define('GM_ANYWHERE_DEFAULT_HEIGHT', '150px');
define('GM_ANYWHERE_DEFAULT_ZOOM',   14);
define('GM_ANYWHERE_DEFAULT_TYPE',   'G_NORMAL_MAP');

// default Value (street view) -- Tokyo Tower
define('GM_ANYWHERE_SV_DEFAULT_LAT',  35.658684);
define('GM_ANYWHERE_SV_DEFAULT_LNG', 139.746326);
define('GM_ANYWHERE_SV_DEFAULT_YAW',   0);
define('GM_ANYWHERE_SV_DEFAULT_PITCH', 5);
define('GM_ANYWHERE_SV_DEFAULT_ZOOM',  0);

// mobile width & height
define('GM_ANYWHERE_MOBILE_WIDTH',   128);
define('GM_ANYWHERE_MOBILE_HEIGHT',   80);

// edit width & height
define('GM_ANYWHERE_EDIT_WIDTH',     620);
define('GM_ANYWHERE_EDIT_HEIGHT',    335);

class GoogleMapsAnywhereController {
 var $plugin_js  = 'js/googlemaps-anywhere-0.3.0.min.js';
 var $plugin_ver = '0.3.0';

 var $jquery_js  = 'js/jquery-1.2.6.min.js';
 var $jquery_ver = '1.2.6';

 var $api_key = false;
 var $added_footer = false;
 var $nonce = -1;

 var $plugin_dir, $plugin_file, $plugin_url;
 var $textdomain_name;

 function GoogleMapsAnywhereController() {
  global $wp_version;

  // Wordpress 2.5+
  if (version_compare($wp_version, "2.5", ">=")) {
   $this->setPluginDir();
   $this->loadTextdomain();
   $this->setAPIKey();

   if ($this->api_key != false) {
    // script loader
    add_action('wp_print_scripts', array($this,'addScripts'));
    add_filter('script_loader_src', array($this,'scriptSrcCleanup'));

    // set style sheet & JavaScript
    add_action('wp_head', array($this, 'addHead'));

    // shortcode API
    add_shortcode(GM_ANYWHERE_SHORTCODE, array($this, 'shortcodeHandler'));

    // for Ktai style
    add_filter('image_to_link/ktai_style.php', array($this, 'keepGmapImage'), 10, 3);
   }

   // set JavaScript (admin head)
   add_action('admin_head', array($this, 'addAdminHead'));

   // media button support
   add_action('media_buttons', array($this, 'addMediaButton'), 20);
   add_action('media_upload_googlemaps', 'media_upload_googlemaps');
   add_action('media_upload_googlemaps_streetview', 'media_upload_googlemaps_streetview');
   add_action('media_upload_googlemaps_option', 'media_upload_googlemaps_option');

   if ($this->api_key != false) {
    add_action('admin_head_media_upload_googlemaps_form', array($this, 'addMediaHead'));
    add_action('admin_head_media_upload_googlemaps_streetview_form', array($this, 'addMediaHead'));
   }

  }
 }

 // get plugin dir, filename, url
 function setPluginDir() {
  $plugins_dir = trailingslashit(defined('PLUGINDIR') ? PLUGINDIR : 'wp-content/plugins');
  $filename = explode("/", __FILE__);
  if(count($filename) <= 1) $filename = explode("\\", __FILE__);
  $this->plugin_dir  = $filename[count($filename) - 2];
  $this->plugin_file = $filename[count($filename) - 1];
  $this->plugin_url  = trailingslashit(trailingslashit(defined('WP_PLUGIN_URL') ? WP_PLUGIN_URL : trailingslashit(get_bloginfo('wpurl')).$plugins_dir).$this->plugin_dir);
  unset($filename);
 }

 // load Textdomain
 function loadTextdomain( $sub_dir = '/language' ) {
  global $wp_version;
  $this->textdomain_name = $this->plugin_dir;
  $textdomain_dir = trailingslashit(trailingslashit($this->plugin_dir).$sub_dir);
  if (version_compare($wp_version, "2.6", ">=") && defined('WP_PLUGIN_DIR')) {
   load_plugin_textdomain($this->textdomain_name, false, $textdomain_dir);
  } else {
   $plugins_dir = trailingslashit(defined('PLUGINDIR') ? PLUGINDIR : 'wp-content/plugins');
   load_plugin_textdomain($this->textdomain_name, $plugins_dir.$textdomain_dir);
  }
 }

 // get Google Maps API Key
 function setAPIKey() {
  $this->api_key = get_option('googlemaps_api_key');
  if (!$this->api_key) $this->api_key = get_option('yf_google_api_key');
  if (!$this->api_key) $this->api_key = (defined('GM_ANYWHERE_API_KEY') ? GM_ANYWHERE_API_KEY : false);
 }

 /*
 * Script loader
 */
 function addScripts() {
  global $script_manager;

  if (is_admin() || (function_exists('is_ktai') && is_ktai()) || (function_exists('is_mobile') && is_mobile())) return;

  // regist jQuery
  if (isset($script_manager)) $script_manager->register_script('jquery', $this->plugin_url.$this->jquery_js, false, $this->jquery_ver);
  wp_enqueue_script('jquery');
  wp_enqueue_script('google.loader', 'http://www.google.com/jsapi?key='.$this->api_key);
 }

 function scriptSrcCleanup($src) {
  return (strstr($src, "http://www.google.com/jsapi") != false ? preg_replace("/(\?|\&|\&(amp|#038);)ver=.*$/i", "", $src) : $src);
 }

 /*
 * style sheet & JavaScript (Head)
 */
 function addHead() {
  global $script_manager, $Lw_GoogleMaps;

  if (is_admin() || (function_exists('is_ktai') && is_ktai()) || (function_exists('is_mobile') && is_mobile())) return;

  $element = (defined('LWGM_EACH_MAP_CLASS') ? 'div.'.LWGM_EACH_MAP_CLASS : GM_ANYWHERE_ELEMENT);

  if (!isset($Lw_GoogleMaps) || (defined('GM_ANYWHERE_DEBUG_MODE') && GM_ANYWHERE_DEBUG_MODE)) {
   $css_out  = "<style type=\"text/css\" media=\"screen,tv,print,handheld\"> /*<![CDATA[ */\n";
   $css_out .= $element."{width:".GM_ANYWHERE_DEFAULT_WIDTH.";height:".GM_ANYWHERE_DEFAULT_HEIGHT.";clear:both;margin:1em auto;border:1px solid #999;line-height:1.25em;text-align:center;overflow:hidden;}\n";
   $css_out .= $element." img {margin:0;padding:0;border:0 none;}\n";
   $css_out .= $element." .infowindow {text-align:left;font-size:0.88em;}\n";
   $css_out .= $element." p {margin:0;text-indent:0;text-align:left;font-size:0.75em;}\n";
   $css_out .= "/* ]]>*/ </style>\n";
   echo $css_out;
  }

  $js_out  = "var googlemapsAnywhereL10n = {";
  $js_out .= " language:\"".(defined('WPLANG') ? WPLANG : 'en')."\"";
  $js_out .= ",markerTitle:\"".__('Move to the Google Maps.', $this->textdomain_name)."\"";
  $js_out .= ",cssPath:\"{$element}\"";
  $js_out .= "};\n";
  if (isset($script_manager)) {
   add_filter('head_script/ScriptManager', create_function('$js', 'return $js . "'.addcslashes($js_out,'"').'";'));
  } else {
   echo "<script type=\"text/javascript\">/*<![CDATA[ */\n";
   echo $js_out;
   echo "/* ]]>*/</script>\n";
  }
 }

 /*
 * JavaScript (Footer)
 */
 function addFooter() {
  if ((function_exists('is_ktai') && is_ktai()) || (function_exists('is_mobile') && is_mobile())) return;

  if (!is_admin() && !$this->added_footer) {
   $out .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}{$this->plugin_js}\"></script>\n";
   echo $out;
   $this->added_footer = true;
  }
 }

 /*
 * JavaScript (Admin Head)
 */
 function addAdminHead() {
  if (strstr($_SERVER['PHP_SELF'], 'post.php') || strstr($_SERVER['PHP_SELF'], 'page-new.php') || strstr($_SERVER['PHP_SELF'], 'post-new.php') || strstr($_SERVER['PHP_SELF'], 'page.php')) {
   $out  = "<script type=\"text/javascript\">/*<![CDATA[ */\n";
   $out .= "function send_meta_value(metakey, metavalue) {";
   $out .= "jQuery('#metakeyinput').val(metakey);";
   $out .= "jQuery('#metavalue').val(metavalue);";
   $out .= "jQuery('#addmetasub').trigger('click');";
   $out .= "}\n";
   $out .= "var gm_anyehere_params = {point:false, zoom:false, pov:false, placename:''};\n";
   $out .= "function gm_anyehere_params_set(name, val) {gm_anyehere_params[name] = val};";
   $out .= "function gm_anyehere_params_get(name) {return gm_anyehere_params[name]};\n";
   $out .= "/* ]]>*/</script>\n";
   echo $out;
  }
 }

 /*
 * Wordpress 2.5 - media button support
 */
 function addMediaButton() {
  global $post_ID, $temp_ID;

  $uploading_iframe_ID = (int) (0 == $post_ID ? $temp_ID : $post_ID);
  $media_upload_iframe_src = "media-upload.php?post_id={$uploading_iframe_ID}";

  $type = "googlemaps";
  $tab  = ($this->api_key != false || !current_user_can(GM_ANYWHERE_OPTION_ACCESS_LEVEL) ? "googlemaps" : "googlemaps_option");
  $googlemaps_iframe_src = apply_filters('media_upload_googlemaps_iframe_src', "{$media_upload_iframe_src}&amp;type={$type}&amp;tab={$tab}");
  $googlemaps_title = __('Add Google Maps', $this->textdomain_name);
  $link_markup = "<a href=\"{$googlemaps_iframe_src}&amp;TB_iframe=true&amp;keepThis=true&amp;height=500&amp;width=640\" class=\"thickbox\" title=\"{$googlemaps_title}\"><img src=\"{$this->plugin_url}images/googlemaps-media.gif\" alt=\"{$googlemaps_title}\" /></a>\n";

  echo $link_markup;
 }

 function googlemapsMediaBrowse() {
  global $type, $tab;

  if ($this->api_key == false) return;

  $post_id = intval($_REQUEST['post_id']);
  $form_action_url = trailingslashit(get_bloginfo('wpurl'))."wp-admin/media-upload.php?type={$type}&amp;tab={$tab}&amp;post_id={$post_id}";
  $callback = "type_form_{$type}";

  $width  = GM_ANYWHERE_EDIT_WIDTH;
  $height = GM_ANYWHERE_EDIT_HEIGHT;
  $lat    = GM_ANYWHERE_DEFAULT_LAT;
  $lng    = GM_ANYWHERE_DEFAULT_LNG;

?>
<div id="map" style="width:<?php echo $width; ?>px;height:<?php echo $height; ?>px;margin:0.5em auto 0px;padding:0px;"></div>

<form method="post" action="<?php echo attribute_escape($form_action_url); ?>" class="media-upload-form type-form validate" id="<?php echo $type; ?>-form">
 <table class="optiontable form-table" style="margin-top:0"><tbody>
  <tr>
   <td>
    <?php _e('Place Name', $this->textdomain_name); ?>: <input type="text" name="placename" value="" />
    <?php _e('Width', $this->textdomain_name); ?>: <input type="text" name="width" size="7" value="<?php echo GM_ANYWHERE_DEFAULT_WIDTH; ?>" />
    <?php _e('Height', $this->textdomain_name); ?>: <input type="text" name="height" size="7" value="<?php echo GM_ANYWHERE_DEFAULT_HEIGHT; ?>" />
   </td>
   <td>
    <input type="submit" class="button" name="insertonlybutton" value="<?php echo attribute_escape(__('Insert into Post')) ?>" /><br />
   </td>
  </tr>
  <tr>
   <td>
    <?php echo attribute_escape(__('Key')); ?>: <input type="text" name="metakeyname" size="7" value="<?php echo (defined('GEO_META_FIELD_NAME') ? GEO_META_FIELD_NAME : GM_ANYWHERE_META_FIELD_NAME); ?>" />
    <?php echo attribute_escape(__('Value')); ?>: <input type="text" name="metavalue" value="" />
   </td>
   <td>
    <input type="submit" class="button" name="sendmetavalbutton" value="<?php echo attribute_escape(__('Add Custom Field')) ?>" />
   </td>
  </tr>
 </tbody></table>
</form>

<script type="text/javascript">/* <![CDATA[ */
var onload_callback = function(func){
 var addLoadEvent = google.setOnLoadCallback;
 if (jQuery.browser.mozilla && typeof top.jQuery != 'undefined' ) {
  var ver = jQuery.browser.version.split('.');
  if ( Number(ver.length > 1 ? ver[0] + '.' + ver[1] : ver[0]) < 1.9 && top.jQuery('iframe').size() > 0 ) addLoadEvent = top.jQuery('iframe').load;
 }
 addLoadEvent(func);
};

onload_callback(function() {
 var gmap, gmarker;

 var default_point = new GLatLng(<?php echo $lat; ?>, <?php echo $lng; ?>);
 var default_zoom  = 4;

 var current_point = top.gm_anyehere_params_get('point');
 var current_zoom = top.gm_anyehere_params_get('zoom');
 var current_place = top.gm_anyehere_params_get('placename');
 if (current_point == false) current_point = default_point;
 if (current_zoom == false) current_zoom = default_zoom;
 if (current_place == false) current_place = '';

 var form = jQuery('#<?php echo $type; ?>-form').submit(function() {return false;});
 jQuery('input[name=placename]:first', form).val(current_place);
 jQuery('input[name=metavalue]:first', form).val(current_point.toUrlValue());

 gmap = new GMap2(document.getElementById("map"), {size: new GSize(<?php echo $width; ?>, <?php echo $height; ?>)});
 gmap.setCenter(current_point, current_zoom);
 gmap.addMapType(G_PHYSICAL_MAP);
 gmap.setMapType(<?php echo GM_ANYWHERE_DEFAULT_TYPE; ?>);

 gmarker = new GMarker(current_point, {draggable: true});
 gmap.addOverlay(gmarker);

 GEvent.addListener(gmap, 'click', function(overlay, point) {
  if (point) {
   gmarker.setPoint(point);
   jQuery('input[name=metavalue]:first', form).val(point.toUrlValue());
   top.gm_anyehere_params_set('point', point);
   top.gm_anyehere_params_set('zoom', gmap.getZoom());
   top.gm_anyehere_params_set('placename', jQuery('input[name=placename]:first', form).val());
  }
 });

 GEvent.addListener(gmarker, 'dragend', function(overlay) {
  var point = gmarker.getLatLng();
  if (point) {
   jQuery('input[name=metavalue]:first', form).val(point.toUrlValue());
   top.gm_anyehere_params_set('point', point);
   top.gm_anyehere_params_set('zoom', gmap.getZoom());
   top.gm_anyehere_params_set('placename', jQuery('input[name=placename]:first', form).val());
  }
 });

 gmap.addControl(new GLargeMapControl());
 gmap.addControl(new GMapTypeControl());
 gmap.addControl(new GOverviewMapControl());
 gmap.addOverlay(new GStreetviewOverlay());
 gmap.addControl(new google.maps.LocalSearch({onSearchCompleteCallback: function(searcher){
  if (searcher.results.length >= 1) {
   var point = new GLatLng(searcher.results[0].lat, searcher.results[0].lng);
   var placename = searcher.results[0].addressLines[searcher.results[0].addressLines.length - 1];
   gmap.setCenter(point, <?php echo GM_ANYWHERE_DEFAULT_ZOOM; ?>);
   gmarker.setPoint(point);
   jQuery('input[name=placename]:first', form).val(placename);
   jQuery('input[name=metavalue]:first', form).val(point.toUrlValue());
   top.gm_anyehere_params_set('point', point);
   top.gm_anyehere_params_set('zoom', gmap.getZoom());
   top.gm_anyehere_params_set('placename', placename);
  }
 }}));

 jQuery('input[name=insertonlybutton]:first', form).unbind('click').click(function(){
  var gmaptypes = Array(
   {name:gmap.getMapTypes()[0].getName(true), type:'G_NORMAL_MAP'}
  ,{name:gmap.getMapTypes()[1].getName(true), type:'G_SATELLITE_MAP'}
  ,{name:gmap.getMapTypes()[2].getName(true), type:'G_HYBRID_MAP'}
  ,{name:gmap.getMapTypes()[3].getName(true), type:'G_PHYSICAL_MAP'}
  );
  var point = gmarker.getPoint();
  var latlng = point.toUrlValue().split(',');
  var placename = jQuery('input[name=placename]:first', form).val();
  var width  = jQuery('input[name=width]:first', form).val();
  var height = jQuery('input[name=height]:first', form).val();
  var maptype = gmaptypes[0].type;
  for (var i = 0; i < gmaptypes.length; i++) {
   if (gmaptypes[i].name == gmap.getCurrentMapType().getName(true)) {
    maptype = gmaptypes[i].type;
    break;
   }
  }
  var gmap_val  = '[<?php echo GM_ANYWHERE_SHORTCODE; ?>'
                + ' lat="' + (latlng.length >= 1 ? latlng[0] : point.lat()) + '"'
                + ' lng="' + (latlng.length >= 1 ? latlng[1] : point.lng()) + '"'
                + ' width="' + width + '"'
                + ' height="' + height + '"'
                + ' zoom="' + gmap.getZoom() + '"'
                + ' type="' + maptype + '"'
                + ']'
                + (placename != '' ? placename : point.toUrlValue())
                + '[/<?php echo GM_ANYWHERE_SHORTCODE; ?>]';
  top.send_to_editor(gmap_val);
  GUnload();
  top.tb_remove();
  return false;
 });

 jQuery('input[name=sendmetavalbutton]:first', form).unbind('click').click(function(){
  var meta_key = jQuery('input[name=metakeyname]:first', form).val();
  var meta_val = jQuery('input[name=metavalue]:first', form).val();
  top.send_meta_value(meta_key, meta_val);
  GUnload();
  top.tb_remove();
  return false;
 });
});
/* ]]> */</script>
<?php
 }

 function googlemapsMediaStreetViewBrowse() {
  global $type, $tab;

  if ($this->api_key == false) return;

  $post_id = intval($_REQUEST['post_id']);
  $form_action_url = trailingslashit(get_bloginfo('wpurl'))."wp-admin/media-upload.php?type={$type}&amp;tab={$tab}&amp;post_id={$post_id}";
  $callback = "type_form_{$type}";

  $width  = GM_ANYWHERE_EDIT_WIDTH;
  $height = GM_ANYWHERE_EDIT_HEIGHT;
  $lat    = GM_ANYWHERE_SV_DEFAULT_LAT;
  $lng    = GM_ANYWHERE_SV_DEFAULT_LNG;

?>
<div id="map" style="width:<?php echo $width; ?>px;height:<?php echo $height; ?>px;margin:0.5em auto 0px;padding:0px;"></div>

<form method="post" action="<?php echo attribute_escape($form_action_url); ?>" class="media-upload-form type-form validate" id="<?php echo $type; ?>-form">
 <table class="optiontable form-table" style="margin-top:0"><tbody>
  <tr>
   <td>
    <?php _e('Place Name', $this->textdomain_name); ?>: <input type="text" name="placename" value="" />
    <?php _e('Width', $this->textdomain_name); ?>: <input type="text" name="width" size="7" value="<?php echo GM_ANYWHERE_DEFAULT_WIDTH; ?>" />
    <?php _e('Height', $this->textdomain_name); ?>: <input type="text" name="height" size="7" value="<?php echo GM_ANYWHERE_DEFAULT_HEIGHT; ?>" />
    <br />
    <?php _e('Lat', $this->textdomain_name); ?>: <input type="text" name="lat" value="" />
    <?php _e('Lng', $this->textdomain_name); ?>: <input type="text" name="lng" value="" />
    <br />
    <?php _e('Yaw', $this->textdomain_name); ?>: <input type="text" name="yaw" size="7" value="" />
    <?php _e('Pitch', $this->textdomain_name); ?>: <input type="text" name="pitch" size="7" value="" />
    <?php _e('Zoom', $this->textdomain_name); ?>: <input type="text" name="zoom" size="7" value="" />
   </td>
   <td>
    <input type="submit" class="button" name="insertonlybutton" value="<?php echo attribute_escape(__('Insert into Post')) ?>" /><br />
   </td>
  </tr>
 </tbody></table>
</form>

<script type="text/javascript">/* <![CDATA[ */
var onload_callback = function(func){
 var addLoadEvent = google.setOnLoadCallback;
 if (jQuery.browser.mozilla && typeof top.jQuery != 'undefined' ) {
  var ver = jQuery.browser.version.split('.');
  if ( Number(ver.length > 1 ? ver[0] + '.' + ver[1] : ver[0]) < 1.9 && top.jQuery('iframe').size() > 0 ) addLoadEvent = top.jQuery('iframe').load;
 }
 addLoadEvent(func);
};

onload_callback(function() {
 var gmapPanoClient, gmapPano;
 var default_point = new GLatLng(<?php echo $lat; ?>, <?php echo $lng; ?>);
 var default_pov   = { yaw : <?php echo GM_ANYWHERE_SV_DEFAULT_YAW; ?>, pitch: <?php echo GM_ANYWHERE_SV_DEFAULT_PITCH; ?>, zoom : <?php echo GM_ANYWHERE_SV_DEFAULT_ZOOM; ?> };

 var current_point = top.gm_anyehere_params_get('point');
 var current_place = top.gm_anyehere_params_get('placename');
 var current_pov   = top.gm_anyehere_params_get('pov');
 if (current_point == false) current_point = default_point;
 if (current_place == false) current_place = '';
 if (current_pov   == false) current_pov   = default_pov;

 var form = jQuery('#<?php echo $type; ?>-form').submit(function() {return false;});
 jQuery('input[name=placename]:first', form).val(current_place);

 gmapPanoClient = new GStreetviewClient();
 gmapPano = new GStreetviewPanorama(document.getElementById("map"));

 GEvent.addListener(gmapPano, "initialized", function(val){
  top.gm_anyehere_params_set('point', val.latlng);
  var latlng = val.latlng.toUrlValue().split(',');
  jQuery('input[name=lat]:first', form).val(latlng[0]);
  jQuery('input[name=lng]:first', form).val(latlng[1]);
 });
 GEvent.addListener(gmapPano, "yawchanged", function(val){
  jQuery('input[name=yaw]:first', form).val(val);
  top.gm_anyehere_params_set('sv_yaw', val);
 });
 GEvent.addListener(gmapPano, "pitchchanged", function(val){
  jQuery('input[name=pitch]:first', form).val(val);
  top.gm_anyehere_params_set('sv_pitch', val);
 });
 GEvent.addListener(gmapPano, "zoomchanged", function(val){
  jQuery('input[name=zoom]:first', form).val(val);
  top.gm_anyehere_params_set('sv_zoom', val);
 });

 gmapPanoClient.getNearestPanorama(current_point, function(panoData){
  gmapPano.setLocationAndPOV(panoData.location.latlng, current_pov);
  var latlng = panoData.location.latlng.toUrlValue().split(',');

  top.gm_anyehere_params_set('point', panoData.location.latlng);
  top.gm_anyehere_params_set('pov',   current_pov);

  jQuery('input[name=lat]:first', form).val(latlng[0]);
  jQuery('input[name=lng]:first', form).val(latlng[1]);
  jQuery('input[name=yaw]:first', form).val(current_pov.yaw);
  jQuery('input[name=pitch]:first', form).val(current_pov.pitch);
  jQuery('input[name=zoom]:first', form).val(current_pov.zoom);
 });

 jQuery('input[name=insertonlybutton]:first', form).unbind('click').click(function(){
  var lat    = jQuery('input[name=lat]:first', form).val();
  var lng    = jQuery('input[name=lng]:first', form).val();
  var yaw    = jQuery('input[name=yaw]:first', form).val();
  var pitch  = jQuery('input[name=pitch]:first', form).val();
  var zoom   = jQuery('input[name=zoom]:first', form).val();
  var placename = jQuery('input[name=placename]:first', form).val();
  var width  = jQuery('input[name=width]:first', form).val();
  var height = jQuery('input[name=height]:first', form).val();
  var maptype = 'STREETVIEW';
  var gmap_val  = '[<?php echo GM_ANYWHERE_SHORTCODE; ?>'
                + ' lat="' + lat + '"'
                + ' lng="' + lng + '"'
                + ' yaw="' + yaw + '"'
                + ' pitch="' + pitch + '"'
                + ' zoom="' + zoom + '"'
                + ' width="' + width + '"'
                + ' height="' + height + '"'
                + ' type="' + maptype + '"'
                + ']'
                + (placename != '' ? placename : point.toUrlValue())
                + '[/<?php echo GM_ANYWHERE_SHORTCODE; ?>]';
  top.send_to_editor(gmap_val);
  GUnload();
  top.tb_remove();
  return false;
 });
});
/* ]]> */</script>
<?php
 }

 function googlemapsOptionBrowse() {
  global $type, $tab;

  if (!current_user_can(GM_ANYWHERE_OPTION_ACCESS_LEVEL)) return;

  $post_id = intval($_REQUEST['post_id']);
  $form_action_url = trailingslashit(get_bloginfo('wpurl'))."wp-admin/media-upload.php?type={$type}&amp;tab={$tab}&amp;post_id={$post_id}";
  $callback = "type_form_$type";

  $msg = "<div id=\"message\" class=\"updated fade\" style=\"margin-top:1em;\"><p><strong>%s</strong></p></div>\n";
  if (isset($_POST['info_update'])) {
   check_admin_referer($this->nonce);
   $this->api_key = $this->upate_options();
   if ($this->api_key != false) {
    echo sprintf($msg, __('Done!', $this->textdomain_name));
   }
  }
  if ($this->api_key == false) {
    echo sprintf($msg, __('Please Enter Your Google Maps API Key', $this->textdomain_name));
  }

?>
<div class="wrap">
 <form method="post" action="<?php echo attribute_escape($form_action_url); ?>" class="media-upload-form type-form validate" id="<?php echo $type; ?>-form">
<?php $this->make_nonce_field($this->nonce); ?>
  <h2 id="apikey"><?php _e('Your Google Maps API Key', $this->textdomain_name); ?></h2>
  <table class="optiontable form-table"><tbody>
   <tr>
    <th width="20%" scope="row"><label for="googlemaps_api_key"><?php _e('API Key', $this->textdomain_name); ?>:</label></th>
    <td><input type="text" name="googlemaps_api_key" id="googlemaps_api_key" /> <?php echo sprintf(__("(don't have one? get one <a href=%s>here</a>)", $this->textdomain_name), '"http://www.google.com/apis/maps/signup.html"'); ?></td>
   </tr>
<?php if ($this->api_key != false) { ?>
   <tr>
    <th><?php _e('Current API Key', $this->textdomain_name); ?>:</th>
    <td><em><?php echo $this->api_key; ?></em></td>
   </tr>
<?php } ?>
  </tbody></table>
  <div class="submit">
   <input type="hidden" name="action" value="update" />
   <input type="submit" name="info_update" value="<?php _e('Update Options', $this->textdomain_name); ?> &raquo;" />
  </div>
 </form>
</div>
<?php

 }

 function make_nonce_field($action = -1) {
  if ( !function_exists('wp_nonce_field') ) {
   return;
  } else {
   return wp_nonce_field($action);
  }
 }

 function modifyMediaTab($tabs) {
  if ( current_user_can( GM_ANYWHERE_OPTION_ACCESS_LEVEL ) ) {
   return array('googlemaps'            =>  __('Google Maps', $this->textdomain_name)
               ,'googlemaps_streetview' =>  __('Street View', $this->textdomain_name)
               ,'googlemaps_option'     =>  __('Option', $this->textdomain_name));
  } else {
   return array('googlemaps'            =>  __('Google Maps', $this->textdomain_name)
               ,'googlemaps_streetview' =>  __('Street View', $this->textdomain_name));
  }
 }

 function addMediaHead() {
  if ($this->api_key == false) return;

  $post_id = intval($_REQUEST['post_id']);
?>
<script src="<?php echo $this->plugin_url.$this->jquery_js ?>" type="text/javascript"></script>
<script src="http://maps.google.com/maps?file=api&amp;v=2&amp;hl=<?php echo (defined('WPLANG') ? WPLANG : 'en'); ?>&amp;key=<?php echo $this->api_key; ?>" type="text/javascript" charset="utf-8"></script>
<script src="http://www.google.com/uds/api?file=uds.js&amp;v=1.0&amp;hl=<?php echo (defined('WPLANG') ? WPLANG : 'en'); ?>&amp;key=<?php echo $this->api_key; ?>" type="text/javascript"></script>
<script src="http://www.google.com/uds/solutions/localsearch/gmlocalsearch.js" type="text/javascript"></script>
<script type="text/javascript">/* <![CDATA[ */
 var post_id = <?php echo (int) $post_id; ?>;
/* ]]> */</script>
<style type="text/css">
 @import url("http://www.google.com/uds/css/gsearch.css");
 @import url("http://www.google.com/uds/solutions/localsearch/gmlocalsearch.css");
 body {margin:0px; padding:0px;}
 #map {border:1px solid #979797;width:100%;height:575px;}
</style>
<?php
 }

 /*
 * update options
 */
 function upate_options() {
  $gmap_api_key = (isset($_POST['googlemaps_api_key']) ? $_POST['googlemaps_api_key'] : false);
  if ($gmap_api_key) {
   update_option('googlemaps_api_key', $gmap_api_key);
   delete_option('yf_google_api_key');
  } elseif ($gmap_api_key = get_option('yf_google_api_key')) {
   update_option('googlemaps_api_key', $gmap_api_key);
   delete_option('yf_google_api_key');
  } else {
   $gmap_api_key = false;
  }
  return $gmap_api_key;
 }

 /*
 * Wordpress 2.5 - New shortcode API
 */
 function shortcodeHandler($atts, $content = '') {
  extract( shortcode_atts( array(
       'lat'    => GM_ANYWHERE_DEFAULT_LAT
      ,'lng'    => GM_ANYWHERE_DEFAULT_LNG
      ,'yaw'    => GM_ANYWHERE_SV_DEFAULT_YAW
      ,'pitch'  => GM_ANYWHERE_SV_DEFAULT_PITCH
      ,'zoom'   => GM_ANYWHERE_DEFAULT_ZOOM
      ,'width'  => GM_ANYWHERE_DEFAULT_WIDTH
      ,'height' => GM_ANYWHERE_DEFAULT_HEIGHT
      ,'type'   => GM_ANYWHERE_DEFAULT_TYPE
      ), $atts ) );

  // add JavaScript
  add_action('wp_footer', array($this, 'addFooter'));

  return $this->createHTMLSrc($lat, $lng, $yaw, $pitch, $width, $height, $zoom, $type, $content);
 }

 function getImgSrc($lat = GM_ANYWHERE_DEFAULT_LAT, $lng = GM_ANYWHERE_DEFAULT_LNG, $width = GM_ANYWHERE_DEFAULT_WIDTH, $height = GM_ANYWHERE_DEFAULT_HEIGHT, $zoom = GM_ANYWHERE_DEFAULT_ZOOM, $type = GM_ANYWHERE_DEFAULT_TYPE) {
  $width  = (int) $width;
  $height = (int) $height;
  $lang   = (defined('WPLANG') ? WPLANG : 'en');
  return GM_ANYWHERE_STATICMAP_URL."?markers={$lat},{$lng},red&amp;zoom={$zoom}&amp;size={$width}x{$height}&amp;key={$this->api_key}&amp;hl={&lang}";
 }

 function createHTMLSrc($lat = GM_ANYWHERE_DEFAULT_LAT, $lng = GM_ANYWHERE_DEFAULT_LNG, $yaw = GM_ANYWHERE_SV_DEFAULT_YAW, $pitch = GM_ANYWHERE_SV_DEFAULT_PITCH, $width = GM_ANYWHERE_DEFAULT_WIDTH, $height = GM_ANYWHERE_DEFAULT_HEIGHT, $zoom = GM_ANYWHERE_DEFAULT_ZOOM, $type = GM_ANYWHERE_DEFAULT_TYPE, $content= "") {
  list($element, $class) = split("\.", (defined('LWGM_EACH_MAP_CLASS') ? 'div.'.LWGM_EACH_MAP_CLASS : GM_ANYWHERE_ELEMENT), 2);

  $ret_val = "";
  if ( !((function_exists('is_ktai') && is_ktai()) || (function_exists('is_mobile') && is_mobile())) ) {
   $style  = "";
   if ($width  != GM_ANYWHERE_DEFAULT_WIDTH)  $style .= "width:{$width};";
   if ($height != GM_ANYWHERE_DEFAULT_HEIGHT) $style .= "height:{$height};";
   if ($style  != "") $style = " style=\"{$style}\"";

   $query = $lat.','.$lng.(strtoupper($type) == 'STREETVIEW' ? ','.$yaw.','.$pitch : '');

   $img_width  = (int) (strstr(strtoupper($width), 'PX') ? $width  : GM_ANYWHERE_DEFAULT_WIDTH);
   $img_height = (int) (strstr(strtoupper($height),'PX') ? $height : GM_ANYWHERE_DEFAULT_HEIGHT);

   $ret_val .= "<{$element} class=\"{$class}\"{$style}>";
   $ret_val .= "<a href=\"http://maps.google.co.jp/maps?hl=".(defined('WPLANG') ? WPLANG : 'en')."&amp;q={$query}&amp;z={$zoom}&amp;t={$type}\" title=\"{$content}\">";
   $ret_val .= "<img src=\"".$this->getImgSrc($lat, $lng, $img_width, $img_height, $zoom, $type)."\" alt=\"{$content}\" title=\"{$content}\" />";
   $ret_val .= "</a>";
   $ret_val .= "</{$element}>\n";

  } else {
   global $Lw_GoogleMaps;
   if (isset($Lw_GoogleMaps)) {
    $img_width  = $Lw_GoogleMaps->get('width');
    $img_height = $Lw_GoogleMaps->get('height');
   } elseif (class_exists('LWGM_Mobile')) {
    $Lwgm = new LWGM_Mobile();
    $img_width  = $Lwgm->width;
    $img_height = $Lwgm->height;
    unset($Lwgm);
   } else {
    $img_width  = GM_ANYWHERE_MOBILE_WIDTH;
    $img_height = GM_ANYWHERE_MOBILE_HEIGHT;
   }

   $ret_val .= "<div align=\"center\">";
   if ( function_exists('ks_is_image_inline') && ks_is_image_inline() ) {
     $ret_val .= "<img src=\"".$this->getImgSrc($lat, $lng, $img_width, $img_height, $zoom, $type)."\" alt=\"{$content}\" title=\"{$content}\" />";
   } else {
     $ret_val .= "[<a href=\"".$this->getImgSrc($lat, $lng, $img_width, $img_height, $zoom, $type)."\" title=\"{$content}\">";
     $ret_val .= __('Map of this location', $this->textdomain_name).' : '.$content;
     $ret_val .= "</a>]";
   }
   $ret_val .= "</div>\n";
  }

  return $ret_val;
 }

 /*
 * for Ktai Style
 */
 function keepGmapImage($rep, $org, $src) {
  if (preg_match('/^'.preg_quote(GM_ANYWHERE_STATICMAP_URL, '/').'/i', $src)) $rep = $org;
  return $rep;
 }
}

function media_upload_googlemaps() {
 global $gm_anywhere, $wp_version;

 if (!isset($gm_anywhere)) return;

 wp_iframe('media_upload_googlemaps_form');
}
function media_upload_googlemaps_form() {
 global $gm_anywhere;

 if (!isset($gm_anywhere)) return;

 add_filter('media_upload_tabs', array(&$gm_anywhere, 'modifyMediaTab'));

 echo "<div id=\"media-upload-header\">\n";
 media_upload_header();
 echo "</div>\n";

 $gm_anywhere->googlemapsMediaBrowse();
}

function media_upload_googlemaps_streetview() {
 global $gm_anywhere, $wp_version;

 if (!isset($gm_anywhere)) return;

 wp_iframe('media_upload_googlemaps_streetview_form');
}
function media_upload_googlemaps_streetview_form() {
 global $gm_anywhere;

 if (!isset($gm_anywhere)) return;

 add_filter('media_upload_tabs', array(&$gm_anywhere, 'modifyMediaTab'));

 echo "<div id=\"media-upload-header\">\n";
 media_upload_header();
 echo "</div>\n";

 $gm_anywhere->googlemapsMediaStreetViewBrowse();
}

function media_upload_googlemaps_option() {
 wp_iframe('media_upload_googlemaps_option_form');
}
function media_upload_googlemaps_option_form() {
 global $gm_anywhere;

 if (!isset($gm_anywhere)) return;

 if ( !function_exists('wp_nonce_field') ) {
  $gm_anywhere->nonce = -1;
 } else {
  $gm_anywhere->nonce = 'googlemaps-anywhere-update-config';
 }

 $gm_anywhere->api_key = (isset($_POST['googlemaps_api_key']) ? $_POST['googlemaps_api_key'] : $gm_anywhere->api_key);
 add_filter('media_upload_tabs', array(&$gm_anywhere, 'modifyMediaTab'));

 echo "<div id=\"media-upload-header\">\n";
 media_upload_header();
 echo "</div>\n";

 $gm_anywhere->googlemapsOptionBrowse();
}

global $wp_version, $gm_anywhere;

// Wordpress 2.5+
if (version_compare($wp_version, "2.5", ">=")) {
 if (!class_exists('ScriptManager')) require(trailingslashit(dirname(__FILE__)).'includes/script-manager.php');
 $gm_anywhere = new GoogleMapsAnywhereController();
}
?>
