<?php
/* ==================================================
 *   Retrieve messages from external mailbox
   ================================================== */

require_once dirname(dirname(dirname(dirname(__FILE__)))) . '/wp-config.php';

header('Content-Type: text/html; charset=' . get_bloginfo('charset'));
if (! class_exists('Ktai_Entry')) {
	http_error(501, 'The plugin is not activated.');
}

$server_url   = get_option('mailserver_url');
$server_port  = get_option('mailserver_port');
$server_login = get_option('mailserver_login');
$server_pass  = get_option('mailserver_pass');

if (! isset($_GET['_wpnonce']) || ! anon_verify_nonce(isset($_GET['_wpnonce']), 'ktai-entry-retieve')) {
	http_error(400, 'Your request could not be understood by the server due to malformed syntax.');
}

// Do nothing if default value
if (empty($server_url) || $server_url == 'mail.example.com'
	|| $server_port <= 0
	|| empty($server_login) || $server_login == 'login@example.com'
	|| $server_pass == 'password'
	) {
	http_error(502, 'The POP3 config is not valid.');
}

require_once dirname(__FILE__) . '/post.php';
$post = new Ktai_Entry_Post('pop3');
require_once dirname(__FILE__) . '/class-pop3.php';
$pop3 = new POP3();
$pop3->ALLOWAPOP = $post->get_option('ke_use_apop');

if (! $pop3->connect($server_url, $server_port)) {
	http_error(502, $pop3->ERROR);
}
if ($post->get_option('ke_use_apop')) {
	$count = $pop3->apop($server_login, $server_pass);
} else {
	$count = $pop3->login($server_login, $server_pass);
}
if (FALSE === $count) {
	$error = $pop3->ERROR;
	$pop3->quit();
	http_error(502, $error);
} elseif (0 == $count) {
	$pop3->quit();
	die("There doesn't seem to be any new mail.\n");
}

if (defined('KE_DEBUG')) {
	echo "There is $count message(s).<br />";
}

for ($i=1; $i <= $count; $i++) :
	$message = $pop3->get($i);
	$contents = $post->parse(implode('', $message));
	if (! is_object($contents)) {
		if (is_array($contents)) {
			$contents = implode("\n", $contents);
		}
		echo str_replace("\n", '<br />', $contents);
		continue;
	}
	$error = $post->insert($contents);
	if ($error) {
		echo str_replace("\n", '<br />', $error);
		continue;
	}
	if (! $pop3->delete($i)) {
		$error = $pop3->ERROR;
		$pop3->reset();
		http_error(502, $error);
	} else {
		echo "Mission complete, message '$i' deleted.<br />";
	}
endfor;

$pop3->quit();
exit();

/* ==================================================
 * @param	string     $nonce
 * @param	string|int $action
 * @return	boolean    $result
 * based on wp_verify_nonce at wp-includes/pluggable.php at WP 2.5
 */
function anon_verify_nonce($nonce, $action = -1) {
	$i = ceil(time() / 43200);
	// Nonce generated 0-12 hours ago
	if ( substr(wp_hash($i . $action . $_SERVER['SERVER_NAME']), -12, 10) == $nonce )
		return 1;
	// Nonce generated 12-24 hours ago
	if ( substr(wp_hash(($i - 1) . $action . $_SERVER['SERVER_NAME']), -12, 10) == $nonce )
		return 2;
	// Invalid nonce
	return false;
}

/* ==================================================
 * @param	int        $code
 * @param	string     $message
 */
function http_error($code, $message) {
	$title = array(
		400 => 'Bad Request',
		401 => 'Unauthorized',
		402 => 'Payment Required',
		403 => 'Forbidden',
		404 => 'Not Found',
		405 => 'Method Not Allowed',
		406 => 'Not Acceptable',
		407 => 'Proxy Authentication Required',
		408 => 'Request Timeout',
		422 => 'Unprocessable Entity',
		500 => 'Internal Server Error',
		501 => 'Not Implemented',
		502 => 'Bad Gateway',
		503 => 'Service Unavailable',
		504 => 'Gateway Timeout',
	);
	$code = intval($code);
	if (! isset($title[$code])) {
		$code = 500;
	}
	$message = htmlspecialchars($message, ENT_QUOTES);
	header("HTTP/1.0 $code " . $title[$code]);
	echo <<<E__O__T
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<HTML><HEAD>
<TITLE>$code $title[$code]</TITLE>
</HEAD><BODY>
<H1>$title[$code]</H1>
$message
</BODY></HTML>
E__O__T;
	exit;
}
?>