<?php
/* ==================================================
 *   Ktai Content Shrinkage
   ================================================== */

global $KS_Shrinkage;
$KS_Shrinkage = new Ktai_Content_Shrinkage;

add_filter('the_title', array($KS_Shrinkage, 'shrink_title'), 90);
add_filter('the_content', array($KS_Shrinkage, 'shrink_content'), 90);
add_filter('get_comment_text', array($KS_Shrinkage, 'shrink_content'), 90);
add_filter('post_link', array($KS_Shrinkage, 'strip_host'), 90);
add_filter('page_link', array($KS_Shrinkage, 'strip_host'), 90);
add_filter('attachment_link', array($KS_Shrinkage, 'strip_host'), 90);
add_filter('year_link', array($KS_Shrinkage, 'strip_host'), 90);
add_filter('month_link', array($KS_Shrinkage, 'strip_host'), 90);
add_filter('day_link', array($KS_Shrinkage, 'strip_host'), 90);
add_filter('category_link', array($KS_Shrinkage, 'strip_host'), 90);
add_filter('tag_link', array($KS_Shrinkage, 'strip_host'), 90);
add_filter('wp_generate_tag_cloud', array($KS_Shrinkage, 'shrink_tag_cloud'), 90, 3);
add_filter('split_page/ktai_style.php', array($KS_Shrinkage, 'add_image_inline'), 7);

define (KS_THUMBNAIL_MAX_SIZE, 96);
define (KS_THUMBNAIL_FILENAME, '.ktai');
define (KS_SIZE_EXCEED_COLOR, '#808080');
// define (KS_SHRINKAGE_DEBUG, TRUE);

class Ktai_Content_Shrinkage {
	private $url;
	private $url_pat;
	private $wpurl;
	private $wpurl_pat;
	private $short_links;
	private $internal_pat;
	private $short_int_pat;
	private $host_pat;

// ==================================================
public function __construct() {
	$this->url       = $this->strip_host(get_bloginfo('url') . '/');
	$this->url_pat   = '!^(' . preg_quote(get_bloginfo('url'), '!') . '/|' . preg_quote($this->url, '!') . ')!';
	$this->wpurl     = $this->strip_host(get_bloginfo('wpurl') . '/');
	$this->wpurl_pat = '!^(' . preg_quote(get_bloginfo('wpurl'), '!') . '/|' . preg_quote($this->wpurl, '!') . ')!';
	$this->short_links[0]  = $this->wpurl;
	$this->internal_pat[0] = '!^' . preg_quote(get_bloginfo('wpurl'), '!') . '/?!';
	if (get_bloginfo('url') && strcmp(get_bloginfo('url'), get_bloginfo('wpurl') !== 0)) {
		$this->short_links[]  = $this->url;
		$this->internal_pat[] = '!^' . preg_quote(get_bloginfo('url'), '!') . '/?!';
	}
	$this->short_int_pat = '!^(' . implode('|',  array_map('preg_quote', $this->short_links)) . ')!';
	if (preg_match('!^(https?://[^/]*)/?!', get_bloginfo('wpurl'), $host)) {
		$this->host_pat = '!^(/|' . preg_quote($host[1], '!') . '/)!';
	} else {
		$this->host_pat = '!^/!';
	}
	return;
}

// ==================================================
public function get($key) {
	return @$this->$key;
}

/* ==================================================
 * @param	string  $url
 * @return	string  $url
 */
public function strip_host($url = '/') {
	return preg_replace('!^https?://[^/]*/?!', '/', $url);
}

/* ==================================================
 * @param	string  $title
 * @return	string  $title
 */
public function shrink_title($title) {
	$protected_phrase = str_replace('%s', '', __('Protected: %s'));
	return preg_replace('/' . preg_quote($protected_phrase, '/') . '/', '<img localsrc="279" alt="' . $protected_phrase . '" />', $title);
}

/* ==================================================
 * @param	string  $content
 * @return	string  $content
 */
public function convert_links($content) {
	$leave_schemes = apply_filters('leave_scheme/ktai_style.php', array('#', 'tel:', 'tel-av:', 'vtel:', 'mailto:', 'device:', 'location:'));
	$leave_sites = preg_split('/\\s+/', ks_option('ks_treat_as_internal'), -1, PREG_SPLIT_NO_EMPTY);
	$leave_pat = '!^(' . implode('|', array_merge($leave_schemes, array_map('preg_quote', $leave_sites))) . ')!';
	for ($offset = 0, $replace = 'X' ; 
	     preg_match('!<a ([^>]*?)>(.*?)</a>!', $content, $l, PREG_OFFSET_CAPTURE, $offset) ; 
	     $offset += strlen($replace))
	{
		$orig    = $l[0][0];
		$offset  = $l[0][1];
		$desc    = $l[2][0];
		preg_match('/href=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1/', $l[1][0], $h);
		$href      = $h[2];
		$replace   = $orig;
		$link_html = $desc; // default is stripping links
		if (preg_match('!<img [^>]*?src=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1[^>]*? ?/?>!', $desc, $image)) {
			$src = $image[2];
			if (preg_match('!' . PLUGINDIR . '!', $src)) { // skip plug-in's icon
				continue; // leave links
			} elseif (preg_match($this->wpurl_pat, $href) && preg_match($this->wpurl_pat, $src)) { // both internal link
				$path = preg_replace($this->wpurl_pat, ABSPATH . '/', $href);
				if (! is_dir($path) && $imagesize = @filesize($path)) { // a thumbnail linked to original image
					$thumbnail = str_replace('<img ', '<img has_orig="true" ', $desc); // inform existance of original to images_to_link()
					$link_html = $thumbnail . '<img src="' . $href . '" alt="' . sprintf(__('Original(%dKB)', 'ktai_style'), intval($imagesize / 1024)) . '" filesize="' . $imagesize . '"/>'; // pass filesize to images_to_link()
				} else { // internal link to other than images
					$link_html = $desc . '(<a href="' . $href . '">' . __('Link Target', 'ktai_style') . '</a>)';
				}
			} elseif (preg_match($this->host_pat, $href) && preg_match($this->host_pat, $src) && $_SERVER['DOCUMENT_ROOT']) { // both in-host link
				$path = preg_replace($this->host_pat, $_SERVER['DOCUMENT_ROOT'] . '/', $href);
				if (! is_dir($path) && $imagesize = @filesize($path)) { // a thumbnail linked to original image
					$thumbnail = str_replace('<img ', '<img has_orig="true" ', $desc); // inform existance of original to images_to_link()
					$link_html = $thumbnail . '<img src="' . $href . '" alt="' . sprintf(__('Original(%dKB)', 'ktai_style'), intval($imagesize / 1024)) . '" filesize="' . $imagesize . '"/>'; // pass filesize to images_to_link()
				} else { // internal link to other than images
					$link_html = $desc . '(<a href="' . $href . '">' . __('Link Target', 'ktai_style') . '</a>)';
				}
			} else { // external link
				$link_html = $this->rewrite_link($href, __('Link Target', 'ktai_style'), $leave_pat);
				if (is_null($link_html)) {
					$link_html = '<a href="' . $href . '">' . __('Link Target', 'ktai_style') . '</a>';
				}
				$link_html = "{$desc}($link_html)";
			}
		} else {
			$link_html = $this->rewrite_link($href, $desc, $leave_pat);
		}
		$replace = apply_filters('convert_links/ktai_style.php', $link_html, $orig, $href, $desc);
		if (! is_null($replace)) {
			$content = substr_replace($content, $replace, $offset, strlen($orig)); // convert links
		} else {
			$offset += strlen($orig);
		}
	}
	return $content;
}

/* ==================================================
 * @param   string  $href
 * @param	string  $desc
 * @param   string  $leave_pat
 * @return	string  $link_html
 */
private function rewrite_link($href, $desc, $leave_pat) {
	global $Ktai_Style;
	$clipped = preg_replace($this->internal_pat, $this->short_links, $href, 1, $is_internal);
	if ($is_internal) {
		$link_html = '<a href="' . $clipped . '">' . $desc . '</a>';
	} elseif (preg_match($this->short_int_pat, $href) 
	     || (preg_match($leave_pat, $href) && ! ks_is_loggedin())) {
		$link_html = NULL; // leave links
	} else {
		$icon_desc = '<img localsrc="337" alt="' . __('[for PC]', 'ktai_style') . '" /><font color="' . ks_option('ks_external_link_color') . '">' . $desc . '</font></a>';
		if ($Ktai_Style->is_ktai() == 'DoCoMo' 
		|| $Ktai_Style->is_ktai() == 'KDDI' 
		|| $Ktai_Style->is_ktai() == 'SoftBank' 
		|| ks_is_loggedin()) {
			$link_html = '<a href="' . ks_plugin_url(FALSE) . 'redir.php?url=' . $href . '">' . $icon_desc;
		} else {
			$link_html = '<a href="' . $href . '">' . $icon_desc;
		}
		$link_html = apply_filters('external_link/ktai_style.php', $link_html, $href, $desc);
	}
	return $link_html;
}

/* ==================================================
 * @param	string  $content
 * @return	string  $content
 */
public function convert_images($content) {
	for ($offset = 0, $replace = 'X'; 
	     preg_match('!<img ([^>]*?)src=([\'"])([^\\\\]*?(\\\\.[^\\2\\\\]*?)*)\\2([^>]*?) ?/?>!', $content, $img, PREG_OFFSET_CAPTURE, $offset) ; 
	     $offset += strlen($replace))
	{
		$orig    = $img[0][0];
		$offset  = $img[0][1];
		$q       = $img[2][0];
		$src     = $img[3][0];
		$attr    = $img[1][0] . $img[5][0];
		$replace = $orig;
		if (preg_match('/local$/', $img[1][0])) { // ezweb pict chars
			continue;
		}
		$replace = apply_filters('image_to_link/ktai_style.php', $this->image_to_link($orig, $src, $q, $attr), $orig, $src);
		if (! is_null($replace)) {
			$content = substr_replace($content, $replace, $offset, strlen($orig));
		} else {
			$offset += strlen($orig);
		}
	}
	return $content;
}

/* ==================================================
 * @param	string  $html
 * @param	string  $src
 * @param	string  $q
 * @param	string  $attr
 * @return	string  $replace
 */
private function image_to_link($html, $src, $q, $attr) {
	global $Ktai_Style;
	$replace = $html;
	if (preg_match('/alt=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1/', $attr, $a)) {
		$alt = stripslashes($a[2]);
	} else {
		$alt = basename(parse_url($src, PHP_URL_PATH));
	}
	if (empty($alt)) {
		$replace = ''; // hide images if the alt string is empty. 
		return $replace;
	}
	if (preg_match('/(width|height)=(([\'"])1\\3|1\b)/', $attr)) {
		$replace = ''; // hide 1 pixel width/height images.
	} elseif (preg_match('/class=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1/', $attr, $class) && preg_match('/\\b(wp-smiley|ktai)\\b/', $class[2])) {
		$replace = '<img src=' . $q . $this->strip_host($src) . $q . ' alt="' . addslashes($alt) . '" class="' . $class[2] . '" />';
	} elseif (preg_match('!' . PLUGINDIR . '!', $src)) { // plug-in's icon or what
		$replace = "[$alt]";
	} elseif (preg_match('/filesize="(\d*)"/', $attr, $filesize)) { // original image for thumbnail passed by convert_links()
		$cache_size = $Ktai_Style->get('cache_size');
		if ($filesize[1] && $cache_size > 0 && $filesize[1] > $cache_size) {
			$replace = '<font color="' . KS_SIZE_EXCEED_COLOR . '">' . $alt . '</font>]';
		} else {
			$replace = '<a href=' . "$q$src$q" . '>' . $alt . '</a>]';
		}
	} else { // normal image or thumbnail image
		$file = NULL;
		$thumbpath = NULL;
		if (preg_match($this->wpurl_pat, $src)) {
			list ($file, $thumbpath, $thumburl) = $this->check_thumbnail($src, $this->wpurl_pat, ABSPATH, $this->wpurl);
		} elseif (preg_match($this->host_pat, $src) && $_SERVER['DOCUMENT_ROOT']) {
			list ($file, $thumbpath, $thumburl) = $this->check_thumbnail($src, $this->host_pat, $_SERVER['DOCUMENT_ROOT'] . '/', '/');
		}
		if (defined('KS_SHRINKAGE_DEBUG') && is_array($thumbpath)) {
			$replace = '[[' . $thumbpath[0] . ']]';
		} elseif ($Ktai_Style->ktai->get('image_inline') && $thumbpath) {
			$replace = '<img src="' . $thumburl . '" alt="' . $alt . '" />';
			$replace .= preg_match('/has_orig="true"/', $attr) ? '[' : '';
		} else {
			if (! $file || (! is_dir($file) && @filesize($file) <= $Ktai_Style->get('cache_size'))) { // link to the image
				$replace = '[<a href=' . "$q$src$q" . '><img localsrc="94" alt="' . __('IMAGE:', 'ktai_style') . '" />' . $alt . '</a>';
			} elseif ($thumbpath && $thumburl) { // link to the thumbnail
				$replace = '[<a href=' . "$q$thumburl$q" . '><img localsrc="94" alt="' . __('IMAGE:', 'ktai_style') . '" />' . $alt . '</a>';
			} else { // no link to images
				$replace = '[<img localsrc="94" alt="' . __('IMAGE:', 'ktai_style') . '" /><font color="' . KS_SIZE_EXCEED_COLOR . '">' . $alt . '</font>';
			}
			$replace .= preg_match('/has_orig="true"/', $attr) ? ' | ' : ']';
		}
	}
	return $replace;
}

/* ==================================================
 * @param	string  $src
 * @param	string  $url_pat
 * @param	string  $path_pre
 * @param	string  $short_url
 * @return	string  $file
 * @return	string  $thumbpath
 * @return	string  $thumburl
 */
private function check_thumbnail($src, $url_pat, $path_pre, $short_url) {
	$target = $file = preg_replace($url_pat, $path_pre, $src);
	$orig = preg_replace('!\.thumbnail(\.[^.]+)?$!', '$1', $file, 1, $count);
	if ($count && file_exists($orig)) {
		$target = $orig;
	}
	$thumbpath = preg_replace('!(\.thumbnail)?(\.[^.]+)?$!', KS_THUMBNAIL_FILENAME .'$2', $file, 1);
	if (! file_exists($thumbpath)) {
		$thumbpath = $this->create_thumbnail($target, $thumbpath);
	}
	if ($thumbpath) {
		$thumburl = preg_replace('!^' . preg_quote($path_pre, '!') . '!', $short_url, $thumbpath);
	}
	return array($file, $thumbpath, $thumburl);
}

/* ==================================================
 * @param	string  $file
 * @return	string  $thumbpath
 */
private function create_thumbnail($file, $thumbpath) {
	try {
		if (empty($file)) {
			throw new Exception('No file name');
		}
		$size = getimagesize($file);
		$width  = $size[0];
		$height = $size[1];
		$type   = $size[2];
		if ($width <= 0 || $height <= 0) {
			throw new Exception('Zero size image');
		}
		switch ($type) {
		case IMAGETYPE_GIF:
			$image = imagecreatefromgif($file);
			$file_other = preg_replace('|\.gif$|i', '.png', $file);
			if (! file_exists($file_other)) {
				$result = imagepng($image, $file_other);
			}
			break;
		case IMAGETYPE_PNG:
			$image = imagecreatefrompng($file);
			$file_other = preg_replace('|\.png$|i', '.gif', $file);
			if (! file_exists($file_other)) {
				$result = imagegif($image, $file_other);
			}
			break;
		case IMAGETYPE_JPEG:
		default:
			$image = imagecreatefromjpeg($file);
			break;
		}
		if ($width <= KS_THUMBNAIL_MAX_SIZE && $height <= KS_THUMBNAIL_MAX_SIZE) { // No need to make thumbnail
			return $file;
		}
		if ($width > $height) {
			$image_ratio = $width / KS_THUMBNAIL_MAX_SIZE;
			$new_width  = KS_THUMBNAIL_MAX_SIZE;
			$new_height = $height / $image_ratio;
		} else {
			$image_ratio = $height / KS_THUMBNAIL_MAX_SIZE;
			$new_height = KS_THUMBNAIL_MAX_SIZE;
			$new_width = $width / $image_ratio;
		}
		$thumbnail = imagecreatetruecolor($new_width, $new_height);
		if (function_exists('imageantialias')) {
			imageantialias($thumbnail, TRUE);
		}
		if (! imagecopyresampled($thumbnail, $image, 0, 0, 0, 0, $new_width, $new_height, $width, $height)) {
			throw new Exception('Resample failed');
		}
	
		// move the thumbnail to it's final destination
		switch ($type) {
		case IMAGETYPE_GIF:
			$result = imagegif($thumbnail, $thumbpath);
			$thumb_other = preg_replace('|\.gif$|i', '.png', $thumbpath);
			$result2 = imagepng($thumbnail, $thumb_other);
			break;
		case IMAGETYPE_PNG:
			$result = imagepng($thumbnail, $thumbpath);
			$thumb_other = preg_replace('|\.png$|i', '.gif', $thumbpath);
			$result2 = imagegif($thumbnail, $thumb_other);
			break;
		case IMAGETYPE_JPEG:
		default:
			$result = imagejpeg($thumbnail, $thumbpath);
			$thumb_other = NULL;
			break;
		}
		imagedestroy($thumbnail);
		if (! $result || ! file_exists($thumbpath)) {
			throw new Exception('Create thumbnail file failed');
		}
		chmod($thumbpath, 0646);
		if ($thumb_other) {
			chmod($thumb_other, 0646);
		}
		return $thumbpath;
	} catch (Exception $e) {
		return defined('KS_SHRINKAGE_DEBUG') ? array($e->getMessage()) : NULL;
	}
}

/* ==================================================
 * @param	string  $content
 * @return	string  $content
 */
public function shrink_content($content) {
	global $Ktai_Style;
	$content = $Ktai_Style->filter_tags($content);
	$content = preg_replace('!<del[^>]*>.*?</del>!s', '', $content);
	$content = $this->convert_links($content);
	$content = $this->convert_images($content);
	return $content;
}

/* ==================================================
 * @param	string  $content
 * @param	array   $tags
 * @param	array   $args
 * @return	string  $html
 */
public function shrink_tag_cloud($content, $tags, $args) {
	for ($offset = 0, $replace = 'X' ; 
	     preg_match('!<a href=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1([^>]*?)>(.*?)</a>!', $content, $l, PREG_OFFSET_CAPTURE, $offset); 
	     $offset += strlen($replace))
	{
		$orig    = $l[0][0];
		$offset  = $l[0][1];
		$q       = $l[1][0];
		$href    = $l[2][0];
		$attr    = $l[4][0];
		$desc    = $l[5][0];
		$replace = $orig;
		preg_match('/ style=([\'"])[^\\\\]*?(\\\\.[^\\1\\\\]*?)*\\1/', $attr, $style);
		$replace = '<a href=' . $q . $href . $q . $style[0] . '>' . $desc . '</a>';
		$content = substr_replace($content, $replace, $offset, strlen($orig));
	}
	return $content;
}

/* ==================================================
 * @param	string  $content
 * @return	string  $content
 */
public function add_image_inline($content) {
	global $Ktai_Style;
	if ($Ktai_Style->ktai->get('image_inline_default') == $Ktai_Style->ktai->get('image_inline')) {
		return $content;
	}
	$value = $Ktai_Style->ktai->get('image_inline') ? 'inline' : 'link';
	$wpcontent_pat = preg_replace('/\)!$/', ')wp-content/!', $this->wpurl_pat);
	for ($offset = 0, $replace = 'X' ; 
	     preg_match('!<a ([^>]*?)href=([\'"])([^\\\\]*?(\\\\.[^\\2\\\\]*?)*)\\2([^>]*?)>!', $content, $l, PREG_OFFSET_CAPTURE, $offset) ; 
	     $offset += strlen($replace))
	{
		$orig    = $l[0][0];
		$offset  = $l[0][1];
		$q       = $l[2][0];
		$href    = $l[3][0];
/*		if (strpos($href, 'paged=')) {
			echo "***$href***<br />";
		} */
		$href    = _quoted_remove_query_arg('img', $href);
		$attr1   = $l[1][0];
		$attr2   = $l[5][0];
		$replace = $orig;
		if (! preg_match($this->url_pat, $href) || preg_match($wpcontent_pat, $href) || preg_match('/id="inline"/', $attr1 . $attr2)) {
			continue;
		}
		$href .= (strpos($href, '?') === FALSE ? '?' : '&amp;' ) . "img=$value";
		$replace = "<a {$attr1}href=$q$href$q$attr2>"; 
		$content = substr_replace($content, $replace, $offset, strlen($orig)); // convert links		
	}
	return $content;
}

// ===== End of class ====================
}
?>