<?php
/* ͕h~̂߂̓{ꕶłB
   ̃\[Xt@C Shift_JIS ŕۑĂ܂B
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with Shift_JIS. */

/* ==================================================
 *   Ktai_Service_WILLCOM class
   ================================================== */

class Ktai_Service_WILLCOM extends Ktai_Services {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->operator   = 'WILLCOM';
	$this->type       = 'AIR-EDGE';
	$this->user_agent = $user_agent;
	preg_match('!\((DDIPOCKET|WILLCOM);[^/]+/([^/]+)/[^/]+/[\d.]+/[cC](\d+)\)!', $user_agent, $specs);
	$this->term_name  = $specs[2];
	$this->page_size  = 20000;
	$this->cache_size = $specs[3] ? $specs[3] * 1024 : 32768;
	$this->charset    = 'SJIS-win';
	$this->mime_type  = 'text/html';
	// use default preamble
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => "\xf9\x95",
		'icon_biggrin.gif'   => "\xf9\xcf",
		'icon_sad.gif'       => "\xf9\x98",
		'icon_surprised.gif' => "\xf9\xaa", // impact
		'icon_eek.gif'       => "\xf9\xfc", 
		'icon_confused.gif'  => "\xf9\xd0",
		'icon_cool.gif'      => "\xf9\xf7",
		'icon_mad.gif'       => "\xf9\x96",
		'icon_razz.gif'      => "\xf9\xcd",
		'icon_neutral.gif'   => "\xf9\xca",
		'icon_wink.gif'      => "\xf9\xce",
		'icon_lol.gif'       => "\xf9\xcd",
		'icon_redface.gif'   => "\xf9\xcb",
		'icon_cry.gif'       => "\xf9\xd2",
		'icon_evil.gif'      => "\xf9\xc9",
		'icon_twisted.gif'   => "\xf9\xc9",
		'icon_rolleyes.gif'  => "\xf9\xc5",
		'icon_exclaim.gif'   => "\xf9\xa7",
		'icon_question.gif'  => "\xf9\xa8",
		'icon_idea.gif'      => "\xf9\xa0",
		'icon_arrow.gif'     => "\xf9\x5b",
		'icon_mrgreen.gif'   => "\xf0\x86",
	);
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 * Reference: http://www.willcom-inc.com/ja/service/contents_service/club_air_edge/for_phone/homepage/
 *            http://www.au.kddi.com/ezfactory/tec/spec/3.html
 */
public function convert_char($buffer) {
	$chars = array (
		'1'   => "\xf0\xb6", // warning (!)
		'2'   => "\xf0\x9f", // exclamation (!)
		'3'   => "\xf0\xa1", // question (?)
		'4'   => 'Q',        // question (Q)
		'5'   => '',       // left triangle
		'6'   => '',       // right triangle
		'7'   => "\xf0\xb2", // double left triangle
		'8'   => "\xf0\xb3", // double right triangle
		'15'  => "\xf0\x68", // moon (3days)
		'16'  => "\xf0\x5d", // thunder
		'25'  => "\xf9\xc4", // watch
		'29'  => '',       // up arrow
		'30'  => '',       // down arrow
		'32'  => '',       // down triangle
		'33'  => '',       // up triangle
		'34'  => '',       // double down triangle
		'35'  => '',       // double up triangle
		'42'  => "\xf8\xf8", // up-left arrow
		'43'  => "\xf8\xf7", // down-right arrow
		'44'  => "\xf0\x48", // sun
		'45'  => "\xf0\x5b", // baseball
		'46'  => "\xf0\x41", // clock
		'48'  => "\xf9\xb8", // bell (chapel)
		'50'  => "\xf0\x4c", // face (female)
		'51'  => "\xf0\x40", // heart
		'52'  => "\xf0\x57", // bar (martini)
		'53'  => "\xf9\xe6", // four-leaf clover
		'54'  => "\xf9\xd7", // trade mark (TM)
		'55'  => '~',       // multiply (cross)
		'56'  => "\xf0\x60", // note
		'61'  => "\xf0\xba", // cross
		'63'  => '',       // right arrow
		'64'  => '',       // left arrow
		'65'  => "\xf0\x77", // magcup (tea room)
		'68'  => "\xf0\x4c", // smile
		'69'  => "\xf0\x96", // star
		'70'  => "\xf8\xd9", // up-right arrow
		'71'  => "\xf9\x49", // down-left arrow
		'72'  => "\xf9\xc0", // jewelry
		'74'  => "\xf0\x6d", // dog
		'75'  => "\xf0\x96", // star
		'76'  => "\xf9\x9f", // spark
		'77'  => "\xf0\x99", // lamp
		'80'  => "\xf0\x4c", // face (male)
		'81'  => "\xf0\xbb", // copyright mark
		'82'  => "\xf0\xbc", // registered mark
		'83'  => "\xf0\x7b", // briefcase
		'85'  => "\xf0\x42", // telephone (fixed)
		'86'  => "\xf8\xea", // pop up memo
		'88'  => '',       // up triangle
		'89'  => '',       // down triangle
		'94'  => "\xf8\xe2", // camera
		'95'  => "\xf0\x49", // rain
		'96'  => "\xf8\xb7", // american football??
		'97'  => "\xf0\x60", // book
		'98'  => "\xf9\xd4", // keep out sign
		'99'  => "\xf8\xce", // traffic signal
		'100' => "\xf0\x60", // book
		'101' => "\xf0\x60", // book
		'102' => "\xf0\x60", // book
		'103' => "\xf0\x60", // document
		'104' => "\xf0\x83", // scissors
		'105' => "\xf8\xea", // daily calender
		'106' => "\xf0\x97", // ticket
		'107' => "\xf0\x4a", // cloud
		'108' => "\xf0\x63", // mail envelope
		'109' => "\xf0\x91", // money
		'110' => "\xf0\x9d", // movie/video camera
		'111' => "\xf0\x9d", // handheld video camera
		'112' => "\xf0\x53", // home
		'113' => "\xf9\xe8", // flower (tulip)
		'116' => "\xf8\xf2", // glasses / eye
		'118' => "\xf9\x7e", // next item /return mark
		'119' => "\xf9\x81", // magnifier (search)
		'120' => "\xf9\x7d", // key
		'124' => "\xf8\xd5", // shoe (high-heel)
		'125' => "\xf0\x4f", // sedan (car)
		'140' => '',       // leftside finger
		'141' => '',       // rightside finger
		'143' => "\xf0\x8c", // clip
		'144' => "\xf0\x90", // present box
		'146' => "\xf0\x56", // knife and fork
		'149' => "\xf0\x61", // pencil
		'151' => "\xf0\x63", // envelope
		'152' => "\xf9\xbd", // spanner
		'155' => "\xf0\x42", // telephone (handset)
		'156' => "\xf0\x54", // factory
		'161' => "\xf0\x95", // mobile phone
		'168' => "\xf0\x51", // air plane
		'169' => "\xf0\x52", // boat (ship)
		'172' => "\xf0\x50", // electric train
		'176' => "\xf0\x78", // smoking
		'177' => "\xf0\x64", // no smoking
		'178' => "\xf8\xfc", // wheel chair
		'179' => "\xf0\xb1", // beginner driver mark
		'180' => "\xf0\xbf", // one
		'181' => "\xf0\xc0", // two
		'182' => "\xf0\xc1", // three
		'183' => "\xf0\xc2", // four
		'184' => "\xf0\xc3", // five
		'185' => "\xf0\xc4", // six
		'186' => "\xf0\xc5", // seven
		'187' => "\xf0\xc6", // eight
		'188' => "\xf0\xc7", // nine
		'190' => "\xf0\xa8", // storm
		'191' => "\xf0\x8d", // snowball
		'192' => "\xf0\xc8", // Aries (Ram)
		'193' => "\xf0\xc9", // Taurus (Bull)
		'194' => "\xf0\xca", // Gemini (Twins)
		'195' => "\xf0\xcb", // Cancer (Crab)
		'196' => "\xf0\xcc", // Leo (Lion)
		'197' => "\xf0\xcd", // Virgo (Virgin)
		'198' => "\xf0\xce", // Libra (Scales)
		'199' => "\xf0\xcf", // Scorpius (Scorpion)
		'200' => "\xf0\xd0", // Sagittarius (Archer)
		'201' => "\xf0\xd1", // Capricornus (Goat)
		'202' => "\xf0\xd2", // Aquarius (Water Bearer)
		'203' => "\xf0\xd3", // Pisces (Fishes)
		'204' => "\xf0\xd4", // Ophiuchus (Serpent Bearer)
		'205' => "\xf8\xc9", // Automatic Teller Machine
		'206' => "\xf8\xcb", // convenience store
		'207' => "\xf8\xcf", // toilet
		'208' => "\xf8\xcd", // parking
		'209' => "\xf8\xc1", // bus stop
		'210' => "\xf9\x83", // location simble (parabola antenna)
		'211' => "\xf0\x85", // anchor (port)
		'212' => "\xf8\xc8", // bank
		'213' => "\xf8\xcc", // gas station
		'215' => "\xf9\xc2", // bicycle
		'216' => "\xf0\xaf", // bus
		'217' => "\xf8\xbe", // shinkansen (bullet train)
		'218' => "\xf9\xd8", // marathon
		'219' => "\xf0\xb0", // football (soccer)
		'220' => "\xf0\x9c", // tennis
		'221' => "\xf9\xb7", // snow board
		'222' => "\xf8\xba", // checker flag
		'223' => "\xf8\xda", // amusement park
		'224' => "\xf0\x67", // spa
		'226' => "\xf9\x50", // movie (clapper board)
		'227' => "\xf9\x57", // night scene
		'233' => "\xf0\x91", // doller bag
		'234' => "\xf9\x48", // christmas tree
		'235' => "\xf9\xed", // cherry blossom
		'239' => "\xf9\xef", // short cake
		'244' => "\xf0\x7a", // onigiri (rise ball)
		'245' => "\xf8\xd3", // hamberger (fast food)
		'251' => "\xf0\x6e", // cat
		'257' => "\xf0\x4c", // laugh face
		'258' => "\xf0\x5e", // angry face
		'259' => "\xf0\x58", // sad face
		'260' => "\xf0\x76", // tired face
		'261' => "\xf9\xa6", // Sleepy (Zzz)
		'262' => "\xf0\x74", // angry
		'263' => "\xf0\x4b", // tear
		'264' => "\xf9\xcd", // bleah
		'265' => "\xf0\x88", // heart break
		'266' => "\xf0\x98", // double hearts
		'268' => "\xf9\xa3", // bomb
		'273' => "\xf0\x4d", // kiss mark
		'278' => "\xf8\xa4", // flower circle
		'279' => "\xf9\xd9", // secret
		'281' => "\xf9\xa2", // punch
		'282' => "\xf9\xad", // dashing
		'287' => "\xf9\xcc", // ok hand sign
		'288' => "\xf8\xeb", // TV set
		'289' => "\xf0\x73", // microphone (kara-oke)
		'290' => "\xf9\xb4", // wallet
		'291' => '', // musical note
		'294' => "\xf8\xdb", // music (headphone)
		'295' => "\xf9\xb5", // rouge
		'299' => "\xf9\x7b", // free
		'300' => "\xf8\xed", // CD/DVD
		'303' => "\xf9\x9f", // updated
		'305' => "\xf8\xa5", // fog
		'306' => "\xf8\xb5", // golf
		'307' => "\xf8\xb9", // basket ball
		'309' => "\xf8\xdc", // art
		'310' => "\xf8\xdd", // performance
		'311' => "\xf8\xde", // event (circus)
		'312' => "\xf8\xe5", // ribbon
		'313' => "\xf0\x8e", // birthday
		'314' => "\xf0\x8b", // spade mark (cards)
		'315' => "\xf0\x89", // diamond mark (cards)
		'316' => "\xf0\x8a", // pam mark (cards)
		'317' => "\xf8\xf2", // eyes
		'318' => "\xf8\xf3", // ear
		'319' => "\xf0\x55", // scissors (hands)
		'320' => "\xf0\x87", // paper (hands)
		'321' => "\xf9\x40", // new moon
		'322' => "\xf9\x41", // eclipsed moon
		'323' => "\xf9\x42", // half moon
		'324' => "\xf9\x80", // clear button
		'325' => "\xf0\xbe", // zero
		'326' => "\xf9\xb0", // ok
		'327' => "\xf0\x76", // very tired face
		'333' => "\xf0\x72", // ramen (donburi)
		'334' => "\xf9\x82", // new
		'337' => "\xf9\xbb", // personal computer
		'339' => "\xf9\xed", // rose
		'340' => "\xf9\xb8", // church
		'341' => "\xf8\xbd", // subway
		'342' => "\xf0\xac", // Mt.Fuji
		'343' => "\xf0\x4e", // music
		'354' => "\xf9\xbf", // crown
		'358' => "\xf9\xec", // read leaves
		'375' => "\xf8\xc6", // post office
		'376' => "\xf8\xc7", // hospital
		'377' => "\xf9\xe3", // school
		'378' => "\xf8\xca", // hotel
		'379' => "\xf0\x52", // ship
		'380' => "\xf0\xb5", // NG / prohibited for U-18
		'381' => "\xf0\xb8", // anntena mark
		'382' => '[cool]',   // cool
		'383' => '[]',     // discount mark
		'384' => '[T]',     // service mark
		'385' => "\xf9\x7c", // ID mark
		'386' => "\xf9\xe0", // full mark
		'387' => "\xf9\xde", // vacant mark
		'388' => '[w]',     // reserved mark
		'389' => '[c]',     // in-business mark
		'390' => '',       // upside finger
		'391' => '',       // downside finger
		'393' => "\xf8\xe9", // manner mode
		'394' => "\xf8\xe9", // power off
		'395' => "\xf8\xea", // make a memo
		'400' => "\xf9\xf0", // tokkkuri,ochoko
		'401' => "\xf0\x5f", // beer (cheers)
		'410' => "\xf0\x83", // hair salon
		'414' => "\xf0\x40", // heart mark (cards)
		'421' => "\xf0\x9e", // ski
		'422' => '',       // oval
		'423' => "\xf9\xc3", // green tea
		'424' => "\xf9\xf2", // bread
		'434' => "\xf0\x8f", // apple
		'508' => "\xf9\x52", // edit (pen)
		'715' => "\xf9\xf6", // fish
		'728' => "\xf0\x9a", // foot print
		'729' => "\xf8\xfa", // shoe
		'803' => "\xf9\x92", // swing heart
		'804' => "\xf9\xf4", // chick
		'805' => "\xf9\xb6", // jeans
		'806' => "\xf9\xbc", // love letter
		'810' => "\xf9\xe4", // tidal wave
		'811' => "\xf9\xeb", // twin leave
		'812' => "\xf9\xf3", // snail
		'817' => "\xf0\x5c", // rock (hands)
		'818' => "\xf9\x86", // number sign (#)
		'\\d+' => '',      // (catch all)
	);
	$pat = preg_replace('/^(.*)$/', '!<img localsrc="$1"( alt="[^"\\\\\\\\]*?(\\\\\\\\.[^"\\\\\\\\]*)*")? ?/?>!', array_keys($chars));
	$buffer = preg_replace($pat, $chars, $buffer);
	return $buffer;
}

// ===== End of class ====================
}
?>
