<?php
/* ͕h~̂߂̓{ꕶłB
   ̃\[Xt@C Shift_JIS ŕۑĂ܂B
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with Shift_JIS. */

/* ==================================================
 *   Ktai_Service_EZweb class
   ================================================== */

class Ktai_Service_EZweb extends Ktai_Services {
	// http://www.au.kddi.com/ezfactory/tec/spec/4_4.html
	static public $devID_to_name = array(
		"KC3B" => "W53K", 
		"ST33" => "INFOBAR 2", 
		"KC3E" => "W44K II (Camera Less)", 
		"SN3B" => "W53S", 
		"CA39" => "W53CA", 
		"ST32" => "W53SA", 
		"TS3E" => "W54T", 
		"SH33" => "W52SH", 
		"CA38" => "W52CA", 
		"MA32" => "W52P", 
		"SN3A" => "W52S", 
		"TS3D" => "W53T", 
		"SA3A" => "W52SA", 
		"HI3A" => "W52H", 
		"KC3A" => "MEDIA SKIN", 
		"SH32" => "W51SH", 
		"SN39" => "W51S", 
		"TS3C" => "W52T", 
		"TS3B" => "W51T", 
		"SA39" => "W51SA", 
		"HI39" => "W51H", 
		"CA37" => "W51CA", 
		"MA31" => "W51P", 
		"KC39" => "W51K", 
		"TS39" => "DRAPE", 
		"TS3A" => "W47T", 
		"SN38" => "W44S", 
		"KC38" => "W44K/K II", 
		"SA38" => "W43SA", 
		"TS38" => "W45T", 
		"CA35" => "W43CA", 
		"HI38" => "W43H/H II", 
		"SN37" => "W43S", 
		"KC37" => "W43K", 
		"ST31" => "W42SA", 
		"SH31" => "W41SH", 
		"CA34" => "W42CA", 
		"HI37" => "W42H", 
		"TS37" => "W44T/T II/T III", 
		"TS35" => "neon", 
		"TS36" => "W43T", 
		"SN36" => "W42S", 
		"KC36" => "W42K", 
		"KC35" => "W41K", 
		"SA36" => "W41SA", 
		"TS34" => "W41T", 
		"HI36" => "W41H", 
		"CA33" => "W41CA", 
		"SN34" => "W41S", 
		"HI34" => "PENCK", 
		"SA35" => "W33SA/SA II", 
		"TS33" => "W32T", 
		"SA34" => "W32SA", 
		"KC34" => "W32K", 
		"HI35" => "W32H", 
		"SN33" => "W32S", 
		"SN35" => "W32S", 
		"CA32" => "W31CA", 
		"TS32" => "W31T", 
		"SN32" => "W31S", 
		"KC33" => "W31K/K II", 
		"SA33" => "W31SA/SA II", 
		"SA32" => "W22SA", 
		"HI33" => "W22H", 
		"CA31" => "W21CA/CA II", 
		"TS31" => "W21T", 
		"SA31" => "W21SA", 
		"SN31" => "W21S", 
		"KC32" => "W21K", 
		"HI32" => "W21H", 
		"KC31" => "W11K", 
		"HI31" => "W11H", 
		"CA36" => "E03CA", 
		"SA37" => "E02SA", 
		"ST2C" => "Sweets cute", 
		"ST29" => "Sweets pure", 
		"CA28" => "G'zOne TYPE-R", 
		"ST26" => "Sweets", 
		"ST25" => "talby", 
		"ST22" => "INFOBAR", 
		"KC2A" => "A5528K", 
		"SA2A" => "A5527SA", 
		"KC29" => "A5526K", 
		"ST2D" => "A5525SA", 
		"TS2D" => "A5523T", 
		"SA29" => "A5522SA", 
		"KC28" => "A5521K", 
		"ST2A" => "A5520SA/SA II", 
		"ST28" => "A5518SA", 
		"TS2C" => "A5517T", 
		"TS2B" => "A5516T", 
		"KC27" => "A5515K", 
		"ST27" => "A5514SA", 
		"CA27" => "A5512CA", 
		"TS2A" => "A5511T", 
		"TS29" => "A5509T", 
		"ST24" => "A5507SA", 
		"TS28" => "A5506T", 
		"SA27" => "A5505SA", 
		"TS27" => "A5504T", 
		"SA26" => "A5503SA", 
		"KC24" => "A5502K", 
		"KC25" => "A5502K", 
		"TS26" => "A5501T", 
		"CA26" => "A5407CA", 
		"CA25" => "A5406CA", 
		"ST23" => "A5405SA", 
		"SN25" => "A5404S", 
		"CA24" => "A5403CA", 
		"SN24" => "A5402S", 
		"CA23" => "A5401CA II", 
		"CA23" => "A5401CA", 
		"ST21" => "A5306ST", 
		"KC22" => "A5305K", 
		"TS24" => "A5304T", 
		"HI24" => "A5303H II", 
		"HI23" => "A5303H", 
		"CA22" => "A5302CA", 
		"TS23" => "A5301T", 
		"SA22" => "A3015SA", 
		"PT22" => "A3015SA", 
		"PT21" => "A1405PT", 
		"SN29" => "A1405PT", 
		"KC26" => "A1403K", 
		"SN27" => "A1403K", 
		"SN28" => "A1402S II (Camera Less)", 
		"SN26" => "A1402S", 
		"KC23" => "A1401K", 
		"SA28" => "A1305SA", 
		"TS25" => "A1304T II", 
		"TS25" => "A1304T II", 
		"TS25" => "A1304T (Camera Less)", 
		"SA25" => "A1303SA", 
		"SA24" => "A1302SA", 
		"SN23" => "A1301S", 
		"ST14" => "A1014ST", 
		"SN21" => "A3014S", 
		"TS22" => "A3013T", 
		"CA21" => "A3012CA", 
		"SA21" => "A3011SA", 
		"SN22" => "A1101S", 
		"KC14" => "A1012K II", 
		"KC14" => "A1012K", 
		"ST13" => "A1011ST", 
		"MA21" => "C3003P", 
		"KC21" => "C3002K", 
		"HI21" => "C3001H", 
		"SN17" => "C1002S", 
		"SY15" => "C1001SA", 
		"CA14" => "C452CA", 
		"HI14" => "C451H", 
		"TS14" => "C415T", 
		"KC13" => "C414K II", 
		"KC13" => "C414K", 
		"SN15" => "C413S", 
		"SN16" => "C413S", 
		"SY14" => "C412SA", 
		"ST12" => "C411ST", 
		"TS13" => "C410T", 
		"CA13" => "C409CA", 
		"MA13" => "C408P", 
		"HI13" => "C407H", 
		"SN13" => "C406S", 
		"SY13" => "C405SA", 
		"SN12" => "C404S", 
		"SN14" => "C404S", 
		"ST11" => "C403ST", 
		"DN11" => "C402DE", 
		"SY12" => "C401SA", 
		"KCTE" => "TK51", 
		"TST9" => "TT51", 
		"KCU1" => "TK41", 
		"SYT5" => "TS41", 
		"KCTD" => "TK40", 
		"TST8" => "TT32", 
		"TST7" => "TT31", 
		"KCTC" => "TK31", 
		"SYT4" => "TS31", 
		"KCTB" => "TK23", 
		"KCTA" => "TK22", 
		"TST6" => "TT22", 
		"KCT9" => "TK21", 
		"TST5" => "TT21", 
		"TST4" => "TT11", 
		"KCT8" => "TK12", 
		"SYT3" => "TS11", 
		"KCT7" => "TK11", 
		"MIT1" => "TD11", 
		"MAT3" => "TP11", 
		"KCT6" => "TK05", 
		"TST3" => "TT03", 
		"KCT5" => "TK04", 
		"KCT4" => "TK03", 
		"SYT2" => "TS02", 
		"MAT1" => "TP01", 
		"MAT2" => "TP01", 
		"TST2" => "TT02", 
		"KCT3" => "TK0K", 
		"KCT2" => "TK02", 
		"KCT1" => "TK01", 
		"TST1" => "TT01", 
		"SYT1" => "TS01", 
		);

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->user_agent = $user_agent;
	$this->operator   = 'KDDI';
	$this->type       = 'EZweb';
	preg_match('!^(KDDI-([A-Za-z0-9]+)|UP\.Browser/\d\.\d+-([A-Za-z0-9]+)) !', $user_agent, $specs);
	$dev_ID = $specs[2] ? $specs[2] : $specs[3];
	if (in_array($dev_ID, array_keys(self::$devID_to_name))) {
		$this->term_name = self::$devID_to_name[$dev_ID];
	} else {
		$this->term_name = "(Unknown au device:$dev_ID)";
	}
	$this->sub_ID     = @$_SERVER['HTTP_X_UP_SUBNO'];
	$this->page_size  = $specs[2] ? 9000 : 7500;
	$this->cache_size = $specs[2] ? 102400 : 49152;
	$this->charset    = 'SJIS-win';
	$this->mime_type  = 'text/html';
	$this->preamble   = '<?xml version="1.0" encoding="__CHARSET__"?>
<!DOCTYPE html PUBLIC "-//OPENWAVE//DTD XHTML 1.0//EN" "http://www.openwave.com/DTD/xhtml-basic.dtd">';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => "\xf6\x49", // 257
		'icon_biggrin.gif'   => "\xf3\xa1", // 454
		'icon_sad.gif'       => "\xf3\x94", // 441
		'icon_surprised.gif' => "\xf7\xf5", // 350
		'icon_eek.gif'       => "\xf3\x9e", // 451
		'icon_confused.gif'  => "\xf3\x97", // 444
		'icon_cool.gif'      => "\xf3\x58", // 382
		'icon_mad.gif'       => "\xf6\x4a", // 258
		'icon_razz.gif'      => "\xf6\xc0", // 264
		'icon_neutral.gif'   => "\xf3\x93", // 440
		'icon_wink.gif'      => "\xf7\xf3", // 348
		'icon_lol.gif'       => "\xf4\x6b", // 789
		'icon_redface.gif'   => "\xf7\xf4", // 349 (446 is better?)
		'icon_cry.gif'       => "\xf6\x4b", // 259
		'icon_evil.gif'      => "\xf6\xc8", // 277 
		'icon_twisted.gif'   => "\xf6\xc8", // 277
		'icon_rolleyes.gif'  => "\xf3\x95", // 442
		'icon_exclaim.gif'   => "\xf6\x5a", // 2
		'icon_question.gif'  => "\xf6\x5b", // 3
		'icon_idea.gif'      => "\xf6\x4e", // 77
		'icon_arrow.gif'     => "\xf7\x6e", // 63
		'icon_mrgreen.gif'   => "\xf4\x85", // 814
	);
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function convert_char($buffer) {
	$chars = array (
		'1'   => "\xf6\x59", // warning (!)
		'2'   => "\xf6\x5a", // exclamation (!)
		'3'   => "\xf6\x5b", // question (?)
		'4'   => "\xf7\x48", // question (Q)
		'5'   => "\xf7\x49", // left triangle
		'6'   => "\xf7\x4a",  // right triangle
		'7'   => "\xf7\x4b",  // double left triangle
		'8'   => "\xf7\x4c",  // double right triangle
		'15'  => "\xf6\x5e", // moon (3days)
		'16'  => "\xf6\x5f", // thunder
		'25'  => "\xf7\x97", // watch
		'29'  => "\xf7\x5b", // up arrow
		'30'  => "\xf7\x5c", // down arrow
		'32'  => "\xf7\x5e", // down triangle
		'33'  => "\xf7\x5f", // up triangle
		'34'  => "\xf7\x60", // double down triangle
		'35'  => "\xf7\x61", // double up triangle
		'42'  => "\xf7\x68", // up-left arrow
		'43'  => "\xf7\x69", // down-right arrow
		'44'  => "\xf6\x60", // sun
		'45'  => "\xf6\x93", // baseball
		'46'  => "\xf7\xb1", // clock
		'48'  => "\xf6\xeb", // bell (chapel)
		'50'  => "\xf6\xd3", // face (female)
		'51'  => "\xf7\xb2", // heart
		'52'  => "\xf6\x9b", // bar (martini)
		'53'  => "\xf6\xec", // four-leaf clover
		'54'  => "\xf7\x6a", // trade mark (TM)
		'55'  => "\xf7\x6b", // multiply (cross)
		'56'  => "\xf7\x7d", // note
		'61'  => "\xf7\x6c", // cross
		'63'  => "\xf7\x6e", // right arrow
		'64'  => "\xf7\x6f", // left arrow
		'65'  => "\xf6\x9c", // magcup (tea room)
		'68'  => "\xf6\xd4", // smile
		'69'  => "\xf6\x63", // star
		'70'  => "\xf7\x71", // up-right arrow
		'71'  => "\xf7\x72", // down-left arrow
		'72'  => "\xf6\xed", // jewelry
		'74'  => "\xf6\xb8", // dog
		'75'  => "\xf6\x40", // star
		'76'  => "\xf6\x44", // spark
		'77'  => "\xf6\x4e", // lamp
		'80'  => "\xf6\xd5", // face (male)
		'81'  => "\xf7\x74", // copyright mark (C)
		'82'  => "\xf7\x75", // registered mark
		'83'  => "\xf6\x74", // briefcase
		'85'  => "\xf7\xb3", // telephone (fixed)
		'86'  => "\xf6\xd6", // pop up memo
		'88'  => "\xf7\x76", // up triangle
		'89'  => "\xf7\x77", // down triangle
		'94'  => "\xf6\xee", // camera
		'95'  => "\xf6\x64", // rain
		'96'  => "\xf6\x94", // american football??
		'97'  => "\xf7\x82", // book
		'98'  => "\xf6\x5c", // keep out sign
		'99'  => "\xf6\x42", // traffic signal
		'100' => "\xf7\x83", // book
		'101' => "\xf7\x84", // book
		'102' => "\xf7\x85", // book
		'103' => "\xf7\x86", // document
		'104' => "\xf6\xef", // scissors
		'105' => "\xf7\x87", // daily calender
		'106' => "\xf6\x76", // ticket
		'107' => "\xf6\x65", // cloud
		'108' => "\xf6\xfa", // mail envelope
		'109' => "\xf7\x9a", // money
		'110' => "\xf6\xf0", // movie/video camera
		'111' => "\xf7\x9b", // handheld video camera
		'112' => "\xf6\x84", // home
		'113' => "\xf6\xbd", // flower (tulip)
		'116' => "\xf6\xd7", // glasses / eye
		'118' => "\xf7\x78", // next item /return mark
		'119' => "\xf7\x79", // magnifier (search)
		'120' => "\xf6\xf2", // key
		'124' => "\xf6\xf3", // shoe (high-heel)
		'125' => "\xf6\x8a", // sedan (car)
		'140' => "\xf6\xd8", // leftside finger
		'141' => "\xf6\xd9", // rightside finger
		'143' => "\xf6\x78", // clip
		'144' => "\xf6\xa8", // present box
		'146' => "\xf6\x85", // knife and fork
		'149' => "\xf6\x79", // pen
		'151' => "\xf7\xae", // envelope
		'152' => "\xf7\xa4", // spanner
		'155' => "\xf6\xf7", // telephone (handset)
		'156' => "\xf6\x86", // factory
		'161' => "\xf7\xa5", // mobile phone
		'168' => "\xf6\x8c", // air plane
		'169' => "\xf6\x8d", // boat (ship)
		'172' => "\xf6\x8e", // electric train
		'176' => "\xf6\x55", // smoking
		'177' => "\xf6\x56", // no smoking
		'178' => "\xf6\x57", // wheel chair
		'179' => "\xf6\x58", // beginner driver mark
		'180' => "\xf6\xfb", // one
		'181' => "\xf6\xfc", // two
		'182' => "\xf7\x40", // three
		'183' => "\xf7\x41", // four
		'184' => "\xf7\x42", // five
		'185' => "\xf7\x43", // six
		'186' => "\xf7\x44", // seven
		'187' => "\xf7\x45", // eight
		'188' => "\xf7\x46", // nine
		'190' => "\xf6\x41", // storm
		'191' => "\xf6\x5d", // snowball
		'192' => "\xf6\x67", // Aries (Ram)
		'193' => "\xf6\x68", // Taurus (Bull)
		'194' => "\xf6\x69", // Gemini (Twins)
		'195' => "\xf6\x6a", // Cancer (Crab)
		'196' => "\xf6\x6b", // Leo (Lion)
		'197' => "\xf6\x6c", // Virgo (Virgin)
		'198' => "\xf6\x6d", // Libra (Scales)
		'199' => "\xf6\x6e", // Scorpius (Scorpion)
		'200' => "\xf6\x6f", // Sagittarius (Archer)
		'201' => "\xf6\x70", // Capricornus (Goat)
		'202' => "\xf6\x71", // Aquarius (Water Bearer)
		'203' => "\xf6\x72", // Pisces (Fishes)
		'204' => "\xf6\x73", // Ophiuchus (Serpent Bearer)
		'205' => "\xf6\x7b", // Automatic Teller Machine
		'206' => "\xf6\x7c", // convenience store
		'207' => "\xf6\x7d", // toilet
		'208' => "\xf6\x7e", // parking
		'209' => "\xf6\x80", // bus stop
		'210' => "\xf6\x81", // location simble (parabola antenna)
		'211' => "\xf6\x82", // anchor (port)
		'212' => "\xf6\x83", // bank
		'213' => "\xf7\x8e", // gas station
		'215' => "\xf6\x87", // bicycle
		'216' => "\xf6\x88", // bus
		'217' => "\xf6\x89", // shinkansen (bullet train)
		'218' => "\xf6\x43", // marathon
		'219' => "\xf6\x8f", // football (soccer)
		'220' => "\xf6\x90", // tennis
		'221' => "\xf6\x91", // snow board
		'222' => "\xf6\x92", // checker flag
		'223' => "\xf6\x45", // amusement park
		'224' => "\xf6\x95", // spa
		'226' => "\xf6\x97", // movie (clapper board)
		'227' => "\xf6\x98", // night scene
		'233' => "\xf6\xa0", // doller bag
		'234' => "\xf6\xa2", // christmas tree
		'235' => "\xf6\xa3", // cherry blossom
		'239' => "\xf6\xa9", // short cake
		'244' => "\xf6\xae", // onigiri (rise ball)
		'245' => "\xf6\xaf", // hamberger (fast food)
		'251' => "\xf6\xb4", // cat
		'257' => "\xf6\x49", // laugh face
		'258' => "\xf6\x4a", // angry face
		'259' => "\xf6\x4b", // sad face
		'260' => "\xf6\x4c", // tired face
		'261' => "\xf6\x4d", // Sleepy (Zzz)
		'262' => "\xf6\xbe", // angry
		'263' => "\xf6\xbf", // tear
		'264' => "\xf6\xc0", // bleah
		'265' => "\xf6\x4f", // heart break
		'266' => "\xf6\x50", // double hearts
		'268' => "\xf6\x52", // bomb
		'273' => "\xf6\xc4", // kiss mark
		'278' => "\xf6\xc9", // flower circle
		'279' => "\xf6\xca", // secret
		'281' => "\xf6\xcc", // punch
		'282' => "\xf6\xcd", // dashing
		'287' => "\xf6\xd2", // ok hand sign
		'288' => "\xf6\xd8", // TV set
		'289' => "\xf6\xdc", // microphone (kara-oke)
		'290' => "\xf6\xdd", // wallet
		'291' => "\xf6\xde", // musical note
		'294' => "\xf6\xe1", // music (headphone)
		'295' => "\xf6\xe2", // rouge
		'299' => "\xf7\x95", // free
		'300' => "\xf6\xe5", // CD/DVD
		'303' => "\xf6\xe8", // updated
		'305' => "\xf7\xb5", // fog
		'306' => "\xf7\xb6", // golf
		'307' => "\xf7\xb7", // basket ball
		'309' => "\xf7\xb9", // art
		'310' => "\xf7\xba", // performance
		'311' => "\xf7\xbb", // event (circus)
		'312' => "\xf7\xbc", // ribbon
		'313' => "\xf7\xbd", // birthday
		'314' => "\xf7\xbe", // spade mark (cards)
		'315' => "\xf7\xbf", // diamond mark (cards)
		'316' => "\xf7\xcd", // pam mark (cards)
		'317' => "\xf7\xc1", // eyes
		'318' => "\xf7\xc2", // ear
		'319' => "\xf7\xc3", // scissors (hands)
		'320' => "\xf7\xc4", // paper (hands)
		'321' => "\xf7\xc5", // new moon
		'322' => "\xf7\xc6", // eclipsed moon
		'323' => "\xf7\xc7", // half moon
		'324' => "\xf7\xc8", // clear button
		'325' => "\xf7\xc9", // zero
		'326' => "\xf7\xca", // ok
		'327' => "\xf7\xcb", // very tired face
		'333' => "\xf7\xd1", // ramen (donburi)
		'334' => "\xf7\xe5", // new
		'337' => "\xf7\xe8", // personal computer
		'339' => "\xf7\xea", // rose
		'340' => "\xf7\xeb", // church
		'341' => "\xf7\xec", // subway
		'342' => "\xf7\xed", // Mt.Fuji
		'343' => "\xf7\xee", // music
		'354' => "\xf7\xf9", // crown
		'358' => "\xf3\x40", // read leaves
		'375' => "\xf3\x51", // post office
		'376' => "\xf3\x52", // hospital
		'377' => "\xf3\x53", // school
		'378' => "\xf3\x54", // hotel
		'379' => "\xf3\x55", // ship
		'380' => "\xf3\x56", // NG / prohibited for U-18
		'381' => "\xf3\x57", // anntena mark
		'382' => "\xf3\x58", // cool
		'383' => "\xf3\x59", // discount mark
		'384' => "\xf3\x5a", // service mark
		'385' => "\xf3\x5b", // ID mark
		'386' => "\xf3\x5c", // full mark
		'387' => "\xf3\x5d", // vacant mark
		'388' => "\xf3\x5e", // reserved mark
		'389' => "\xf3\x5f", // in-business mark
		'390' => "\xf3\x60", // upside finger
		'391' => "\xf3\x61", // downside finger
		'393' => "\xf3\x63", // manner mode
		'394' => "\xf3\x64", // power off
		'395' => "\xf3\x65", // make a memo
		'400' => "\xf3\x6a", // tokkkuri,ochoko
		'401' => "\xf3\x6b", // beer (cheers)
		'410' => "\xf3\x74", // hair salon
		'414' => "\xf3\x78", // heart mark (cards)
		'421' => "\xf3\x80", // ski
		'422' => "\xf3\x81", // oval
		'423' => "\xf3\x82", // green tea
		'424' => "\xf3\x83", // bread
		'434' => "\xf3\x8d", // apple
		'508' => "\xf7\xda", // edit (pen)
		'715' => "\xf3\xde", // fish
		'728' => "\xf3\xeb", // foot print
		'729' => "\xf3\xec", // shoe
		'803' => "\xf4\x79", // swing heart
		'804' => "\xf4\x7a", // chick
		'805' => "\xf4\x7b", // jeans
		'806' => "\xf4\x7c", // love letter
		'810' => "\xf4\x81", // tidal wave
		'811' => "\xf4\x82", // twin leave
		'812' => "\xf4\x83", // snail
		'817' => "\xf4\x88", // rock (hands)
		'818' => "\xf4\x89", // number sign (#)
	);
	$pat = preg_replace('/^(.*)$/', '!<img localsrc="$1"( alt="[^"\\\\\\\\]*?(\\\\\\\\.[^"\\\\\\\\]*)*")? ?/?>!', array_keys($chars));
	$buffer = preg_replace($pat, $chars, $buffer);
	$buffer = preg_replace('!(<img localsrc="[^"\\\\]*?(\\\\.[^"\\\\]*)*")( alt="[^"\\\\]*?(\\\\.[^"\\\\]*)*")? ?/?>!', '$1>', $buffer); // catch all
	return $buffer;
}

// ===== End of class ====================
}
?>