<?php 
/* 
Plugin Name: Force Wave Dash
Plugin URI: http://wppluginsj.sourceforge.jp/force-wave-dash/
Description: In a UTF-8 based weblog, convert full-width-tild characters to wave dash ones at creating/editing posts and at outputting contents.
Author: IKEDA yuriko
Version: 0.80
Author URI: http://www.yuriko.net/cat/wordpress
*/

if (get_bloginfo('charset') == 'UTF-8' && function_exists('mb_ereg_replace')) {
	if (isset($_GET['s'])) {
		$_GET['s'] = Force_Wavedash::tild2wave($_GET['s']);
	}
	add_filter('the_title', array('Force_Wavedash', 'tild2wave'), 21);
	add_filter('the_title_rss', array('Force_Wavedash', 'tild2wave'), 21);
	add_filter('the_content',array('Force_Wavedash', 'tild2wave'), 21);
	add_filter('get_the_excerpt', array('Force_Wavedash', 'tild2wave'), 21);
	add_filter('get_comment_author', array('Force_Wavedash', 'tild2wave'), 21);
	add_filter('get_comment_text', array('Force_Wavedash', 'tild2wave'), 21);
	add_filter('get_comment_excerpt', array('Force_Wavedash', 'tild2wave'), 21);
	add_action('save_post', array('Force_Wavedash', 'convert_posts'), 21);
	add_filter('pre_comment_author_name', array('Force_Wavedash', 'tild2wave'), 21);
	add_filter('pre_comment_content', array('Force_Wavedash', 'tild2wave'), 21);
}

/* ==================================================
 *   Force_Wavedash class
   ================================================== */

class Force_Wavedash {

// ==================================================
function tild2wave($text) {
	mb_regex_encoding('UTF-8');
	$text = mb_ereg_replace("\xef\xbd\x9e", "\xe3\x80\x9c", $text);
	return $text;
}

// ==================================================
function convert_posts($post_id) {
	$post = get_post($post_id);
	$title   = Force_Wavedash::tild2wave($post->post_title);
	$content = Force_Wavedash::tild2wave($post->post_content);
	$excerpt = Force_Wavedash::tild2wave($post->excerpt);
	global $wpdb;
	$title_sql   = $wpdb->escape($title);
	$content_sql = $wpdb->escape($content);
	$excerpt_sql = $wpdb->escape($excerpt);
	$id_sql      = intval($post->ID);
	$wpdb->query("UPDATE {$wpdb->posts} SET post_title = '$title_sql', post_content = '$content_sql', post_excerpt = '$excerpt_sql' WHERE ID = $id_sql");
	$posts = array($post);
	update_post_cache($posts);
	return $post_id;
}

// ===== End of class ====================
}

?>