<?php
/*
Plugin Name: Blogroll Page
Plugin URI: http://www.websitehostingiq.net/blogroll-page-plugin/
Description: Outputs your Blogroll links to a Page or Post. Add the text <code>&lt;!--blogroll-page--&gt;</code> to a Page or Post and it will output your Blogroll links. Pretty simple stuff really.
Author: Dominic Foster
Version: 1.0
Author URI: http://www.websitehostingiq.com/
*/


/*
Links Page is a Wordpress Plugin that will create a list of blogroll links to a Post or Page on your Wordpress Blog.
Copyright (C) 2007 Dominic Foster

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

//To replace the <!--blogroll-page--> with the blogroll links
function bp_text($text) {
	global $wpdb, $table_prefix;

	//Only perform plugin functionality if post/page text has <!--rs sitemap-->
	if (preg_match("|<!--blogroll-page-->|", $text)) {

		$sql = "SELECT * FROM " . $table_prefix . "links";

		$alllinks = $wpdb->get_results($sql);

    if (get_option('blogroll_page_new_window') == 'yes')
    {
      $target = 'target="_blank"';
    } else {
      $target = '';
    }

		foreach($alllinks as $link) {
			$url = $link->link_url;
      $name = $link->link_name;
      $description = (strlen($link->link_description) > 0) ? ' - ' . $link->link_description : '';

			$links .= '<a href=' . $url . ' ' . $target . '>' . $name . '</a>' . $description . '<br/><br/>';
		}

    if (get_option('blogroll_page_link') != 'yes')
    {
			$links .= '<a href="http://www.websitehostingiq.net/" ' . $target . '>Blogroll Links Plugin</a> - Wordpress Plugin to display your Blogroll in its own page or post<br/><br/>';
    }

		$text = preg_replace("|<!--blogroll-page-->|", $links, $text);

	}

	return $text;

} //end bp_text()

//admin menu
function blogroll_page_admin() {
	if (function_exists('add_options_page')) {
		add_options_page('blogroll-page', 'Blogroll Page', 1, basename(__FILE__), 'blogroll_page_admin_panel');
  }
}

function blogroll_page_admin_panel() {

	//Add options if first time running
	add_option('blogroll_page_link', 'no', 'Blogroll Page - disable link');
	add_option('blogroll_page_new_window', 'no', 'Blogroll Page - open link in new window');

	if (isset($_POST['info_update'])) {
		//update settings
		if($_POST['disable'] == 'on') { $disable = 'yes'; } else { $disable = 'no'; }
		if($_POST['newwindow'] == 'on') { $new = 'yes'; } else { $new = 'no'; }

		update_option('blogroll_page_link', $disable);
		update_option('blogroll_page_new_window', $new);
	} else {
		//load settings from database
		$disable = get_option('blogroll_page_link');
		$new = get_option('blogroll_page_new_window');
	}

	?>

	<div class=wrap>
		<form method="post">

			<h2>Blogroll Page Plugin 設定</h2>

			<fieldset name="set1">
				<h3>プラグインページへのリンクを無効:</h3>

				<p>
            プラグインのダウンロードリンクです。望まないならチェックして解除しましょう。 :(<br /><br />
					<label>
            <input type="checkbox" name="disable" <?php checked('yes', $disable); ?> class="tog"/>
						プラグインへのリンクを表示しないようにする。
					</label>
				</p>

				<h3>新しいウィンドウでリンク先を表示:</h3>

				<p>
					<label>
            <input type="checkbox" name="newwindow" <?php checked('yes', $new); ?> class="tog"/>
						新しいウィンドウでリンクを表示するようにする。
					</label>
				</p>

			</fieldset>

			<div class="submit">

				<input type="submit" name="info_update" value="設定を更新" />

			</div>

		</form>
	</div><?php
}


//hooks
add_filter('the_content', 'bp_text', 2);
add_action('admin_menu', 'blogroll_page_admin');

?>