<?php
/* ͕h~̂߂̓{ꕶłB
   ̃\[Xt@C Shift_JIS ŕۑĂ܂B
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with Shift_JIS. */

define ('KS_DEFAULT_CHARSET', 'SJIS');
define ('KS_MAX_PAGE_NUM', 1000);

/* ==================================================
 *   Ktai_Services class
     version 0.91
   ================================================== */

class Ktai_Services {
	protected $user_agent;
	protected $operator   = 'Unknown';
	protected $type       = 'N/A';
	protected $term_name  = 'N/A';
	protected $term_ID    = '';
	protected $SIM_ID     = '';
	protected $page_size  = 20000;
	protected $cache_size = 524288;
	protected $charset    = 'SJIS-win';
	protected $preamble   = '<?xml version="1.0" encoding="__CHARSET__">
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML Basic 1.0//EN" "http://www.w3.org/TR/xhtml-basic/xhtml-basic10.dtd">';
	protected $allowedtags = array( 'address' => array(), 'a' => array('href' => array(), 'name' => array(), 'lcs' => array(), 'utn' => array(), 'z' => array()), 'b' => array(), 'big' => array(), 'bgsound' => array('loop' => array(), 'src' => array()), 'blink' => array(), 'blockquote' => array('cite' => array()), 'br' => array(), 'caption' => array('align' => array()), 'code' => array(), 'col' => array('align' => array(), 'char' => array(), 'charoff' => array(), 'span' => array(), 'valign' => array(), 'width' => array()), 'del' => array('datetime' => array()), 'dd' => array(), 'div' => array('align' => array()), 'dl' => array(), 'dt' => array(), 'em' => array(), 'fieldset' => array(), 'font' => array('color' => array(), 'size' => array()), 'form' => array('action' => array(), 'enctype' => array(), 'method' => array(), 'name' => array(), 'target' => array(), 'lcs' => array(), 'utn' => array(), 'z' => array()), 'h1' => array('align' => array()), 'h2' => array('align' => array()), 'h3' => array('align' => array()), 'h4' => array('align' => array()), 'h5' => array('align' => array()), 'h6' => array('align' => array()), 'hr' => array('align' => array(), 'noshade' => array(), 'size' => array(), 'width' => array(), 'color' => array()), 'i' => array(), 'img' => array('alt' => array(), 'align' => array(), 'border' => array(), 'class' => array(), 'copyright' => array(), 'height' => array(), 'hspace' => array(), 'localsrc' => array(), 'src' => array(), 'vspace' => array(), 'width' => array()), 'input' => array('type' => array(), 'name' => array(), 'size' => array(), 'maxlength' => array(), 'accesskey' => array(), 'value' => array(), 'istyle' => array(), 'mode' => array()), 'ins' => array('datetime' => array(), 'cite' => array()), 'kbd' => array(), 'label' => array('for' => array()), 'legend' => array('align' => array()), 'li' => array(), 'marquee' => array('behavior' => array(), 'direction' => array(), 'loop' => array(), 'height' => array(), 'width' => array(), 'scrollamount' => array(), 'scrolldelay' => array(), 'bgcolor' => array()), 'object' => array('declare' => array(), 'id' => array(), 'data' => array(), 'type' => array(), 'width' => array(), 'height' => array(), 'copyright' => array(), standby => array()), 'p' => array('align' => array()), 'param' => array('name' => array(), 'value' => array(), 'valuetype' => array()), 'pre' => array('width' => array()), 'q' => array('cite' => array()), 's' => array(), 'select' => array('name' => array(), 'size' => array(), 'multiple' => array()), 'strike' => array(), 'strong' => array(), 'sub' => array(), 'sup' => array(), 'table' => array('align' => array(), 'bgcolor' => array(), 'border' => array(), 'cellpadding' => array(), 'cellspacing' => array(), 'rules' => array(), 'summary' => array(), 'width' => array()), 'tbody' => array('align' => array(), 'char' => array(), 'charoff' => array(), 'valign' => array()), 'td' => array('abbr' => array(), 'align' => array(), 'axis' => array(), 'bgcolor' => array(), 'char' => array(), 'charoff' => array(), 'colspan' => array(), 'headers' => array(), 'height' => array(), 'nowrap' => array(), 'rowspan' => array(), 'scope' => array(), 'valign' => array(), 'width' => array()), 'textarea' => array('cols' => array(), 'rows' => array(), 'disabled' => array(), 'name' => array(), 'readonly' => array(), 'istyle' => array(), 'mode' => array()), 'tfoot' => array('align' => array(), 'char' => array(), 'charoff' => array(), 'valign' => array()), 'th' => array('abbr' => array(), 'align' => array(), 'axis' => array(), 'bgcolor' => array(), 'char' => array(), 'charoff' => array(), 'colspan' => array(), 'headers' => array(), 'height' => array(), 'nowrap' => array(), 'rowspan' => array(), 'scope' => array(), 'valign' => array(), 'width' => array()), 'thead' => array('align' => array(), 'char' => array(), 'charoff' => array(), 'valign' => array()), 'title' => array(), 'tr' => array('align' => array(), 'bgcolor' => array(), 'char' => array(), 'charoff' => array(), 'valign' => array()), 'tt' => array(), 'u' => array(), 'ul' => array(), 'ol' => array(), 'var' => array() );

/* ==================================================
 * @param	none
 * @return	object  $ktai
 */
public function factory($wince = FALSE) {
	$ktai = NULL;
	$ua = $_SERVER['HTTP_USER_AGENT'];
	if (preg_match('!^DoCoMo/1!', $ua)) {
		$ktai = new Ktai_Service_imode_mova($ua);
	} elseif (preg_match('!^DoCoMo/2!', $ua)) {
		$ktai = new Ktai_Service_imode_FOMA($ua);
	} elseif (preg_match('!^J-PHONE/!', $ua)) {
		$ktai = new Ktai_Service_Softbank_PDC($ua);
	} elseif (preg_match('!^(Vodafone/|MOT-[CV]|SoftBank/)!', $ua)) {
		$ktai = new Ktai_Service_Softbank_3G($ua);
	} elseif (preg_match('!(DDIPOCKET|WILLCOM);!', $ua)) {
		$ktai = new Ktai_Service_WILLCOM($ua);
	} elseif (preg_match('!^(KDDI-|UP\.Browser)!',$ua)) {
		$ktai = new Ktai_Service_EZweb($ua);
	} elseif (preg_match('!(Nokia\\d+|^Opera Mini)/!', $ua)) {
		$ktai = new Ktai_Service_Other($ua);
	} elseif ($wince) { // Smartphones are not support pict chars
		if (preg_match('!Windows CE; SHARP/W?S\d+SH;!', $ua)) {
			$ktai = new Ktai_Service_Other($ua); // W-ZERO3 & EMEONE
		} elseif (preg_match('!Windows CE; HTC/X\d+H?T;!', $ua)) {
			$ktai = new Ktai_Service_Other($ua); // X01HT, X02HT, X01T...
		} elseif (preg_match('!Windows CE; .*?DCM\d+\)!', $ua)) {
			$ktai = new Ktai_Service_Other($ua); // htcZ etc...
		}
	}
	return $ktai;
}

/* ==================================================
 * @param	string $key
 * @return	mix    $value
 */
public function get_param($key) {
	switch ($key) {
	case 'charset':
		return ($this ? $this->charset : KS_DEFAULT_CHARSET);
	case 'iana_charset':
		$charset = ($this ? $this->charset : KS_DEFAULT_CHARSET);
		$charset = preg_replace('/^SJIS(-win)?$/', 'Shift_JIS', $charset);
		$charset = preg_replace('/^eucJP(-win)?$/', 'EUC-JP', $charset);
		return $charset;
	case 'preamble':
		return str_replace('__CHARSET__', $this->get_param('iana_charset'), $this->preamble);
	case 'term_name':
		return ($this->term_name ? $this->term_name : 'Unknown');
	default:
		return isset($this->$key) ? $this->$key : NULL;
	}
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_pre_split($buffer) {
	$buffer = preg_replace('/\r?\n/', "\n", $buffer);
	$short_url = _strip_host(get_bloginfo('url') . '/');
	$buffer = preg_replace('!href=([\'"])' . preg_quote(get_bloginfo('url'), '!') . '/?!', 'href=$1' . $short_url, $buffer); //": fix for SubEthaEdit syntax formatting

	$buffer = preg_replace('!<(p|div)( (id|class|align)=([\'"])[-_ a-zA-Z0-9]+\\4)*>\s*</\\1>\s*!', '', $buffer); //"	$buffer = preg_replace('!\s*<(ul|/li)>\s*<(li)!', '<$1><$2', $buffer);
	$buffer = preg_replace('!\s*<(dl|/?dt|/?dd)>\s*<(dt|dd)!', '<$1><$2', $buffer);
	$buffer = preg_replace('/^\s+/m', '', $buffer);
	$buffer = preg_replace('!/>\s+!', '/>', $buffer);
	$buffer = preg_replace('!\s+</!', '</', $buffer);
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
protected function replace_smiley($buffer, $smiles = NULL) {
	if ($smiles && preg_match_all('!<img src=([\'"])[^>]*?/([-_.a-zA-Z0-9]+)\\1( alt=([\'"])([^\\4\\\\]|\\\\\\4)*?\\4)? class=([\'"])(([^\\6\\\\]|\\\\\\6)*?)\\6 ?/?>!', $buffer, $images, PREG_SET_ORDER)) {
		foreach($images as $i) {
			if (preg_match('/\bwp-smiley\b/', $i[7]) && ! preg_match('/\bktai\b/', $i[7])) {
				$buffer = str_replace($i[0], $smiles[$i[2]], $buffer);
			}
		}
	}
	return $buffer;
}

/* ==================================================
 * @param	string  $message
 * @return	string  $message
 */
private function encode_message($message) {
	return mb_convert_encoding(__($message, 'ktai_style'), $this->get_param('charset'), 'UTF-8');
}

/* ==================================================
 * @param	none
 * @return	int     $page_num
 */
private function get_split_page_navi($num, $rest, $post_password) {
	$link = preg_replace('/kp=\d+$/', 'kp=', $_SERVER['REQUEST_URI'], 1, $count);
	if (! $count) {
		$link .= (strpos($link, '?') === FALSE) ? '?kp=': '&kp=';
	}
	$html = '<div align="center">' . $this->encode_message('Splitting the page for mobile: ');
	$del_accesskey = '';
	if ($num == 2) {
		$html .= _internal_link(preg_replace('/[?&]kp=/', '', $link), '*', '', $this->encode_message('*.Prev'), $post_password) . ' | ';
		$del_accesskey .= '*';
	} elseif ($num >= 3) {
		$html .= _internal_link($link . intval($num -1), '*', '', $this->encode_message('*.Prev'), $post_password) . ' | ';
		$del_accesskey .= '*';
	}
	$html .= sprintf($this->encode_message('page %d'), intval($num));
	if ($rest) {
		$html .= ' | ' . _internal_link($link . intval($num +1), '#', '', $this->encode_message('#.Next'), $post_password);
		$del_accesskey .= '#';
	}
	$html .= '</div>';
	return array($html, $del_accesskey);
}

/* ==================================================
 * @param	string  $content
 * @param   int     $page_num
 * @return	string  $paged_content
 */
public function split_page($content, $page_num) {
	if ($page_num > KS_MAX_PAGE_NUM) {
		$page_num = KS_MAX_PAGE_NUM;
	} elseif ($page_num < 1) {
		$page_num = 1;
	}

	if (! preg_match('/<!--start paging-->/', $content)) {
		$content = preg_replace('/(<body[^>]*>)/', "$1\n<!--start paging-->", $content);
	}
	if (! preg_match('/<!--end paging-->/', $content)) {
		if (preg_match('!<hr />\s*<a name="tail"!', $content)) {
			$content = preg_replace('!(<hr />\s*<a name="tail")!', "<!--end paging-->\n\\1", $content);
		} else {
			$content = preg_replace('!(</body>)!', "<!--end paging-->\n$1", $content);
		}
	}

	list($header, $content) = preg_split('/<!--start paging-->\n*/', $content, 2);
	list($content, $footer) = preg_split('/\n*<!--end paging-->/', $content, 2);
	$content = preg_replace('/>\s*</', '><', $content);
	if (preg_match('/<input type="hidden" name="post_password" value="(.*?)"/', $content, $match)) {
		$post_password = $match[1];
	} else {
		$post_password = '';
	}
	list($navi, $del_accesskey) = $this->get_split_page_navi(101,TRUE, $post_password);
	$page_size = $this->page_size - strlen("$header$navi<hr /><hr />$navi$footer") - 32; // 32-byte is space for adding tags by force_balance_tags()
	if ($page_size < 256) { // too mall
		$header = preg_replace('/(<body[^>]*>)/', '$1<!--start paging-->', $header);
		list($header, $move2body) = explode('<!--start paging-->', $header, 2);
		$content = $move2body . $content . $footer;
		$footer = '';
		$page_size = $this->page_size - strlen("$header$navi<hr /><hr />$navi$footer") - 32;
	}

	$start_tags = '';
	$terminator = '<!--' . md5(uniqid()) . '-->';
	$marker = 0;
	$content_length = strlen($content);
	for ($count = 0 ; $count < $page_num ; $count++) {
		$fragment = mb_strcut($content, $marker, $page_size, $this->charset);
		if (preg_match('/<[^>]*$/', $fragment, $uncomplete_tag)) {
			$fragment = preg_replace('/' . preg_quote($uncomplete_tag[0], '/') . '$/', '', $fragment);
		}
		if (preg_match('/&#?[a-zA-Z0-9]*?$/', $fragment, $uncomplete_entity)) {
			$fragment = preg_replace('/' . preg_quote($uncomplete_entity[0], '/') . '$/', '', $fragment);
		}
		if (preg_match('!(<[^/]>|<[^/][^>]*[^/]>)([^<]*?)$!', $fragment, $only_start_tag) && (preg_match('/^\s*$/', $only_start_tag[2]) || strlen($only_start_tag[2]) < 32)) {
			$fragment = preg_replace('/' . preg_quote($only_start_tag[0], '/') . '$/', '', $fragment);
		}

		$balanced = force_balance_tags($start_tags . $fragment . $terminator);
		preg_match('/' . $terminator . '(.*)$/', $balanced, $added_html);
		if (preg_match_all('!</([^<>]*)>!', $added_html[1], $added_tags)) {
			$start_tags = '<' . implode('><', array_reverse($added_tags[1])) . '>';
		} else {
			$start_tags = '';
		}
		$marker += strlen($fragment);
		if ($marker >= $content_length /* || preg_match('/^\s*<[^>]+>\s*$/', mb_strcut($content, $marker, 0, $this->charset)) */ ) {
			$count++;
			break;
		}
	}

	if (strlen($fragment) < $content_length) {
		$balanced = str_replace($terminator, '', $balanced);
		list($navi, $del_accesskey) = $this->get_split_page_navi($count, ($marker +1 < $content_length), $post_password);
		if ($del_accesskey) {
			$balanced = preg_replace('/(<a [^>]*?) accesskey="[' . $del_accesskey . ']">/', '$1>', $balanced);
		}
		return "$header$navi<hr />$balanced<hr />$navi$footer";
	} else {
		return "$header$content$footer";
	}
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	return $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_Other class
   ================================================== */

class Ktai_Service_Other extends Ktai_Services {
	static public $dcm_smartphones = array(
		'DCM06' => 'htcZ',
	);

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	$this->user_agent = $user_agent;
	if (preg_match('!Windows CE;( [^/]*/([^;]*);)? \w+; \d+x\d+(; (DCM\d+))?[;)]!', $user_agent, $specs)) {
		if ($specs[1]) {
			$this->term_name = $specs[2];
		} elseif ($specs[3]) {
			$this->term_name = self::$dcm_smartphones[$specs[4]];
		}
	}
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function convert_char($buffer) {
	$buffer = preg_replace('!<img localsrc="([^\\\\"]|\\\\")*?"( alt="(([^\\\\"]|\\\\")*?)")? ?/?>!', '$3', $buffer);
	return $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_EZweb class
   ================================================== */

class Ktai_Service_EZweb extends Ktai_Services {
	static public $devID_to_name = array(
		"SN3B" => "W53S", 
		"CA39" => "W53CA", 
		"ST32" => "W53SA", 
		"TS3E" => "W54T", 
		"SH33" => "W52SH", 
		"CA38" => "W52CA", 
		"MA32" => "W52P", 
		"SN3A" => "W52S", 
		"TS3D" => "W53T", 
		"SA3A" => "W52SA", 
		"HI3A" => "W52H", 
		"KC3A" => "MEDIA SKIN", 
		"SH32" => "W51SH", 
		"SN39" => "W51S", 
		"TS3C" => "W52T", 
		"TS3B" => "W51T", 
		"SA39" => "W51SA", 
		"HI39" => "W51H", 
		"CA37" => "W51CA", 
		"MA31" => "W51P", 
		"KC39" => "W51K", 
		"TS39" => "DRAPE", 
		"TS3A" => "W47T", 
		"SN38" => "W44S", 
		"KC38" => "W44K/K II", 
		"SA38" => "W43SA", 
		"TS38" => "W45T", 
		"CA35" => "W43CA", 
		"HI38" => "W43H/H II", 
		"SN37" => "W43S", 
		"KC37" => "W43K", 
		"ST31" => "W42SA", 
		"SH31" => "W41SH", 
		"CA34" => "W42CA", 
		"HI37" => "W42H", 
		"TS37" => "W44T/T II/T III", 
		"TS35" => "neon", 
		"TS36" => "W43T", 
		"SN36" => "W42S", 
		"KC36" => "W42K", 
		"KC35" => "W41K", 
		"SA36" => "W41SA", 
		"TS34" => "W41T", 
		"HI36" => "W41H", 
		"CA33" => "W41CA", 
		"SN34" => "W41S", 
		"HI34" => "PENCK", 
		"SA35" => "W33SA/SA II", 
		"TS33" => "W32T", 
		"SA34" => "W32SA", 
		"KC34" => "W32K", 
		"HI35" => "W32H", 
		"SN33" => "W32S", 
		"SN35" => "W32S", 
		"CA32" => "W31CA", 
		"TS32" => "W31T", 
		"SN32" => "W31S", 
		"KC33" => "W31K/K II", 
		"SA33" => "W31SA/SA II", 
		"SA32" => "W22SA", 
		"HI33" => "W22H", 
		"CA31" => "W21CA/CA II", 
		"TS31" => "W21T", 
		"SA31" => "W21SA", 
		"SN31" => "W21S", 
		"KC32" => "W21K", 
		"HI32" => "W21H", 
		"KC31" => "W11K", 
		"HI31" => "W11H", 
		"CA36" => "E03CA", 
		"SA37" => "E02SA", 
		"ST2C" => "Sweets cute", 
		"ST29" => "Sweets pure", 
		"CA28" => "G'zOne TYPE-R", 
		"ST26" => "Sweets", 
		"ST25" => "talby", 
		"ST22" => "INFOBAR", 
		"KC2A" => "A5528K", 
		"SA2A" => "A5527SA", 
		"KC29" => "A5526K", 
		"ST2D" => "A5525SA", 
		"TS2D" => "A5523T", 
		"SA29" => "A5522SA", 
		"KC28" => "A5521K", 
		"ST2A" => "A5520SA/SA II", 
		"ST28" => "A5518SA", 
		"TS2C" => "A5517T", 
		"TS2B" => "A5516T", 
		"KC27" => "A5515K", 
		"ST27" => "A5514SA", 
		"CA27" => "A5512CA", 
		"TS2A" => "A5511T", 
		"TS29" => "A5509T", 
		"ST24" => "A5507SA", 
		"TS28" => "A5506T", 
		"SA27" => "A5505SA", 
		"TS27" => "A5504T", 
		"SA26" => "A5503SA", 
		"KC24" => "A5502K", 
		"KC25" => "A5502K", 
		"TS26" => "A5501T", 
		"CA26" => "A5407CA", 
		"CA25" => "A5406CA", 
		"ST23" => "A5405SA", 
		"SN25" => "A5404S", 
		"CA24" => "A5403CA", 
		"SN24" => "A5402S", 
		"CA23" => "A5401CA II", 
		"CA23" => "A5401CA", 
		"ST21" => "A5306ST", 
		"KC22" => "A5305K", 
		"TS24" => "A5304T", 
		"HI24" => "A5303H II", 
		"HI23" => "A5303H", 
		"CA22" => "A5302CA", 
		"TS23" => "A5301T", 
		"SA22" => "A3015SA", 
		"PT22" => "A3015SA", 
		"PT21" => "A1405PT", 
		"SN29" => "A1405PT", 
		"KC26" => "A1403K", 
		"SN27" => "A1403K", 
		"SN28" => "A1402S II (Camera Less)", 
		"SN26" => "A1402S", 
		"KC23" => "A1401K", 
		"SA28" => "A1305SA", 
		"TS25" => "A1304T II", 
		"TS25" => "A1304T II", 
		"TS25" => "A1304T (Camera Less)", 
		"SA25" => "A1303SA", 
		"SA24" => "A1302SA", 
		"SN23" => "A1301S", 
		"ST14" => "A1014ST", 
		"SN21" => "A3014S", 
		"TS22" => "A3013T", 
		"CA21" => "A3012CA", 
		"SA21" => "A3011SA", 
		"SN22" => "A1101S", 
		"KC14" => "A1012K II", 
		"KC14" => "A1012K", 
		"ST13" => "A1011ST", 
		"MA21" => "C3003P", 
		"KC21" => "C3002K", 
		"HI21" => "C3001H", 
		"SN17" => "C1002S", 
		"SY15" => "C1001SA", 
		"CA14" => "C452CA", 
		"HI14" => "C451H", 
		"TS14" => "C415T", 
		"KC13" => "C414K II", 
		"KC13" => "C414K", 
		"SN15" => "C413S", 
		"SN16" => "C413S", 
		"SY14" => "C412SA", 
		"ST12" => "C411ST", 
		"TS13" => "C410T", 
		"CA13" => "C409CA", 
		"MA13" => "C408P", 
		"HI13" => "C407H", 
		"SN13" => "C406S", 
		"SY13" => "C405SA", 
		"SN12" => "C404S", 
		"SN14" => "C404S", 
		"ST11" => "C403ST", 
		"DN11" => "C402DE", 
		"SY12" => "C401SA", 
		"KCTE" => "TK51", 
		"TST9" => "TT51", 
		"KCU1" => "TK41", 
		"SYT5" => "TS41", 
		"KCTD" => "TK40", 
		"TST8" => "TT32", 
		"TST7" => "TT31", 
		"KCTC" => "TK31", 
		"SYT4" => "TS31", 
		"KCTB" => "TK23", 
		"KCTA" => "TK22", 
		"TST6" => "TT22", 
		"KCT9" => "TK21", 
		"TST5" => "TT21", 
		"TST4" => "TT11", 
		"KCT8" => "TK12", 
		"SYT3" => "TS11", 
		"KCT7" => "TK11", 
		"MIT1" => "TD11", 
		"MAT3" => "TP11", 
		"KCT6" => "TK05", 
		"TST3" => "TT03", 
		"KCT5" => "TK04", 
		"KCT4" => "TK03", 
		"SYT2" => "TS02", 
		"MAT1" => "TP01", 
		"MAT2" => "TP01", 
		"TST2" => "TT02", 
		"KCT3" => "TK0K", 
		"KCT2" => "TK02", 
		"KCT1" => "TK01", 
		"TST1" => "TT01", 
		"SYT1" => "TS01", 
		);

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	$this->user_agent = $user_agent;
	$this->operator   = 'KDDI';
	$this->type       = 'EZweb';
	preg_match('!^(KDDI-([A-Za-z0-9]+)|UP\.Browser/\d\.\d+-([A-Za-z0-9]+)) !', $user_agent, $specs);
	$dev_ID = $specs[2] ? $specs[2] : $specs[3];
	if (in_array($dev_ID, array_keys(self::$devID_to_name))) {
		$this->term_name = self::$devID_to_name[$dev_ID];
	} else {
		$this->term_name = "(Unknown au device:$dev_ID)";
	}
	$this->term_ID    = @$_SERVER['HTTP_X_UP_SUBNO'];
	$this->page_size  = $specs[2] ? 9000 : 7500;
	$this->cache_size = $specs[2] ? 102400 : 49152;
	$this->charset    = 'SJIS-win';
	$this->preamble   = '<?xml version="1.0" encoding="__CHARSET__">
<!DOCTYPE html PUBLIC "-//OPENWAVE//DTD XHTML 1.0//EN" "http://www.openwave.com/DTD/xhtml-basic.dtd">';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => '<img localsrc="257">',
		'icon_biggrin.gif'   => '<img localsrc="454">',
		'icon_sad.gif'       => '<img localsrc="441">',
		'icon_surprised.gif' => '<img localsrc="350">',
		'icon_eek.gif'       => '<img localsrc="451">',
		'icon_confused.gif'  => '<img localsrc="444">',
		'icon_cool.gif'      => '<img localsrc="382">',
		'icon_mad.gif'       => '<img localsrc="258">',
		'icon_razz.gif'      => '<img localsrc="264">',
		'icon_neutral.gif'   => '<img localsrc="440">',
		'icon_wink.gif'      => '<img localsrc="348">',
		'icon_lol.gif'       => '<img localsrc="789">',
		'icon_redface.gif'   => '<img localsrc="349">', // 446 is better?
		'icon_cry.gif'       => '<img localsrc="259">',
		'icon_evil.gif'      => '<img localsrc="277">',
		'icon_twisted.gif'   => '<img localsrc="277">',
		'icon_rolleyes.gif'  => '<img localsrc="442">',
		'icon_exclaim.gif'   => '<img localsrc="2">',
		'icon_question.gif'  => '<img localsrc="3">',
		'icon_idea.gif'      => '<img localsrc="77">',
		'icon_arrow.gif'     => '<img localsrc="63">',
		'icon_mrgreen.gif'   => '<img localsrc="814">',
	);
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function convert_char($buffer) {
	$buffer = preg_replace('!(<img localsrc="([^\\\\"]|\\\\")*?")( alt="([^\\\\"]|\\\\")*?")? ?/?>!', '$1>', $buffer);
	return $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_imode class
   ================================================== */

class Ktai_Service_imode extends Ktai_Services {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	$this->user_agent = $user_agent;
	$this->operator   = 'DoCoMo';
	$this->charset    = 'SJIS-win';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => '&#63893;',
		'icon_biggrin.gif'   => '&#xE72A;',
		'icon_sad.gif'       => '&#63896;',
		'icon_surprised.gif' => '&#63914;', // impact
		'icon_eek.gif'       => '&#xE757;', 
		'icon_confused.gif'  => '&#xE72B;',
		'icon_cool.gif'      => '&#xE752;',
		'icon_mad.gif'       => '&#63894;',
		'icon_razz.gif'      => '&#xE728;',
		'icon_neutral.gif'   => '&#xE725;',
		'icon_wink.gif'      => '&#xE729;',
		'icon_lol.gif'       => '&#xE728;',
		'icon_redface.gif'   => '&#xE726;',
		'icon_cry.gif'       => '&#xE72D;',
		'icon_evil.gif'      => '&#xE724;',
		'icon_twisted.gif'   => '&#xE724;',
		'icon_rolleyes.gif'  => '&#xE720;',
		'icon_exclaim.gif'   => '&#63911;',
		'icon_question.gif'  => '&#63912;',
		'icon_idea.gif'      => '&#63904;',
		'icon_arrow.gif'     => '&#63835;',
		'icon_mrgreen.gif'   => '&#xE753;',
	);
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 * Reference: http://www.nttdocomo.co.jp/service/imode/make/content/pictograph/basic/
 *            http://www.au.kddi.com/ezfactory/tec/spec/3.html
 */
public function convert_char($buffer) {
	$chars = array (
		'1'   => '&#xE737;', // warning (!)
		'2'   => '&#63911;', // exclamation (!)
		'5'   => '',       // left triangle
		'6'   => '',       // right triangle
		'7'   => '',       // double left triangle
		'8'   => '',       // double right triangle
		'16'  => '&#63651;', // thunder
		'29'  => '',       // up arrow
		'30'  => '',       // down arrow
		'32'  => '',       // down triangle
		'33'  => '',       // up triangle
		'34'  => '',       // double down triangle
		'35'  => '',       // double up triangle
		'44'  => '&#63647;', // sun
		'45'  => '&#63668;', // baseball
		'46'  => '&#63838;', // clock
		'50'  => '&#63829;', // face (female)
		'51'  => '&#63889;', // heart
		'56'  => '&#63722;', // note
		'61'  => '~',       // cross
		'63'  => '',       // right arrow
		'64'  => '',       // left arrow
		'68'  => '&#63893;', // smile
		'77'  => '&#63904;', // lamp
		'80'  => '&#63829;', // face (male)
		'81'  => '&#xE731;', // copyright mark
		'82'  => '&#xE736;', // registered mark
		'83'  => '&#63715;', // briefcase
		'85'  => '&#63720;', // telephone (fixed)
		'86'  => '&#63722;', // memo
		'94'  => '&#63714;', // camera
		'95'  => '&#63649;', // rain
		'96'  => '&#63671;', // american football??
		'97'  => '&#63716;', // book
		'98'  => '&#xE72F;', // keep out sign
		'99'  => '&#63694;', // traffic signal
		'100' => '&#63716;', // book
		'101' => '&#63716;', // book
		'102' => '&#63716;', // book
		'103' => '&#63722;', // document
		'104' => '&#63702;', // scissors
		'105' => '&#63722;', // daily calender
		'106' => '&#63711;', // ticket
		'107' => '&#63648;', // cloud
		'108' => '&#63863;', // mail envelope
		'109' => '&#63866;', // money
		'112' => '&#63684;', // home
		'116' => '&#63730;', // glasses / eye
		'119' => '&#63873;', // magnifier (search)
		'120' => '&#63869;', // key
		'125' => '&#63679;', // sedan (car)
		'140' => '',       // leftside finger
		'141' => '',       // rightside finger
		'143' => '&#xE730;', // clip
		'144' => '&#63718;', // present box
		'146' => '&#63696;', // knife and fork
		'149' => '&#63826;', // pen
		'151' => '&#63863;', // envelope
		'152' => '&#xE718;', // spanner
		'155' => '&#63720;', // telephone (handset)
		'156' => '&#63685;', // factory
		'161' => '&#63721;', // mobile phone
		'168' => '&#63683;', // air plane
		'169' => '&#63682;', // boat (ship)
		'172' => '&#63676;', // electric train
		'176' => '&#63712;', // smoking
		'177' => '&#63713;', // no smoking
		'178' => '&#63740;', // wheel car
		'179' => '[t}[N]', // beginner driver mark
		'180' => '&#63879;', // one
		'181' => '&#63880;', // two
		'182' => '&#63881;', // three
		'183' => '&#63882;', // four
		'184' => '&#63883;', // five
		'185' => '&#63884;', // six
		'186' => '&#63885;', // seven
		'187' => '&#63886;', // eight
		'188' => '&#63887;', // nine
		'190' => '&#63652;', // storm
		'191' => '&#63650;', // snowball
		'192' => '&#63655;', // Aries (Ram)
		'193' => '&#63656;', // Taurus (Bull)
		'194' => '&#63657;', // Gemini (Twins)
		'195' => '&#63658;', // Cancer (Crab)
		'196' => '&#63659;', // Leo (Lion)
		'197' => '&#63660;', // Virgo (Virgin)
		'198' => '&#63661;', // Libra (Scales)
		'199' => '&#63662;', // Scorpius (Scorpion)
		'200' => '&#63663;', // Sagittarius (Archer)
		'201' => '&#63664;', // Capricornus (Goat)
		'202' => '&#63665;', // Aquarius (Water Bearer)
		'203' => '&#63666;', // Pisces (Fishes)
		'204' => '[֎g]', // Ophiuchus (Serpent Bearer)
		'205' => '&#63689;', // Automatic Teller Machine
		'206' => '&#63691;', // convenience store
		'207' => '&#63695;', // toilet
		'208' => '&#63693;', // parking
		'209' => '&#63681;', // bus stop
		'212' => '&#63688;', // bank
		'213' => '&#63692;', // gas station
		'215' => '&#xE71D;', // bicycle
		'216' => '&#63681;', // bus
		'217' => '&#63678;', // shinkansen (bullet train)
		'218' => '&#xE733;', // marathon
		'219' => '&#63671;', // football (soccer)
		'220' => '&#63670;', // tennis
		'221' => '&#xE712;', // snow board
		'222' => '&#63674;', // checker flag
		'223' => '&#63706;', // amusement park
		'224' => '&#63900;', // spa
		'226' => '&#63824;', // movie (clapper board)
		'227' => '&#63831;', // night scene
		'233' => '&#xE715;', // doller bag
		'234' => '&#63816;', // christmas tree
		'235' => '&#xE748;', // cherry blossom
		'257' => '&#63893;', // laugh face
		'258' => '&#63894;', // angry face
		'259' => '&#63896;', // sad face
		'260' => '&#63897;', // tired face
		'265' => '&#63891;', // heart break
		'278' => '&#63652;', // flower circle
		'279' => '&#xE734;', // secret
		'299' => '&#63867;', // free
		'303' => '&#63903;', // updated
		'305' => '&#63653;', // fog
		'306' => '&#63669;', // golf
		'307' => '&#63673;', // basket ball
		'325' => '&#63888;', // zero
		'327' => '&#63897;', // very tired face
		'334' => '&#63874;', // new
		'337' => '&#xE716;', // personal computer
		'339' => '&#xE748;', // rose
		'340' => '&#xE713;', // church
		'341' => '&#63677;', // subway
		'375' => '&#63686;', // post office
		'376' => '&#63687;', // hospital
		'377' => '&#xE73E;', // school
		'378' => '&#63690;', // hotel
		'379' => '&#63682;', // ship
		'380' => '&#xE738;', // NG / prohibited for U-18
		'381' => '[|i.]',    // anntena mark
		'382' => '[cool]',   // cool
		'383' => '[]',     // discount mark
		'384' => '[T]',     // service mark
		'385' => '&#63868;', // ID mark
		'386' => '&#xE73B;', // full mark
		'387' => '&#xE739;', // vacant mark
		'388' => '[w]',     // reserved mark
		'389' => '[c]',     // in-business mark
		'390' => '',       // upside finger
		'391' => '',       // downside finger
		'393' => '&#63721;', // manner mode
		'394' => '&#63721;', // power off
		'421' => '&#63672;', // ski
		'\\d+' => '',      // (catch all)
	);
	$pat = preg_replace('/^(.*)$/', '!<img localsrc="$1"( alt="([^\\\\"]|\\\\")*?")? ?/?>!', array_keys($chars));
	$buffer = preg_replace($pat, $chars, $buffer);
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_pre_split($buffer) {
//	$buffer = preg_replace('#<img src="([^>]*?)\.png"#', '<img src="\\1.gif"', $buffer);
	return parent::shrink_pre_split($buffer);
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_imode_mova class
   ================================================== */

class Ktai_Service_imode_mova extends Ktai_Service_imode {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	$this->type       = 'mova';
	preg_match('!1\.0/([-_.a-zA-Z0-9]+)(/c(\d+)(/\w+)*?(/ser(\w+))?)?!', $user_agent, $specs);
	$this->term_name  = $specs[1];
	$this->term_ID    = @$specs[6];
	$this->page_size  = 5000;
	$this->cache_size = ($specs[3] > 0) ? intval($specs[3]) * 1024 : 5120;
	$this->preamble   = '';
	parent::__construct($user_agent);
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	$buffer = preg_replace('#\s*</(li|dt|dd)>\s*#', '', $buffer);
	$buffer = preg_replace('!<([-~_= a-zA-Z0-9%.,:;\'"#*/+]+?) ?/>!', '<$1>', $buffer); //"
	return parent::shrink_post_split($buffer);
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_imode_FOMA class
   ================================================== */

class Ktai_Service_imode_FOMA extends Ktai_Service_imode {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	$this->type       = 'FOMA';
	preg_match('!2\.\d ([-_.a-zA-Z0-9]+)\(c(\d+)(;\w+)*?(;ser(\w+);icc(\w+))?\)!', $user_agent, $specs);
	$this->term_name  = $specs[1];
	$this->term_ID    = @$specs[5];
	$this->SIM_ID     = @$specs[6];
	$this->page_size  = 10000;
	$this->cache_size = ($specs[2] > 0) ? intval($specs[2]) * 1024 : 102400;
	$this->preamble   = '<?xml version="1.0" encoding="__CHARSET__">
<!DOCTYPE html PUBLIC "-//i-mode group (ja)//DTD XHTML i-XHTML(Locale/Ver.=ja/1.0) 1.0//EN" "i-xhtml_4ja_10.dtd">';
	parent::__construct($user_agent);
	return;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_Softbank class
   ================================================== */

class Ktai_Service_Softbank extends Ktai_Services {

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => '$Gv',
		'icon_biggrin.gif'   => '$P5',
		'icon_sad.gif'       => '$P!',
		'icon_surprised.gif' => '$P$',
		'icon_eek.gif'       => '$P0',
		'icon_confused.gif'  => '$P\'', //'
		'icon_cool.gif'      => '$F4',
		'icon_mad.gif'       => '$P6',
		'icon_razz.gif'      => '$P)',
		'icon_neutral.gif'   => '$P"',
		'icon_wink.gif'      => '$P%',
		'icon_lol.gif'       => '$P)',
		'icon_redface.gif'   => '$P-',
		'icon_cry.gif'       => '$P1',
		'icon_evil.gif'      => '$P6',
		'icon_twisted.gif'   => '$P6',
		'icon_rolleyes.gif'  => '$P7',
		'icon_exclaim.gif'   => '$GA',
		'icon_question.gif'  => '$G@',
		'icon_idea.gif'      => '$E/',
		'icon_arrow.gif'     => '$FT',
		'icon_mrgreen.gif'   => '$Gv',
	);
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 * Reference: http://developers.softbankmobile.co.jp/dp/tool_dl/web/picword_top.php
 *            http://www.au.kddi.com/ezfactory/tec/spec/3.html
 */
public function convert_char($buffer) {
	$chars = array (
		'1'   => '$Fr', // warning (!)
		'2'   => '$OW', // exclamation (!)
		'5'   => '$F[', // left triangle
		'6'   => '$FZ', // right triangle
		'7'   => '$F]', // double left triangle
		'8'   => '$F\\', // double right triangle
		'16'  => '$E]', // thunder
		'29'  => '$FR', // up arrow
		'30'  => '$FS', // down arrow
		'32'  => '',  // down triangle
		'33'  => '',  // up triangle
		'34'  => '',  // double down triangle
		'35'  => '',  // double up triangle
		'44'  => '$Gj', // sun
		'45'  => '$G6', // baseball
		'46'  => '$GF', // clock
		'50'  => '$G"', // face (female)
		'51'  => '$GB', // heart
		'56'  => '$O!', // note
		'61'  => '$OS', // cross
		'63'  => '$FT', // right arrow
		'64'  => '$FU', // left arrow
		'68'  => '$Gv', // smile
		'77'  => '$E/', // lamp
		'80'  => '$G!', // face (male)
		'81'  => '$Fn', // copyright mark
		'82'  => '$Fo', // registered mark
		'83'  => '$E>', // briefcase
		'85'  => '$G)', // telephone (fixed)
		'86'  => '$O!', // memo
		'94'  => '$G(', // camera
		'95'  => '$Gk', // rain
		'96'  => '$PK', // american football
		'97'  => '$Eh', // book
		'98'  => '$EW', // keep out sign
		'99'  => '$En', // traffic signal
		'100' => '$Eh', // book
		'101' => '$Eh', // book
		'102' => '$Eh', // book
		'103' => '$O!', // document
		'104' => '$O3', // scissors
		'105' => '$O!', // daily calender
		'106' => '$EE', // ticket
		'107' => '$Gi', // cloud
		'108' => '$E#', // mail envelope
		'109' => '$EO', // money
		'112' => '$GV', // home
		'116' => '$F1', // glasses / eye
		'119' => '$E4', // magnifier (search)
		'120' => '$G_', // key
		'125' => '$Ez', // sedan (car)
		'140' => '$FP', // leftside finger
		'141' => '$FQ', // rightside finger
		'143' => '[clip]', // clip
		'144' => '$E2', // present box
		'146' => '$Gc', // knife and fork
		'149' => '$O!', // pen
		'151' => '$E#', // envelope
		'152' => '$E6', // spanner / hammer
		'155' => '$G)', // telephone (handset)
		'156' => '$GX', // factory
		'161' => '$G*', // mobile phone
		'168' => '$G=', // air plane
		'169' => '$F"', // boat (ship)
		'172' => '$G>', // electric train
		'176' => '$O.', // smoking
		'177' => '$F(', // no smoking
		'178' => '$F*', // wheel car
		'179' => '$F)', // beginner driver mark
		'180' => '$F<', // one
		'181' => '$F=', // two
		'182' => '$F>', // three
		'183' => '$F?', // four
		'184' => '$F@', // five
		'185' => '$FA', // six
		'186' => '$FB', // seven
		'187' => '$FC', // eight
		'188' => '$FD', // nine
		'190' => '$Pc', // storm
		'191' => '$Gh', // snowball
		'192' => '$F_', // Aries (Ram)
		'193' => '$F`', // Taurus (Bull)
		'194' => '$Fa', // Gemini (Twins)
		'195' => '$Fb', // Cancer (Crab)
		'196' => '$Fc', // Leo (Lion)
		'197' => '$Fd', // Virgo (Virgin)
		'198' => '$Fe', // Libra (Scales)
		'199' => '$Ff', // Scorpius (Scorpion)
		'200' => '$Fg', // Sagittarius (Archer)
		'201' => '$Fh', // Capricornus (Goat)
		'202' => '$Fi', // Aquarius (Water Bearer)
		'203' => '$Fj', // Pisces (Fishes)
		'204' => '$Fk', // Ophiuchus (Serpent Bearer)
		'205' => '$Et', // Automatic Teller Machine
		'206' => '$Ev', // convenience store
		'207' => '$Eq', // toilet
		'208' => '$Eo', // parking
		'209' => '$Ep', // bus stop
		'212' => '$Em', // bank
		'213' => '$GZ', // gas station
		'215' => '$EV', // bicycle
		'216' => '$Ey', // bus
		'217' => '$G?', // shinkansen (bullet train)
		'218' => '$E5', // marathon
		'219' => '$G8', // football (soccer)
		'220' => '$G5', // tennis
		'221' => '$G3', // snow board
		'222' => '$ER', // checker flag
		'223' => '$ED', // amusement park
		'224' => '$EC', // spa
		'226' => '$OD', // movie (clapper board)
		'227' => '$Pk', // night scene
		'233' => '$EO', // doller bag
		'234' => '$GS', // christmas tree
		'235' => '$GP', // cherry blossom
		'257' => '$Gv', // laugh face
		'258' => '$Gy', // angry face
		'259' => '$Gw', // sad face
		'260' => '$Gx', // tired face
		'265' => '$GC', // heart break
		'278' => '$F$', // flower circle
		'279' => '$O5', // secret
		'299' => '$F6', // free
		'303' => '$F3', // updated
		'305' => '[]',  // fog
		'306' => '$G4', // golf
		'307' => '$PJ', // basket ball
		'325' => '$FE', // zero
		'327' => '$Gx', // very tired face
		'334' => '$F2', // new
		'337' => '$G,', // personal computer
		'339' => '$GR', // rose
		'340' => '$GW', // church
		'341' => '$PT', // subway
		'375' => '$Es', // post office
		'376' => '$Eu', // hospital
		'377' => '$Ew', // school
		'378' => '$Ex', // hotel
		'379' => '$F"', // ship
		'380' => '$F\'', // prohibited for U-18 '
		'381' => '$F+', // anntena mark
		'382' => '$F4', // cool
		'383' => '$FG', // discount mark
		'384' => '$FH', // service mark
		'385' => '$FI', // ID mark
		'386' => '$FJ', // full mark
		'387' => '$FK', // vacant mark
		'388' => '$FL', // reserved mark
		'389' => '$FM', // in-business mark
		'390' => '$FN', // upside finger
		'391' => '$FO', // downside finger
		'393' => '$Fp', // manner mode
		'394' => '$Fq', // power off
		'421' => '$G3', // ski
		'\\d+' => '',   // (catch all)
	);
	$pat = preg_replace('/^(.*)$/', '!<img localsrc="$1"( alt="([^\\\\"]|\\\\")*?")? ?/?>!', array_keys($chars));
	$buffer = preg_replace($pat, $chars, $buffer);
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	$buffer = preg_replace('!$!', '', $buffer);
	return parent::shrink_post_split($buffer);
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_Softbank_PDC class
   ================================================== */

class Ktai_Service_Softbank_PDC extends Ktai_Service_Softbank {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	$this->operator   = 'SoftBank';
	$this->type       = 'PDC';
	$this->user_agent = $user_agent;
	preg_match('!^J-PHONE/\d\.\d+/([-_.a-zA-Z0-9]+)/?(SN([-_.a-zA-Z0-9]*))? ?!', $user_agent, $specs);
	$this->term_name  = $specs[1];
	$this->term_ID    = @$specs[3];
	$this->page_size  = 6000;
	$this->cache_size = isset($specs[2]) ? 12288 : 6144;
	$this->charset    = 'SJIS-win';
	$this->preamble   = '';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_pre_split($buffer) {
	$buffer = preg_replace('!<h([1-6])(.*?)</h\\1>!', '<p$2</p>', $buffer);
	return parent::shrink_pre_split($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	$buffer = preg_replace('!\s*</(li|dt|dd|)>\s*!', '', $buffer);
	$buffer = preg_replace('!<([-~_= a-zA-Z0-9%.,:;\'"#*/+]+?) ?/>!', '<$1>', $buffer); //"
	return parent::shrink_post_split($buffer);
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_Softbank_3G class
   ================================================== */

class Ktai_Service_Softbank_3G extends Ktai_Service_Softbank {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	$this->operator   = 'SoftBank';
	$this->type       = '3G';
	$this->user_agent = $user_agent;
	preg_match('!^(Vodafone|SoftBank)/\d\.\d+/([-_.a-zA-Z0-9]+)/[-_.a-zA-Z0-9]+/(SN([-_.a-zA-Z0-9]*))? !', $user_agent, $specs);
	$this->term_name  = $specs[2];
	$this->term_ID    = $specs[4];
	$this->page_size  = 10000;
	$this->cache_size = 102400;
	$this->charset    = 'SJIS-win';
	$this->preamble   = '<?xml version="1.0" encoding="__CHARSET__">
<!DOCTYPE html PUBLIC "-//J-PHONE//DTD XHTML Basic 1.0 Plus//EN" "xhtml-basic10-plus.dtd">';
	return;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_WILLCOM class
   ================================================== */

class Ktai_Service_WILLCOM extends Ktai_Services {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	$this->operator   = 'WILLCOM';
	$this->type       = 'AIR-EDGE';
	$this->user_agent = $user_agent;
	preg_match('!\((DDIPOCKET|WILLCOM);[^/]+/([^/]+)/[^/]+/[\d.]+/[cC](\d+)\)!', $user_agent, $specs);
	$this->term_name  = $specs[2];
	$this->page_size  = 20000;
	$this->cache_size = $specs[3] ? $specs[3] * 1024 : 32768;
	$this->charset    = 'SJIS-win';
	// use default preamble
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => '&#63893;',
		'icon_biggrin.gif'   => '&#xE72A;',
		'icon_sad.gif'       => '&#63896;',
		'icon_surprised.gif' => '&#63914;', // impact
		'icon_eek.gif'       => '&#xE757;', 
		'icon_confused.gif'  => '&#xE72B;',
		'icon_cool.gif'      => '&#xE752;',
		'icon_mad.gif'       => '&#63894;',
		'icon_razz.gif'      => '&#xE728;',
		'icon_neutral.gif'   => '&#xE725;',
		'icon_wink.gif'      => '&#xE729;',
		'icon_lol.gif'       => '&#xE728;',
		'icon_redface.gif'   => '&#xE726;',
		'icon_cry.gif'       => '&#xE72D;',
		'icon_evil.gif'      => '&#xE724;',
		'icon_twisted.gif'   => '&#xE724;',
		'icon_rolleyes.gif'  => '&#xE720;',
		'icon_exclaim.gif'   => '&#63911;',
		'icon_question.gif'  => '&#63912;',
		'icon_idea.gif'      => '&#63904;',
		'icon_arrow.gif'     => '&#63835;',
		'icon_mrgreen.gif'   => '&#61574;',
	);
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 * Reference: http://www.willcom-inc.com/ja/service/contents_service/club_air_edge/for_phone/homepage/
 *            http://www.au.kddi.com/ezfactory/tec/spec/3.html
 */
public function convert_char($buffer) {
	$chars = array (
		'1'   => '&#61622;', // warning (!)
		'2'   => '&#61599;', // exclamation (!)
		'5'   => '',       // left triangle
		'6'   => '',       // right triangle
		'7'   => '&#61618;', // double left triangle
		'8'   => '&#61619;', // double right triangle
		'16'  => '&#63651;', // thunder
		'29'  => '',       // up arrow
		'30'  => '',       // down arrow
		'32'  => '',       // down triangle
		'33'  => '',       // up triangle
		'34'  => '',       // double down triangle
		'35'  => '',       // double up triangle
		'44'  => '&#61512;', // sun
		'45'  => '&#61531;', // baseball
		'46'  => '&#61505;', // clock
		'50'  => '&#61516;', // face (female)
		'51'  => '&#61504;', // heart
		'56'  => '&#61536;', // note
		'61'  => '&#61626;', // cross
		'63'  => '',       // right arrow
		'64'  => '',       // left arrow
		'68'  => '&#61516;', // smile
		'77'  => '&#61593;', // lamp
		'80'  => '&#61516;', // face (male)
		'81'  => '&#61627;', // copyright mark
		'82'  => '&#61628;', // registered mark
		'83'  => '&#61563;', // briefcase
		'85'  => '&#61506;', // telephone (fixed)
		'86'  => '&#63722;', // memo
		'94'  => '&#63714;', // camera
		'95'  => '&#61513;', // rain
		'96'  => '&#63671;', // american football??
		'97'  => '&#61536;', // book
		'98'  => '&#xE72F;', // keep out sign
		'99'  => '&#63694;', // traffic signal
		'100' => '&#61536;', // book
		'101' => '&#61536;', // book
		'102' => '&#61536;', // book
		'103' => '&#61536;', // document
		'104' => '&#61571;', // scissors
		'105' => '&#63722;', // daily calender
		'106' => '&#61591;', // ticket
		'107' => '&#61514;', // cloud
		'108' => '&#61539;', // mail envelope
		'109' => '&#61585;', // money
		'112' => '&#61523;', // home
		'116' => '&#63730;', // glasses / eye
		'119' => '&#63873;', // magnifier (search)
		'120' => '&#63869;', // key
		'125' => '&#61519;', // sedan (car)
		'140' => '',       // leftside finger
		'141' => '',       // rightside finger
		'143' => '&#61580;', // clip
		'144' => '&#61584;', // present box
		'146' => '&#61526;', // knife and fork
		'149' => '&#61537;', // pen
		'151' => '&#61539;', // envelope
		'152' => '&#xE718;', // spanner
		'155' => '&#61506;', // telephone (handset)
		'156' => '&#61524;', // factory
		'161' => '&#61589;', // mobile phone
		'168' => '&#61521;', // air plane
		'169' => '&#61522;', // boat (ship)
		'172' => '&#61520;', // electric train
		'176' => '&#61560;', // smoking
		'177' => '&#61540;', // no smoking
		'178' => '&#63740;', // wheel car
		'179' => '&#61617;', // beginner driver mark
		'180' => '&#61631;', // one
		'181' => '&#61632;', // two
		'182' => '&#61633;', // three
		'183' => '&#61634;', // four
		'184' => '&#61635;', // five
		'185' => '&#61636;', // six
		'186' => '&#61637;', // seven
		'187' => '&#61638;', // eight
		'188' => '&#61639;', // nine
		'190' => '&#61608;', // storm
		'191' => '&#61581;', // snowball
		'192' => '&#61640;', // Aries (Ram)
		'193' => '&#61641;', // Taurus (Bull)
		'194' => '&#61642;', // Gemini (Twins)
		'195' => '&#61643;', // Cancer (Crab)
		'196' => '&#61644;', // Leo (Lion)
		'197' => '&#61645;', // Virgo (Virgin)
		'198' => '&#61646;', // Libra (Scales)
		'199' => '&#61647;', // Scorpius (Scorpion)
		'200' => '&#61648;', // Sagittarius (Archer)
		'201' => '&#61649;', // Capricornus (Goat)
		'202' => '&#61650;', // Aquarius (Water Bearer)
		'203' => '&#61651;', // Pisces (Fishes)
		'204' => '&#61652;', // Ophiuchus (Serpent Bearer)
		'205' => '&#63689;', // Automatic Teller Machine
		'206' => '&#63691;', // convenience store
		'207' => '&#63695;', // toilet
		'208' => '&#63693;', // parking
		'209' => '&#63681;', // bus stop
		'212' => '&#63688;', // bank
		'213' => '&#63692;', // gas station
		'215' => '&#xE71D;', // bicycle
		'216' => '&#61615;', // bus
		'217' => '&#63678;', // shinkansen (bullet train)
		'218' => '&#xE733;', // marathon
		'219' => '&#61616;', // football (soccer)
		'220' => '&#61596;', // tennis
		'221' => '&#xE712;', // snow board
		'222' => '&#63674;', // checker flag
		'223' => '&#63706;', // amusement park
		'224' => '&#61543;', // spa
		'226' => '&#63824;', // movie (clapper board)
		'227' => '&#63831;', // night scene
		'233' => '&#61585;', // doller bag
		'234' => '&#63816;', // christmas tree
		'235' => '&#xE748;', // cherry blossom
		'257' => '&#61516;', // laugh face
		'258' => '&#61534;', // angry face
		'259' => '&#61528;', // sad face
		'260' => '&#61558;', // tired face
		'265' => '&#61576;', // heart break
		'278' => '&#63652;', // flower circle
		'279' => '&#xE734;', // secret
		'299' => '&#63867;', // free
		'303' => '&#63903;', // updated
		'305' => '&#63653;', // fog
		'306' => '&#63669;', // golf
		'307' => '&#63673;', // basket ball
		'325' => '&#61630;', // zero
		'327' => '&#61558;', // very tired face
		'334' => '&#63874;', // new
		'337' => '&#xE716;', // personal computer
		'339' => '&#xE748;', // rose
		'340' => '&#xE713;', // church
		'341' => '&#63677;', // subway
		'375' => '&#63686;', // post office
		'376' => '&#63687;', // hospital
		'377' => '&#xE73E;', // school
		'378' => '&#63690;', // hotel
		'379' => '&#61522;', // ship
		'380' => '&#61621;', // NG / prohibited for U-18
		'381' => '&#61624;', // anntena mark
		'382' => '[cool]',   // cool
		'383' => '[]',     // discount mark
		'384' => '[T]',     // service mark
		'385' => '&#63868;', // ID mark
		'386' => '&#xE73B;', // full mark
		'387' => '&#xE739;', // vacant mark
		'388' => '[w]',     // reserved mark
		'389' => '[c]',     // in-business mark
		'390' => '',       // upside finger
		'391' => '',       // downside finger
		'393' => '&#63721;', // manner mode
		'394' => '&#63721;', // power off
		'421' => '&#61598;', // ski
		'\\d+' => '',      // (catch all)
	);
	$pat = preg_replace('/^(.*)$/', '!<img localsrc="$1"( alt="([^\\\\"]|\\\\")*?")? ?/?>!', array_keys($chars));
	$buffer = preg_replace($pat, $chars, $buffer);
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_pre_split($buffer) {
//	$buffer = preg_replace('#<img src="([^>]*?)\.png"#', '<img src="\\1.gif"', $buffer);
	return parent::shrink_pre_split($buffer);
}

// ===== End of class ====================
}

?>
