<?php
/*
Plugin Name: VideoPop+
Plugin URI: http://wppluginsj.sourceforge.jp/videopop-plus/
Description: Add links to your posts and pages that open Videos in a popup window. Upload & administration via the WP admin panel
Version: 0.2.2
Author: wokamoto
Author URI: http://dogmap.jp/

 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

 this plugin based on
  VideoPop v.1.3.1(http://www.lynk.de/wordpress/videopop/)
  thanks to Marcus Grellert.

*/

@ini_set("max_execution_time","5000");

require("videopop_link.php");

load_plugin_textdomain('videopop_plus','wp-content/plugins/videopop_plus');

// =============
// CLASS

class VideoPopPlusController {
 var $plugin_name = 'videopop_plus';
 var $plugin_uri,$data_txt;
 var $options = array();
 var $note,$error,$blog_charset;
 var $admin_option,$admin_manage;

 /*
 * Constructor
 */
 function VideoPopPlusController() {
  $wkoptions = get_option($this->plugin_name." Options");
  if (!is_array($wkoptions)) {
   //----- Options default Value -----
   // User Level Permission -- Subscriber = 0,Contributor = 1,Author = 2,Editor= 7,Administrator = 9
   // Set the user level the user needs to have (at least) to manage/upload/delete videos
   $this->options['user_lvl'] = '7';

   // Show Option
   // "lightpop" or "modalbox" or "popup"
   $this->options['show_option'] = "lightpop";

   // data directory
   $this->options['data_dir'] = "wp-content/videopop/";

   update_option($this->plugin_name." Options", $this->options);

  } else {
   $this->options = $wkoptions;
   $this->options['data_dir'] = "wp-content/videopop/";
  }

  $this->plugin_uri = get_settings('siteurl').'/wp-content/plugins/'.$this->plugin_name;
  $this->data_txt = ABSPATH.$this->options['data_dir'].'videopopdata.txt';

  // Defaults
  $this->note = '';
  $this->error = 0;
  $this->blog_charset = get_settings('blog_charset');
  $this->admin_option = basename(__FILE__);
  $this->admin_manage = 'manage_VideoPop_Files';
 }

 /*
 * Add menu item to WP admin panel
 */
 function addAdminMenu() {
  // Upload and Adminstration
  add_options_page(__('VideoPop+', 'videopop_plus'), __('VideoPop+', 'videopop_plus'), 9, $this->admin_option, array($this,'optionPage'));
  add_submenu_page('edit.php', __('My Videos', 'videopop_plus'), __('My Videos', 'videopop_plus'), $this->options['user_lvl'], $this->admin_manage, array($this,'manageVideoPopPlusFiles'),1);

  // Add link-chooser on selected pages
  if (strstr($_SERVER['PHP_SELF'], 'post.php') OR strstr($_SERVER['PHP_SELF'], 'page-new.php') OR strstr($_SERVER['PHP_SELF'], 'post-new.php') OR strstr($_SERVER['PHP_SELF'], 'page.php')){
   add_action('admin_head',array($this,'printHead'));
   add_action('admin_footer',array($this,'addChooser'));
  }
 }

 /*
 * Handles Add/strips slashes to the given array
 */
 function stripArray($array) {
  if(is_array($array)) {
   // If already slashed, strip.
   foreach($array as $key => $value) {$slashed_array[$key] = stripslashes($value);}
  } else {
   return $array;
  }
  return $slashed_array;
 }

 /*
 * Add css and js to admin head
 */
 function printHead() {
  // Open file and fill array with unserialized data
  $a_vids = unserialize(file_get_contents($this->data_txt));
  $js_array = '';
  $js_array_format = 'lynkvpArray[%1$d] = \'[videopop vid=%1$d vsize=%2$d vtitle="%3$s"%4$s]%3$s[/videopop]\';';
  $inline = '';

  if(!empty($a_vids)) {
   foreach($a_vids as $a_value) {
    $js_array .= sprintf($js_array_format, $a_value['lynkvp_id'], $a_value['lynkvp_size'], $a_value['lynkvp_name'],$inline);
   }//foreach
  }//if

  echo '<style type="text/css">'."\n";
  echo '#lynkvpBox1{/*position:absolute;top:18px;left:500px;*/float:left;background:#ffffff;padding:4px;border:1px solid black;z-index:99;margin:2px;}'."\n";
  echo '</style>'."\n";
  echo '<script type="text/javascript">';
  echo 'function lynkvpShowHide(id){opp = document.getElementById(id);if(opp.style.visibility=="hidden"){opp.style.display = "inline";opp.style.visibility = "visible";}else{opp.style.display = "none";opp.style.visibility = "hidden";}}lynkvpArray = new Array();'.$js_array;
  echo '</script>';
 }//func

 /*
 * Remove dir and all its contents
 */
 function lynkvp_removeDir($dir) {
  if($objs = glob($dir."/*")){
   foreach($objs as $obj) {is_dir($obj)? rmdirr($obj) : unlink($obj);}
  }
  rmdir($dir);
 }

 /*
 * HTML part1 for the Menu on the write pages
 */
 function addChooser() {
  echo '<div id="lynkvpBox1"><a href="#" onclick="lynkvpShowHide(\'lynkvpBox2\');return false;">'.__('Add VideoPop', 'videopop_plus').'</a>&nbsp;&nbsp;<div id="lynkvpBox2" style="visibility:hidden; display:none; background:#ffffcc">'.$this->getChooserData().'</div></div>'."\n";
  echo '<script language="JavaScript" type="text/javascript">';
  echo 'var pingBack = document.getElementById("pingback");';
  echo 'if (pingBack == null) var pingBack = document.getElementById("post_pingback");';
  echo 'var VideoPopLink = document.getElementById("lynkvpBox1");';
  echo 'pingBack.parentNode.insertBefore(VideoPopLink, pingBack);';
  echo '</script>'."\n";
 }

 /*
 * HTML part2 for the Menu on the write page; get the  links to the videos
 */
 function getChooserData() {
  $out  = '<select onchange="document.getElementById(\'lynkvpVidUrl\').value=lynkvpArray[this.value]">'."\n";
  $out .= '<option value="">'.__('Choose video', 'videopop_plus').'</a>'."\n";

  // Open file and fill array with unserialized data
  $a_vids = unserialize(file_get_contents($this->data_txt));

  if(!empty($a_vids)) {
   $a_vids = array_reverse($a_vids);
   foreach($a_vids as $a_value) {
    $out .= '<option value="'.$a_value['lynkvp_id'].'">'.$a_value['lynkvp_name'].'</option>';
   }
  }

  $out .= '</select><br />'."\n";
  $out .= '<input type="text" id="lynkvpVidUrl" style="width:500px;font-family:Arial;font-size:12px;" /><br />'."\n";
  $out .= '<div style="text-align:right;padding:2px;">'.__('Copy &amp; paste the code', 'videopop_plus').' &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.__('Close', 'videopop_plus').' <a href="#" onclick="lynkvpShowHide(\'lynkvpBox2\');return false;"><span style="border:1px solid black;padding:1px;">X</span></a></div>'."\n";

  return $out;
 }

 /*
 * Check/Create folder/files
 */
 function checkDir() {
  if(file_exists($this->data_txt)) {
   return true;
  } else {
   if(!is_writable(ABSPATH.'wp-content/')) {
    $this->note .= __("To use <strong>VideoPop+</strong>, the directory <strong>&quot;wp-content&quot;</strong> within your WordPress installation on your webserver must be writeable.<br /><br />To change permission, use a FTP program to access your websever and right-click on the directory <strong>&quot;wp-content&quot;</strong>.<br /> Tick all boxes that say &quot;Write&quot; or set the permission to <strong>777</strong>.", 'videopop_plus');
    $this->error++;
    return false;
   }

   // Create directory
   if(!file_exists(ABSPATH.$this->options['data_dir'])) {
    if(mkdir(ABSPATH.$this->options['data_dir'],0777)!=true) {
     $this->note .= __("The VideoPop+ directory couldn't be created with &quot;mkdir()&quot; on your server. The function could be disabled by your webhost or another restriction is in place. Ask your host.", 'videopop_plus');
     $this->error++;
     return false;
    }
   }

   // Write default file
   $handle = fopen($this->data_txt, 'w');
   if($handle==false) {
    $this->note .= __("The VideoPop+ files couldn't be created with &quot;fopen()&quot; on your server. The function could be disabled by your webhost or another restriction is in place. Ask your host.", 'videopop_plus');
    $this->error++;
    return false;
   } else {
    fwrite($handle,'N;');
    fclose($handle);
    return true;
   }
  }//else
 }//func

 /**
 * Validates form first input
 */
 function valInput() {
  switch(TRUE) {
  case (empty($_POST['lynkvp_name'])):
   $this->note .= __('Please enter a Name.', 'videopop_plus');
   return FALSE; break;
  case (empty($_FILES['lynkvp_file']['size']) && empty($_POST['lynkvp_url'])):
   $this->note .= __('Please choose a Video or enter an URL.', 'videopop_plus');
   return FALSE; break;
  case (empty($_POST['lynkvp_type'])):
   $this->note .= __('Please choose a Video Type.', 'videopop_plus');
   return FALSE; break;
  case ($_POST['lynkvp_size']==0):
   $this->note .= __('Please select a Size.', 'videopop_plus');
   return FALSE; break;
  default:
   return TRUE; break;
  }
 }

 /**
 * returns selected if value in POST array
 */
 function setOptionSelected($option,$value) {
  if (($option == $value)) {
   return ' selected="selected"';
  } else {
   return '';
  }
 }

 /**
 * returns selected if value in POST array
 */
 function getTypeSelect() {
  $retval  = '<tr>';
  $retval  .= ' <td>'.__('Video type', 'videopop_plus').':</td><td><select name="lynkvp_type">';
  $retval  .= ' <option value="0"'.$this->setOptionSelected($_POST['lynkvp_type'],'0').'>'.__('Select video type', 'videopop_plus').'</option>';
  $retval  .= ' <option value="asf"'.$this->setOptionSelected($_POST['lynkvp_type'],'asf').'>.asf</option>';
  $retval  .= ' <option value="avi"'.$this->setOptionSelected($_POST['lynkvp_type'],'avi').'>.avi</option>';
  $retval  .= ' <option value="mp4"'.$this->setOptionSelected($_POST['lynkvp_type'],'mp4').'>.mp4</option>';
  $retval  .= ' <option value="mpg"'.$this->setOptionSelected($_POST['lynkvp_type'],'mpg').'>.mpg</option>';
  $retval  .= ' <option value="mov"'.$this->setOptionSelected($_POST['lynkvp_type'],'mov').'>.mov</option>';
  $retval  .= ' <option value="rm"'.$this->setOptionSelected($_POST['lynkvp_type'],'rm').'>.rm</option>';
  $retval  .= ' <option value="swf"'.$this->setOptionSelected($_POST['lynkvp_type'],'swf').'>.swf</option>';

  if (file_exists(dirname(__FILE__).'/flvplayer.swf')) {
   $retval  .= ' <option value="flv"'.$this->setOptionSelected($_POST['lynkvp_type'],'flv').'>.flv</option>';
  }

  $retval  .= ' <option value="wmv"'.$this->setOptionSelected($_POST['lynkvp_type'],'wmv').'>.wmv</option>';
  $retval  .= ' <option value="3gp"'.$this->setOptionSelected($_POST['lynkvp_type'],'3gp').'>.3gp</option>';
  $retval  .= ' </select></td>';
  $retval  .= '</tr>';

  return $retval;
 }

 /*
 * Display option page body
 */
 function optionPage() {
  $out = $lynkvp_uninstall = '';

  // Check write permissions
  if($this->checkDir() != true) {
  } else {

   if(isset($_POST['lynkvp_options_update'])) {      // options update

    // strip slashes array
    $_POST = $this->stripArray($_POST);

    $this->options['user_lvl'] = $_POST['lynkvp_userlevel'];
    $this->options['show_option'] = $_POST['lynkvp_show'];
    //$this->options['data_dir'] = $_POST['lynkvp_datadir'];
    update_option($this->plugin_name." Options", $this->options);

    $_POST = '';
    $this->note .= __('<strong>Done!</strong>', 'videopop_plus');

   } elseif(isset($_POST['lynkvp_uninst'])) {         // uninstall
    $this->lynkvp_removeDir(ABSPATH.$this->options['data_dir']);
    $this->note .= __('All files and folders have (probably) been deleted. Now click <strong>Plugins</strong> in the admin panel above and <b>Deactivate</b> the VideoPop plugin.', 'videopop_plus');
    $this->error++;
    error_reporting(0);
   }
  }

  // Add Options
  $out .= '<div class="wrap">'."\n";
  $out .= '<h2>'.__('VideoPop+ Options', 'videopop_plus').'</h2><br />'."\n";
  $out .= '<form method="post" id="update_options" action="'.get_settings('siteurl')."/wp-admin/admin.php?page=".$this->admin_option.'">'."\n";

  // Add User Level
  //  Permission -- Subscriber = 0, Contributor = 1, Author = 2, Editor = 7, Administrator = 9
  $out .= '<h3>'.__('User Level', 'videopop_plus').'</h3>'."\n";
  $out .= '<p><select name="lynkvp_userlevel">';
  $out .= '<option value="0"'.$this->setOptionSelected($this->options['user_lvl'],'0').'>'.__('subscriber', 'videopop_plus').'</option>';
  $out .= '<option value="1"'.$this->setOptionSelected($this->options['user_lvl'],'1').'>'.__('contributor', 'videopop_plus').'</option>';
  $out .= '<option value="2"'.$this->setOptionSelected($this->options['user_lvl'],'2').'>'.__('author', 'videopop_plus').'</option>';
  $out .= '<option value="7"'.$this->setOptionSelected($this->options['user_lvl'],'7').'>'.__('editor', 'videopop_plus').'</option>';
  $out .= '<option value="9"'.$this->setOptionSelected($this->options['user_lvl'],'9').'>'.__('administrator', 'videopop_plus').'</option>';
  $out .= '</select>'."\n";
  $out .= __('Set the user level the user needs to have (at least) to manage/upload/delete videos', 'videopop_plus').'</p>'."\n";
  //$out .= '<p>'.__('User Level Permission -- Subscriber = 0, Contributor = 1, Author = 2, Editor = 7, Administrator = 9', 'videopop_plus').'<br /></p>'."\n";

  // Add Method of display
  $out .= '<h3>'.__('Method of display', 'videopop_plus').'</h3>'."\n";
  $out .= '<p><select name="lynkvp_show">';
  $out .= '<option value="popup"'.$this->setOptionSelected($this->options['show_option'],'popup').'>'.__('Pop up', 'videopop_plus').'</option>';
  $out .= '<option value="lightpop"'.$this->setOptionSelected($this->options['show_option'],'lightpop').'>'.__('LightPop', 'videopop_plus').'</option>';
  $out .= '<option value="modalbox"'.$this->setOptionSelected($this->options['show_option'],'modalbox').'>'.__('ModalBox', 'videopop_plus').'</option>';
  $out .= '<option value="inline"'.$this->setOptionSelected($this->options['show_option'],'inline').'>'.__('In line', 'videopop_plus').'</option>';
  $out .= '<option value="none"'.$this->setOptionSelected($this->options['show_option'],'none').'>'.__('The effect none', 'videopop_plus').'</option>';
  $out .= '</select>&nbsp;'."\n";
  $out .= __('Please select it from &quot;Pop up&quot;, &quot;LightPop&quot;, &quot;ModalBox&quot;, &quot;In line&quot;, and &quot;The effect none&quot;.', 'videopop_plus').'</p>'."\n";
  $out .= '<p>'.__("<strong>Attention:</strong> When &quot;ModalBox&quot; is selected, the installation of <a href='http://wildbit.com/demos/modalbox/' title='ModalBox - An easy way to create popups and wizards'>ModalBox.js</a> is separately needed.", 'videopop_plus').'<br /></p>'."\n";

  //// Add Data Directory Setting
  //$out .= '<h3>'.__('Data Directory', 'videopop_plus').'</h3>'."\n";
  //$out .= '<p>'.__('Please set the data directory.', 'videopop_plus').'<br /></p>'."\n";
  //$out .= '<input type="text" name="lynkvp_datadir" value="'.$this->options['data_dir'].'"/><br />'."\n";

  // Add Update Button
  $out .= '<div style="text-align:right"><input type="submit" name="lynkvp_options_update" value="'.__('Update Options', 'videopop_plus').'" class="button" style="font-size:11px;" /></div>';
  $out .= '</form></div>'."\n";

  // About the file of the video of the FLV form
  $out .= '<div class="wrap">'."\n";
  $out .= '<h2>'.__('About the file of the video of the FLV form', 'videopop_plus').'</h2><br />'."\n";
  $out .= '<p>'.__("It comes to be able to treat the file of the FLV form by preserving free <a href='http://www.jeroenwijering.com/?item=Flash_Video_Player&amp;' title='JW FLV Player'>JW FLV Player</a> in the same to plug-in directory. ", 'videopop_plus').'</p>'."\n";
  $out .= '</div>'."\n";

  // Add uninstall
  $out .= '<div class="wrap">'."\n";
  $out .= '<h2>'.__('Uninstall', 'videopop_plus').'</h2><br />'."\n";
  $out .= '<p>'.__('If you want to keep your videos and the popup functionality of your links but want to get rid of the additional menus in the control panel, just deactivate the plugin.<br />For a complete uninstall including all uploaded videos use the uninstall button.', 'videopop_plus').'</p>'."\n";
  $out .= '<div style="text-align:right"><form method="post" id="uninstall" action="'.get_settings('siteurl')."/wp-admin/admin.php?page=".$this->admin_option.'"><input type="submit" name="lynkvp_uninst" value="'.__('Uninstall VideoPop+', 'videopop_plus').'" onclick="javascript:check=confirm(\''.__('You are about to delete all your settings and Videos! The links you created with VideoPop will not work after uninstall! Proceed with uninstall?', 'videopop_plus').'\');if(check==false) return false;" class="button" style="font-size:11px;" /></form></div></div>'."\n";

  // Note snuff
  if(!empty($this->note)) {
   $this->note  = '<div id="message" class="updated fade"><p>'.$this->note.'</p></div>'."\n";
  }

  // If any error, dont display body
  if($this->error>0) {$out = '';}

  // Output
  echo $this->note."\n";
  echo $out."\n";
 }//func

 /*
 * Display manage page body
 */
 function manageVideoPopPlusFiles() {
  // Check write permissions
  if($this->checkDir() != true) {
  } else {

   // IF Video is uploaded
   if(isset($_POST['lynkvp_upload']) AND $this->valInput()) {
    // defaults
    $vid_url = '';
    $vid_file = '';
    $vid_id = time(); // use timestamp for unique id

    if(is_uploaded_file($_FILES['lynkvp_file']['tmp_name'])) {
     // Save file
     $vid_file = $vid_id.'.'.$_POST['lynkvp_type']; // filename+extension

     if(!move_uploaded_file($_FILES['lynkvp_file']['tmp_name'],ABSPATH.$this->options['data_dir'].$vid_file)) {
      $this->note .= __("The file couldn't be saved on your server", 'videopop_plus');
     }
    } elseif(!empty($_POST['lynkvp_url'])) {
     $vid_url = ltrim($_POST['lynkvp_url'],'http://');
    }

    // Open file and fill array with unserialized data
    $a_vids = unserialize(file_get_contents($this->data_txt));

    // Add data to array
    $a_vids[$vid_id]['lynkvp_id'] = $vid_id;
    $a_vids[$vid_id]['lynkvp_filename'] = $vid_file;
    $a_vids[$vid_id]['lynkvp_url'] = $vid_url;
    $a_vids[$vid_id]['lynkvp_type'] = $_POST['lynkvp_type'];
    $a_vids[$vid_id]['lynkvp_size'] = $_POST['lynkvp_size'];
    $a_vids[$vid_id]['lynkvp_name'] = $_POST['lynkvp_name'];
    $a_vids[$vid_id]['lynkvp_caption'] = $_POST['lynkvp_caption'];

    // Save ser. array
    $handle = fopen($this->data_txt, 'w');
    fwrite($handle,serialize($a_vids));
    fclose($handle);

    $_POST = '';
    $this->note .= __('<strong>Done!</strong>', 'videopop_plus');

   } elseif(isset($_POST['lynkvp_edit2'])) {
    if(empty($_POST['lynkvp_name'])) {
     $this->note .= __('Please edit again and enter a name.', 'videopop_plus');
     $_POST = '';

    } elseif(isset($_POST['lynkvp_type']) && empty($_POST['lynkvp_type'])) {
     $this->note .= __('Please edit again and select a video type.', 'videopop_plus');
     $_POST = '';

    } elseif(isset($_POST['lynkvp_url']) && empty($_POST['lynkvp_url']) ) {
     $this->note .= __('Please edit again and enter an URL.', 'videopop_plus');
     $_POST = '';

    } else {
     // Open file and fill array with unserialized data
     $a_vids = unserialize(file_get_contents($this->data_txt));
     $vid_id = $_POST['lynkvp_editid'];

     // Add data to array
     $a_vids[$vid_id]['lynkvp_id'] = $vid_id;
     $a_vids[$vid_id]['lynkvp_filename'] = $_POST['lynkvp_filename'];
     $a_vids[$vid_id]['lynkvp_url'] = $_POST['lynkvp_url'];
     $a_vids[$vid_id]['lynkvp_type'] = $_POST['lynkvp_type'];
     $a_vids[$vid_id]['lynkvp_size'] = $_POST['lynkvp_size'];
     $a_vids[$vid_id]['lynkvp_name'] = $_POST['lynkvp_name'];
     $a_vids[$vid_id]['lynkvp_caption'] = $_POST['lynkvp_caption'];

     // Save ser. array
     $handle = fopen($this->data_txt, 'w');
     fwrite($handle,serialize($a_vids));
     fclose($handle);

     $this->note .= __('<strong>Done!</strong>', 'videopop_plus');

     $_POST = array();
    }

   } elseif(isset($_POST['lynkvp_del'])) {
    // Get array data
    $a_vids = unserialize(file_get_contents($this->data_txt));
    $a_id = array_flip($_POST['lynkvp_del']);

    // Remove Video
    @unlink(ABSPATH.$this->options['data_dir'].$a_vids[$a_id[__('delete', 'videopop_plus')]]['lynkvp_filename']);

    foreach($a_vids as $key=>$value) {
     if($key!=$a_id[__('delete', 'videopop_plus')]) $a_vids2[$key] = $value;
    }

    // Save ser. images
    $handle = fopen($this->data_txt, 'w');
    fwrite($handle,serialize($a_vids2));
    fclose($handle);

    $this->note .= __('<strong>Done!</strong>', 'videopop_plus');

   }

   // IF edit
   if(isset($_POST['lynkvp_edit'])) {
    // Video ID
    $a_id = array_flip($_POST['lynkvp_edit']);

    // Get array data
    $a_vids = unserialize(file_get_contents($this->data_txt));

    // Populate POST
    $_POST = $a_vids[$a_id[__('edit', 'videopop_plus')]];

    // strip slashes array
    $_POST = $this->stripArray($_POST);

    $out_url = '';
    if(!empty($_POST['lynkvp_url'])) {
     $out_url =  '<tr>'."\n";
     $out_url .= '<td>'.__('URL', 'videopop_plus').':</td><td>http://<input type="text" name="lynkvp_url" value="'.$_POST['lynkvp_url'].'" style="width:400px;" /></td>'."\n";
     $out_url .= '</tr>'.$this->getTypeSelect()."\n";
    }

    $out .= '<div class="wrap" style="text-align:left;">'."\n";
    $out .= '<h2>'.__('Video Edit', 'videopop_plus').'</h2>'."\n";
    $out .= '<form method="post" action="'.get_settings('siteurl')."/wp-admin/admin.php?page=".$this->admin_manage.'" enctype="multipart/form-data">'."\n";
    $out .= '<input type="hidden" name="lynkvp_type" value="'.$_POST['lynkvp_type'].'" />'."\n";
    $out .= '<table border="0" cellpadding="2" cellspacing="0">'."\n";
    $out .= '<tr>'."\n";
    $out .= '<td>'.__('Name','videopop_plus').':</td><td><input type="text" name="lynkvp_name" value="'.$_POST['lynkvp_name'].'" /></td>'."\n";
    $out .= '</tr>'."\n";
    $out .= '<tr>'."\n";
    $out .= '<td>'.__('Caption','videopop_plus').':</td><td><input type="text" name="lynkvp_caption" value="'.$_POST['lynkvp_caption'].'" /></td>'."\n";
    $out .= '</tr>'."\n";
    $out .= $out_url."\n";
    $out .= '</table>'."\n";
    $out .= '<br />'."\n";
    $out .= '<input type="hidden" name="lynkvp_size" value="'.$_POST['lynkvp_size'].'" />'."\n";
    $out .= '<input type="hidden" name="lynkvp_editid" value="'.$_POST['lynkvp_id'].'" />'."\n";
    $out .= '<input type="hidden" name="lynkvp_filename" value="'.$_POST['lynkvp_filename'].'" />'."\n";
    $out .= '<input type="submit" name="lynkvp_edit2" value="'.__('edit', 'videopop_plus').'" />'."\n";
    $out .= '</form>'."\n";
    $out .= '</div>'."\n";

   } else {
    // BLOCK Upload
    $out .= '<div class="wrap" style="text-align:left;">'."\n";
    $out .= '<h2>'.__('Video Upload', 'videopop_plus').'</h2>'."\n";
    $out .= '<form method="post" action="'.get_settings('siteurl')."/wp-admin/admin.php?page=".$this->admin_manage.'" enctype="multipart/form-data">'."\n";
    $out .= '<table border="0" cellpadding="2" cellspacing="0">'."\n";
    $out .= '<tr>'."\n";
    $out .= '<td>'.__('Name', 'videopop_plus').':</td><td><input type="text" name="lynkvp_name" value="'.$_POST['lynkvp_name'].'" /></td>'."\n";
    $out .= '</tr>'."\n";
    $out .= '<tr>'."\n";
    $out .= '<td>'.__('Caption', 'videopop_plus').':</td><td><input type="text" name="lynkvp_caption" value="'.$_POST['lynkvp_caption'].'" /></td>'."\n";
    $out .= '</tr>'."\n";
    $out .= '<tr>'."\n";
    $out .= '<td>'.__('Choose video', 'videopop_plus').':</td><td><input type="file" name="lynkvp_file" />&nbsp;&nbsp;&nbsp;'."\n";
    $out .= __('<strong>or</strong>', 'videopop_plus').' &nbsp;&nbsp;'.__('URL', 'videopop_plus').':&nbsp;&nbsp;http://<input type="text" name="lynkvp_url" style="width:400px;" value="'.$_POST['lynkvp_url'].'" /></td>'."\n";
    $out .= '</tr>'."\n";
    $out .= $this->getTypeSelect()."\n";
    $out .= '<tr>'."\n";
    $out .= '<td>'.__('Size', 'videopop_plus').':</td><td><select name="lynkvp_size">'."\n";
    $out .= '<option value="0"'.$this->setOptionSelected($_POST['lynkvp_size'],'0').'>'.__('Select size', 'videopop_plus').'</option>'."\n";
    $out .= '<!-- Video sizes, one each line -->'."\n";
    $out .= '<option value="160"'.$this->setOptionSelected($_POST['lynkvp_size'],'160').'>160 x 120</option>'."\n";
    $out .= '<option value="320"'.$this->setOptionSelected($_POST['lynkvp_size'],'320').'>320 x 240</option>'."\n";
    $out .= '<option value="640"'.$this->setOptionSelected($_POST['lynkvp_size'],'640').'>640 x 480</option>'."\n";
    $out .= '<option value="719"'.$this->setOptionSelected($_POST['lynkvp_size'],'719').'>720 x 540</option>'."\n";
    $out .= '<option value="450"'.$this->setOptionSelected($_POST['lynkvp_size'],'450').'>450 x 252 [16:9 - 1.78:1]</option>'."\n";
    $out .= '<option value="480"'.$this->setOptionSelected($_POST['lynkvp_size'],'480').'>480 x 260 [16:9 - 1.85:1]</option>'."\n";
    $out .= '<option value="720"'.$this->setOptionSelected($_POST['lynkvp_size'],'720').'>720 x 405 [16:9 - 1.78:1]</option>'."\n";
    $out .= '<option value="721"'.$this->setOptionSelected($_POST['lynkvp_size'],'721').'>720 x 390 [16:9 - 1.85:1]</option>'."\n";
    $out .= '</select></td>'."\n";
    $out .= '</tr>'."\n";
    $out .= '</table>'."\n";
    $out .= '<br />'."\n";
    $out .= '<input type="submit" name="lynkvp_upload" class="button" value="'.__('Upload', 'videopop_plus').'" />'."\n";
    $out .= '</form>'."\n";
    $out .= '</div>'."\n";
   }

   // ---------
   // ALWAYS DISPLAYED

   // BLOCK Your Videos
   $out .= '<div class="wrap" style="text-align:left;">'."\n";
   $out .= '<h2>'.__('My Videos', 'videopop_plus').'</h2>'."\n";
   $out .= '<form method="post" action="'.get_settings('siteurl')."/wp-admin/admin.php?page=".$this->admin_manage.'">'."\n";

   // Get video data
   $a_vids = unserialize(file_get_contents($this->data_txt));

   // If any vids uploaded
   if(is_array($a_vids)) {
    $a_vids = array_reverse($a_vids);

    $out .= '<table>';
    foreach($a_vids as $key => $a_value) {
     // strip slashes
     $a_value = $this->stripArray($a_value);

     $src = '../wp-content/videopop/'.$a_value['lynkvp_filename'];
     $is_type = '';
     if(!empty($a_value['lynkvp_url'])) {
      $src = 'http://'.$a_value['lynkvp_url'];
      $is_type = '<span style="font-size:10px;">URL</span>';
     }

     $out .= '<tr>'."\n";
     $out .= '<td><a href="'.$src.'" target="_blank">'.$a_value['lynkvp_name'].'</a>&nbsp;&nbsp;</td>'."\n";
     $out .= '<td>'.$is_type.'</td>'."\n";
     $out .= '<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type="submit" value="'.__('delete', 'videopop_plus').'" name="lynkvp_del['.$a_value['lynkvp_id'].']" onclick="javascript:check=confirm(\''.__('The links you created will not work anymore. Delete?', 'videopop_plus').'\');if(check==false) return false;" class="button" style="font-size:10px;" />&nbsp;&nbsp;&nbsp;<input type="submit" value="'.__('edit', 'videopop_plus').'" name="lynkvp_edit['.$a_value['lynkvp_id'].']" class="button" style="font-size:10px;" /></td>'."\n";
     $out .= '</tr>'."\n";
    }
    $out .= '</table>'."\n";
   }

   $out .= '</form>'."\n";
   $out .= '</div>'."\n";
  }//else

  // Note snuff
  if(!empty($this->note)) {
   $this->note  = '<div id="message" class="updated fade"><p>'.$this->note.'</p></div>'."\n";
  }

  // If any error, dont display body
  if($this->error>0) {$out = '';}

  // Output
  echo $this->note."\n";
  echo $out."\n";
 }//func

 /*
 * Set Videopop Script
 */
 function addHeadJs($unused) {
  if (!(is_404() || is_page())) {
   switch($this->options['show_option']) {
   case "lightpop":
    echo '<script type="text/javascript" src="'.$this->plugin_uri.'/lightpop/lightpop.php?js"></script>'."\n";
    echo '<link rel="stylesheet" href="'.$this->plugin_uri.'/lightpop/lightpop.php?css" type="text/css" media="screen" />'."\n";
    echo '<script type="text/javascript">';
    echo "function VideoPop(vpsize,vpid){";
    echo " url = '".$this->plugin_uri."/videopop.php?vid='+vpid;";
    echo " if (window.LightPop){";
    echo " xwidth = vpsize+110; xheight = Math.round(vpsize/1.3)+74;";
    echo " LightPop.show(url, xwidth, xheight);";
    echo " } else {";
    echo " xwidth = vpsize+110; xheight = (vpsize/1.3)+94;";
    echo " lvp = window.open(url,'','top=100,left=100,status=0,location=0,width='+xwidth+',height='+xheight+'');";
    echo " lvp.focus();";
    echo " }";
    echo "}";
    echo "</script>"."\n";
    break;

   case "modalbox":
    if (file_exists(dirname(__FILE__).'/modalbox.js') && file_exists(dirname(__FILE__).'/modalbox.css')) {
     echo '<script type="text/javascript" src="'.$this->plugin_uri.'/modalbox.js"></script>'."\n";
     echo '<link rel="stylesheet" href="'.$this->plugin_uri.'/modalbox.css" type="text/css" media="screen" />'."\n";
    }
    echo '<script type="text/javascript">';
    echo "function VideoPop(vpsize,vpid){";
    echo " if (window.Modalbox){";
    echo " url = '".$this->plugin_uri."/videopop.php';";
    echo " xwidth = vpsize+110; xheight = Math.round(vpsize/1.3)+124;";
    echo " xoptions = {title: 'VideoPop', width: xwidth, height: xheight, params: {vid: vpid}};";
    echo " Modalbox.show(url, xoptions);";
    echo " } else {";
    echo " url = '".$this->plugin_uri."/videopop.php?vid='+vpid;";
    echo " xwidth = vpsize+110; xheight = (vpsize/1.3)+94;";
    echo " lvp = window.open(url,'','top=100,left=100,status=0,location=0,width='+xwidth+',height='+xheight+'');";
    echo " lvp.focus();";
    echo " }";
    echo "}";
    echo "</script>"."\n";
    break;

   case "popup":
    echo '<script type="text/javascript">';
    echo "function VideoPop(vpsize,vpid){";
    echo " url = '".$this->plugin_uri."/videopop.php?vid='+vpid;";
    echo " xwidth = vpsize+110; xheight = (vpsize/1.3)+94;";
    echo " lvp = window.open(url,'','top=100,left=100,status=0,location=0,width='+xwidth+',height='+xheight+'');";
    echo " lvp.focus();";
    echo "}";
    echo "</script>"."\n";
    break;

   case "inline":
    break;

   default:
    break;
   }
  }
 }//func

 /*
 * Content Filter
 */
 function addContentFilter($content) {
  global $wpdb, $id, $page;

  $link_format = '';
  $inline = false;
  switch($this->options['show_option']) {
  case "lightpop":
  case "modalbox":
  case "popup":
   $link_format = '<a href="'.$this->plugin_uri.'/videopop.php?vid=%1$d" title="%2$s" onclick="javascript:VideoPop(%3$d,\'%1$d\');return false;">%4$s</a>';
   break;
  case "inline":
   $inline = true;
   break;
  default:
   $link_format = '<a href="'.$this->plugin_uri.'/videopop.php?vid=%1$d" title="%2$s">%4$s</a>';
   break;
  }

  // videopop tag found
  if (strstr(strtolower($content),'[/videopop]')) {
   $content = mb_convert_encoding($content, "UTF-8", $this->blog_charset);

   $pattern = '/\[videopop(.*)\](.*)\[\/videopop\]/i';
   $matches = '';

   if(preg_match_all($pattern, $content, $matches)) {
    for ($i=0; $i<count($matches[0]); $i++) {
     // get options
     $options = explode(" v",$matches[1][$i]);
     $vid = 0;
     $vsize = 320;
     $vtitle = $matches[2][$i];
     for ($j=0; $j<count($options); $j++) {
      if (strstr(strtolower($options[$j]),'id')) {
        $vid = preg_replace('/id=(.*)/i', '$1', $options[$j]);
      } elseif (strstr(strtolower($options[$j]),'size')) {
        $vsize = preg_replace('/size=(.*)/i', '$1', $options[$j]);
      } elseif (strstr(strtolower($options[$j]),'title')) {
        $vtitle = preg_replace('/title=\&.*;(.*)\&.*;/i', '$1', $options[$j]);
      } elseif (strstr(strtolower($options[$j]),'inline')) {
        $inline = strstr(strtolower($options[$j]),'true') != false;
      }
     }

     $search_strings[$i] = '/' . preg_quote($matches[0][$i], '/') . '/';
     if ($inline) {
      $replace_strings[$i]  = getVideoPopObject($vid,false);
     } else {
      $replace_strings[$i]  = sprintf($link_format, $vid, $vtitle, $vsize, $matches[2][$i]);
     }
    }

    $content = preg_replace($search_strings, $replace_strings, $content);
   }
   $content = mb_convert_encoding($content, $this->blog_charset, "UTF-8");

  } elseif (strstr($content, 'class="lynkvp"')) {
   $content = mb_convert_encoding($content, "UTF-8", $this->blog_charset);

   $pattern = '/<a href="javascript:lynkVideoPop\(([0-9]*),\'([0-9]*)\'\);" class="lynkvp">(.*)<\/a>/i';
   $matches = '';

   if(preg_match_all($pattern, $content, $matches)) {
    for ($i=0; $i<count($matches[0]); $i++) {
     // get options
     $vid = $matches[2][$i];
     $vsize = $matches[1][$i];
     $vtitle = $matches[3][$i];

     $search_strings[$i] = '/' . preg_quote($matches[0][$i], '/') . '/';
     $replace_strings[$i]  = sprintf($link_format, $vid, $vtitle, $vsize, $matches[2][$i]);
    }
    $content = preg_replace($search_strings, $replace_strings, $content);
   }

   $content = mb_convert_encoding($content, $this->blog_charset, "UTF-8");
  }

  return $content;
 }//func

}//class

// Go, Go, Go!
$VideoPopPlus = & new VideoPopPlusController();

add_action('admin_menu', array(&$VideoPopPlus,'addAdminMenu'));
add_action('wp_head',array(&$VideoPopPlus, 'addHeadJs'));
add_filter('the_content',array(&$VideoPopPlus, 'addContentFilter'));
?>