<?php
/*
Plugin Name: WP-AutoPager
Version: 0.2.0
Plugin URI: http://wppluginsj.sourceforge.jp/wp-autopager/
Description: Add autoloading for next page to Wordpress. DblClick to enable/disable it.
Author: wokamoto
Author URI: http://dogmap.jp/

 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

 this script based on
 GoogleAutoPager(http://la.ma.la/blog/diary_200506231749.htm)
 thanks to ma.la.
*/

class AutoPagerController {
  var $plugin_name = 'wp-autopager';
  var $options = array();
  var $note,$error;

  /*
  * Constructor
  */
  function AutoPagerController() {
    $this->note = '';
    $this->error = 0;
    $wkoptions = get_option($this->plugin_name." Options");
    if (!is_array($wkoptions)) {
      $this->options['content_id'] = "content";
      $this->options['post_class'] = "post";
      $this->options['navigation_class'] = "navigation";
      $this->options['remain'] = 500;
      $this->options['default_enable'] = 1;
      $this->options['plugin_uri'] = trailingslashit(get_settings('siteurl')).'wp-content/plugins/'.basename(dirname(__FILE__));
      $this->update_options();
    } else {
      $this->options = $wkoptions;
    }
  }

  /*
  * Handles Add/strips slashes to the given array
  */
  function stripArray($array) {
    if(is_array($array)) {
      // If already slashed, strip.
      foreach($array as $key => $value) {$slashed_array[$key] = stripslashes($value);}
    } else {
      return $array;
    }
    return $slashed_array;
  }

  function update_options() {
    update_option($this->plugin_name." Options", $this->options);
    $this->autopagerJs_write();
  }

  function addHeadJs() {
    if (!is_404() && !is_single() && !is_page() ) {
      if (have_posts()){
        echo '<script type="text/javascript" src="'.$this->options['plugin_uri'].'/wp-autopager.js" charset="UTF-8"></script>'."\n";
      } else {
        header("HTTP/1.1 404 Not Found");
      }
    }
  }

  function addFooterJs() {
    if (!is_404() && !is_single() && !is_page() ) {
      if (have_posts()){
        global $request, $posts_per_page, $wpdb, $paged;

        // get Max Page
        $numposts = 0;
        if(strpos(get_query_var('tag'), " ")) {
          preg_match('#^(.*)\sLIMIT#siU', $request, $matches);
          $fromwhere = $matches[1];
          $results = $wpdb->get_results($fromwhere);
          $numposts = count($results);
        } else {
          preg_match('#FROM\s*+(.+?)\s+(GROUP BY|ORDER BY)#si', $request, $matches);
          $fromwhere = $matches[1];
          $numposts = $wpdb->get_var("SELECT COUNT(DISTINCT ID) FROM $fromwhere");
        }
        $max_page = ceil($numposts/$posts_per_page);

        // get Next Page No.
        if(empty($paged)) {$paged = 1;}
        $next_page = $paged + 1;

        // get Query String
        $query = get_pagenum_link($next_page);
        if (strstr($query,"/page/") != false) {
            preg_match("/(.+page\/)(\d+)/i", $query, $matches);
            $query = $matches[1];
            $next_page = $matches[2];
        } else {
          if (strstr($query,"paged=") != false) {
            preg_match("/(.+paged=)(\d+)/i", $query, $matches);
            $query = $matches[1];
            $next_page = $matches[2];
          } else {
            if (strstr($query,"?")) {
              $query = $query."&paged=";
            }
          }
        }

        echo '<script type="text/javascript">autopager("'.$query.'",'.$next_page.','.$max_page.');</script>'."\n";
      }
    }
  }

  function addAdminMenu() {
    add_options_page(__('WP-AutoPager', 'wp-autopager'), __('WP-AutoPager', 'wp-autopager'), 9, basename(__FILE__), array($this,'optionPage'));
  }

  function optionPage() {
    if(isset($_POST['ap_options_update'])) {      // options update
      // strip slashes array
      $_POST = $this->stripArray($_POST);

      $this->options['content_id'] = $_POST['ap_content_id'];
      $this->options['post_class'] = $_POST['ap_post_class'];
      $this->options['navigation_class'] = $_POST['ap_navigation_class'];
      $this->options['remain'] = $_POST['ap_remain'];
      $this->options['default_enable'] = $_POST['ap_default_enable'] == 1;
      $this->options['plugin_uri'] = trailingslashit(get_settings('siteurl')).'wp-content/plugins/'.basename(dirname(__FILE__));
      $this->update_options();

      $_POST = '';
      $this->note .= __('<strong>Done!</strong>', 'wp-autopager');
    }

    // Add Options
    $out .= '<div class="wrap">'."\n";
    $out .= '<h2>'.__('WP-AutoPager Options', 'wp-autopager').'</h2><br />'."\n";
    $out .= '<form method="post" id="update_options" action="'.$_SERVER['REQUEST_URI'].'">'."\n";

    $out .= '<table>'."\n";

    $out .= '<tr><td><strong>'.__('Content ID', 'wp-autopager').'</strong></td>';
    $out .= '<td><input type="text" name="ap_content_id" value="'.$this->options['content_id'].'"/></td>';
    $out .= '<td></td></tr>'."\n";

    $out .= '<tr><td><strong>'.__('Posts Class', 'wp-autopager').'</strong></td>';
    $out .= '<td><input type="text" name="ap_post_class" value="'.$this->options['post_class'].'"/></td>';
    $out .= '<td></td></tr>'."\n";

    $out .= '<tr><td><strong>'.__('Navigation Class', 'wp-autopager').'</strong></td>';
    $out .= '<td><input type="text" name="ap_navigation_class" value="'.$this->options['navigation_class'].'"/></td>';
    $out .= '<td></td></tr>'."\n";

    $out .= '<tr><td><strong>'.__('Remain', 'wp-autopager').'</strong></td>';
    $out .= '<td><input type="text" name="ap_remain" value="'.$this->options['remain'].'"/></td>';
    $out .= '<td>'.__('Position in which lookahead is begun(relative value px from the bottom of a browser)', 'wp-autopager').'</td></tr>'."\n";

    $out .= '<tr><td><strong>'.__('Default Enable', 'wp-autopager').'</strong></td>';
    $out .= '<td><select name="ap_default_enable">';
    $out .= '<option value="0"'.($this->options['default_enable']==0?' selected="selected"':'').'>'.__('disable', 'wp-autopager').'</option>';
    $out .= '<option value="1"'.($this->options['default_enable']==1?' selected="selected"':'').'>'.__('enable', 'wp-autopager').'</option>';
    $out .= '</select></td>';
    $out .= '<td>'.__('Whether operation is enabled when the page is displayed is set.', 'wp-autopager').'</td></tr>'."\n";

    $out .= '</table>'."\n";

    // Add Update Button
    $out .= '<div style="text-align:right"><input type="submit" name="ap_options_update" value="'.__('Update Options', 'wp-autopager').'" class="button" style="font-size:11px;" /></div>';
    $out .= '</form></div>'."\n";

    // Add Usage
    $out .= '<div class="wrap">'."\n";
    $out .= '<h2>'.__('Usage', 'wp-autopager').'</h2><br />'."\n";
    $out .= '<p>'.__('If it is a default template base, it operates yet in there is no template correction.', 'wp-autopager').'<br />'."\n";
    $out .= __('If the structure of HTML is as follows, it is OK.', 'wp-autopager').'</p>'."\n";

    $out .= '<div style="border:1px solid gray;background-color:#F9F7ED;width:auto;_width:95%;margin:0.25em;padding:0.25em;">'."\n";
    $out .= '&lt;html&gt;<br />'."\n";
    $out .= '&lt;head&gt;</p>'."\n";
    $out .= '<div style="padding-left:3em;">F</div>'."\n";
    $out .= '<p>&lt;/head&gt;<br />'."\n";
    $out .= '&lt;body&gt;</p>'."\n";
    $out .= '<div style="padding-left:3em;">F</div>'."\n";
    $out .= '<div style="border:1px solid gray;background-color:#F9F7DD;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>id=&#8221;content&#8221;</strong></em>&gt;</p>'."\n";
    $out .= '<div style="padding-left:3em;">F</div>'."\n";

    $out .= '<div style="border:1px solid gray;background-color:#F9F7AA;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>class=&#8221;post&#8221;</strong></em> id=&#8221;post-???&#8221;&gt;&#8230;'.__('Content of post', 'wp-autopager').'&#8230;&lt;/div&gt;</div>'."\n";
    $out .= '<div style="border:1px solid gray;background-color:#F9F7AA;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>class=&#8221;post&#8221;</strong></em> id=&#8221;post-???&#8221;&gt;&#8230;'.__('Content of post', 'wp-autopager').'&#8230;&lt;/div&gt;</div>'."\n";

    $out .= '<div style="border:1px solid gray;background-color:#F9F7AA;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>class=&#8221;post&#8221;</strong></em> id=&#8221;post-???&#8221;&gt;&#8230;'.__('Content of post', 'wp-autopager').'&#8230;&lt;/div&gt;</div>'."\n";
    $out .= '<div style="padding-left:3em;">F</div>'."\n";
    $out .= '<div style="border:1px solid gray;background-color:#F9F7BB;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>class=&#8221;navigation&#8221;</strong></em>&gt;&#8230;'.__('Page navigation', 'wp-autopager').'&#8230;&lt;/div&gt;</div>'."\n";

    $out .= '<p>&lt;/div&gt;</div>'."\n";
    $out .= '<div style="padding-left:3em;">F</div>'."\n";
    $out .= '<p>&lt;/body&gt;<br />'."\n";
    $out .= '&lt;/html&gt;'."\n";
    $out .= '</div>'."\n";

    $out .= '</div>'."\n";

    // Note snuff
    if(!empty($this->note)) {
      $this->note  = '<div id="message" class="updated fade"><p>'.$this->note.'</p></div>'."\n";
    }

    // If any error, dont display body
    if($this->error>0) {$out = '';}

    // Output
    echo $this->note."\n";
    echo $out."\n";
  }

  function autopagerJs() {
    $out_tmpl = '// wp-autopager.js
//  Released under the GPL license
//   http://www.gnu.org/copyleft/gpl.html

//  this script based on
//   GoogleAutoPager(http://la.ma.la/blog/diary_200506231749.htm)
//   thanks to ma.la.

function autopager(q,n,m){
  var query;
  var next_page = 0;
  var max_page = 0;
  var insertPoint;
  var Enable = %1$s;
  var loading = false;
  var last_page = false;

  // Array.prototype.contains()
  // Whether the value that exists in the array is included is examined.
  // Core code from - Reread (http://text.readalittle.net/article.php?id=135)
  if(!Array.prototype.contains){
    Array.prototype.contains = function(value){
      for(var i in this){if(this.hasOwnProperty(i) && this[i]===value){return true;}}
      return false;
    }
  }

  // getPageScroll()
  // Returns array with x,y page scroll values.
  // Core code from - quirksmode.org
  var getPageScroll = function(){
    var xScroll,yScroll;
    if (window.pageYOffset) {
      xScroll = window.pageXOffset;
      yScroll = window.pageYOffset;
    } else if (document.documentElement && document.documentElement.scrollTop){
      // Explorer 6 Strict
      xScroll = document.documentElement.scrollLeft;
      yScroll = document.documentElement.scrollTop;
    } else if (document.body) {
      // all other Explorers
      xScroll = document.body.scrollLeft;
      yScroll = document.body.scrollTop;
    }
    arrayPageScroll = new Array(xScroll,yScroll);
    return arrayPageScroll;
  }

  // getPageSize()
  // Returns array with page width, height and window width, height
  // Core code from - quirksmode.org
  var getPageSize = function(){
    var xScroll, yScroll;
    if (window.innerHeight && window.scrollMaxY) {
      xScroll = document.body.scrollWidth;
      yScroll = window.innerHeight + window.scrollMaxY;
    } else if (document.body.scrollHeight > document.body.offsetHeight){
      // all but Explorer Mac
      xScroll = document.body.scrollWidth;
      yScroll = document.body.scrollHeight;
    } else {
      // Explorer Mac...would also work in Explorer 6 Strict, Mozilla and Safari
      xScroll = document.body.offsetWidth;
      yScroll = document.body.offsetHeight;
    }
    var windowWidth, windowHeight;
    if (window.innerHeight) {
      // all except Explorer
      windowWidth = window.innerWidth;
      windowHeight = window.innerHeight;
    } else if (document.documentElement && document.documentElement.clientHeight) {
      // Explorer 6 Strict Mode
      windowWidth = document.documentElement.clientWidth;
      windowHeight = document.documentElement.clientHeight;
    } else if (document.body) {
      // other Explorers
      windowWidth = document.body.clientWidth;
      windowHeight = document.body.clientHeight;
    }	
    // for small pages with total height less then height of the viewport
    pageHeight = (yScroll < windowHeight) ? windowHeight : yScroll;
    // for small pages with total width less then width of the viewport
    pageWidth = (xScroll < windowWidth) ? windowWidth : xScroll;

    arrayPageSize = new Array(pageWidth,pageHeight,windowWidth,windowHeight);
    return arrayPageSize;
  }

  var watch_scroll = function(){
    if (last_page == true) {
      return;
    } else if (loading == false ) {
      var aryPageSize = getPageSize();
      var aryPageScroll = getPageScroll();
      var remain = aryPageSize[1] - aryPageSize[3] - aryPageScroll[1];
      if(remain < %2$s && Enable){do_request();}
      var self = arguments.callee;
      setTimeout(self,100);
    } else {
      var self = arguments.callee;
      setTimeout(self,5000);
    }
  };

  var do_request = function(){
    var xmlhttp;

    // Get Next Page
    try{
      try{
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
      }catch(e){
        xmlhttp = new XMLHttpRequest();
      }

      // XMLHttpRequest state change
      xmlhttp.onreadystatechange = function(){
        if(xmlhttp.readyState == 1 && loading == false) {
          loading = true;

          // Display Now Loading...
          window.status = "loading ... " + (next_page - 1) +" - " + next_page;
          var p = document.createElement("p");
          var img = document.createElement("img");
          img.setAttribute("src","%3$s/ajax-loader.gif");
          img.setAttribute("alt","Now Loading...");
          img.setAttribute("style","float:left;margin-right:0.5em;");
          p.appendChild(img);
          p.appendChild(document.createTextNode("Now Loading..."));
          insertPoint.innerHTML="";
          insertPoint.appendChild(p);
        }
        if(xmlhttp.readyState == 4) {
          if(xmlhttp.status == 200) {
            var xmlString = xmlhttp.responseText.replace(/[\r\n]/g,"").replace(/.*<body.*?>(.*?)<\/body>.*$/, "$1");
            var newDoc = document.createElement("div");
            newDoc.innerHTML = xmlString;

            var div = newDoc.getElementsByTagName("div");
            var len = div.length;
            for(var i=0; i<len; i++){
              if(div[i].className.split(" ").contains("%4$s")){
                insertPoint.parentNode.insertBefore(div[i],insertPoint);
                i--;len = div.length;
              }
              if(div[i].className.split(" ").contains("%5$s")){
                insertPoint.innerHTML = div[i].innerHTML;
                break;
              }
            }

            window.status = "loading ... " + (next_page - 1) +" - " + next_page + " done.";
            next_page ++;
          } else {
            last_page = true;
            insertPoint.innerHTML = "";
          }
          if (max_page != 0 && next_page > max_page) {
           last_page = true;
           insertPoint.innerHTML = "";
          }
          loading = false;
        }
      };

      // XMLHttpRequest
      var href = query+next_page;
      if(href.indexOf("/page/")!=-1) {href = href + "/";}
      href = href.replace("&amp;","&");
      xmlhttp.open("GET", href, true);
      xmlhttp.send(null);

    }catch (e){

    }
  };

  var init_autopager = function(){
    next_page = 0;

    // find insertpoint
    var not_found = true;
    var content = document.getElementById("%6$s");
    var div = content.getElementsByTagName("div");
    var len = div.length;
    for(var i=0;i<len;i++){
      if(div[i].className.split(" ").contains("%5$s")){
        insertPoint = div[i];
        not_found = false;
        break;
      }
    }
    if (not_found) {
      insertPoint = document.createElement("div");
      insertPoint.setAttribute("class","%5$s");
      content.appendChild(insertPoint);
    }

    // find next link
    if (q!="") {
      query = q;
      next_page = n;
      max_page = m;
      last_page = (max_page != 0 && next_page > max_page);
    } else {
      var a = insertPoint.getElementsByTagName("a");
      var len = a.length;
      for(var i=0;i<len;i++){
        var href = a[i].href;
        if(href.indexOf("/page/")!=-1) {
         var temp = href.match(/^(.+\/)(\d+)\/$/);
         query = temp[1];
         next_page = (temp[2]-0 > next_page) ? temp[2]-0 : next_page;
        }
        if(href.indexOf("paged=")!=-1) {
         var temp = href.match(/^(.+paged=)(\d+)$/);
         query = temp[1];
         next_page = (temp[2]-0 > next_page) ? temp[2]-0 : next_page;
        }
      }
    }

    if (next_page > 0 && last_page == false) {
      // attach Event (Double Click)
      if(document.body.attachEvent){
        document.body.attachEvent(
          "ondblclick",function(){
            Enable = Enable?false:true;
            window.status = (Enable)?"Enabled":"Disabled"
          }
        );
      }else{
        document.body.addEventListener(
          "dblclick",function(){
            Enable = Enable?false:true;
            window.status = (Enable)?"Enabled":"Disabled"
          },true
        );
      };

      // start watch scroll
      watch_scroll();
    }
  };

  // init 
  init_autopager();
};';
    
    return sprintf($out_tmpl, ($this->options['default_enable']==1?'true':'false'), $this->options['remain'], $this->options['plugin_uri'], $this->options['post_class'], $this->options['navigation_class'], $this->options['content_id']);
  }

  function autopagerJs_write() {
    $filename = dirname(__FILE__)."/wp-autopager.js";
    $retVal = TRUE;

    if (is_writable($filename)) {
      if (!$handle = fopen($filename, 'w')) {
        $retVal = FALSE;
      } else {
        if (fwrite($handle, $this->autopagerJs()) === FALSE) {$retVal = FALSE;}
        fclose($handle);
      }
    } else {
      $retVal = FALSE;
    }
    return $retVal;
  }

}//class

load_plugin_textdomain('wp-autopager','wp-content/plugins/wp-autopager');

$wpAutoPager = & new AutoPagerController();

add_action('admin_menu', array(&$wpAutoPager,'addAdminMenu'));
add_action('wp_head',array(&$wpAutoPager, 'addHeadJs'));
add_action('wp_footer',array(&$wpAutoPager, 'addFooterJs'));
?>
