<?php

	// Get the plugin's options
	$mm_opt = get_option('plugin_maintenancemode');
 
	// Get message
	function maintenance_get_message($type) {

		global $mm_opt;

		$message = $mm_opt[$type];	// Get message according to provided type

		$message = stripslashes($message); // remove slashes
		
		// Replace place holders
		$message = str_replace('[blogurl]', get_settings('home'), $message);
		$message = str_replace('[blogtitle]', get_bloginfo('name'), $message);
		$message = str_replace('[backtime]', $mm_opt['mwmm_backtime'], $message);
		
		// Finished
		echo "\n" . $message . "\n";
	}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<head profile="http://gmpg.org/xfn/11">
	<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
	<meta name="description" content="<?php bloginfo('description'); ?>" />
	<title><?php bloginfo('name'); ?> &raquo; <?php echo $mm_opt['mwmm_langtitle'];  if ($mm_opt['mwmm_applyaltlang']) echo ' / ' . $mm_opt['mwmm_langalttitle']; ?></title>
	
	<style type="text/css">
		<!--
		* {
			margin: 0;
			padding: 0;
		}
		
		body {
			font-family: Georgia, Arial, Helvetica, Sans Serif;
			font-size: 65.5%;
		}
		
		a {
			color: #08658F;
		}
		
		a:hover {
			color: #0092BF;
		}
		
		#header {
			color: #333;
			padding: 1.5em;
			text-align: center;
			font-size: 1.2em;
			border-bottom: 1px solid #08658F;
		}
		
		#content {
			font-size: 150%;
			width:80%;
			margin:0 auto;
			padding: 5% 0;
			text-align: center;
		}
		
		#content p {
			font-size: 1em;
			padding: .8em 0;
		}
		
		h1, h2 {
			color: #08658F;
		}
		
		h1 {
			font-size: 300%;
			padding: .5em 0;
		}
		
		#footer {
			position: absolute;
			font-family: Arial, Helvetica, Sans Serif;
			bottom: 2em;
			width: 100%;
			border-top: 1px solid #08658F;
		}

		#footer #pluginauthor {
			padding-left: .3em;
		}

		#footer #admin {
			float: right;
			padding-right: .3em;
		}


		-->
	</style>
	
</head>

<body>

	<div id="header">
		<h2><a title="<?php bloginfo('name'); ?>" href="<?php echo get_settings('home'); ?>"><?php bloginfo('name'); ?></a></h2>
	</div>
	

	<div id="content">

	<?php 
	
		// ---------- MAIN LANGUAGE --------------------------------------------
	
		maintenance_get_message('mwmm_langmessage');
			

		// ---------- SECOND LANGUAGE ------------------------------------------
 
		if ($mm_opt['mwmm_applyaltlang']) {
			maintenance_get_message('mwmm_langaltmessage');
		}

	?>

	</div>

	<div id="footer">
		<p id="admin"><a href="<?php echo get_settings('home'); ?>/wp-admin/">Administration</a></p>
		<p id="pluginauthor">Maintenance Mode plugin provided by <a href="http://sw-guide.de/wordpress/maintenance-mode-plugin/">Software Guide</a>.</p>
	</div>

</body>
</html>