<?php

/*
Plugin Name: WP-AddQuicktag (ja)
Version: 0.4
Plugin URI: http://wppluginsj.sourceforge.jp/add-quicktag/
Description: This plugin makes it easy to add extra quicktags via the options menu in your Wordpress administration. <a href="options-general.php?page=wp-addquicktag.php">Options --> Add Quicktags</a> WordPress.
Author: <a href="http://roel.meurders.nl/" >Roel Meurders</a> and <a href="http://bueltge.de" >Frank Bueltge</a> and <a href="http://mikebrowne.com/wp/">Mike Browne</a> and i18ned by <a href="http://xn--65q67bs6i.jp/">Otsukare</a>.
*/

// SCRIPT INFO ///////////////////////////////////////////////////////////////////////////
/*
	WP-AddQuicktag for Wordpress
	(C) 2005 Roel Meurders - GNU General Public License

	Translate to German and little mofifikations - Frank Bueltge
	
	Translated back to English by Mike Browne

	This Wordpress plugin is released under a GNU General Public License. A complete version of this license
	can be found here: http://www.gnu.org/licenses/gpl.txt

	This Wordpress plugin has been tested with Wordpress 1.5.2 and Wordpress 2.0;

	This Wordpress plugin is released "as is". Without any warranty. The author cannot
	be held responsible for any damage that this script might cause.

*/
// NO EDITING HERE!!!!! ////////////////////////////////////////////////////////////////

if(function_exists('load_plugin_textdomain')) {
	load_plugin_textdomain('aqt');
}

add_action('admin_menu', 'wpaq_admin_menu');

function wpaq_admin_menu(){
	add_options_page('WP-Quicktag - Add Quicktags', __('Add Quicktags', 'aqt'), 9, basename(__FILE__), 'wpaq_options_page');
}

function wpaq_options_page(){
	if ($_POST['wpaq']){
		$buttons = array();
		for ($i = 0; $i < count($_POST['wpaq']['buttons']); $i++){
			$b = $_POST['wpaq']['buttons'][$i];
			if ($b['text'] != '' && $b['start'] != ''){
				$b['text'] = htmlentities($b['text']);
				$b['start'] = stripslashes($b['start']);
				$b['end'] = stripslashes($b['end']);
				$buttons[] = $b;
			}
		}
		$_POST['wpaq']['buttons'] = $buttons;
		update_option('rmnlQuicktagSettings', $_POST['wpaq']);
		$message = '<div class="updated"><p><strong>' . __('Options saved.', 'aqt') . '</strong></p></div>';
	}

	$o = get_option('rmnlQuicktagSettings');
	
	echo '
	<div class="wrap">
		<h2>' . __('WP-Quicktag Management', 'aqt') . '</h2>' . $message . '<form name="form1" method="post" action="options-general.php?page=wp-addquicktag.php">
			<fieldset class="options">
				<legend>' . __('Adding or deleting buttons', 'aqt') . '</legend>
				<p>' . __('Fill in the fields below to add or edit the quicktags. Fields with * are compulsary. To delete a tag simply empty all fields.', 'aqt') . '</p>
				<table width="100%" cellspacing="2" cellpadding="5" class="editform">
					<tr>
						<th style="text-align: center;">' . __('Buttontext*', 'aqt') . '</th>
						<th style="text-align: center;">' . __('Start tag(s)*', 'aqt') . '</th>
						<th style="text-align: center;">' . __('End tag(s)', 'aqt') . '</th>
					</tr>';
		for ($i = 0; $i < count($o['buttons']); $i++){
			$b = $o['buttons'][$i];
			$nr = $i + 1;
			echo <<<EOT
					<tr valign="top" style="text-align: center;">
						<td><input type="text" name="wpaq[buttons][{$i}][text]" value="{$b['text']}" style="width: 95%;" /></td>
						<td><textarea name="wpaq[buttons][{$i}][start]" rows="2" cols="25" style="width: 95%;">{$b['start']}</textarea></td>
						<td><textarea name="wpaq[buttons][{$i}][end]" rows="2" cols="25" style="width: 95%;">{$b['end']}</textarea></td>
					</tr>
EOT;
		}
		echo <<<EOT
					<tr valign="top" style="text-align: center;">
						<td><input type="text" name="wpaq[buttons][{$i}][text]" value="" style="width: 95%;" /></td>
						<td><textarea name="wpaq[buttons][{$i}][start]" rows="2" cols="25" style="width: 95%;"></textarea></td>
						<td><textarea name="wpaq[buttons][{$i}][end]" rows="2" cols="25" style="width: 95%;"></textarea></td>
					</tr>
				</table>
			</fieldset>
			<p class="submit">
EOT;
			echo '<input type="submit" name="Submit" value="' . __('Update Options &raquo;', 'aqt') . '" />
			</p>
			</form>
		</div>
';
} //End function wpaq_options_page

if (strpos($_SERVER['REQUEST_URI'], 'post.php') || strpos($_SERVER['REQUEST_URI'], 'post-new.php') || strpos($_SERVER['REQUEST_URI'], 'page-new.php') || strpos($_SERVER['REQUEST_URI'], 'page.php')) {
	add_action('admin_footer', 'wpaq_addsome');

	function wpaq_addsome(){
		$o = get_option('rmnlQuicktagSettings');
		if(count($o['buttons']) > 0){
			echo <<<EOT
				<script type="text/javascript">
					<!--
					if(wpaqToolbar = document.getElementById("ed_toolbar")){
						var wpaqNr, wpaqBut, wpaqStart, wpaqEnd;
EOT;
						for ($i = 0; $i < count($o['buttons']); $i++){
							$b = $o['buttons'][$i];
							$start = preg_replace('![\n\r]+!', "\\n", $b['start']);
							$start = str_replace("'", "\'", $start);
							$end = preg_replace('![\n\r]+!', "\\n", $b['end']);
							$end = str_replace("'", "\'", $end);
							echo <<<EOT
									wpaqStart = '{$start}';
									wpaqEnd = '{$end}';
									wpaqNr = edButtons.length;
									edButtons[wpaqNr] = new edButton('ed_wpaq{$i}','{$b['txt']}',wpaqStart, wpaqEnd,'');
									var wpaqBut = wpaqToolbar.lastChild;
									while (wpaqBut.nodeType != 1){
										wpaqBut = wpaqBut.previousSibling;
									}
									wpaqBut = wpaqBut.cloneNode(true);
									wpaqToolbar.appendChild(wpaqBut);
									wpaqBut.value = '{$b['text']}';
									wpaqBut.title = wpaqNr;
									wpaqBut.onclick = function () {edInsertTag(edCanvas, parseInt(this.title));}
									wpaqBut.id = "ed_wpaq{$i}";
EOT;
						}
				echo <<<EOT
					}

					//-->
				</script>
EOT;
		}
	} //End wpaq_addsome
} // End if

?>