<?php 
/* これは文字化け防止のための日本語文字列です。*/
/* 
Plugin Name: Force Wave Dash
Plugin URI: http://wppluginsj.sourceforge.jp/force-wave-dash/
Description: In a UTF-8 based weblog, convert full-width-tild characters to wave dash ones at creating/editing posts and at outputting contents.
Author: IKEDA yuriko
Version: 0.72
Author URI: http://www.yuriko.net/cat/wordpress
*/

if (get_bloginfo('charset') == 'UTF-8' && function_exists('mb_ereg_replace') && mb_internal_encoding() == 'UTF-8') {
	add_action('publish_post',  array('Force_Wavedash', 'convert_posts'), 21);
	add_action('edit_post',     array('Force_Wavedash', 'convert_posts'), 21);
	add_filter('the_title',     array('Force_Wavedash', 'tild2wave'), 21);
	add_filter('the_title_rss', array('Force_Wavedash', 'tild2wave'), 21);
	add_filter('the_content',   array('Force_Wavedash', 'tild2wave'), 21);
}

/* ==================================================
 *   Force_Wavedash class
   ================================================== */

class Force_Wavedash {

// ==================================================
function tild2wave($text) {
	$replaced = mb_ereg_replace('～', '〜', $text);
	return ($replaced ? $replaced : $text);
}

// ==================================================
function convert_posts($post_id) {
	$post = get_post($post_id);
	$title   = Force_Wavedash::tild2wave($post->post_title);
	$content = Force_Wavedash::tild2wave($post->post_content);
	global $wpdb;
	$title_sql   = $wpdb->escape($title);
	$content_sql = $wpdb->escape($content);
	$id_sql      = intval($post->ID);
	$wpdb->query("UPDATE {$wpdb->posts} SET post_title = '$title_sql', post_content = '$content_sql' WHERE ID = $id_sql");
	$posts = array($post);
	update_post_cache($posts);
	return $post_id;
}

// ===== End of class ====================
}

?>