<?php

require_once dirname(dirname(dirname(dirname(__FILE__)))) . '/wp-config.php';
define('GEO_META_FIELD_NAME', 'Lat_Long');

header('Content-Type: application/xml; charset=' . get_settings('blog_charset'));
if (! get_settings('yf_google_page_id')) {
	echo '<error>The static map page does not exists.</error>';
	exit();
}

if (! isset($_GET['format']) || $_GET['format'] != 'xml') {
	echo '<error>Data format does not specified.</error>';
	exit();
}
$locations = new Lightweight_Google_Maps_Locations;
$locations->output_locations();

class Lightweight_Google_Maps_Locations {

// ==================================================
function get_LatLon() {
	global $post;
	$latlongs = array();
	$meta_values = get_post_meta($post->ID, GEO_META_FIELD_NAME);
	if (! $meta_values) {
		return NULL;
	}
	foreach ($meta_values as $lat_long) {
		list($lat, $lon) = array_map('floatval', split(',', $lat_long));
		$latlongs[] = compact('lat', 'lon');
	}
	return $latlongs;
}

// ==================================================
function posts_in_bounds($bounds) {
	if (count($bounds) != 4 || abs($bounds[0] - $bounds[2]) >= 1.0 || abs($bounds[1] - $bounds[3]) >= 1.0 ) {
		return NULL;
	}
	$center = array('lat' => ($bounds[0] + $bounds[2]) / 2, 'lon' => ($bounds[1] + $bounds[3]) / 2);
	$south_lat = min($bounds[0], $bounds[2]);
	$north_lat = max($bounds[0], $bounds[2]);
	$west_lon  = min($bounds[1], $bounds[3]);
	$east_lon  = max($bounds[1], $bounds[3]);
	global $wpdb;
	$locations = $wpdb->get_results("SELECT post_id,meta_value FROM {$wpdb->postmeta} WHERE meta_key = '" . GEO_META_FIELD_NAME . "' AND SUBSTRING_INDEX(meta_value, ',',1) >= $south_lat AND SUBSTRING_INDEX(meta_value, ',',1) <= $north_lat AND SUBSTRING_INDEX(meta_value, ',',-1) >= $west_lon AND SUBSTRING_INDEX(meta_value, ',',-1) <= $east_lon ORDER BY post_id DESC");
	$posts_w_loc = array();
	foreach ($locations as $l) {
		list($lat, $lon) = array_map('floatval', split(',', $l->meta_value));
		$posts_w_loc[$l->post_id][] = compact('lat', 'lon');
	}
	return $posts_w_loc;
}

// ==================================================
function is_same($point1, $point2) {
	return (abs($point1['lat'] - $point2['lat']) < 0.0000000001 && abs($point1['lon'] - $point2['lon']) < 0.0000000001);
}

// ==================================================
function post_info($lat, $lon) {
	$title = get_the_title();
	$link = get_permalink();
	$date = get_the_time('Y-m-d');
	$excerpt = preg_replace('/^\s+/', '', get_the_excerpt());
	$excerpt = preg_replace('/\n.*$/m', '', $excerpt);
	return compact('lat', 'lon', 'title', 'link', 'date', 'excerpt');
}

// ==================================================
function query_markers() {
	if (isset($_GET['bounds'])) {
		$bounds = array_map('floatval', explode(',', $_GET['bounds']));
		$posts_w_loc = $this->posts_in_bounds($bounds);
	} else {
		$posts_w_loc = NULL;
	}
	$query = '';
	if (isset($_GET['category'])) {
		$query .= '&cat=' . intval($_GET['category']);
	}
	if (isset($_GET['date'])) {
		list($year, $month, $date) = array_map('intval', explode('-', $_GET['date']));
		$query .= sprintf('&year=%d&monthnum=%d&day=%d', $year, $month, $date);
	}
	$num = isset($_GET['recent']) ? intval($_GET['recent']) : 0;

	$loc = array();
	if ($query || $num) {
		for ($page = 1 ; $page <= 100000 ; $page++) {
			$posts = new WP_Query("paged=$page$query");
			if (! $posts->have_posts() || $page > 100000) {
				break;
			}
			while ($posts->have_posts()) : $posts->the_post();
				if ($posts_w_loc) {
					global $post;
					$latlongs = @$posts_w_loc[$post->ID];
				} else {
					$latlongs = $this->get_LatLon();
				}
				if ($latlongs) {
					foreach ($latlongs as $l) {
						$loc[] = $this->post_info($l['lat'], $l['lon']);
						if ($num > 0 && count($loc) >= $num) {
							break 3;
						}
					}
				}
			endwhile;
		}
	} elseif ($posts_w_loc) {
		foreach ($posts_w_loc as $p => $latlongs) {
			$posts = new WP_Query("p=$p");
			if ($posts->have_posts()) {
				$posts->the_post();
				foreach ($latlongs as $l) {
					$loc[] = $this->post_info($l['lat'], $l['lon']);
				}
			}
		}
	}
	return $loc;
}

// ==================================================
function output_locations() {
	$markers = $this->query_markers();
	echo "<markers>\n";
	while ($m = array_shift($markers)) {
		$m = array_map('wp_specialchars', $m);
		extract($m);
		echo <<<E__O__T
<marker>
<lat>$lat</lat>
<lon>$lon</lon>
<title>$title</title>
<link>$link</link>
<date>$date</date>
<excerpt>$excerpt</excerpt>
</marker>

E__O__T;
	}
	echo "</markers>\n";
	return;
}

// ==================================================
} // End of class

?>