<?php 
/* 
Plugin Name: KtaiLo2otenki
Plugin URI: http://www.yuriko.net/travel/2007/01/18/1791/
Description: Decide a area code for wp-otenki from "Lat_Long" custom field. Based on wp-eznavi by Sa.Ga.
Author: IKEDA yuriko
Version: 0.7.0
Author URI: http://www.yuriko.net/travel/category/wordpress/
*/

/*  Copyright (c) 2007 yuriko

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

define ('OTENKI_AREA_XML_FILE',           'otenki.xml');
define ('OTENKI_AREA_XML_TOP_LEVEL_NODE', 'otenki');
define ('OTENKI_AREA_XML_2ND_LEVEL_NODE', 'area');
define ('GEO_META_FIELD_NAME',    'Lat_Long');
define ('OTENKI_META_FIELD_NAME', 'wpotenki_area');
define ('ERROR_LOG_FIELD_NAME',   'KtaiLoc_Errors');

add_action('save_post',    array('KtaiLoc2otenki', 'latlong2otenki'), 21);
add_action('publish_post', array('KtaiLoc2otenki', 'latlong2otenki'), 21);

/* ==================================================
 *   KtaiLoc2otenki Class
   ================================================== */

class KtaiLoc2otenki {

/* ==================================================
 * Read a "Lat_Long" custom field and save the area code for the location into "wpotenki-area custom field.
 * @param	Int $postID
 * @return	Int $postID
*/

function latlong2otenki($postID) {
	if (! defined('WPOTENKI_METANAME')) {
		return;	// Do nothing if wp-otenki is not exists.
	}
	$meta_value = get_post_meta($postID, GEO_META_FIELD_NAME, TRUE);
	$latlng = explode(',', $meta_value);
	if (! $meta_value || ! intval(@$latlng[0]) || ! intval(@$latlng[1])) {
		return $postID; // Do nothing if no location info.
	}
	$meta_value = get_post_meta($postID, OTENKI_META_FIELD_NAME, TRUE);
	if (is_numeric($meta_value)) {
		return $postID; // Do nothing if a manually input value is exists.
	}
	$area_info = KtaiLoc2otenki::decide_nearest_area($latlng, $postID);
	if ($area_info) {
		$info_string = '';
		foreach ($area_info as $k => $v) {
			$v = trim($v);
			if ($v) {
				$info_string .= "$k=$v;";
			}
		}
		if ($meta_value) {
			update_post_meta($postID, OTENKI_META_FIELD_NAME, $info_string);
		} else {
			add_post_meta($postID, OTENKI_META_FIELD_NAME, $info_string);
		}
	}
	return $postID;
}

/* ==================================================
 * Decide the nearest area from a latitude-longtitude.
 * @param	Array $latlng
 * @param	Int   $postID
 * @return	Array $nearest_area
*/
function decide_nearest_area($latlong, $postID) {
	$area_data = KtaiLoc2otenki::read_area_data($postID);
	$lat = floatval($latlong[0]);
	$lon = floatval($latlong[1]);
	$lat_lower = $lat - 1.0;
	$lat_upper = $lat + 1.0;
	$lon_left  = $lon - 1.0;
	$lon_right = $lon + 1.0;

	$min_distance = 9999;
	$nearest_area = NULL;
	foreach ($area_data as $a) {
		if ($a['lat'] < $lat_lower || $a['lat'] > $lat_upper || $a['long'] < $lon_left || $a['long'] > $lon_right) {
			continue;
		}
		$square_distance = ($a['lat'] - $lat) * ($a['lat'] - $lat) + ($a['long'] - $lon) * ($a['long'] - $lon);
		if ($square_distance < $min_distance) {
			$min_distance = $square_distance;
			$nearest_area = $a;
		}
	}
	return $nearest_area;
}

/* ==================================================
 * Read the otenki area XML file.
 * @param	none
 * @return	Array $area_data
*/
function read_area_data($postID) {
	$parser = xml_parser_create();
	if (! $parser) {
		KtaiLoc2otenki::log_error($postID, "Can't create XML parser!");
		return NULL;
	}
	global $buffer, $bufferPos, $currentElement;
	$buffer = array();
	$bufferPos = 0;
	$currentElement = '';
	xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, false);
	xml_set_element_handler($parser, array('KtaiLoc2otenki', 'start_element_handler'), array('KtaiLoc2otenki', 'end_element_handler'));
	xml_set_character_data_handler($parser, array('KtaiLoc2otenki', 'character_data_handler'));
	xml_set_default_handler($parser, array('KtaiLoc2otenki', 'default_handler'));
	$fp = fopen(dirname(__FILE__) . '/' . OTENKI_AREA_XML_FILE, 'r');
	if (! $fp) {
		KtaiLoc2otenki::log_error($postID, 'Failed to open the area XML file: ' . dirname(__FILE__) . '/' . OTENKI_AREA_XML_FILE);
		return NULL;
	}
	while ($fin = fread($fp, 4096)) {
		if (! xml_parse($parser, $fin, feof($fp))) {
			KtaiLoc2otenki::log_error($postID, 'XML parse error: ' . xml_error_string(xml_get_error_code($parser)) . ' at line ' . xml_get_current_line_number($parser));
			return NULL;
		}
	}
	xml_parser_free($parser);
	return $buffer;
}

/* ==================================================
 * Start element handler (used by XML Parser)
 * @param $parser XML Parser
 * @param $name Element name
 * @param $attrs Arrays of attributes
 */
function start_element_handler($parser, $name, $attrs) {
	global $currentElement;
	if ($name == OTENKI_AREA_XML_TOP_LEVEL_NODE) {
		$currentElement = '';
	} else {
		$currentElement = $name;
	}
}

/* ==================================================
 * End element handler (used by XML Parser)
 * @param $parser XML Parser
 * @param $name Element name
 */
function end_element_handler($parser, $name) {
	global $bufferPos, $currentElement;
	if ($name == OTENKI_AREA_XML_2ND_LEVEL_NODE) {
		$bufferPos++;
	}
	$currentElement = '';
}

/* ==================================================
 * Character data handler (used by XML Parser)
 * @param $parser XML Parser
 * @param $chrdata Body String read by XML Parser
 */
function character_data_handler($parser, $chrdata) {
	global $buffer, $bufferPos, $currentElement;
	if ($currentElement) {
		$buffer[$bufferPos][$currentElement] = mb_convert_encoding($chrdata, get_settings('blog_charset'), 'auto');
	}
}

/* ==================================================
 * Default handler (used by XML Parser)
 * @param $parser XML Parser
 * @param $nodedata Node data
 */
function default_handler($parser, $nodedata) {
}

/* ==================================================
 * log error report to the postmeta table.
 * @param Int    $postID
 * @param String $message
 */
function log_error($postID, $message) {
	$meta_value = get_post_meta($postID, ERROR_LOG_FIELD_NAME, TRUE);
	if ($meta_value) {
		add_post_meta($postID, ERROR_LOG_FIELD_NAME, $message);
	} else {
		update_post_meta($postID, ERROR_LOG_FIELD_NAME, $meta_value . '/' . $message);
	}
	return;
}

// ==================================================
} // End of class
?>