<?php
/*
Plugin Name: Search Word Highlight for Mutibyte
Plugin URI: http://wppluginsj.sourceforge.jp/search-word-highlight-for-multibyte/
Description: This plugin displays highlighting site visitor's search word.
Author: hiromasa
Version: 1.02
Author URI: http://hiromasa.zone.ne.jp/blog/
Special Thanks: Masayan (http://mmrt.sub.jp/blogs/)
Special Thanks: kohaku (http://aoiro.s58.xrea.com/)
*/

/*  Copyright 2005 hiromasa  (email : webmaster@hiromasa.zone.ne.jp)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * THIS FILE IS CALLED ONLY.
 *****************************************************************************/
if(basename($_SERVER['SCRIPT_FILENAME']) == 'searchword-highlight.php') {
	die();
}

/******************************************************************************
 * WordPress filter and admin-tool define
 *  - If multi byte function used is not defined, the plug-in is invalidated.
 *****************************************************************************/
if(
	class_exists('SearchWordHighlightWp') &&
	class_exists('SearchWordHighlightWpAdmin') &&
	class_exists('SearchEngineWord') &&
	searchMultibyteFunction() ) {
	
	load_plugin_textdomain('searchword-highlight');
	
	$swh = & new SearchwordHighlightWp();
	add_filter('the_content', array(&$swh, 'doHighlight'));
	add_filter('the_excerpt', array(&$swh, 'doHighlight'));
	add_filter('comment_text', array(&$swh, 'doHighlight')); 
	add_filter('wp_head', array(&$swh, 'theUserCSS'));
	
}

function searchMultibyteFunction() {
	
	$mbf = array(
		'mb_convert_encoding',
		'mb_convert_kana',
		'mb_regex_encoding',
		'mb_split');
	
	$find = true;
	foreach ($mbf as $function) {
		if(!function_exists($function)) {
			$find = false;
			break;
		}
	}
	
	return $find;
	
}

/******************************************************************************
 * This object displays highlighting site visitor's search word for WordPress.
 *  - The character string is substituted and highlighted.
 *  - CSS to highlight is output.
 *  - Plugin Options maintains.
 * 
 * @author		hiromasa
 * @version	1.02
 * 
 *****************************************************************************/
class SearchWordHighlightWp {
	
	var $seo;
	var $swa;
	
	var $wp_highlight_flag;
	var $searchengines_highlight_flag;
	var $debug_highlight_flag;
	var $searchengine;
	var $highlight_css;
	var $debug_url;
	
	var $highlight;
	
	/**
	 * The Constructor
	 * The option of the plug-in is acquired,
	 *  and it maintains it in the object.
	 * 
	 * @param none
	 * @return Object reference
	 */
	function SearchWordHighlightWp() {
		
		if(!get_option('swh_wp_highlight_flag')) {
			$this->wpSetDefalutOption();
		}
		else {
			$this->wpGetOptions();
		}
		
		$this->seo = & new SearchEngineWord($this->searchengine);
		$this->swa = & new SearchWordHighlightWpAdmin($this);
		
		add_action('admin_menu', array($this, 'addAdminMenu'));
		
	}
	
	/**
	 * The management panel of this plug-in is added. 
	 * 
	 * @param none
	 * @return none
	 */
	function addAdminMenu() {
		
		add_options_page(
			'SearchWordHighlight',
			'SearchWordHighlight',
			8,
			'searchword-highlight.php',
			array($this->swa, 'viewAdminPanel')
		);
		
	}
	
	/**
	 * The character string is substituted and highlighted in WP interface.
	 * 
	 * @param Wordpress contents HTML
	 * @return Highlighted HTML
	 */
	function doHighlight($content) {
		
		$this->highlight = false;
		
		if(preg_match('/<script/i', $content)) {
			return $content;
		}
		
		$HTTP_REFERER = $_SERVER['HTTP_REFERER'];
		
		if($this->wp_highlight_flag == 'true') {
			$url = $this->wpAddWordPressHostpath();
			if($url != '') $HTTP_REFERER = $url;
		}
		if($this->debug_highlight_flag == 'true') {
			$HTTP_REFERER = $this->debug_url;
		}
		if(!isset($HTTP_REFERER)) {
			return $content;
		}
		
		$referer = $HTTP_REFERER;
		if(!$this->seo->analyzeURL($referer)) {
			return $content;
		}
		
		$this->highlight = true;
		
		$highlight_stag = '<span id="searchword">';
		$highlight_etag = '</span>';
		
		$search_strings = $this->seo->getSearchStringsArray();
		
		for ($i=0; $i<sizeof($search_strings); $i++) {
			
			$search_string = htmlspecialchars($search_strings[$i]);
			$search_string = preg_quote($search_string, '/');
			
			// The first search word that appears
			//  from one element of tag is highlighted.
			$search_strings[$i] = 
				'/(<[^>].*>(?:(?!' . $search_string . ')(?!<).|\n)*)' .
				'(' . $search_string . ')' .
				'/i';
			$replace_string[$i] =
				'$1' .
				$highlight_stag. '$2' .$highlight_etag;
			
		}
		
		$charset = get_settings('blog_charset');
		$content = mb_convert_encoding($content, "UTF-8", $charset);
		$content = preg_replace($search_strings, $replace_string, $content);
		$content = mb_convert_encoding($content, $charset, "UTF-8");
		
		return $content;
		
	}
	
	/**
	 * CSS to highlight is output in WP interface.
	 * 
	 * @param none
	 * @return none
	 */
	function theUserCSS() {
		
		echo '<style type="text/css" media="screen">#searchword { ';
		echo $this->highlight_css;
		echo ' }</style>' . "\n";
		
	}
	
	/**
	 * Get highlighflag
	 * 
	 * @param none
	 * @return $this->highlight
	 */
	function getHighlighFlag() {
		
		return $this->highlight;
		
	}
	
	/**
	 * Get highlighString
	 * 
	 * @param none
	 * @return $highlighString
	 */
	function getHighlighString() {
		
		$highlighString = $this->seo->getSearchStringsArray();
		if($highlighString == false) {
			$highlighString = null;
		} else {
			$highlighString = implode(" ", $highlighString);
			$charset = get_settings('blog_charset');
			$highlighString = mb_convert_encoding($highlighString, $charset, "UTF-8");
		}
		
		return $highlighString;
		
	}
	
	/**
	 * Get option value from WP database.
	 * 
	 * @param $option_name
	 * @return Option value
	 */
	function getOption($option_name) {
		
		return get_option($option_name);
		
	}
	
	/**
	 * Option value is set in WP database.
	 * 
	 * @param $option_name
	 * @param $value
	 * @return none
	 */
	function setOption($option_name, $value) {
		
		if(is_array($value)) {
			$value = serialize($value);
		}
		
		update_option($option_name, $value);
		
	}
	
	/**
	 * Initialize Search engine attribute.
	 * 
	 * @param none
	 * @return none
	 */
	function initSearchEngine() {
		
		$this->seo->initSearchEngine();
		
	}
	
	/**
	 * search engine adds.
	 * 
	 * @param $hostpath (ex.'www.google.co.jp/search')
	 * @param $query_name (ex.'q')
	 * @param $query_encode (ex.'UTF-8')
	 * @return true
	 * @return false (Illegal hostpath or query_name)
	 */
	function addSearchEngine($hostpath, $query_name, $query_encode) {
		
		return $this->seo->addSearchEngine(
			$hostpath, $query_name, $query_encode);
		
	}
	
	/**
	 * Search engine attribute array return.
	 * 
	 * @param none
	 * @return Array
	 */
	function getSearchEngineArray() {
		
		return $this->seo->getSearchEngineArray();
		
	}
	
	/**
	 * WordPress search function attribute get and enable.
	 * 
	 * @param none
	 * @return Curent URI string
	 * @return null
	 */
	function wpAddWordPressHostpath() {
		
		$query = trim($_SERVER['QUERY_STRING']);
		$url = '';
		if(preg_match('/^s=.*/', $query)) {
			$hostpath = $_SERVER['SERVER_NAME'] . $_SERVER['PHP_SELF'];
			$url = $hostpath . '?' . $_SERVER['QUERY_STRING'];
			$charset = get_settings('blog_charset');
			$this->addSearchEngine($hostpath, 's', $charset);
		}
		
		return $url;
		
	}
	
	/**
	 * Get this plug-in all options value from WP database.
	 * 
	 * @param none
	 * @return none
	 */
	function wpGetOptions() {
		
		$this->wp_highlight_flag = get_option('swh_wp_highlight_flag');
		$this->searchengines_highlight_flag = get_option('swh_searchengines_highlight_flag');
		$this->debug_highlight_flag = get_option('swh_debug_highlight_flag');
		$this->searchengine = unserialize(get_option('swh_searchengine'));
		$this->highlight_css = get_option('swh_highlight_css');
		$this->debug_url = get_option('swh_debug_url');
		
	}
	
	/**
	 * Option value initialize.
	 * 
	 * @param none
	 * @return none
	 */
	function wpSetDefalutOption() {
		
		$this->wpDeleteOption();
		
		$option_description = 'Search Word Highlight Plugin Option';
		
		add_option('swh_wp_highlight_flag', 'true', $option_description);
		add_option('swh_searchengines_highlight_flag', 'true', $option_description);
		add_option('swh_debug_highlight_flag', 'false', $option_description);
		
		$searchEngines 
			= array(
				array('www.google.co.jp/search', 'q', 'UTF-8'),
				array('search.yahoo.co.jp/search', 'p', 'EUC-JP'),
				array('search.msn.co.jp/results.aspx', 'q', 'UTF-8')
			  );
		// WordPress will automatically serialize (?)
		$searchEngines = serialize($searchEngines);
		add_option('swh_searchengine', $searchEngines, $option_description);
		
		$swh_highlight_css  = 'background-color: #fff9c8;';
		$swh_highlight_css .= 'text-decoration: inherit;';
		add_option('swh_highlight_css', $swh_highlight_css, $option_description);
		
		add_option('swh_debug_url', '', $option_description);
		
	}
	
	/**
	 * Delete this plug-in all options value from WP database.
	 * 
	 * @param none
	 * @return none
	 */
	function wpDeleteOption() {
		
		delete_option('swh_wp_highlight_flag');
		delete_option('swh_searchengines_highlight_flag');
		delete_option('swh_debug_highlight_flag');
		delete_option('swh_searchengine');
		delete_option('swh_highlight_css');
		delete_option('swh_debug_url');
		
	}
	
}

/******************************************************************************
 * Search Word Highlight Administrator Userinterface.
 *  - Output admin panel HTML.
 *  - Get user operation and notisfy plug-in.
 * 
 * @author		hiromasa
 * @version	1.02
 * 
 *****************************************************************************/
class SearchWordHighlightWpAdmin {
	
	var $swc;
	
	var $forms = array(
					array('swh_wp_highlight_flag', 'checkbox'),
					array('swh_searchengines_highlight_flag', 'checkbox'),
					array('swh_debug_highlight_flag', 'checkbox'),
					array('swh_highlight_css', 'textbox'),
					array('swh_debug_url', 'textbox')
				);
	
	var $searchengine_attr_name = array(
					'swh_searchengine_hostpath_',
					'swh_searchengine_query_',
					'swh_searchengine_encode_',
				);
	
	/**
	 * The Constructor
	 * 
	 * @param none
	 * @return Object reference
	 */
	function SearchWordHighlightWpAdmin(&$swc) {
		
		$this->swc = $swc;
		
	}
	
	/**
	 * Update options notisfy.
	 * 
	 * @param $post_array
	 * @return none
	 */
	function updateOption($post_array) {
		
		foreach($this->forms as $form_attr) {
			
			$name = $form_attr[0];
			$type = $form_attr[1];
			
			if($type == 'checkbox') {
				if(isset($post_array[$name])) {
					$this->swc->setOption($name, 'true');
				} else {
					$this->swc->setOption($name, 'false');
				}
			}
			if($type == 'textbox') {
				if(isset($post_array[$name])) {
					$this->swc->setOption($name, $post_array[$name]);
				}
			}
			
		}
		
		$searchengine = array();
		$count = 0;
		foreach($post_array as $name => $value) {
			
			if(preg_match('/^swh_searchengine_(.*)_(.*)/', preg_quote($name), $matches)) {
				if($value != null) {
					$searchengine[$matches[2]][$matches[1]] = $value;
					$count++;
				}
			}
			
		}
		
		$this->swc->initSearchEngine();
		for($i=0; $i<$count; $i++) {
			$hostpath = $searchengine[$i]['hostpath'];
			$query_name = $searchengine[$i]['query'];
			$query_encode = $searchengine[$i]['encode'];
			$this->swc->addSearchEngine($hostpath, $query_name, $query_encode);
		}
		
		$searchEngines = serialize($this->swc->getSearchEngineArray());
		$this->swc->setOption('swh_searchengine', $searchEngines);
		
	}
	
	/**
	 * Administrator Panel.
	 *  - Output admin panel HTML.
	 *  - Get user operation and notisfy controller.
	 * 
	 * @param none
	 * @return none
	 */
	function viewAdminPanel() {
		
		$message = '';
		
		if(isset($_POST['update_options'])) {
			
			$post_array = array();
			foreach ($_POST as $name => $value) {
				if(preg_match('/^swh_/', preg_quote($name))) {
					$post_array[$name] = $value;
				}
			}
			
			foreach($post_array as $name => $value) {
				$message .=  $name . ':' . $value . '<br />';
			}
			
			$this->updateOption($post_array);
			
			$message = __('Option Update.', 'searchword-highlight');
			
		}
		else if(isset($_POST['init_options'])) {
			$this->swc->wpSetDefalutOption();
		}
		
		$form = array();
		foreach($this->forms as $form_attr) {
			
			$name = $form_attr[0];
			$type = $form_attr[1];
			
			if($type == 'checkbox') {
				$checked_flag = '';
				if($this->swc->getOption($name) == 'true') {
					$checked_flag = 'checked';
				}
				$form[$name] = $checked_flag;
			}
			if($type == 'textbox') {
				$form[$name] = stripslashes($this->swc->getOption($name));
			}
			
		}
		
		$swh_searchengine = $this->swc->getOption('swh_searchengine');
		$swh_searchengine = unserialize($swh_searchengine);
		
		$searchengine = array();
		$swh_count = 0;
		foreach($swh_searchengine as $attr) {
			for($i=0; $i<=count($this->searchengine_attr_name); $i++) {
				$searchengine[$swh_count][$this->searchengine_attr_name[$i] . $swh_count]
					= $attr[$i];
			}
			$swh_count++;
		}
?>
<?php if($message != null) { ?>
	<div class="updated"><p><strong><?php echo $message; ?></strong></p></div>
<?php } ?>
	<div class="wrap"> 
	
	<h2>Search Word Highlight</h2>
	
	<form name="SearchWordHighlight" method="post">
	
	<input type="hidden" name="action" value="update" />
	
	<fieldset class="options">
		<legend><?php _e('Highlight Settings', 'searchword-highlight'); ?></legend>
		<ul>
			<li>
				<label for="swh_wp_highlight_flag">
				<input name="swh_wp_highlight_flag" type="checkbox" value="true" <?php echo $form['swh_wp_highlight_flag']; ?> /> 
				<?php _e('The Search word by WordPress serach function is highlighted.', 'searchword-highlight'); ?>
				</label>
			</li>
			<li>
				<label for="swh_searchengines_highlight_flag">
				<input name="swh_searchengines_highlight_flag" type="checkbox" value="true" <?php echo $form['swh_searchengines_highlight_flag']; ?> /> 
				<?php _e('The Search word by "Search Engine" is highlighted.', 'searchword-highlight'); ?>
			</label>
			</li>
		</ul>
	</fieldset>
	
	<fieldset class="options">
		<legend><?php _e('Serach Engine Settings', 'searchword-highlight'); ?></legend>
		<table width="100%" cellspacing="2" cellpadding="5">
			<tr>
				<th valign="top" scope="row"><?php _e('Hostname + Path','searchword-highlight'); ?></th>
				<th valign="top" scope="row"><?php _e('Query', 'searchword-highlight'); ?></th>
				<th valign="top" scope="row"><?php _e('Character Encode', 'searchword-highlight'); ?></th>
			</tr>
<?php for($i=0; $i<$swh_count+5; $i++) { ?>
			<tr>
				<td>
					<input type="text" name="swh_searchengine_hostpath_<?php echo $i; ?>"
						value="<?php echo $searchengine[$i]['swh_searchengine_hostpath_' . $i]; ?>" size="50" maxlength="255"/>
				</td>
				<td>
					<input type="text" name="swh_searchengine_query_<?php echo $i; ?>"
						value="<?php echo $searchengine[$i]['swh_searchengine_query_' . $i];?>" size="15" maxlength="30"/>
				</td>
				<td>
					<input type="text" name="swh_searchengine_encode_<?php echo $i; ?>"
						value="<?php echo $searchengine[$i]['swh_searchengine_encode_' . $i];?>" size="15" maxlength="30"/>
				</td>
			</tr>
<?php } ?>
		</table> 
	</fieldset>
	
	<fieldset class="options">
		<legend><?php _e('CSS Setings', 'searchword-highlight'); ?></legend>
		<textarea name="swh_highlight_css" rows="4" cols="80" wrap="off"><?php echo $form['swh_highlight_css']; ?></textarea>
	</fieldset>
	
	<fieldset class="options">
		<legend><?php _e('Debug Mode', 'searchword-highlight'); ?></legend>
		<ul>
			<li>
				<label for="swh_debug_highlight_flag">
				<input name="swh_debug_highlight_flag" type="checkbox" value="true"  <?php echo $form['swh_debug_highlight_flag']; ?> />
				<?php _e('Enable debug mode. (HTTP_REFERER fix)', 'searchword-highlight'); ?>
				</label>
			</li>
			<li>
				<label><?php _e('Fix HTTP_REFERER', 'searchword-highlight'); ?></label>
				<input type="text" name="swh_debug_url" value="<?php echo $form['swh_debug_url']; ?>" size="90" maxlength="255"/>
			</li>
		</ul>
	</fieldset>
	
	<p class="submit">
		<!-- <input type="submit" name="init_options" value="Initialize Options &raquo;" /> -->
		<input type="submit" name="update_options" value="<?php _e('Update Options &raquo;', 'searchword-highlight'); ?>" />
	</p>
	
	</form>
	
	</div>
<?php
	}
	
}

/******************************************************************************
 * This object extracts, analyzes, and maintains the search word
 * from URL of search engine.
 * 
 * @author		hiromasa
 * @version	1.0
 * 
 *****************************************************************************/
class SearchEngineWord {
	
	var $search_engines;
	
	var $search_engine_hostpath;
	var $search_strings;
	
	/**
	 * The Constructor
	 * 
	 * @param none
	 * @return object reference
	 */
	function SearchEngineWord($search_engines = array()) {
		
		$this->initSearchEngine($search_engines);
		
	}
	
	/**
	 * Initialize Object
	 * 
	 * @param Search engine Array
	 * @return none
	 */
	function initSearchEngine($search_engines = array()) {
		
		$this->search_engines = $search_engines;
		
		$this->search_engine_hostpath = null;
		$this->search_strings = null;
		
	}
	
	/**
	 * analysis of URL and storage in the object.
	 * 
	 * @param $url
	 * @return true (It succeeded in analysis and it stored it in the object.)
	 * @return false
	 */
	function analyzeURL($url) {
		
		$url = parse_url($url);
		$hostpath = $url['host'] . $url['port'] . $url['path'];
		$query = rawurldecode($url['query']);
		
		$query_name = array();
		parse_str($query, $query_name);
		
		$search_string = null;
		for ($i=0; $i<sizeof($this->search_engines); $i++) {
			if ($hostpath == $this->search_engines[$i][0]) {
				$search_string
					= $query_name[$this->search_engines[$i][1]];
				break;
			}
		}
		
		if($search_string != null) {
			
			$this->search_engine_hostpath = $this->search_engines[$i][0];
			$query_encode = $this->search_engines[$i][2];
			if($query_encode == "") $query_encode = "auto";
			
			$search_string
				= mb_convert_encoding($search_string, "UTF-8", $query_encode);
			$search_string
				= mb_convert_kana($search_string, "s", "UTF-8");
			$this->search_strings = $search_string;
			
			return true;
			
		} else {
			return false;
		}
		
	}
	
	/**
	 * The array of the search word return.
	 * 
	 * @param none
	 * @return search word array (UTF-8)
	 * @return false (when it is not possible to find it)
	 */
	function getSearchStringsArray() {
		
		if($this->search_engine_hostpath == null) return false;
		
		mb_regex_encoding("UTF-8");
		$strings = mb_split("\s", $this->search_strings);
		mb_regex_encoding(get_settings('blog_charset'));
		
		return $strings;
		
	}
	
	/**
	 * The host name of the search engine returne.
	 * 
	 * @param none
	 * @return search engine hostpath (ex.'www.google.co.jp/search')
	 * @return false (when it is not possible to find it)
	 */
	function getHostPath() {
		
		if($this->search_engine_hostpath == null) return false;
		
		return $this->search_engine_hostpath;
		
	}
	
	/**
	 * search engine adds.
	 * 
	 * @param $hostpath (ex.'www.google.co.jp/search')
	 * @param $query_name (ex.'q')
	 * @param $query_encode (ex.'UTF-8')
	 * @return true
	 * @return false (Illegal hostpath or query_name)
	 */
	function addSearchEngine($hostpath, $query_name, $query_encode) {
		
		$url = parse_url($hostpath);
		if(isset($url['scheme'])) {
			$hostpath = $url['host'] . $url['port'] . $url['path'];
		}
		
		$hostpath = trim($hostpath);
		$query_name = trim($query_name);
		if($hostpath == "" || $query_name == "") return false;
		
		$search_engines =
			array($hostpath, $query_name, $query_encode);
			array_push($this->search_engines, $search_engines);
		
		return true;
		
	}
	
	/**
	 * Search engine attribute array return.
	 * 
	 * @param none
	 * @return Array
	 */
	function getSearchEngineArray() {
		
		return $this->search_engines;
		
	}
	
}
?>
