<?php
# Organizer - Plugin
# Version - 1.0.1
# For Wordpress 2.0.X
# <http://imthi.com/organizer/>
#
# Project:     Organizer
# File:        organizer.php
#
# This plugin is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This plugin is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this plugin; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# For questions, help, comments, discussion, etc., 
# please maill to hmimthiaz@gmail.com 
# or visit http://imthi.com/organizer/

/*
Plugin Name: Organizer
Plugin URI: http://imthi.com/organizer/
Description: <a href=" http://imthi.com/organizer/">Organizer</a> is a simple plugin to view and manage your upload folder files.
Author: Imthiaz
Version: 1.1.0
Author URI: http://imthi.com/
*/ 
$file_icons = array(
	'unknown' => array('unknown.png',__('Unknown document','organizer')),
	'txt' => array('txt.png',__('Text document','organizer')),
	'zip|rar|tar|gz|cab' => array('zip.png',__('Archive files','organizer')),
	'mp3|wav|wma|mid|ac3' => array('mp3.png',__('Archive files','organizer')),
	'avi|mov|wmv' => array('avi.png',__('Video files','organizer')),
	'htm|html' => array('html.png',__('Html files','organizer')),
	'php' => array('php.png',__('PHP files','organizer')),
	'doc|rtf' => array('doc.png',__('Document files','organizer')),
	'pdf' => array('pdf.png',__('PDF files','organizer')),
	'ps' => array('ps.png',__('Postscript files','organizer')),
	'xls' => array('xls.png',__('Spreadsheet files','organizer'))
);

include_once("plugin_functions.php");
include_once("class_filereader.php");
include_once("image.php");



load_plugin_textdomain('organizer',$path = 'wp-content/plugins/organizer');

if(get_settings('organizer_installed')!='1'){
	organizer_install_organizer();
}

if(function_exists("gd_info")){
	$php_gd=true;
}

//Plug the plugin
add_filter('capabilities_list', 'organizer_capabilities');
add_action('admin_head','organizer_initialize');
add_action('admin_head','organizer_add_files_to_admin_head');
add_action('admin_menu', 'organizer_plug_pages');
?>