
<div class="wrap">
<h2 id="write-post"><?php _e('Write Page'); ?><?php if ( 0 != $post_ID ) : ?>
<small class="quickjump"><a href="#preview-post"><?php _e('preview &darr;'); ?></a></small><?php endif; ?></h2>
<?php
if (0 == $post_ID) {
	$form_action = 'post';
	$nonce_action = 'add-post';
	$temp_ID = -1 * time();
	$form_extra = "<input type='hidden' name='temp_ID' value='$temp_ID' />";
} else {
	$post_ID = (int) $post_ID;
	$form_action = 'editpost';
	$nonce_action = 'update-post_' . $post_ID;
	$form_extra = "<input type='hidden' id='post_ID' name='post_ID' value='$post_ID' />";
}

$temp_ID = (int) $temp_ID;
$user_ID = (int) $user_ID;

$sendto = attribute_escape(wp_get_referer());

if ( 0 != $post_ID && $sendto == get_permalink($post_ID) )
 	$sendto = 'redo';

?>

<form name="post" action="post.php" method="post" id="post">

<?php
wp_nonce_field($nonce_action);

if (isset($mode) && 'bookmarklet' == $mode) {
    echo '<input type="hidden" name="mode" value="bookmarklet" />';
}
?>
<input type="hidden" name="user_ID" value="<?php echo $user_ID ?>" />
<input type="hidden" id="hiddenaction" name="action" value='<?php echo $form_action ?>' />
<?php echo $form_extra ?>
<input type="hidden" name="post_status" value="static" />

<script type="text/javascript">
// <![CDATA[
function focusit() { // focus on first input field
	document.post.title.focus();
}
addLoadEvent(focusit);
// ]]>
</script>
<div id="poststuff">

<div id="moremeta">
<div id="grabit" class="dbx-group">
<fieldset id="commentstatusdiv" class="dbx-box">
<h3 class="dbx-handle"><?php _e('Discussion') ?></h3>
<div class="dbx-content">
<input name="advanced_view" type="hidden" value="1" />
<label for="comment_status" class="selectit">
<input name="comment_status" type="checkbox" id="comment_status" value="open" <?php checked($post->comment_status, 'open'); ?> />
<?php _e('Allow Comments') ?></label> 
<label for="ping_status" class="selectit"><input name="ping_status" type="checkbox" id="ping_status" value="open" <?php checked($post->ping_status, 'open'); ?> /> <?php _e('Allow Pings') ?></label>
</div>
</fieldset>

<fieldset id="passworddiv" class="dbx-box">
<h3 class="dbx-handle"><?php _e('Password-Protect Post') ?></h3> 
<div class="dbx-content"><input name="post_password" type="text" size="13" id="post_password" value="<?php echo attribute_escape($post->post_password); ?>" /></div>
</fieldset>

<fieldset id="pageparent" class="dbx-box">
<h3 class="dbx-handle"><?php _e('Page Parent') ?></h3> 
<div class="dbx-content"><p><select name="parent_id">
<option value='0'><?php _e('Main Page (no parent)'); ?></option>
<?php parent_dropdown($post->post_parent); ?>
</select></p>
</div>
</fieldset>

<?php if ( 0 != count( get_page_templates() ) ) { ?>
<fieldset id="pagetemplate" class="dbx-box">
<h3 class="dbx-handle"><?php _e('Page Template:') ?></h3> 
<div class="dbx-content"><p><select name="page_template">
		<option value='default'><?php _e('Default Template'); ?></option>
		<?php page_template_dropdown($post->page_template); ?>
		</select></p>
</div>
</fieldset>
<?php } ?>

<fieldset id="slugdiv" class="dbx-box">
<h3 class="dbx-handle"><?php _e('Post slug') ?></h3> 
<div class="dbx-content"><input name="post_name" type="text" size="13" id="post_name" value="<?php echo attribute_escape($post->post_name); ?>" /></div>
</fieldset>

<?php if ( $authors = get_editable_authors( $current_user->id ) ) : // TODO: ROLE SYSTEM ?>
<fieldset id="authordiv" class="dbx-box">
<h3 class="dbx-handle"><?php _e('Post author'); ?>:</h3>
<div class="dbx-content">
<select name="post_author_override" id="post_author_override">
<?php 
foreach ($authors as $o) :
$o = get_userdata( $o->ID );
if ( $post->post_author == $o->ID || ( empty($post_ID) && $user_ID == $o->ID ) ) $selected = 'selected="selected"';
else $selected = '';
$o->ID = (int) $o->ID;
$o->display_name = wp_specialchars( $o->display_name );
echo "<option value='$o->ID' $selected>$o->display_name</option>";
endforeach;
?>
</select>
</div>
</fieldset>
<?php endif; ?>

<fieldset id="pageorder" class="dbx-box">
<h3 class="dbx-handle"><?php _e('Page Order') ?></h3> 
<div class="dbx-content"><p><input name="menu_order" type="text" size="4" id="menu_order" value="<?php echo $post->menu_order ?>" /></p></div>
</fieldset>

<?php do_action('dbx_page_sidebar'); ?>

</div>
</div>

<fieldset id="titlediv">
  <legend><?php _e('Page Title') ?></legend> 
  <div><input type="text" name="post_title" size="30" tabindex="1" value="<?php echo attribute_escape($post->post_title); ?>" id="title" /></div>
</fieldset>


<fieldset id="<?php echo user_can_richedit() ? 'postdivrich' : 'postdiv'; ?>">
    <legend><?php _e('Page Content') ?></legend>
<?php
 $rows = get_settings('default_post_edit_rows');
 if (($rows < 3) || ($rows > 100)) {
     $rows = 10;
 }
?>
<?php the_quicktags(); ?>

<div><textarea title="true" rows="<?php echo $rows; ?>" cols="40" name="content" tabindex="4" id="content"><?php echo user_can_richedit() ? wp_richedit_pre($post->post_content) : $post->post_content; ?></textarea></div>
</fieldset>

<script type="text/javascript">
<!--
edCanvas = document.getElementById('content');
<?php if ( user_can_richedit() ) : ?>
// This code is meant to allow tabbing from Title to Post (TinyMCE).
if ( tinyMCE.isMSIE )
	document.getElementById('title').onkeydown = function (e)
		{
			e = e ? e : window.event;
			if (e.keyCode == 9 && !e.shiftKey && !e.controlKey && !e.altKey) {
				var i = tinyMCE.selectedInstance;
				if(typeof i ==  'undefined')
					return true;
                                tinyMCE.execCommand("mceStartTyping");
				this.blur();
				i.contentWindow.focus();
				e.returnValue = false;
				return false;
			}
		}
else
	document.getElementById('title').onkeypress = function (e)
		{
			e = e ? e : window.event;
			if (e.keyCode == 9 && !e.shiftKey && !e.controlKey && !e.altKey) {
				var i = tinyMCE.selectedInstance;
				if(typeof i ==  'undefined')
					return true;
                                tinyMCE.execCommand("mceStartTyping");
				this.blur();
				i.contentWindow.focus();
				e.returnValue = false;
				return false;
			}
		}
<?php endif; ?>
//-->
</script>

<p class="submit">
<?php if ( $post_ID ) : ?>
<input name="save" type="submit" id="save" tabindex="5" value=" <?php _e('Save and Continue Editing'); ?> "/> 
<input name="savepage" type="submit" id="savepage" tabindex="6" value="<?php $post_ID ? _e('Save') : _e('Create New Page') ?> &raquo;" /> 
<?php else : ?>
<input name="savepage" type="submit" id="savepage" tabindex="6" value="<?php _e('Create New Page') ?> &raquo;" /> 
<?php endif; ?>
<input name="referredby" type="hidden" id="referredby" value="<?php echo $sendto; ?>" />
</p>

<?php do_action('edit_page_form'); ?>

<?php
if (current_user_can('upload_files')) {
	$uploading_iframe_ID = (0 == $post_ID ? $temp_ID : $post_ID);
	$uploading_iframe_src = wp_nonce_url("inline-uploading.php?action=view&amp;post=$uploading_iframe_ID", 'inlineuploading');
	$uploading_iframe_src = apply_filters('uploading_iframe_src', $uploading_iframe_src);
	if ( false != $uploading_iframe_src )
		echo '<iframe id="uploading" frameborder="0" src="' . $uploading_iframe_src . '">' . __('This feature requires iframe support.') . '</iframe>';
}
?>

<div id="advancedstuff" class="dbx-group">

<fieldset id="postcustom" class="dbx-box">
<h3 class="dbx-handle"><?php _e('Custom Fields') ?></h3>
<div id="postcustomstuff" class="dbx-content">
<?php 
if($metadata = has_meta($post_ID)) {
?>
<?php
	list_meta($metadata); 
?>
<?php
}
	meta_form();
?>
</div>
<div id="ajax-response"></div>
</fieldset>

<?php do_action('dbx_page_advanced'); ?>

</div>

<?php if ('edit' == $action) : $delete_nonce = wp_create_nonce( 'delete-page_' . $post_ID ); ?>
		<input name="deletepost" class="button" type="submit" id="deletepost" tabindex="10" value="<?php _e('Delete this page') ?>" <?php echo "onclick=\"if ( confirm('" . sprintf(__("You are about to delete this page \'%s\'\\n  \'Cancel\' to stop, \'OK\' to delete."), js_escape($post->post_title) ) . "') ) { document.forms.post._wpnonce.value = '$delete_nonce'; return true;}return false;\""; ?> />
<?php endif; ?>

</div>

</form>

</div>
