/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.samples.hellomain;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;

import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.dom.Serial;
import woolpack.html.AutoUpdate;
import woolpack.html.ToNode;
import woolpack.utils.OGE;
import woolpack.utils.StringReaderFactory;

/**
 * Woolpack の Hello World アプリケーション。
 * @author nakamura
 *
 */
public class Hello {
	public static void main(final String[] args) throws IOException {
		// Expression 役を順に実行する定義。
		final DomExpression expression = new Serial(
				// 固定のHTMLの雛型を読み込む定義。
				new ToNode(new StringReaderFactory(
						"<HTML><BODY><FORM><TABLE><TR id=\"list0\">"+
						"<TD><TEXTAREA name=\"textarea0\" >value0</TEXTAREA></TD>"+ 
						"<TD><DIV id=\"div0\" >value0</DIV></TD>"+ 
						"<TD><SPAN id=\"span0\" >value0</SPAN></TD>"+ 
						"<TD><INPUT name=\"input0\" value=\"value0\" /></TD>"+ 
						"<TD><SPAN id=\"span1\" >spanvalue1</SPAN></TD>"+
						"</TR></TABLE></FORM></BODY></HTML>")),
				// DomContext#getLocal()#get("list0")の内容を HTML 雛型に自動設定する定義。
				// ゼロ番目の引数は自動的に画面に値を設定するための、更新対象の属性名の一覧。
				new AutoUpdate(Arrays.asList("name", "id"), new OGE("local.list0")));

		// Context 役。
		final DomContext context = new DomContext();
		
		// Context 役に対し、HTML に流し込む値を設定する。「#{}」はHashMap、「{}」はArrayListを表す。
		new OGE("local.list0 = #{\"list0\":{" +
				"#{\"textarea0\":\"textareavalue0\", " +
				"\"div0\":\"divvalue0\", " +
				"\"span0\":\"spanvalue0\", " +
				"\"input0\":\"inputvalue0\"}," +
				"#{\"textarea0\":\"textareavalue1\", " +
				"\"div0\":\"divvalue1\", " +
				"\"span0\":\"spanvalue1\", " +
				"\"input0\":\"inputvalue1\"}" +
				"}}").getValue(context);

		// Context 役を Expression 役に作用させる。
		expression.interpret(context);
		
		// 結果を出力する。
		Writer w = new OutputStreamWriter(System.out);
		try{
			DomConstants.write(context.getNode(), w);
		}finally{
			w.close();
		}
	}
}
