/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.samples;

import java.util.HashMap;
import java.util.Map;

import woolpack.action.ActionDef;
import woolpack.action.ForwardDef;
import woolpack.utils.OGE;

public class ActionDefMaker {
	public static final OGE INPUT_OGE = new OGE("input");

	private final Map<String,ActionDef> map;
	
	public ActionDefMaker(final Map<String,ActionDef> map){
		map.getClass();
		this.map = map;
	}

	public ActionDefMaker(){
		this(new HashMap<String,ActionDef>());
	}
	
	public Map<String,ActionDef> getMap(){
		return map;
	}
	
	public ActionDefMaker put(final String id, final ActionDef actionDef){
		id.charAt(0);
		map.put(id, actionDef);
		return this;
	}
	
	private ActionDefMaker put(
			final String actionId, 
			final OGE componentOGE, 
			final OGE methodOGE, 
			final String forwardId, 
			final OGE forwardOGE){
		return put(actionId, new ActionDef(componentOGE, methodOGE, new ForwardDef(forwardId, forwardOGE)));
	}
	
	public ActionDefMaker put(
			final String id, 
			final OGE componentOGE, 
			final OGE methodOGE, 
			final OGE forwardOGE){
		return put(id, componentOGE, methodOGE, id, forwardOGE);
	}
	
	public ActionDefMaker putForward(final String id){
		return put(id, OGE.NULL, OGE.NULL, id, OGE.NULL);
	}
	
	public ActionDefMaker putEcho(final String actionId, final String forwardId){
		return put(actionId, OGE.NULL, OGE.NULL, forwardId, INPUT_OGE);
	}
	
	public ActionDefMaker putEcho(final String id){
		return put(id, OGE.NULL, OGE.NULL, id, INPUT_OGE);
	}
}
